/*
 * Decompiled with CFR 0.152.
 */
package net.awpspace.caromini;

import net.awpspace.caromini.BoardCaro;

public class Algorithm {
    private BoardCaro caro;
    private int attack = 0;
    private int defend = 0;
    public static int ME_TYPE = 2;
    public static int ENEMY_TYPE = 1;
    public int current_me_X;
    public int current_me_Y;
    public int current_enemy_X;
    public int current_enemy_Y;
    private int[] review_attack;
    private int[] review_defend;
    private int x_attack;
    private int y_attack;
    private int x_defend;
    private int y_defend;
    private int stepWin;
    private int[] lineWinner;

    public Algorithm() {
        int[] nArray = new int[8];
        nArray[2] = 100;
        nArray[3] = 300;
        nArray[4] = 500;
        nArray[5] = 700;
        nArray[6] = 900;
        nArray[7] = 1000;
        this.review_attack = nArray;
        int[] nArray2 = new int[8];
        nArray2[2] = 99;
        nArray2[3] = 299;
        nArray2[4] = 499;
        nArray2[5] = 699;
        nArray2[6] = 899;
        nArray2[7] = 999;
        this.review_defend = nArray2;
        this.stepWin = 5;
        this.lineWinner = new int[4];
        this.caro = BoardCaro.getInstance();
    }

    private int[] count_row(int x, int y, int type) {
        int i;
        int left = 0;
        int right = 0;
        if (y - 1 >= 0) {
            i = y - 1;
            while (i >= 0) {
                if (this.caro.getValue(x, i) != type) break;
                ++left;
                --i;
            }
        }
        if (y + 1 < BoardCaro.COL) {
            i = y + 1;
            while (i < BoardCaro.COL) {
                if (this.caro.getValue(x, i) != type) break;
                ++right;
                ++i;
            }
        }
        return new int[]{left, right};
    }

    private int[] count_column(int x, int y, int type) {
        int i;
        int left = 0;
        int right = 0;
        if (x - 1 >= 0) {
            i = x - 1;
            while (i >= 0) {
                if (this.caro.getValue(i, y) != type) break;
                ++left;
                --i;
            }
        }
        if (x + 1 < BoardCaro.ROW) {
            i = x + 1;
            while (i < BoardCaro.ROW) {
                if (this.caro.getValue(i, y) != type) break;
                ++right;
                ++i;
            }
        }
        return new int[]{left, right};
    }

    private int[] count_diagonal_1(int x, int y, int type) {
        int left = 0;
        int right = 0;
        int i = x - 1;
        int j = y - 1;
        if (i >= 0 && j >= 0) {
            while (i >= 0 && j >= 0 && this.caro.getValue(i, j) == type) {
                ++left;
                --i;
                --j;
            }
        }
        i = x + 1;
        j = y + 1;
        if (i < BoardCaro.ROW && j < BoardCaro.COL) {
            while (i < BoardCaro.ROW && j < BoardCaro.COL && this.caro.getValue(i, j) == type) {
                ++right;
                ++i;
                ++j;
            }
        }
        return new int[]{left, right};
    }

    private int[] count_diagonal_2(int x, int y, int type) {
        int left = 0;
        int right = 0;
        int i = x + 1;
        int j = y - 1;
        if (i < BoardCaro.ROW && j >= 0) {
            while (i < BoardCaro.ROW && j >= 0 && this.caro.getValue(i, j) == type) {
                ++left;
                ++i;
                --j;
            }
        }
        i = x - 1;
        j = y + 1;
        if (i >= 0 && j < BoardCaro.COL) {
            while (i >= 0 && j < BoardCaro.COL && this.caro.getValue(i, j) == type) {
                ++right;
                --i;
                ++j;
            }
        }
        return new int[]{left, right};
    }

    private void setDefend(int x, int y, int type) {
        int tmp_defend;
        int[] row = this.count_row(x, y, type);
        int[] col = this.count_column(x, y, type);
        int[] diagonal_1 = this.count_diagonal_1(x, y, type);
        int[] diagonal_2 = this.count_diagonal_2(x, y, type);
        int r = row[0] + row[1];
        int c = col[0] + col[1];
        int d1 = diagonal_1[0] + diagonal_1[1];
        int d2 = diagonal_2[0] + diagonal_2[1];
        int maxx = this.getMax(r, c, d1, d2);
        switch (maxx + 1) {
            case 7: {
                tmp_defend = this.review_defend[7];
                break;
            }
            case 6: {
                tmp_defend = this.review_defend[6];
                break;
            }
            case 5: {
                tmp_defend = this.review_defend[5];
                break;
            }
            case 4: {
                tmp_defend = this.review_defend[4];
                break;
            }
            case 3: {
                tmp_defend = this.review_defend[3];
                break;
            }
            case 2: {
                tmp_defend = this.review_defend[2];
                break;
            }
            default: {
                tmp_defend = this.review_defend[0];
            }
        }
        if (this.isEnable(x, y, type)) {
            tmp_defend += 50;
        }
        if (tmp_defend >= this.defend) {
            this.defend = tmp_defend;
            this.x_defend = x;
            this.y_defend = y;
        }
    }

    private void setAttack(int x, int y, int type) {
        int tmp_attack;
        int[] row = this.count_row(x, y, type);
        int[] col = this.count_column(x, y, type);
        int[] diagonal_1 = this.count_diagonal_1(x, y, type);
        int[] diagonal_2 = this.count_diagonal_2(x, y, type);
        int r = row[0] + row[1];
        int c = col[0] + col[1];
        int d1 = diagonal_1[0] + diagonal_1[1];
        int d2 = diagonal_2[0] + diagonal_2[1];
        int maxx = this.getMax(r, c, d1, d2);
        switch (maxx + 1) {
            case 7: {
                tmp_attack = this.review_attack[7];
                break;
            }
            case 6: {
                tmp_attack = this.review_attack[6];
                break;
            }
            case 5: {
                tmp_attack = this.review_attack[5];
                break;
            }
            case 4: {
                tmp_attack = this.review_attack[4];
                break;
            }
            case 3: {
                tmp_attack = this.review_attack[3];
                break;
            }
            case 2: {
                tmp_attack = this.review_attack[2];
                break;
            }
            default: {
                tmp_attack = this.review_attack[0];
            }
        }
        if (this.isEnable(x, y, type)) {
            tmp_attack += 49;
        }
        if (tmp_attack >= this.attack) {
            this.attack = tmp_attack;
            this.x_attack = x;
            this.y_attack = y;
        }
    }

    private void research_defend(int key) {
        int i = 0;
        while (i < BoardCaro.ROW) {
            int j = 0;
            while (j < BoardCaro.COL) {
                if (this.caro.getValue(i, j) == 0 && this.isNonZero(i, j)) {
                    this.setDefend(i, j, key);
                }
                ++j;
            }
            ++i;
        }
    }

    private void research_Attack(int key) {
        int i = 0;
        while (i < BoardCaro.ROW) {
            int j = 0;
            while (j < BoardCaro.COL) {
                if (this.caro.getValue(i, j) == 0 && this.isNonZero(i, j)) {
                    this.setAttack(i, j, key);
                }
                ++j;
            }
            ++i;
        }
    }

    public int getMax(int a2, int b, int c, int d) {
        return Math.max(Math.max(a2, b), Math.max(c, d));
    }

    public boolean isNonZero(int x, int y) {
        int mV = 2;
        int r = x - 1;
        int r1_count = 0;
        if (r < 0) {
            r1_count = 10;
        }
        while (r >= 0 && this.caro.getValue(r, y) == 0) {
            if (--r >= 0 || ++r1_count >= mV) continue;
            r1_count = 10;
        }
        int r2_count = 0;
        r = x + 1;
        if (r >= BoardCaro.ROW) {
            r2_count = 10;
        }
        while (r < BoardCaro.ROW && this.caro.getValue(r, y) == 0) {
            if (++r < BoardCaro.ROW || ++r2_count >= mV) continue;
            r2_count = 10;
        }
        int c = y - 1;
        int c1_count = 0;
        if (c < 0) {
            c1_count = 10;
        }
        while (c >= 0 && this.caro.getValue(x, c) == 0) {
            if (--c >= 0 || ++c1_count >= mV) continue;
            c1_count = 10;
        }
        c = y + 1;
        int c2_count = 0;
        if (c >= BoardCaro.COL) {
            c2_count = 10;
        }
        while (c < BoardCaro.COL && this.caro.getValue(x, c) == 0) {
            if (++c < BoardCaro.COL || ++c2_count >= mV) continue;
            c2_count = 10;
        }
        int d1 = x - 1;
        int d2 = y - 1;
        int d1_count = 0;
        if (d1 < 0 || d2 < 0) {
            d1_count = 10;
        }
        while (d1 >= 0 && d2 >= 0 && this.caro.getValue(d1, d2) == 0) {
            if (--d1 >= 0 && --d2 >= 0 || ++d1_count >= mV) continue;
            d1_count = 10;
        }
        d1 = x + 1;
        d2 = y + 1;
        int d2_count = 0;
        if (d1 >= BoardCaro.ROW || d2 >= BoardCaro.COL) {
            d2_count = 10;
        }
        while (d1 < BoardCaro.ROW && d2 < BoardCaro.COL && this.caro.getValue(d1, d2) == 0) {
            if (++d1 < BoardCaro.ROW && ++d2 < BoardCaro.COL || ++d2_count >= mV) continue;
            d2_count = 10;
        }
        int d11 = x + 1;
        int d22 = y - 1;
        int d3_count = 0;
        if (d11 >= BoardCaro.ROW || d22 < 0) {
            d3_count = 10;
        }
        while (d11 < BoardCaro.ROW && d22 >= 0 && this.caro.getValue(d11, d22) == 0) {
            if (++d11 < BoardCaro.ROW && --d22 >= 0 || ++d3_count >= mV) continue;
            d3_count = 10;
        }
        d11 = x - 1;
        d22 = y + 1;
        int d4_count = 0;
        if (d11 < 0 || d22 >= BoardCaro.COL) {
            d4_count = 10;
        }
        while (d11 >= 0 && d22 < BoardCaro.COL && this.caro.getValue(d11, d22) == 0) {
            if (--d11 >= 0 && ++d22 < BoardCaro.COL || ++d4_count >= mV) continue;
            d4_count = 10;
        }
        return c1_count < mV || c2_count < mV || r1_count < mV || r2_count < mV || d1_count < mV || d2_count < mV || d3_count < mV || d4_count < mV;
    }

    public boolean isEnable(int x, int y, int type) {
        int r = x - 1;
        int r_count = 1;
        boolean isOk = false;
        while (r >= 0 && (this.caro.getValue(r, y) == type || this.caro.getValue(r, y) == 0)) {
            ++r_count;
            if (--r >= 0 && this.caro.getValue(r, y) == type) {
                isOk = true;
            }
            if (r_count < this.stepWin || !isOk) continue;
            return true;
        }
        r = x + 1;
        isOk = false;
        while (r < BoardCaro.ROW && (this.caro.getValue(r, y) == type || this.caro.getValue(r, y) == 0)) {
            ++r_count;
            if (++r < BoardCaro.ROW && this.caro.getValue(r, y) == type) {
                isOk = true;
            }
            if (r_count < 5 || !isOk) continue;
            return true;
        }
        int c = y - 1;
        int c_count = 1;
        isOk = false;
        while (c >= 0 && (this.caro.getValue(x, c) == type || this.caro.getValue(x, c) == 0)) {
            ++c_count;
            if (--c >= 0 && this.caro.getValue(x, c) == type) {
                isOk = true;
            }
            if (c_count < 5 || !isOk) continue;
            return true;
        }
        c = y + 1;
        isOk = false;
        while (c < BoardCaro.COL && (this.caro.getValue(x, c) == type || this.caro.getValue(x, c) == 0)) {
            ++c_count;
            if (++c < BoardCaro.COL && this.caro.getValue(x, c) == type) {
                isOk = true;
            }
            if (c_count < 5 || !isOk) continue;
            return true;
        }
        int d1 = x - 1;
        int d2 = y - 1;
        int d_count = 1;
        isOk = false;
        while (d1 >= 0 && d2 >= 0 && (this.caro.getValue(d1, d2) == type || this.caro.getValue(d1, d2) == 0)) {
            ++d_count;
            if (--d1 >= 0 && --d2 >= 0 && this.caro.getValue(d1, d2) == type) {
                isOk = true;
            }
            if (d_count < 5 || !isOk) continue;
            return true;
        }
        d1 = x + 1;
        d2 = y + 1;
        isOk = false;
        while (d1 < BoardCaro.ROW && d2 < BoardCaro.COL && (this.caro.getValue(d1, d2) == type || this.caro.getValue(d1, d2) == 0)) {
            ++d_count;
            if (++d1 < BoardCaro.ROW && ++d2 < BoardCaro.COL && this.caro.getValue(d1, d2) == type) {
                isOk = true;
            }
            if (d_count < 5 || !isOk) continue;
            return true;
        }
        int d11 = x + 1;
        int d22 = y - 1;
        int d1_count = 1;
        isOk = false;
        while (d11 < BoardCaro.ROW && d22 >= 0 && (this.caro.getValue(d11, d22) == type || this.caro.getValue(d11, d22) == 0)) {
            ++d1_count;
            if (++d11 < BoardCaro.ROW && --d22 >= 0 && this.caro.getValue(d11, d22) == type) {
                isOk = true;
            }
            if (d1_count < 5 || !isOk) continue;
            return true;
        }
        d11 = x - 1;
        d22 = y + 1;
        isOk = false;
        while (d11 >= 0 && d22 < BoardCaro.COL && (this.caro.getValue(d11, d22) == type || this.caro.getValue(d11, d22) == 0)) {
            ++d1_count;
            if (--d11 >= 0 && ++d22 < BoardCaro.COL && this.caro.getValue(d11, d22) == type) {
                isOk = true;
            }
            if (d1_count < 5 || !isOk) continue;
            return true;
        }
        return false;
    }

    public void decision() {
        this.reset();
        this.research_Attack(ME_TYPE);
        this.research_defend(ENEMY_TYPE);
        if (this.attack == 0 && this.defend == 0) {
            this.caro.setValue(4, 5, ME_TYPE);
            this.current_me_X = 4;
            this.current_me_Y = 5;
        } else if (this.attack >= this.defend) {
            this.caro.setValue(this.x_attack, this.y_attack, ME_TYPE);
            this.current_me_X = this.x_attack;
            this.current_me_Y = this.y_attack;
        } else {
            this.caro.setValue(this.x_defend, this.y_defend, ME_TYPE);
            this.current_me_X = this.x_defend;
            this.current_me_Y = this.y_defend;
        }
        System.out.println("Current: " + this.current_me_X + "  " + this.current_me_X);
    }

    public boolean isMeWin() {
        return this.win(this.current_me_X, this.current_me_Y, ME_TYPE);
    }

    public boolean isEnemyWin() {
        return this.win(this.current_enemy_X, this.current_enemy_Y, ENEMY_TYPE);
    }

    public boolean win(int x, int y, int type) {
        int[] t4;
        int[] t3;
        int[] t2;
        int[] t1 = this.count_row(x, y, type);
        int maxx = this.getMax(t1[0] + t1[1], (t2 = this.count_column(x, y, type))[0] + t2[1], (t3 = this.count_diagonal_1(x, y, type))[0] + t3[1], (t4 = this.count_diagonal_2(x, y, type))[0] + t4[1]);
        return maxx + 1 == 5;
    }

    public void setCurrentEnemy(int x, int y) {
        this.current_enemy_X = x;
        this.current_enemy_Y = y;
    }

    public void reset() {
        this.attack = 0;
        this.defend = 0;
    }
}

