/*
 * Decompiled with CFR 0.152.
 */
package net.awpspace.caromini;

import java.io.InputStream;
import javax.microedition.lcdui.Image;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableImage;

public class ImageLoader {
    private static ImageLoader self;

    private ImageLoader() {
    }

    public static ImageLoader getInstance() {
        if (self == null) {
            self = new ImageLoader();
        }
        return self;
    }

    public Image loadImage(String imagepath) throws RuntimeException {
        Image image;
        try {
            InputStream in = this.getClass().getResourceAsStream(imagepath);
            image = Image.createImage((InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException("ImageLoader failed to load image:" + imagepath + " " + e.getMessage());
        }
        return image;
    }

    public SVGImage loadSVGImage(String imagepath) throws RuntimeException {
        SVGImage svg_image;
        try {
            InputStream in = this.getClass().getResourceAsStream(imagepath);
            svg_image = (SVGImage)ScalableImage.createImage((InputStream)in, null);
        }
        catch (Exception io) {
            throw new RuntimeException("ImageLoader failed to load SVG image:" + imagepath + " " + io.getMessage());
        }
        return svg_image;
    }
}

