/*
 * Decompiled with CFR 0.152.
 */
package net.awpspace.caromini;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import net.awpspace.caromini.Button;
import net.awpspace.caromini.ButtonListener;
import net.awpspace.caromini.CaroMini;
import net.awpspace.caromini.ImageLoader;
import net.awpspace.caromini.MySprite;
import net.awpspace.caromini.OneGameScreen;
import net.awpspace.caromini.TwoGameScreen;

public class MenuGame
extends GameCanvas
implements CommandListener {
    private Image imBg;
    private Image imPanel;
    private Image imMenIn;
    private Image imOneUp;
    private Image imOneDown;
    private Image imTwoUp;
    private Image imTwoDown;
    private Image imHelpUp;
    private Image imHelpDown;
    private Image imInforUp;
    private Image imInforDown;
    private Button oneplayer;
    private Button twoplayer;
    private Button help;
    private Button infor;
    private MySprite menu;
    private CaroMini mid;
    private boolean isMenu = false;
    Command back;
    Image imback1;
    Image imback2;
    Button btnBack;

    public MenuGame(CaroMini mid) {
        super(true);
        this.setFullScreenMode(true);
        this.mid = mid;
        try {
            this.back = new Command("back", 2, 0);
            this.addCommand(this.back);
            this.setCommandListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.load();
        this.loadButton();
        this.setListener();
    }

    private void load() {
        this.imBg = this.loadImage("/bgmenu.png");
        this.imPanel = this.loadImage("/panel.png");
        this.imMenIn = this.loadImage("/menu.png");
        this.imOneUp = this.loadImage("/oneplayerup.png");
        this.imOneDown = this.loadImage("/oneplayerdown.png");
        this.imTwoUp = this.loadImage("/twoplayerup.png");
        this.imTwoDown = this.loadImage("/twoplayerdown.png");
        this.imHelpUp = this.loadImage("/helpup.png");
        this.imHelpDown = this.loadImage("/helpdown.png");
        this.imInforUp = this.loadImage("/inforup.png");
        this.imInforDown = this.loadImage("/infordown.png");
        try {
            this.setCommandListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.imback1 = this.loadImage("/back1.png");
        this.imback2 = this.loadImage("/back2.png");
        this.btnBack = new Button(this.imback1, this.imback2, 198, 358);
        this.btnBack.setListener(new ButtonListener(){

            public void actionUp() {
                super.actionUp();
                MenuGame.this.mid.exitMIDlet();
            }
        });
    }

    public Image loadImage(String path) {
        return ImageLoader.getInstance().loadImage(path);
    }

    private void loadButton() {
        this.menu = new MySprite(this.imMenIn, 2, 1, 197, 290);
        this.oneplayer = new Button(this.imOneUp, this.imOneDown, 8, 290);
        this.twoplayer = new Button(this.imTwoUp, this.imTwoDown, 52, 290);
        this.help = new Button(this.imHelpUp, this.imHelpDown, 117, 290);
        this.infor = new Button(this.imInforUp, this.imInforDown, 159, 290);
    }

    private void setListener() {
        this.oneplayer.setListener(new ButtonListener(){

            public void actionUp() {
                super.actionUp();
                MenuGame.this.mid.getDisplay().setCurrent((Displayable)new OneGameScreen(MenuGame.this.mid));
            }
        });
        this.twoplayer.setListener(new ButtonListener(){

            public void actionUp() {
                super.actionUp();
                System.out.println("AAAAA");
                MenuGame.this.mid.getDisplay().setCurrent((Displayable)new TwoGameScreen(MenuGame.this.mid));
            }
        });
        this.help.setListener(new ButtonListener(){

            public void actionUp() {
                super.actionUp();
                Alert alert = new Alert("How to play", "Caro Easy is easy mode of Caro Game. You can play with mobile or your friends.\nHaving Fun.", null, AlertType.INFO);
                alert.addCommand(new Command("OK", 4, 0));
                MenuGame.this.mid.getDisplay().setCurrent(alert, (Displayable)MenuGame.this);
            }
        });
        this.infor.setListener(new ButtonListener(){

            public void actionUp() {
                super.actionUp();
                MenuGame.this.showAbout();
            }
        });
    }

    public void paint(Graphics g) {
        g.drawImage(this.imBg, 0, 0, 20);
        if (this.isMenu) {
            g.drawImage(this.imPanel, 0, 287, 0);
            this.oneplayer.draw(g);
            this.twoplayer.draw(g);
            this.help.draw(g);
            this.infor.draw(g);
        }
        this.menu.paint(g);
        this.btnBack.draw(g);
    }

    protected void pointerPressed(int x, int y) {
        this.btnBack.actionDown(x, y);
        if (this.inSprite(this.menu, x, y)) {
            this.menu.nextFrame();
            this.isMenu = !this.isMenu;
            this.repaint();
            return;
        }
        if (this.isMenu) {
            this.oneplayer.actionDown(x, y);
            this.twoplayer.actionDown(x, y);
            this.help.actionDown(x, y);
            this.infor.actionDown(x, y);
        }
        this.repaint();
    }

    public void showAbout() {
        Alert dialog = new Alert("About", "Development by withlovei.\nhttps://www.facebook.com/AwpSpace?ref=hl\nEmail:phamkyit@gmail.com\n@Copyright of Awpspace team", null, AlertType.INFO);
        dialog.addCommand(new Command("OK", 4, 1));
        this.mid.switchDisplayable(dialog, (Displayable)this);
    }

    protected void pointerReleased(int x, int y) {
        if (this.btnBack.isPressed) {
            this.btnBack.actionUp(x, y);
            return;
        }
        if (this.isMenu) {
            this.oneplayer.actionUp(x, y);
            this.twoplayer.actionUp(x, y);
            this.help.actionUp(x, y);
            this.infor.actionUp(x, y);
        }
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        this.mid.exitMIDlet();
    }

    public boolean inSprite(Sprite s, int x, int y) {
        return x > s.getX() && x < s.getX() + s.getWidth() && y > s.getY() && y < s.getY() + s.getHeight();
    }
}

