/*
 * Decompiled with CFR 0.152.
 */
package net.awpspace.caromini;

import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import net.awpspace.caromini.Algorithm;
import net.awpspace.caromini.Board;
import net.awpspace.caromini.BoardCaro;
import net.awpspace.caromini.Button;
import net.awpspace.caromini.ButtonListener;
import net.awpspace.caromini.CaroMini;
import net.awpspace.caromini.Hand;
import net.awpspace.caromini.ImageLoader;
import net.awpspace.caromini.MenuGame;
import net.awpspace.caromini.MySprite;

public class OneGameScreen
extends GameCanvas
implements CommandListener {
    public static final int START = 1;
    public static final int WARNING = 2;
    public static final int WINGAME = 3;
    public static final int LOSEGAME = 4;
    private BoardCaro caro;
    private int widthCell = 25;
    private int heightCell = 25;
    private boolean gameOver = false;
    private Algorithm al;
    private CaroMini game;
    Image X;
    Image O;
    Image imExpandUp;
    Image imExpandDown;
    Image imMoveUp;
    Image imMoveDown;
    Image imClearUp;
    Image imClearDown;
    Image imBackUp;
    Image imBackDown;
    Image imExpand;
    Image imrow;
    Image imcol;
    Image imOkUp;
    Image imOkDown;
    Image imHand;
    Image imYourTurn;
    Image imMobileTurn;
    Image imYouWin;
    Image imMobileWin;
    MySprite yourTurn;
    MySprite mobileTurn;
    Button expand;
    Button move;
    Button clear;
    Button back;
    Button ok;
    boolean isExpand = false;
    boolean allowMove = false;
    int count = 0;
    Board board;
    int currentX;
    int currentY;
    Hand hand;
    int curX;
    int curY;
    boolean isTurn = true;
    int win = 0;
    Vector current = new Vector();
    Image imback1;
    Image imback2;
    Button btnBack;
    private Timer timer = new Timer();

    public OneGameScreen(CaroMini g) {
        super(true);
        this.setFullScreenMode(true);
        this.game = g;
        this.caro = BoardCaro.getInstance();
        this.caro.reset();
        this.al = new Algorithm();
        try {
            this.setCommandListener(this);
            this.addCommand(new Command("Exit", 2, 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.load();
        this.board = new Board(this.imrow, this.imcol, -130, -50);
    }

    private void load() {
        this.X = this.loadImage("/x.png");
        this.O = this.loadImage("/o.png");
        this.imMoveUp = this.loadImage("/moveup.png");
        this.imMoveDown = this.loadImage("/movedown.png");
        this.imClearUp = this.loadImage("/clearup.png");
        this.imClearDown = this.loadImage("/cleardown.png");
        this.imBackUp = this.loadImage("/resetup.png");
        this.imBackDown = this.loadImage("/resetdown.png");
        this.imExpand = this.loadImage("/expand.png");
        this.imrow = this.loadImage("/row.png");
        this.imcol = this.loadImage("/col.png");
        this.imYourTurn = this.loadImage("/yourturn.png");
        this.imMobileTurn = this.loadImage("/mobileturn.png");
        this.imOkUp = this.loadImage("/ok1.png");
        this.imOkDown = this.loadImage("/ok2.png");
        this.imHand = this.loadImage("/hand.png");
        this.imExpandUp = this.loadImage("/expandup.png");
        this.imExpandDown = this.loadImage("/expanddown.png");
        this.imYouWin = this.loadImage("/youwin.png");
        this.imMobileWin = this.loadImage("/mobilewin.png");
        this.expand = new Button(this.imExpandUp, this.imExpandDown, 0, 365);
        this.move = new Button(this.imMoveUp, this.imMoveDown, 42, 370);
        this.clear = new Button(this.imClearUp, this.imClearDown, 77, 370);
        this.back = new Button(this.imBackUp, this.imBackDown, 112, 370);
        this.ok = new Button(this.imOkUp, this.imOkDown, 95, 358);
        this.hand = new Hand(this.imHand);
        this.hand.update(120, 160);
        this.yourTurn = new MySprite(this.imYourTurn, 2, 1, 5, 5);
        this.mobileTurn = new MySprite(this.imMobileTurn, 2, 1, 130, 15);
        this.setListener();
        this.mobileTurn.nextFrame();
        this.imback1 = this.loadImage("/back1.png");
        this.imback2 = this.loadImage("/back2.png");
        this.btnBack = new Button(this.imback1, this.imback2, 198, 358);
        this.btnBack.setListener(new ButtonListener(){

            public void actionUp() {
                super.actionUp();
                Alert warning = new Alert("Exit game");
                warning.setString("Are you really quit!");
                warning.addCommand(new Command("OK", 4, 1));
                warning.addCommand(new Command("Cancel", 3, 1));
                warning.setCommandListener(new CommandListener(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void commandAction(Command c, Displayable d) {
                        if (c.getLabel().equals("OK")) {
                            OneGameScreen.access$0(1.access$0(this.this$1)).getDisplay().setCurrent((Displayable)new MenuGame(OneGameScreen.access$0(1.access$0(this.this$1))));
                        } else if (c.getLabel().equals("Cancel")) {
                            OneGameScreen.access$0(1.access$0(this.this$1)).getDisplay().setCurrent((Displayable)1.access$0(this.this$1));
                        }
                    }
                });
                OneGameScreen.this.game.switchDisplayable(warning, (Displayable)OneGameScreen.this);
            }

            static /* synthetic */ OneGameScreen access$0(1 var0) {
                return var0.OneGameScreen.this;
            }
        });
    }

    private void setListener() {
        this.expand.setListener(new ButtonListener(){

            public void actionUp() {
                super.actionUp();
                OneGameScreen.this.isExpand = !OneGameScreen.this.isExpand;
                OneGameScreen.this.repaint();
            }
        });
        this.move.setListener(new ButtonListener(){

            public void actionUp() {
                super.actionUp();
                OneGameScreen.this.isExpand = !OneGameScreen.this.isExpand;
                OneGameScreen.this.allowMove = !OneGameScreen.this.allowMove;
                OneGameScreen.this.expand.isPressed = false;
                OneGameScreen.this.repaint();
            }
        });
        this.clear.setListener(new ButtonListener(){

            public void actionUp() {
                super.actionUp();
                OneGameScreen.this.reset();
                OneGameScreen.this.repaint();
                OneGameScreen.this.win = 0;
            }
        });
        this.back.setListener(new ButtonListener(){

            public void actionUp() {
                super.actionUp();
                OneGameScreen.this.back();
                OneGameScreen.this.repaint();
            }
        });
        this.ok.setListener(new ButtonListener(){

            public void actionUp() {
                OneGameScreen.this.allowMove = !OneGameScreen.this.allowMove;
                OneGameScreen.this.repaint();
                super.actionUp();
            }
        });
    }

    private Image loadImage(String path) {
        return ImageLoader.getInstance().loadImage(path);
    }

    public void drawCell(int type, int x, int y, Graphics g) {
        int real_x = x * this.heightCell;
        int real_y = y * this.widthCell;
        int anchorX = 5;
        int anchorY = 0;
        if (type == 1) {
            g.setColor(255, 0, 0);
            g.drawString("X", real_x + anchorX, real_y + anchorY, 0);
        } else if (type == 2) {
            g.setColor(0, 0, 255);
            g.drawString("O", real_x + anchorX, real_y + anchorY, 0);
        }
    }

    public void drawBoard(Graphics g) {
        int i = 0;
        while (i < 10) {
            g.drawImage(this.imrow, 0, 40 + this.heightCell * i, 0);
            ++i;
        }
        i = 0;
        while (i < 10) {
            g.drawImage(this.imcol, 20 + this.widthCell * i, 0, 0);
            ++i;
        }
    }

    public void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, 240, 400);
        this.board.paint(g);
        this.board.drawValue(g, BoardCaro.getInstance().board, this.X, this.O);
        if (this.allowMove) {
            this.ok.draw(g);
            this.hand.draw(g);
        }
        if (this.isExpand) {
            g.drawImage(this.imExpand, 5, 400 - this.imExpand.getHeight() - 1, 0);
            this.move.draw(g);
            this.clear.draw(g);
            this.back.draw(g);
        }
        this.expand.draw(g);
        if (this.gameOver) {
            g.setColor(250, 70, 250);
            g.setFont(Font.getDefaultFont());
        }
        this.yourTurn.paint(g);
        this.mobileTurn.paint(g);
        if (this.win == 1) {
            g.drawImage(this.imYouWin, 30, 200, 0);
        } else if (this.win == 2) {
            g.drawImage(this.imMobileWin, 5, 200, 0);
        }
        this.btnBack.draw(g);
    }

    protected void pointerDragged(int x, int y) {
        if (this.allowMove) {
            int a2 = x - this.currentX < 0 ? -2 : 2;
            int b = y - this.currentY < 0 ? -2 : 2;
            this.board.move(a2, b);
            this.hand.update(x, y);
            this.repaint();
        }
    }

    protected void pointerPressed(int x, int y) {
        this.currentX = x;
        this.currentY = y;
        this.expand.actionDown(x, y);
        this.btnBack.actionDown(x, y);
        if (this.allowMove) {
            this.ok.actionDown(x, y);
        }
        if (this.isExpand) {
            this.move.actionDown(x, y);
            this.clear.actionDown(x, y);
            this.back.actionDown(x, y);
        }
        this.repaint();
    }

    protected void pointerReleased(int x, int y) {
        if (this.btnBack.isPressed) {
            this.btnBack.actionUp(x, y);
            return;
        }
        if (this.allowMove) {
            this.ok.actionUp(x, y);
            this.repaint();
            return;
        }
        if (this.expand.isPressed || this.move.isPressed || this.clear.isPressed || this.back.isPressed) {
            this.expand.actionUp(x, y);
            this.move.actionUp(x, y);
            this.clear.actionUp(x, y);
            if (!this.gameOver) {
                this.back.actionUp(x, y);
            }
            this.repaint();
            return;
        }
        if (this.isExpand || this.gameOver) {
            return;
        }
        System.out.println(String.valueOf(x) + " " + y);
        if (this.isTurn) {
            int real_x = (x + Math.abs(this.board.x)) / this.widthCell;
            int real_y = (y + Math.abs(this.board.y)) / this.heightCell;
            System.out.println("Me: " + real_x + " " + real_y);
            if (this.caro.getValue(real_x, real_y) != 0) {
                this.warning();
                return;
            }
            this.caro.setValue(real_x, real_y, 1);
            this.al.setCurrentEnemy(real_x, real_y);
            this.current.addElement(new int[]{real_x, real_y});
            this.yourTurn.nextFrame();
            this.mobileTurn.nextFrame();
            this.repaint();
            if (this.al.isEnemyWin()) {
                this.gameOver = true;
                this.win = 1;
                this.isExpand = true;
                this.notifyYouWinGame();
                this.repaint();
                return;
            }
            this.isTurn = false;
            this.mobileTurn();
        }
        this.repaint();
    }

    private void notifyMobileWinGame() {
    }

    private void notifyYouWinGame() {
    }

    private void warning() {
        Alert warning = new Alert("Invalid move");
        warning.addCommand(new Command("OK", 4, 1));
        warning.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                OneGameScreen.this.game.getDisplay().setCurrent((Displayable)OneGameScreen.this);
            }
        });
        this.game.switchDisplayable(warning, (Displayable)this);
    }

    private void back() {
        if (this.current.size() == 0) {
            return;
        }
        System.out.println(this.current.size());
        int[] a2 = (int[])this.current.lastElement();
        this.current.removeElementAt(this.current.size() - 1);
        System.out.println(String.valueOf(this.current.size()) + "  " + a2[0] + "|" + a2[1]);
        int[] b = (int[])this.current.lastElement();
        this.current.removeElementAt(this.current.size() - 1);
        System.out.println(String.valueOf(this.current.size()) + "  " + b[0] + "|" + b[1]);
        this.caro.setValue(a2[0], a2[1], 0);
        this.caro.setValue(b[0], b[1], 0);
        this.repaint();
    }

    public void mobileTurn() {
        TimerTask task = new TimerTask(){

            public void run() {
                OneGameScreen.this.al.decision();
                OneGameScreen.this.current.addElement(new int[]{((OneGameScreen)OneGameScreen.this).al.current_me_X, ((OneGameScreen)OneGameScreen.this).al.current_me_Y});
                OneGameScreen.this.isTurn = true;
                OneGameScreen.this.mobileTurn.nextFrame();
                OneGameScreen.this.yourTurn.nextFrame();
                if (OneGameScreen.this.al.isMeWin()) {
                    OneGameScreen.this.win = 2;
                    OneGameScreen.this.isExpand = true;
                    OneGameScreen.this.gameOver = true;
                    OneGameScreen.this.repaint();
                    OneGameScreen.this.notifyMobileWinGame();
                    return;
                }
                OneGameScreen.this.repaint();
            }
        };
        this.timer.schedule(task, 1L);
    }

    public void commandAction(Command command, Displayable displayable) {
        Alert warning = new Alert("Are you really quit!");
        warning.addCommand(new Command("OK", 4, 1));
        warning.addCommand(new Command("Cancel", 3, 1));
        warning.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("OK")) {
                    OneGameScreen.this.game.getDisplay().setCurrent((Displayable)new MenuGame(OneGameScreen.this.game));
                } else if (c.getLabel().equals("Cancel")) {
                    OneGameScreen.this.game.getDisplay().setCurrent((Displayable)OneGameScreen.this);
                }
            }
        });
        this.game.switchDisplayable(warning, (Displayable)this);
    }

    public void reset() {
        this.al.reset();
        this.caro.reset();
        this.gameOver = false;
    }

    public boolean inSprite(Sprite s, int x, int y) {
        return x > s.getX() && x < s.getX() + s.getWidth() && y > s.getY() && y < s.getY() + s.getHeight();
    }
}

