/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenu {
    DrawString ds;
    DisplayableCanvas dc;
    int MENU_MODE;
    final byte SPLASH;
    final byte MAIN_MENU;
    final byte OPTIONS = (byte)3;
    final byte HELP = (byte)4;
    final byte ABOUT = (byte)5;
    int WIDTH;
    int HEIGHT;
    Image imgLogo;
    Image imgSplash;
    Image imgAboutLogo;
    Image imgMenuLogo;
    Image[] imgFont;
    Image imgSelection;
    Font font = Font.getFont((int)0, (int)1, (int)16);
    boolean isContinue;
    boolean onoffs = true;
    boolean onoffv = true;
    Button butContinue;
    Button butNewGame;
    Button butOption;
    Button butHelp;
    Button butAbout;
    Button butExit;
    Button butSoundon;
    Button butSoundoff;
    Button butVibrateon;
    Button butVibrateoff;
    Button buttonHome;
    Button buttonHelpData;
    Image imgHelpText;
    Image imgUpArrow;
    Image imgDownArrow;
    int selectIndex = -1;
    int noofline;
    byte optionIndex;

    public MainMenu(DisplayableCanvas dc, DrawString ds) {
        this.SPLASH = 0;
        this.MAIN_MENU = 1;
        this.dc = dc;
        this.ds = ds;
        this.WIDTH = dc.WIDTH;
        this.HEIGHT = dc.HEIGHT;
    }

    public void resetSplash() {
        try {
            this.imgLogo = Image.createImage((String)"/res/menu/logo.png");
            this.imgSplash = Image.createImage((String)"/res/menu/splash.png");
        }
        catch (Exception io) {
            io.printStackTrace();
        }
        this.MENU_MODE = 0;
    }

    public void resetMainMenu() {
        if (this.imgMenuLogo == null) {
            try {
                this.imgMenuLogo = Image.createImage((String)"/res/menu/menulogo.png");
                this.imgSelection = Image.createImage((String)"/res/menu/selection.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.butContinue == null) {
            this.butContinue = new Button(0, 0, "/res/menu/continue0.png", null);
            this.butNewGame = new Button(0, 0, "/res/menu/play0.png", null);
            this.butOption = new Button(0, 0, "/res/menu/option0.png", null);
            this.butHelp = new Button(0, 0, "/res/menu/help0.png", null);
            this.butAbout = new Button(0, 0, "/res/menu/about0.png", null);
            this.butExit = new Button(0, 0, "/res/menu/exit0.png", null);
            this.butSoundon = new Button(this.WIDTH - 86 >> 1, 90, "/res/menu/soundon0.png", null);
            this.butSoundoff = new Button(this.WIDTH - 92 >> 1, 90, "/res/menu/soundoff0.png", null);
            this.butVibrateon = new Button(this.WIDTH - 118 >> 1, 140, "/res/menu/vibrateon0.png", null);
            this.butVibrateoff = new Button(this.WIDTH - 125 >> 1, 140, "/res/menu/vibrateoff0.png", null);
            this.buttonHome = new Button(this.WIDTH - 40, this.HEIGHT - 30, "/res/menu/homeIcon0.png", null);
        }
        if (this.isContinue) {
            this.butContinue.setXY(this.WIDTH - 195 + (195 - this.butContinue.width >> 1), 15);
            this.butNewGame.setXY(this.WIDTH - 195 + (195 - this.butNewGame.width >> 1), this.butContinue.y + 35);
            this.butOption.setXY(this.WIDTH - 195 + (195 - this.butOption.width >> 1), this.butNewGame.y + 35);
            this.butHelp.setXY(this.WIDTH - 195 + (195 - this.butHelp.width >> 1), this.butOption.y + 35);
            this.butAbout.setXY(this.WIDTH - 195 + (195 - this.butAbout.width >> 1), this.butHelp.y + 35);
            this.butExit.setXY(this.WIDTH - 195 + (195 - this.butExit.width >> 1), this.butAbout.y + 35);
        } else {
            this.butNewGame.setXY(this.WIDTH - 195 + (195 - this.butNewGame.width >> 1), 25);
            this.butOption.setXY(this.WIDTH - 195 + (195 - this.butOption.width >> 1), this.butNewGame.y + 40);
            this.butHelp.setXY(this.WIDTH - 195 + (195 - this.butHelp.width >> 1), this.butOption.y + 40);
            this.butAbout.setXY(this.WIDTH - 195 + (195 - this.butAbout.width >> 1), this.butHelp.y + 40);
            this.butExit.setXY(this.WIDTH - 195 + (195 - this.butExit.width >> 1), this.butAbout.y + 40);
        }
        this.selectIndex = -1;
        this.MENU_MODE = 1;
    }

    public void clearMenu() {
        try {
            if (this.imgMenuLogo != null) {
                this.imgMenuLogo = null;
                this.imgSelection = null;
                this.butContinue = null;
                this.butNewGame = null;
                this.butOption = null;
                this.butHelp = null;
                this.butAbout = null;
                this.butExit = null;
                this.butSoundon = null;
                this.butSoundoff = null;
                this.butVibrateon = null;
                this.butVibrateoff = null;
                this.buttonHome = null;
                System.gc();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetHighScore() {
    }

    public void resetOptions() {
        this.optionIndex = (byte)-1;
    }

    public void resetHelp() {
        if (this.buttonHelpData == null) {
            try {
                if (this.buttonHelpData == null) {
                    try {
                        this.imgHelpText = Image.createImage((String)"/res/menu/helpText.png");
                        this.imgUpArrow = Image.createImage((String)"/res/upArrow.png");
                        this.imgDownArrow = Image.createImage((String)"/res/downArrow.png");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.buttonHelpData = new Button(this.WIDTH - this.imgHelpText.getWidth() >> 1, 50, this.imgHelpText.getWidth(), 155, -1, -1);
                    this.buttonHelpData.nameX = this.buttonHelpData.x;
                    this.buttonHelpData.nameY = this.buttonHelpData.y;
                    this.buttonHelpData.name = "Try not to become the chefs special for the day. Make a run for it. A fun game for all ages.\nThe game has four levels, with five lives. If you loose all your five lives you lose the game.\nAs you escape, try to rescue your fellow roosters from the locked coop by breaking the lock. The percentage bar will reflect your success at breaking. With each level breaking the lock becomes more difficult.\n\nTo run use the right key or 6, left key or 4 \n\nTo jump use the up arrow or 2 \n\nTo break lock use down arrow or 8.";
                    this.noofline = SystemFont.findLines(this.buttonHelpData.name, SystemFont.font1, this.buttonHelpData.width);
                    this.buttonHelpData.imgButton = null;
                }
                this.buttonHelpData.nameY = this.buttonHelpData.y;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resetAbout() {
        try {
            this.imgAboutLogo = Image.createImage((String)"/res/menu/aboutLogo.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void clearAbout() {
        if (this.imgAboutLogo != null) {
            this.imgAboutLogo = null;
        }
        System.gc();
    }

    void clearHelp() {
        if (this.buttonHelpData != null) {
            this.buttonHelpData = null;
            this.imgHelpText = null;
        }
        System.gc();
    }

    public void resetMode(int gameMode) {
        switch (gameMode) {
            case 0: {
                this.resetSplash();
                break;
            }
            case 1: {
                this.resetMainMenu();
                break;
            }
            case 3: {
                this.resetOptions();
                break;
            }
            case 4: {
                this.resetHelp();
                break;
            }
            case 5: {
                this.resetAbout();
            }
        }
        this.MENU_MODE = gameMode;
    }

    protected void pointerPressed(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isContinue && (result = this.butContinue.isPressed(x, y))) {
                    this.selectIndex = 0;
                }
                if (result) break;
                result = this.butNewGame.isPressed(x, y);
                if (!result) {
                    result = this.butOption.isPressed(x, y);
                    if (!result) {
                        result = this.butHelp.isPressed(x, y);
                        if (!result) {
                            result = this.butAbout.isPressed(x, y);
                            if (!result) {
                                result = this.butExit.isPressed(x, y);
                                if (!result) break;
                                this.selectIndex = 5;
                                break;
                            }
                            this.selectIndex = 4;
                            break;
                        }
                        this.selectIndex = 3;
                        break;
                    }
                    this.selectIndex = 2;
                    break;
                }
                this.selectIndex = 1;
                break;
            }
            case 3: {
                if (this.onoffs) {
                    result = this.butSoundon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                } else {
                    result = this.butSoundoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                } else {
                    result = this.butVibrateoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                }
                if (result) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 4: {
                result = this.buttonHome.isPressed(x, y);
                if (result) break;
                result = this.buttonHelpData.isPressed(x, y);
                break;
            }
            case 5: {
                result = this.buttonHome.isPressed(x, y);
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                result = this.butExit.isReleased(x, y);
                if (result) {
                    this.selectIndex = 5;
                    this.selection();
                } else {
                    if (this.isContinue && (result = this.butContinue.isReleased(x, y))) {
                        this.selectIndex = 0;
                        this.selection();
                    }
                    if (!result) {
                        result = this.butNewGame.isReleased(x, y);
                        if (result) {
                            this.selectIndex = 1;
                            this.selection();
                        } else {
                            result = this.butOption.isReleased(x, y);
                            if (result) {
                                this.selectIndex = 2;
                                this.selection();
                            } else {
                                result = this.butHelp.isReleased(x, y);
                                if (result) {
                                    this.selectIndex = 3;
                                    this.selection();
                                } else {
                                    result = this.butAbout.isReleased(x, y);
                                    if (result) {
                                        this.selectIndex = 4;
                                        this.selection();
                                    }
                                }
                            }
                        }
                    }
                }
                this.selectIndex = -1;
                break;
            }
            case 3: {
                if (this.onoffs) {
                    result = this.butSoundon.isReleased(x, y);
                    if (result) {
                        this.onoffs = false;
                    }
                } else {
                    result = this.butSoundoff.isReleased(x, y);
                    if (result) {
                        this.onoffs = true;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isReleased(x, y);
                    if (result) {
                        this.onoffv = false;
                    }
                } else {
                    result = this.butVibrateoff.isReleased(x, y);
                    if (result) {
                        this.onoffv = true;
                    }
                }
                if (!result && (result = this.buttonHome.isReleased(x, y))) {
                    this.MENU_MODE = 1;
                }
                this.optionIndex = (byte)-1;
                break;
            }
            case 4: {
                result = this.buttonHome.isReleased(x, y);
                if (result) {
                    this.clearHelp();
                    this.MENU_MODE = 1;
                    break;
                }
                if (this.buttonHelpData == null) break;
                this.buttonHelpData.isReleased(x, y);
                break;
            }
            case 5: {
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.clearAbout();
                this.MENU_MODE = 1;
            }
        }
    }

    private void selection() {
        switch (this.selectIndex) {
            case 0: {
                this.clearMenu();
                this.dc.continueGame();
                this.dc.getClass();
                this.dc.GAME_MODE = 5;
                break;
            }
            case 1: {
                this.clearMenu();
                this.dc.initGame();
                this.dc.setNoOfSeed();
                this.dc.setRandomSeedXY();
                break;
            }
            case 2: {
                this.resetMode(3);
                break;
            }
            case 3: {
                this.resetMode(4);
                break;
            }
            case 4: {
                this.resetMode(5);
                break;
            }
            case 5: {
                this.dc.midlet.exit();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void input(int KEY) {
        block28: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block27: {
                                block26: {
                                    if (KEY == this.dc.KEY_LEFT_SOFT) break block26;
                                    if (KEY != 42) break block27;
                                }
                                this.dc.KEY = 0;
                                break block28;
                            }
                            if (KEY == this.dc.KEY_RIGHT_SOFT) break block29;
                            if (KEY != 35) break block30;
                        }
                        switch (this.MENU_MODE) {
                            case 3: 
                            case 4: 
                            case 5: {
                                this.MENU_MODE = 1;
                                break;
                            }
                        }
                        break block28;
                    }
                    if (KEY == 49) break block28;
                    if (KEY != 50) break block31;
                    switch (this.MENU_MODE) {
                        case 1: {
                            if (this.isContinue) {
                                this.selectIndex = (this.selectIndex + 5) % 6;
                                break;
                            }
                            --this.selectIndex;
                            if (this.selectIndex == 0) {
                                this.selectIndex = 5;
                                break;
                            }
                            if (this.selectIndex != 6) break;
                            this.selectIndex = 5;
                            break;
                        }
                        case 3: {
                            if (this.optionIndex == 0) {
                                this.optionIndex = 1;
                                break;
                            }
                            this.optionIndex = 0;
                            break;
                        }
                        case 4: {
                            this.buttonHelpData.nameY += SystemFont.fontHeight1;
                            if (this.buttonHelpData.nameY <= this.buttonHelpData.y) break;
                            this.buttonHelpData.nameY = this.buttonHelpData.y;
                            break;
                        }
                    }
                    this.dc.KEY = 0;
                    break block28;
                }
                if (KEY != 56) break block32;
                switch (this.MENU_MODE) {
                    case 1: {
                        if (this.isContinue) {
                            this.selectIndex = (this.selectIndex + 1) % 6;
                            break;
                        }
                        ++this.selectIndex;
                        if (this.selectIndex == 6) {
                            this.selectIndex = 1;
                            break;
                        }
                        break block28;
                    }
                    case 3: {
                        if (this.optionIndex == 0) {
                            this.optionIndex = 1;
                            break;
                        }
                        this.optionIndex = 0;
                        break;
                    }
                    case 4: {
                        this.buttonHelpData.nameY -= SystemFont.fontHeight1;
                        if (this.buttonHelpData.nameY - this.buttonHelpData.y < -(this.noofline * SystemFont.fontHeight1 - this.buttonHelpData.height)) {
                            this.buttonHelpData.nameY = this.buttonHelpData.y - (this.noofline * SystemFont.fontHeight1 - this.buttonHelpData.height);
                            break;
                        }
                        break block28;
                    }
                }
                break block28;
            }
            if (KEY == 53) {
                switch (this.MENU_MODE) {
                    case 1: {
                        this.selection();
                        break;
                    }
                    case 3: {
                        if (this.optionIndex == 0) {
                            this.onoffs = !this.onoffs;
                            break;
                        }
                        this.onoffv = !this.onoffv;
                        break;
                    }
                }
            }
        }
        this.dc.KEY = 0;
    }

    public void run() {
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter <= 60) break;
                this.imgSplash = null;
                this.resetMode(1);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter < 40) {
                    g.setColor(0xFFFFFF);
                    g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                    g.drawImage(this.imgLogo, this.WIDTH >> 1, this.HEIGHT >> 1, 1 | 2);
                    break;
                }
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                break;
            }
            case 1: {
                g.setColor(0xFFCC00);
                g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                g.drawImage(this.imgMenuLogo, 20, 67, 0x10 | 4);
                if (this.isContinue) {
                    this.butContinue.paint(g);
                }
                this.butNewGame.paint(g);
                this.butOption.paint(g);
                this.butHelp.paint(g);
                this.butAbout.paint(g);
                this.butExit.paint(g);
                switch (this.selectIndex) {
                    case 0: {
                        g.drawImage(this.imgSelection, this.butContinue.x - this.imgSelection.getWidth(), this.butContinue.y + 15, 0x10 | 4);
                        break;
                    }
                    case 1: {
                        g.drawImage(this.imgSelection, this.butNewGame.x - this.imgSelection.getWidth(), this.butNewGame.y + 15, 0x10 | 4);
                        break;
                    }
                    case 2: {
                        g.drawImage(this.imgSelection, this.butOption.x - this.imgSelection.getWidth(), this.butOption.y + 15, 0x10 | 4);
                        break;
                    }
                    case 3: {
                        g.drawImage(this.imgSelection, this.butHelp.x - this.imgSelection.getWidth(), this.butHelp.y + 15, 0x10 | 4);
                        break;
                    }
                    case 4: {
                        g.drawImage(this.imgSelection, this.butAbout.x - this.imgSelection.getWidth(), this.butAbout.y + 15, 0x10 | 4);
                        break;
                    }
                    case 5: {
                        g.drawImage(this.imgSelection, this.butExit.x - this.imgSelection.getWidth(), this.butExit.y + 15, 0x10 | 4);
                    }
                }
                break;
            }
            case 3: {
                g.setColor(0xFFCC00);
                g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                g.drawImage(this.butOption.imgButton[0], this.WIDTH >> 1, 35, 1 | 2);
                if (this.onoffs) {
                    this.butSoundon.paint(g);
                } else {
                    this.butSoundoff.paint(g);
                }
                if (this.onoffv) {
                    this.butVibrateon.paint(g);
                } else {
                    this.butVibrateoff.paint(g);
                }
                if (this.optionIndex == 0) {
                    if (this.onoffs) {
                        g.drawImage(this.imgSelection, this.butSoundon.x - this.imgSelection.getWidth(), this.butSoundon.y + 15, 0x10 | 4);
                    } else {
                        g.drawImage(this.imgSelection, this.butSoundoff.x - this.imgSelection.getWidth(), this.butSoundoff.y + 15, 0x10 | 4);
                    }
                } else if (this.optionIndex == 1) {
                    if (this.onoffv) {
                        g.drawImage(this.imgSelection, this.butVibrateon.x - this.imgSelection.getWidth(), this.butVibrateon.y + 15, 0x10 | 4);
                    } else {
                        g.drawImage(this.imgSelection, this.butVibrateoff.x - this.imgSelection.getWidth(), this.butVibrateoff.y + 15, 0x10 | 4);
                    }
                }
                this.buttonHome.paint(g);
                break;
            }
            case 4: {
                g.setColor(0xFFCC00);
                g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                g.drawImage(this.butHelp.imgButton[0], this.WIDTH >> 1, 20, 1 | 2);
                g.setClip(this.buttonHelpData.x, this.buttonHelpData.y, this.buttonHelpData.width, this.buttonHelpData.height);
                g.drawImage(this.imgHelpText, this.buttonHelpData.nameX, this.buttonHelpData.nameY, 0x10 | 4);
                g.setClip(0, 0, this.WIDTH, this.HEIGHT);
                if (this.buttonHelpData.nameY < this.buttonHelpData.y) {
                    g.drawImage(this.imgUpArrow, this.WIDTH >> 1, this.HEIGHT - 23, 1 | 2);
                }
                if (this.buttonHelpData.nameY + (this.imgHelpText.getHeight() - this.buttonHelpData.height) > this.buttonHelpData.y) {
                    g.drawImage(this.imgDownArrow, this.WIDTH >> 1, this.HEIGHT - 9, 1 | 2);
                }
                this.buttonHome.paint(g);
                break;
            }
            case 5: {
                g.setColor(0xFFCC00);
                g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                g.drawImage(this.butAbout.imgButton[0], this.WIDTH >> 1, 20, 1 | 2);
                if (this.imgAboutLogo != null) {
                    g.drawImage(this.imgAboutLogo, this.WIDTH >> 1, (this.HEIGHT >> 1) + 20, 1 | 2);
                }
                this.buttonHome.paint(g);
            }
        }
        if (this.buttonHome != null && this.buttonHome.buttonState == 1) {
            g.drawImage(this.imgSelection, this.buttonHome.x - this.imgSelection.getWidth(), this.buttonHome.y + 10, 0x10 | 4);
        }
    }

    protected void pointerDragged(int x, int y) {
        if (this.MENU_MODE == 4 && this.buttonHelpData.buttonState == 1) {
            this.buttonHelpData.nameY += y - this.buttonHelpData.touchY;
            this.buttonHelpData.touchY = y;
            if (this.buttonHelpData.nameY > this.buttonHelpData.y) {
                this.buttonHelpData.nameY = this.buttonHelpData.y;
            } else if (this.buttonHelpData.nameY < this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height)) {
                this.buttonHelpData.nameY = this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height);
            }
        }
    }
}

