/*
 * Decompiled with CFR 0.152.
 */
package CrazyLiquid.object;

import CrazyLiquid.main.Global;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;

public class Button
extends GameCanvas {
    public int X;
    public int Y;
    private int Width;
    private int Height;
    private int Type;
    public boolean isVisible;
    private final Listener listener;
    public Sprite sprite;

    public Button(Image img, int width, int height, Listener listener) {
        super(false);
        this.listener = listener;
        this.isVisible = true;
        this.Width = width;
        this.Height = height;
        this.sprite = new Sprite(img, width, height);
        this.Type = 0;
    }

    public boolean checkContains(int x, int y) {
        return this.X <= x && this.X + this.Width >= x && this.Y <= y && this.Y + this.Height >= y;
    }

    public void render(Graphics g) {
        if (!this.isVisible) {
            return;
        }
        this.sprite.setFrame(this.Type);
        this.sprite.setPosition(this.X, this.Y);
        this.sprite.paint(g);
    }

    public void TouchEvent(int type, int x, int y) {
        if (!this.isVisible) {
            return;
        }
        if (type == Global.POINTER_PRESS && this.checkContains(x, y)) {
            this.Type = 1;
        }
        if (type == Global.POINTER_RELEASE && this.checkContains(x, y)) {
            this.Type = 0;
            this.listener.onClick(this);
        }
        if (type == Global.POINTER_DRAGGED) {
            this.Type = this.checkContains(x, y) ? 1 : 0;
        }
    }

    public static interface Listener {
        public void onClick(Button var1);
    }
}

