/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display.textfield;

import tv.ingames.j2dm.display.J2DM_GameObject;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.system.fonts.J2DM_Font;
import tv.ingames.j2dm.system.fonts.J2DM_FontsManager;
import tv.ingames.j2dm.utils.J2DM_Rect;

public class J2DM_NumberField
extends J2DM_GameObject {
    private J2DM_Font _font;
    private int _textNumber;
    private int _anchorX;
    private int _anchorY;
    private J2DM_Rect[] _tempRect;
    private J2DM_Image _tempImage;

    public J2DM_NumberField(String fontName, int textNumber, String name) {
        super(name);
        this.create(fontName);
        this.setTextNumber(textNumber);
    }

    public J2DM_NumberField(String fontName, int textNumber) {
        this.create(fontName);
        this.setTextNumber(textNumber);
    }

    private void create(String fontName) {
        this.setFont(fontName);
        this._anchorX = 4;
        this._anchorY = 16;
    }

    public void setTextNumber(int textNumber) {
        this._textNumber = textNumber;
    }

    public int getTextNumber() {
        return this._textNumber;
    }

    public int getAnchorX() {
        return this._anchorX;
    }

    public void setAnchorX(int anchorX) {
        this._anchorX = anchorX;
    }

    public int getAnchorY() {
        return this._anchorY;
    }

    public void setAnchorY(int anchorY) {
        this._anchorY = anchorY;
    }

    public void setFont(String fontName) {
        this._font = J2DM_FontsManager.getInstance().getFont(fontName);
        if (this._font == null) {
            J2DM_Console.getInstance().addLog("J2DM_TextField::setFont", "Font is null, fontName:" + fontName, J2DM_ConsoleMessageTypes.ERROR);
            return;
        }
    }

    private int getLengthNumbers(int number) {
        int divisor = 1;
        int cantDigits = 1;
        while (number / (divisor * 10) != 0) {
            divisor *= 10;
            ++cantDigits;
        }
        return cantDigits;
    }

    public void draw(J2DM_Graphics g) {
        int digitNumber;
        if (this._font == null || !this._font.isReady()) {
            return;
        }
        this._tempRect = this._font.getRect();
        this._tempImage = this._font.getImage();
        int amountDigits = this.getLengthNumbers(this._textNumber);
        long module = 1L;
        int i = 0;
        while (i < amountDigits) {
            module *= 10L;
            ++i;
        }
        int[] arrayFramesNumbers = new int[amountDigits];
        int i2 = 0;
        while (i2 < amountDigits) {
            arrayFramesNumbers[i2] = digitNumber = (int)((long)this._textNumber % module / (module / 10L));
            module /= 10L;
            ++i2;
        }
        int x0 = this.getXinitFromAnchor(arrayFramesNumbers, this._anchorX);
        int y0 = this.getYinitFromAnchor(this._anchorY);
        int xcar = 0;
        int ycar = 0;
        int i3 = 0;
        while (i3 < amountDigits) {
            digitNumber = arrayFramesNumbers[i3];
            int xActual = this._x + x0 + this._xGlobal + xcar;
            int yActual = this._y + y0 + this._yGlobal + ycar;
            g.drawImage(xActual, yActual, this._tempRect[digitNumber]._width, this._tempRect[digitNumber]._height, this._tempImage, this._tempRect[digitNumber]._x, this._tempRect[digitNumber]._y);
            xcar += this._tempRect[digitNumber]._width;
            ++i3;
        }
    }

    private int getXinitFromAnchor(int[] _digitsNumber, int anchorX) {
        int xInit = 0;
        int amountDigits = _digitsNumber.length;
        J2DM_Rect[] rect = this._font.getRect();
        int widthInPixels = 0;
        int i = 0;
        while (i < amountDigits) {
            widthInPixels += rect[_digitsNumber[i]]._width;
            ++i;
        }
        switch (anchorX) {
            case 4: {
                xInit = 0;
                break;
            }
            case 8: {
                xInit = -widthInPixels;
                break;
            }
            case 1: {
                xInit = -widthInPixels / 2;
            }
        }
        return xInit;
    }

    private int getYinitFromAnchor(int anchorY) {
        int yInit = 0;
        int heightInPixels = this._font.getSize();
        switch (anchorY) {
            case 16: {
                yInit = 0;
                break;
            }
            case 32: {
                yInit = -heightInPixels;
                break;
            }
            case 2: {
                yInit = -heightInPixels / 2;
            }
        }
        return yInit;
    }

    public void destroy() {
        super.destroy();
        this._font = null;
        this._tempRect = null;
        this._tempImage = null;
    }
}

