/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display.ui;

import tv.ingames.j2dm.display.J2DM_DisplayContainer;
import tv.ingames.j2dm.display.J2DM_Sprite;
import tv.ingames.j2dm.display.ui.J2DM_GenericButton;
import tv.ingames.j2dm.stage.J2DM_Stage;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.system.input.IListenKeyboard;
import tv.ingames.j2dm.utils.J2DM_Point;

public class J2DM_SimpleMenu
extends J2DM_DisplayContainer
implements IListenKeyboard {
    protected J2DM_Sprite _backGround;
    protected J2DM_GenericButton[][] _buttons;
    protected int _indButtonSelectX;
    protected int _indButtonSelectY;
    protected boolean _inStage;
    protected static boolean _touchDevice = false;

    public J2DM_SimpleMenu(J2DM_GenericButton[][] buttons, J2DM_Sprite backGround, String name) {
        super(name);
        this.init(new J2DM_Point(0.0f, 0.0f), buttons, backGround);
    }

    public J2DM_SimpleMenu(J2DM_GenericButton[][] buttons, J2DM_Sprite backGround, J2DM_Point buttonSel, String name) {
        super(name);
        this.init(buttonSel, buttons, backGround);
    }

    public J2DM_SimpleMenu(J2DM_GenericButton[][] buttons, J2DM_Sprite backGround) {
        this.init(new J2DM_Point(0.0f, 0.0f), buttons, backGround);
    }

    public J2DM_SimpleMenu(J2DM_GenericButton[][] buttons, J2DM_Sprite backGround, J2DM_Point buttonSel) {
        this.init(buttonSel, buttons, backGround);
    }

    public static void setTouchDevice(boolean flag) {
        _touchDevice = flag;
    }

    public static boolean getTouchDevice() {
        return _touchDevice;
    }

    protected void init(J2DM_Point buttonSel, J2DM_GenericButton[][] buttons, J2DM_Sprite backGround) {
        this._inStage = false;
        this._buttons = buttons;
        if (this._buttons == null) {
            J2DM_Console.getInstance().addLog("J2DM_SimpleMenu::init", "Null buttons", J2DM_ConsoleMessageTypes.ERROR);
            return;
        }
        this._backGround = backGround;
        if (this._backGround != null) {
            this.addChild(this._backGround);
        }
        int i = 0;
        while (i < this._buttons.length) {
            int j = 0;
            while (j < this._buttons[0].length) {
                if (this._buttons[i][j] != null) {
                    this.addChild(this._buttons[i][j]);
                }
                ++j;
            }
            ++i;
        }
        this._indButtonSelectX = (int)buttonSel.getY();
        this._indButtonSelectY = (int)buttonSel.getX();
        if (!_touchDevice && this._buttons[this._indButtonSelectY][this._indButtonSelectX] != null) {
            this._buttons[this._indButtonSelectY][this._indButtonSelectX].setRollOver();
        }
        J2DM_Stage.getInstance().suscribeKeyboardElement(this);
    }

    public void destroy() {
        super.destroy();
        J2DM_Stage.getInstance().unsuscribeKeyboardElement(this);
        this._backGround = null;
        if (this._buttons != null) {
            int i = 0;
            while (i < this._buttons.length) {
                int j = 0;
                while (j < this._buttons[0].length) {
                    if (this._buttons[i][j] != null) {
                        this._buttons[i][j].destroy();
                        this._buttons[i][j] = null;
                    }
                    ++j;
                }
                ++i;
            }
        }
        this._buttons = null;
        this.hide();
    }

    public void setIndButtonSelect(int indButtonSelectY, int indButtonSelectX) {
        if (this._buttons[this._indButtonSelectY][this._indButtonSelectX] != null) {
            this._buttons[this._indButtonSelectY][this._indButtonSelectX].setRollOut();
        }
        if (indButtonSelectX < this._buttons[0].length && indButtonSelectY < this._buttons.length) {
            this._indButtonSelectX = indButtonSelectX;
            this._indButtonSelectY = indButtonSelectY;
            if (!_touchDevice && this._buttons[this._indButtonSelectY][this._indButtonSelectX] != null) {
                this._buttons[this._indButtonSelectY][this._indButtonSelectX].setRollOver();
            }
        }
    }

    public int getIndButtonSelectX() {
        return this._indButtonSelectX;
    }

    public int getIndButtonSelectY() {
        return this._indButtonSelectY;
    }

    public void keyPressed(char key) {
    }

    public void keyReleased(char key) {
    }

    public void keyRepeated(char key) {
    }

    public void specialKeyPressed(int keyCode) {
        int maxx = this._buttons[0].length;
        int maxy = this._buttons.length;
        switch (keyCode) {
            case 2: {
                if (this._indButtonSelectX - 1 < 0 || this._buttons[this._indButtonSelectY][this._indButtonSelectX - 1] == null || !this._buttons[this._indButtonSelectY][this._indButtonSelectX - 1].getEnable()) break;
                this.setIndButtonSelect(this._indButtonSelectY, this._indButtonSelectX - 1);
                break;
            }
            case 3: {
                if (this._indButtonSelectX + 1 >= maxx || this._buttons[this._indButtonSelectY][this._indButtonSelectX + 1] == null || !this._buttons[this._indButtonSelectY][this._indButtonSelectX + 1].getEnable()) break;
                this.setIndButtonSelect(this._indButtonSelectY, this._indButtonSelectX + 1);
                break;
            }
            case 0: {
                if (this._indButtonSelectY - 1 >= 0 && this._buttons[this._indButtonSelectY - 1][this._indButtonSelectX] != null && this._buttons[this._indButtonSelectY - 1][this._indButtonSelectX].getEnable()) {
                    this.setIndButtonSelect(this._indButtonSelectY - 1, this._indButtonSelectX);
                    break;
                }
                int indX = this.getIFirstXFillSlotFromY(this._indButtonSelectX, this._indButtonSelectY - 1);
                if (indX < 0) break;
                this.setIndButtonSelect(this._indButtonSelectY - 1, indX);
                break;
            }
            case 1: {
                if (this._indButtonSelectY + 1 < maxy && this._buttons[this._indButtonSelectY + 1][this._indButtonSelectX] != null && this._buttons[this._indButtonSelectY + 1][this._indButtonSelectX].getEnable()) {
                    this.setIndButtonSelect(this._indButtonSelectY + 1, this._indButtonSelectX);
                    break;
                }
                int indX = this.getIFirstXFillSlotFromY(this._indButtonSelectX, this._indButtonSelectY + 1);
                if (indX < 0) break;
                this.setIndButtonSelect(this._indButtonSelectY + 1, indX);
                break;
            }
            case 4: {
                if (this._buttons[this._indButtonSelectY][this._indButtonSelectX] == null) break;
                this._buttons[this._indButtonSelectY][this._indButtonSelectX].setPressed();
            }
        }
    }

    private int getIFirstXFillSlotFromY(int x, int y) {
        int maxx = this._buttons[0].length;
        int maxy = this._buttons.length;
        if (y >= 0 && y < maxy) {
            int i = 0;
            while (i < maxx) {
                if (this._buttons[y][i] != null && this._buttons[y][i].getEnable()) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void show() {
        if (!this._inStage) {
            this._inStage = true;
            J2DM_Stage.getInstance().addElement(this, 3);
        }
    }

    public void hide() {
        if (this._inStage) {
            this._inStage = false;
            J2DM_Stage.getInstance().removeElement(this, 3);
        }
    }

    public void specialKeyReleased(int keyCode) {
    }

    public void specialKeyRepeated(int keyCode) {
    }
}

