/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.states;

import tv.ingames.j2dm.core.J2DM_AbstractState;
import tv.ingames.j2dm.core.J2DM_AbstractStateParameters;
import tv.ingames.j2dm.display.J2DM_Sprite;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.stage.J2DM_Stage;
import tv.ingames.j2dm.utils.J2DM_Point;

public class J2DM_StateShowLogo
extends J2DM_AbstractState {
    protected int _x;
    protected int _y;
    protected int _bgColor;
    protected long _timeToShowLogo;
    protected long _timeInit;
    private int _timeFading;
    private J2DM_Sprite _spriteLogo;
    private int _backUpBgColor;

    public J2DM_StateShowLogo() {
        this.init();
    }

    public J2DM_StateShowLogo(J2DM_AbstractStateParameters params) {
        super(params);
        this.init();
    }

    private void init() {
        this._timeFading = 500;
    }

    public void showLogo(J2DM_Image image, int x, int y, int bgColor, long time) {
        this._x = x;
        this._y = y;
        this._bgColor = bgColor;
        this._timeToShowLogo = time;
        this._timeInit = System.currentTimeMillis();
        this._spriteLogo = new J2DM_Sprite(image, new J2DM_Point(image.getWidth() / 2, image.getHeight() / 2));
        J2DM_Stage.getInstance().addElement(this._spriteLogo, 3);
        this._spriteLogo.setX(x);
        this._spriteLogo.setY(y);
        this._backUpBgColor = J2DM_Stage.getInstance().getBgColor();
        J2DM_Stage.getInstance().setBgColor(bgColor);
    }

    public void setTimeFading(int timeFading) {
        this._timeFading = timeFading;
    }

    public int getTimeFading() {
        return this._timeFading;
    }

    public void destroy() {
        super.destroy();
        if (this._spriteLogo != null) {
            this._spriteLogo.destroy();
            this._spriteLogo = null;
        }
    }

    public void update() {
        long timeNow = System.currentTimeMillis();
        long timeLeft = this._timeToShowLogo - (timeNow - this._timeInit);
        if (timeNow - this._timeInit > this._timeToShowLogo) {
            J2DM_Stage.getInstance().setBgColor(this._backUpBgColor);
            J2DM_Stage.getInstance().removeElement(this._spriteLogo, 3);
            this.onFinishState();
        } else if (timeLeft < (long)this._timeFading) {
            int porc = (int)(timeLeft * 100L / (long)this._timeFading);
            int alpha = porc * 255 / 100;
            this._spriteLogo.setAlpha(alpha);
        }
    }
}

