/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.ToneControl;
import javax.microedition.media.control.VolumeControl;

public class AudioPlayer
implements PlayerListener {
    public static final int SINGLE = 0;
    public static final int CONT = 1;
    private int playerMode = 0;
    public static final int CREATE = 0;
    public static final int PLAY = 1;
    public static final int MUTE = 2;
    public static final int UNMUTE = 3;
    public static final int STOP = 4;
    public int ACTION;
    public int playerState;
    private String playerName = null;
    private String soundFile = null;
    private String mimeType = null;
    private Player player = null;
    private VolumeControl volume;
    private ToneControl tc;
    InputStream is = null;
    private boolean playerClosed = false;

    public AudioPlayer(String name, int mode, String file, String type) {
        this.playerName = name;
        this.playerMode = mode;
        this.soundFile = file;
        this.mimeType = type;
    }

    public void nullObjects() {
        if (this.is != null) {
            this.is = null;
        }
        if (this.player != null) {
            this.player.close();
        }
        while (!this.playerClosed) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.player != null) {
            this.player = null;
        }
        if (this.volume != null) {
            this.volume = null;
        }
    }

    public boolean isMediaSupported(String mimeType) {
        String[] types = Manager.getSupportedContentTypes(null);
        int i = 0;
        while (i < types.length) {
            if (mimeType.toLowerCase().equals(types[i].toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void createPlayer() {
        if (this.is == null) {
            try {
                this.is = this.getClass().getResourceAsStream(this.soundFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.playerClosed = false;
        if (this.player != null) {
            this.player = null;
        }
        try {
            this.player = Manager.createPlayer((InputStream)this.is, (String)this.mimeType);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        this.player.addPlayerListener((PlayerListener)this);
        try {
            this.player.realize();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        try {
            this.player.prefetch();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        this.volume = (VolumeControl)this.player.getControl("VolumeControl");
        this.volume.setLevel(100);
    }

    private void createTonePlayer() {
        byte[] sequence = null;
        try {
            this.player = Manager.createPlayer((String)"device://tone");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        this.player.addPlayerListener((PlayerListener)this);
        try {
            this.player.realize();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        this.tc = (ToneControl)this.player.getControl("ToneControl");
        this.tc.setSequence(sequence);
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("closed")) {
            this.playerClosed = true;
        }
    }

    public void runAudioAction(int action) {
        this.playerState = this.player != null ? this.player.getState() : 0;
        switch (action) {
            case 0: {
                this.createPlayer();
                break;
            }
            case 1: {
                if (this.player == null || this.playerState == 0 || (long)this.playerState == -1L || this.playerState == 400) break;
                if (this.playerState == 100) {
                    try {
                        this.player.prefetch();
                        this.player.realize();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                if (this.playerState == 200) {
                    try {
                        this.player.prefetch();
                        this.player.realize();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                if (this.playerState != 300) break;
                if (this.playerMode == 1) {
                    this.player.setLoopCount(-1);
                }
                try {
                    this.player.setMediaTime(0L);
                    this.player.start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 2: {
                if (this.player == null || this.playerState == 0 || (long)this.playerState == -1L) break;
                if (this.playerState == 400) {
                    this.volume.setMute(true);
                    break;
                }
                if (this.playerState == 100) {
                    try {
                        this.player.prefetch();
                        this.player.realize();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                if (this.playerState != 200) break;
                try {
                    this.player.prefetch();
                    this.player.realize();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 3: {
                if (this.player == null || this.playerState == 0 || (long)this.playerState == -1L) break;
                if (this.playerState == 400) {
                    this.volume.setMute(false);
                    break;
                }
                if (this.playerState == 100) {
                    try {
                        this.player.prefetch();
                        this.player.realize();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                if (this.playerState != 200) break;
                try {
                    this.player.prefetch();
                    this.player.realize();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 4: {
                if (this.player == null || this.playerState == 0 || (long)this.playerState == -1L) break;
                if (this.playerState == 400) {
                    try {
                        this.player.stop();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                if (this.playerState == 100) break;
                if (this.playerState == 200) {
                    try {
                        this.player.stop();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                if (this.playerState != 300) break;
                try {
                    this.player.stop();
                    break;
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

