/*
 * Decompiled with CFR 0.152.
 */
package com.academmedia.jewelsaga.views;

import com.academmedia.jewelsaga.components.Activity;
import com.academmedia.jewelsaga.components.NewButton;
import com.academmedia.jewelsaga.content.L10n;
import com.academmedia.jewelsaga.interfaces.ActivityInterface;
import com.academmedia.jewelsaga.interfaces.ActivityListener;
import com.academmedia.jewelsaga.statemachine.StateMachine;
import com.academmedia.jewelsaga.utils.Log;
import com.am.activity.tools.ImageHelper;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

public class MenuView
extends Activity
implements ActivityInterface {
    private NewButton btnPlay;
    private NewButton btnHelp;
    private NewButton btnAbout;
    private NewButton btnExit;
    private ActivityListener listener;
    private Image bg;
    private Sprite background;
    private Sprite logo;

    public MenuView(int w, int h) {
        super(w, h);
        Log.log("MenuView()");
    }

    public MenuView(ActivityListener listener, int w, int h) {
        super(w, h);
        this.listener = listener;
        Log.log("MenuView()");
    }

    public void initResources() {
        Log.log("MenuView.initResources()");
        this.btnPlay = NewButton.createButtonWithImage(this, ImageHelper.loadCached("/img/btnPlay.png"), 500);
        this.btnPlay.setPosition((StateMachine.displayWidth - this.btnPlay.getWidth()) / 2, (StateMachine.displayHeight - this.btnPlay.getHeight()) / 2 + 30);
        this.btnPlay.setText(L10n.get("Play"), Font.getFont((int)32, (int)0, (int)16), 0);
        this.btnHelp = NewButton.createButtonWithImage(this, ImageHelper.loadCached("/img/btnHelp.png"), 502);
        this.btnHelp.setText(L10n.get("btnHelp"));
        this.btnHelp.setPosition(0, 0);
        this.btnAbout = NewButton.createButtonWithImage(this, ImageHelper.loadCached("/img/btnAbout.png"), 503);
        this.btnAbout.setText(L10n.get("btnAbout"));
        this.btnAbout.setPosition(StateMachine.displayWidth - this.btnAbout.getWidth(), 0);
        this.btnExit = NewButton.createButtonWithImage(this, ImageHelper.loadCached("/img/btnExit.png"), 504);
        this.btnExit.setText(L10n.get("btnExit"));
        this.btnExit.setPosition(StateMachine.displayWidth - this.btnExit.getWidth(), StateMachine.displayHeight - this.btnExit.getHeight() - 40);
        System.out.println("height = " + StateMachine.displayHeight + " width = " + StateMachine.displayWidth);
        this.bg = StateMachine.displayHeight < 400 ? ImageHelper.loadCached("/img/back_320.png") : ImageHelper.loadCached("/img/back_400.png");
        this.background = new Sprite(this.bg);
        this.logo = new Sprite(ImageHelper.loadCached("/img/logo.png"));
        this.logo.setPosition(0, 50);
        this.append((Layer)this.logo);
        this.append((Layer)this.background);
    }

    public void paint(Graphics g, int x, int y) {
        super.paint(g, x, y);
        this.btnPlay.printText(g);
        this.btnHelp.printText(g);
        this.btnAbout.printText(g);
    }

    public void refreshResources() {
        Log.log("MenuView.refreshResources()");
        this.listener.removeText();
    }

    public void buttonIsPressed(int index) {
    }

    public void buttonIsReleased(int index) {
        if (index == this.btnHelp.getBtnNum()) {
            this.listener.handleEvent(103);
        }
        if (index == this.btnAbout.getBtnNum()) {
            this.listener.handleEvent(102);
        }
        if (index == this.btnPlay.getBtnNum()) {
            this.listener.handleEvent(104);
        }
        if (index == this.btnExit.getBtnNum()) {
            this.listener.handleEvent(333);
        }
    }

    public boolean isReady() {
        return true;
    }

    public void buttonIsDragged(int btnNum) {
    }
}

