/*
 * Decompiled with CFR 0.152.
 */
package com.academmedia.jewelsaga.components;

import com.academmedia.jewelsaga.components.ButtonInterface;
import com.academmedia.jewelsaga.components.NewButton;
import com.academmedia.jewelsaga.components.OnButtonListener;
import java.util.Vector;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public abstract class Activity
extends LayerManager
implements OnButtonListener {
    private Vector buttons = new Vector();
    private int width;
    private int height;

    public Activity(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public int getID(ButtonInterface o) {
        int index = this.buttons.indexOf(o);
        return index;
    }

    public NewButton getButtonFromID(int index) {
        NewButton but = (NewButton)this.buttons.elementAt(index);
        return but;
    }

    public void addButton(ButtonInterface o, int index) {
        this.buttons.insertElementAt(o, index);
        Sprite sp = (Sprite)o;
        if (sp != null) {
            this.append((Layer)sp);
        }
    }

    public void addButton(ButtonInterface o) {
        this.buttons.addElement(o);
        Sprite sp = (Sprite)o;
        if (sp != null) {
            this.append((Layer)sp);
        }
    }

    public void removeButton(ButtonInterface o) {
        Sprite sp;
        int i = this.buttons.indexOf(o);
        if (i >= 0) {
            this.buttons.removeElementAt(i);
        }
        if ((sp = (Sprite)o) != null) {
            this.remove((Layer)sp);
        }
    }

    public void notifyPointerPressed(int x, int y) {
        if (!this.buttons.isEmpty()) {
            int i = 0;
            while (i < this.buttons.size()) {
                ButtonInterface observer = (ButtonInterface)this.buttons.elementAt(i);
                observer.pointerPressed(x, y);
                ++i;
            }
        }
    }

    public void notifyPointerReleased(int x, int y) {
        if (!this.buttons.isEmpty()) {
            int i = 0;
            while (i < this.buttons.size()) {
                ButtonInterface observer = (ButtonInterface)this.buttons.elementAt(i);
                if (observer.pointerReleased(x, y)) break;
                ++i;
            }
        }
    }

    public void notifyPointerDragged(int x, int y) {
        if (!this.buttons.isEmpty()) {
            int i = 0;
            while (i < this.buttons.size()) {
                ButtonInterface observer = (ButtonInterface)this.buttons.elementAt(i);
                observer.pointerDragged(x, y);
                ++i;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.notifyPointerPressed(x, y);
    }

    public void pointerReleased(int x, int y) {
        this.notifyPointerReleased(x, y);
    }

    public void pointerDragged(int x, int y) {
        this.notifyPointerDragged(x, y);
    }

    public int getActivityWidth() {
        return this.width;
    }

    public int getActivityHeight() {
        return this.height;
    }

    public abstract void buttonIsPressed(int var1);

    public abstract void buttonIsReleased(int var1);

    public abstract void buttonIsDragged(int var1);
}

