/*
 * Decompiled with CFR 0.152.
 */
package com.academmedia.jewelsaga.statemachine;

import com.academmedia.jewelsaga.content.L10n;
import com.academmedia.jewelsaga.interfaces.ActivityInterface;
import com.academmedia.jewelsaga.interfaces.ActivityListener;
import com.academmedia.jewelsaga.interfaces.MainMIDlet;
import com.academmedia.jewelsaga.utils.Log;
import com.academmedia.jewelsaga.views.AboutView;
import com.academmedia.jewelsaga.views.GameView;
import com.academmedia.jewelsaga.views.HelpView;
import com.academmedia.jewelsaga.views.MenuView;
import com.am.adlib.Ad;
import com.am.adlib.BannerSprite;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class StateMachine
extends GameCanvas
implements ActivityListener,
CommandListener {
    private int ID_APP;
    private final boolean SHOW_BANNER;
    public static long INTERVAL = 100L;
    public static final int EVENT_SHOW_MENU = 101;
    public static final int EVENT_SHOW_ABOUT = 102;
    public static final int EVENT_SHOW_HELP = 103;
    public static final int EVENT_PLAY_GAME = 104;
    public static final int EVENT_SELECT_LEVEL = 105;
    public static final int EVENT_EXIT_GAME = 333;
    public static int displayWidth;
    public static int displayHeight;
    private Graphics g;
    private static MainMIDlet mainMIDlet;
    private Command backCommand;
    private GameThread gameThread;
    private ActivityInterface currentView;
    private ActivityInterface menuView;
    private ActivityInterface aboutView;
    private ActivityInterface helpView;
    private ActivityInterface gameView;
    private ActivityInterface levelView;
    private Ad ad;
    public BannerSprite bannerSprite;
    private String text;
    private boolean showText = false;

    public StateMachine(MainMIDlet mainMIDlet) {
        super(true);
        this.SHOW_BANNER = true;
        Log.log("StateMachine()");
        StateMachine.mainMIDlet = mainMIDlet;
        this.setFullScreenMode(true);
        this.calculateDisplayVariables();
        this.initL10n();
        this.initBanner(mainMIDlet);
    }

    public void startApp() {
        Log.log("StateMachine.startApp()");
        if (this.gameThread == null) {
            this.gameThread = new GameThread();
        }
        this.initViews();
        this.initListeners();
        this.handleEvent(101);
        this.gameThread.requestStart();
    }

    public void handleEvent(int event) {
        Log.log("StateMachine.handleEvent() " + event);
        switch (event) {
            case 101: {
                this.changeView(this.menuView);
                break;
            }
            case 102: {
                this.changeView(this.aboutView);
                break;
            }
            case 103: {
                this.changeView(this.helpView);
                break;
            }
            case 104: {
                this.changeView(this.gameView);
                break;
            }
            case 105: {
                this.changeView(this.levelView);
                break;
            }
            case 333: {
                mainMIDlet.exit();
            }
        }
    }

    public void addText(String text) {
        this.text = text;
        this.showText = true;
    }

    public void removeText() {
        this.showText = false;
    }

    public void render() {
        this.g = this.getGraphics();
        this.paint(this.g);
        this.flushGraphics();
    }

    public void paint(Graphics g) {
        if (this.currentView != null) {
            this.currentView.paint(g, 0, 0);
        }
        this.bannerSprite.setPosition(0, displayHeight - this.bannerSprite.getHeight());
        this.bannerSprite.paint(g);
        if (this.showText) {
            g.setColor(240);
            g.setFont(Font.getFont((int)32, (int)0, (int)0));
            g.drawString(this.text, this.getWidth() / 2, 100, 17);
        }
    }

    public void changeView(ActivityInterface targetView) {
        Log.log("StateMachine.changeView()");
        System.out.println(targetView.getClass());
        this.currentView = targetView;
        targetView.refreshResources();
    }

    public void pointerPressed(int x, int y) {
        Log.log("StateMachine.pointerPressed()");
        this.currentView.pointerPressed(x, y);
        this.bannerSprite.touchDown(x, y);
    }

    public void pointerReleased(int x, int y) {
        Log.log("StateMachine.pointerReleased()");
        this.currentView.pointerReleased(x, y);
        if (this.bannerSprite.touchUp(x, y)) {
            this.ad.openLink();
        }
    }

    public void pointerDragged(int x, int y) {
        this.currentView.pointerDragged(x, y);
    }

    public void changeState(int state) {
        Log.log("StateMachine.changeState()");
    }

    private void initL10n() {
        Log.log("StateMachine.initL10n()");
        try {
            L10n.initTextRes();
        }
        catch (UnsupportedEncodingException ex) {
            Log.log(ex.getMessage());
        }
        catch (IOException ex) {
            Log.log(ex.getMessage());
        }
    }

    private void initViews() {
        Log.log("StateMachine.initViews()");
        if (this.menuView == null) {
            this.menuView = new MenuView(this, displayWidth, displayHeight);
            this.menuView.initResources();
        }
        if (this.aboutView == null) {
            this.aboutView = new AboutView(this, displayWidth, displayHeight);
            this.aboutView.initResources();
        }
        if (this.helpView == null) {
            this.helpView = new HelpView(this, displayWidth, displayHeight);
            this.helpView.initResources();
        }
        if (this.gameView == null) {
            this.gameView = new GameView(this, displayWidth, displayHeight);
            this.gameView.initResources();
        }
    }

    private void initListeners() {
        Log.log("StateMachine.initListeners()");
        this.backCommand = new Command("", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    private void calculateDisplayVariables() {
        Log.log("StateMachine.calculateDisplayVariables()");
        this.g = this.getGraphics();
        displayHeight = this.getHeight();
        displayWidth = this.getWidth();
    }

    private void initBanner(MIDlet mainMIDlet) {
        Log.log("StateMachine.createBanner()");
        System.out.println(L10n.get("appId"));
        this.ID_APP = Integer.parseInt(L10n.get("appId"));
        this.ad = Ad.start(mainMIDlet, this.ID_APP, displayWidth, displayHeight);
        this.bannerSprite = this.ad.createBannerSprite();
        if (displayWidth != 400) {
            this.bannerSprite.setPosition(0, displayHeight - 40);
        }
        this.ad.startAd();
    }

    protected void showNotify() {
        Log.log("StateMachine.showNotify()");
        if (this.gameView != null) {
            ((GameView)this.gameView).tt.setPause(true);
        }
        this.ad.startAd();
    }

    protected void hideNotify() {
        Log.log("StateMachine.hideNotify()");
        if (this.gameView != null) {
            ((GameView)this.gameView).tt.setPause(false);
        }
        this.ad.stopAd();
    }

    public void commandAction(Command c, Displayable d) {
        Log.log("StateMachine.commandAction()");
        if (this.currentView == this.menuView) {
            mainMIDlet.exit();
        } else {
            this.handleEvent(101);
        }
    }

    public static MainMIDlet getMainMIDlet() {
        return mainMIDlet;
    }

    class GameThread
    extends Thread {
        private boolean pause = true;
        private boolean stop = false;
        private boolean started = false;

        public GameThread() {
            Log.log("GameThread()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStart() {
            this.pause = false;
            if (!this.started) {
                this.start();
                this.started = true;
            } else {
                GameThread gameThread = this;
                synchronized (gameThread) {
                    this.notify();
                }
            }
        }

        public void requestPause() {
            this.pause = true;
        }

        public void requestStop() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            System.out.println("Run start");
            long time = 0L;
            while (!this.stop) {
                try {
                    if (this.pause) {
                        GameThread gameThread = this;
                        synchronized (gameThread) {
                            this.wait();
                            continue;
                        }
                    }
                    time = System.currentTimeMillis();
                    StateMachine.this.render();
                    time = INTERVAL - (System.currentTimeMillis() - time);
                    Thread.sleep(time < 0L ? 0L : time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

