/*
 * Decompiled with CFR 0.152.
 */
package com.academmedia.jewelsaga.views;

import com.academmedia.jewelsaga.components.Activity;
import com.academmedia.jewelsaga.components.NewButton;
import com.academmedia.jewelsaga.content.L10n;
import com.academmedia.jewelsaga.interfaces.ActivityInterface;
import com.academmedia.jewelsaga.interfaces.ActivityListener;
import com.academmedia.jewelsaga.statemachine.StateMachine;
import com.academmedia.jewelsaga.utils.Log;
import com.academmedia.jewelsaga.utils.MultiLineText;
import com.am.activity.tools.ImageHelper;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

public class AboutView
extends Activity
implements ActivityInterface {
    private NewButton btnBack;
    private ActivityListener listener;
    private String aboutString;
    private Sprite background;
    private MultiLineText multText;
    private Image bg;

    private AboutView(int w, int h) {
        super(w, h);
        Log.log("AboutView()");
    }

    public AboutView(ActivityListener listener, int w, int h) {
        super(w, h);
        this.listener = listener;
        Log.log("AboutView()");
    }

    public void initResources() {
        Log.log("AboutView.initResources()");
        if (StateMachine.displayHeight < 400) {
            this.bg = ImageHelper.loadCached("/img/back_320.png");
        } else {
            this.bg = ImageHelper.loadCached("/img/back_400.png");
            this.btnBack = NewButton.createButtonWithImage(this, ImageHelper.loadCached("/img/btnBack.png"), 300);
            this.btnBack.setPosition(StateMachine.displayWidth - this.btnBack.getWidth(), 0);
        }
        this.aboutString = String.valueOf(StateMachine.getMainMIDlet().getAppProperty("MIDlet-Name")) + " v " + StateMachine.getMainMIDlet().getAppProperty("MIDlet-Version") + "             " + L10n.get("Developer") + ": " + StateMachine.getMainMIDlet().getAppProperty("MIDlet-Vendor") + ". " + L10n.get("Feedback and bugreports") + ": " + "info@academmedia.mobi";
        this.multText = new MultiLineText(this.aboutString, 225, StateMachine.displayHeight - 30, 0, 20);
        this.multText.setScrollbarVisible(false);
        this.multText.setDraggeable(false);
        this.background = new Sprite(this.bg);
        this.append((Layer)this.background);
    }

    public void paint(Graphics g, int x, int y) {
        super.paint(g, x, y);
        if (this.btnBack != null) {
            this.btnBack.paint(g);
        }
        this.multText.paint(g);
    }

    public void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.multText.pointerPressed(x, y);
    }

    public void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
        this.multText.pointerDragged(x, y);
    }

    public void refreshResources() {
        Log.log("AboutView.refreshResources()");
    }

    public void buttonIsPressed(int index) {
    }

    public void buttonIsReleased(int index) {
        Log.log("AboutView.buttonIsReleased()");
        if (this.btnBack != null && index == this.btnBack.getBtnNum()) {
            System.out.println(this.btnBack.getID());
            this.listener.handleEvent(101);
        }
    }

    public boolean isReady() {
        return true;
    }

    public void buttonIsDragged(int btnNum) {
    }
}

