/*
 * Decompiled with CFR 0.152.
 */
package com.academmedia.jewelsaga.views;

import com.academmedia.jewelsaga.components.Activity;
import com.academmedia.jewelsaga.components.NewButton;
import com.academmedia.jewelsaga.interfaces.ActivityInterface;
import com.academmedia.jewelsaga.interfaces.ActivityListener;
import com.academmedia.jewelsaga.statemachine.GameLogic;
import com.academmedia.jewelsaga.statemachine.StateMachine;
import com.academmedia.jewelsaga.statemachine.TimerThread;
import com.am.activity.tools.ImageHelper;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

public class GameView
extends Activity
implements ActivityInterface {
    private ActivityListener listener;
    private Image bg;
    private GameLogic gl;
    public Hashtable buttons;
    private NewButton btnBack;
    private NewButton btnSound;
    NewButton btn;
    int score;
    int yText;
    int totalScore;
    int seconds;
    String text;
    public TimerThread tt;
    public boolean sound = true;

    public GameView(StateMachine stateMachine, int displayWidth, int displayHeight) {
        super(displayWidth, displayHeight);
        this.listener = stateMachine;
        this.tt = new TimerThread();
    }

    public void initResources() {
        this.buttons = new Hashtable();
        this.score = 0;
        this.totalScore = 0;
        this.text = "";
        this.gl = new GameLogic(this);
        this.btnSound = NewButton.createButtonWithImage(this, ImageHelper.loadCached("/img/btnSoundSeq.png"), 40, 40, 555);
        this.btnSound.setPosition(0, 0);
        this.btnSound.setFrame(0);
        if (StateMachine.displayHeight < 400) {
            this.bg = ImageHelper.loadCached("/img/back_320.png");
            this.gl.delta = 0;
        } else {
            this.btnBack = NewButton.createButtonWithImage(this, ImageHelper.loadCached("/img/btnBack.png"), 510);
            System.out.println("Display width = " + StateMachine.displayWidth + " btnBack.getWidth() = " + this.btnBack.getWidth());
            this.btnBack.setPosition(200, 0);
            this.bg = ImageHelper.loadCached("/img/back_400.png");
            this.gl.delta = 5;
        }
        this.gl.makeButtons(this.buttons);
        this.append((Layer)new Sprite(this.bg));
        if (!this.tt.isAlive()) {
            this.tt.start();
        }
    }

    public void printScore(int score) {
        this.score = score;
        this.yText = this.getActivityHeight() / 2;
        this.totalScore += score;
    }

    public void paint(Graphics g, int x, int y) {
        super.paint(g, x, y);
        g.setColor(0);
        g.setFont(Font.getFont((int)32, (int)0, (int)16));
        if (this.tt.getSeconds() >= 0) {
            g.drawString(String.valueOf(this.tt.getSeconds()), this.getActivityWidth() / 2, this.gl.delta, 17);
        }
        g.drawString(String.valueOf(this.totalScore), this.getActivityWidth() - 50, this.gl.delta, 17);
        if (this.tt.getSeconds() == 0) {
            this.text = "Your score: " + this.totalScore;
        }
        int i = 0;
        while (i < this.buttons.size()) {
            if (this.buttons.get(this.gl.keys.elementAt(i)) != null) {
                this.btn = (NewButton)this.buttons.get(this.gl.keys.elementAt(i));
                this.btn.paint(g);
            }
            ++i;
        }
        if (this.score != 0) {
            g.drawString("+" + this.score, this.getActivityWidth() / 2, this.yText--, 17);
        }
        if (this.text != "") {
            g.drawString(this.text, this.getActivityWidth() / 2, this.getActivityHeight() / 2, 17);
        }
    }

    public void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
    }

    public void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
    }

    public void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
    }

    public void refreshResources() {
        this.gl.removeButtons();
        this.gl.makeButtons(this.buttons);
        this.totalScore = 0;
        this.tt.setSeconds(100);
        this.text = "";
    }

    public boolean isReady() {
        return false;
    }

    public void buttonIsPressed(int index) {
        System.out.println("Pressed btn " + index);
        if (index < GameLogic.CN * GameLogic.RN) {
            this.gl.setBtnPressed(index);
        }
    }

    public void buttonIsReleased(int index) {
        System.out.println("Released btn " + index);
        if (this.btnBack != null && index == this.btnBack.getBtnNum()) {
            System.out.println(this.btnBack.getID());
            this.listener.handleEvent(101);
        }
        if (this.btnSound.getBtnNum() == index) {
            this.sound = !this.sound;
            this.btnSound.nextFrame();
        } else {
            if (this.tt.getSeconds() > 0) {
                this.gl.setBtnReleased(index);
                this.gl.analysMove();
            }
            if (this.tt.getSeconds() == 0) {
                this.text = "Your score: " + this.totalScore;
                this.printScore(this.text);
            }
        }
    }

    public int getTotalScore() {
        return this.totalScore;
    }

    public void printScore(String string) {
        this.text = string;
    }

    public void buttonIsDragged(int btnNum) {
    }
}

