/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.tools;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

public class L10n {
    public static final String MICROEDITION_PLATFORM = "microedition.platform";
    private static Hashtable text = new Hashtable();
    public static final String SEPARATOR = "|";
    private static boolean initialized = false;
    public static final String PATH_TO_TEXT_RESOURCES = "/text/strings.txt";

    public static void initTextRes() throws IOException {
        new L10n().readFile(PATH_TO_TEXT_RESOURCES);
    }

    private static void silentInitTextRes() {
        try {
            L10n.initTextRes();
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Wrong encoding in /text/strings.txt");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Error reading file /text/strings.txt");
            e.printStackTrace();
        }
    }

    public static void initTextRes(String filename) throws UnsupportedEncodingException, IOException {
        new L10n().readFile(filename);
    }

    public static String get(String key) {
        if (!initialized) {
            L10n.silentInitTextRes();
        }
        String result = null;
        Object value = text.get(key);
        result = value != null ? (String)value : " ";
        return result;
    }

    public static int getID() {
        if (!initialized) {
            L10n.silentInitTextRes();
        }
        int id = L10n.isAsha10() ? Integer.parseInt(L10n.get("ASHA1.0 ID")) : (L10n.isAsha11() ? Integer.parseInt(L10n.get("ASHA1.1 ID")) : Integer.parseInt(L10n.get("S40 ID")));
        return id;
    }

    private void readFile(String filename) throws UnsupportedEncodingException, IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), "UTF-8");
        String line = null;
        while ((line = this.readLine(reader)) != null) {
            String[] result = this.split(line, SEPARATOR);
            text.put(result[0], result[1]);
        }
        ((Reader)reader).close();
    }

    private String readLine(Reader reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuffer string = new StringBuffer("");
        while (readChar != -1 && readChar != 10) {
            if (readChar != 13) {
                string.append((char)readChar);
            }
            readChar = reader.read();
        }
        return string.toString();
    }

    private String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(new String(original.substring(0, index)));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            int loop = 0;
            while (loop < nodes.size()) {
                result[loop] = (String)nodes.elementAt(loop);
                ++loop;
            }
        }
        return result;
    }

    private static String getPlatform() {
        return System.getProperty(MICROEDITION_PLATFORM);
    }

    private static boolean isAsha10() {
        return L10n.getPlatform().indexOf("Nokia501") >= 0;
    }

    private static boolean isAshaSDK() {
        return L10n.getPlatform().indexOf("Nokia5") >= 0;
    }

    private static boolean isAsha11() {
        return L10n.isAshaSDK() & !L10n.isAsha10();
    }
}

