/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Button;
import game.DisplayableCanvas;
import game.DrawString;
import game.MazeWonderMidlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class MainMenu {
    DrawString ds;
    DisplayableCanvas dc;
    int MENU_MODE;
    final byte SPLASH;
    final byte MAIN_MENU;
    final byte OPTIONS = (byte)2;
    final byte HELP = (byte)3;
    final byte ABOUT = (byte)4;
    final byte GAME_TYPE = (byte)5;
    final byte CHECK_SAMEPHONE = (byte)6;
    int WIDTH;
    int HEIGHT;
    Image imgLogo;
    Image imgSplash;
    Image imgMenuLogo;
    Image imgAboutLogo;
    Image imgSplashLogo;
    Font font = Font.getFont((int)0, (int)1, (int)16);
    boolean isContinue;
    boolean onoffs = true;
    boolean onoffv = true;
    Button butContinue;
    Button butNewGame;
    Button butOption;
    Button butHelp;
    Button butAbout;
    Button butExit;
    Button butSoundon;
    Button butSoundoff;
    Button butVibrateon;
    Button butVibrateoff;
    Button buttonHelpData;
    Button buttonHome;
    Image imgHelpText;
    Image imgUpArrow;
    Image imgDownArrow;
    int helpTextx = 170;
    int helpTexty = 160;
    int selectIndex = -1;
    byte optionIndex = (byte)-1;
    Button buttonSingleP;
    Button buttonMultiP;
    Button buttonNFC;
    Button buttonSamePhone;
    Image imgTopBorder;
    Image imgBottomBorder;
    Image imgHelpTitle;
    Image imgAboutTitle;
    Image imgOptiontitle;
    int dragy;
    RecordStore soundSettings;

    public MainMenu(DisplayableCanvas displayableCanvas, DrawString drawString) {
        this.SPLASH = 0;
        this.MAIN_MENU = 1;
        this.dc = displayableCanvas;
        this.ds = drawString;
        this.WIDTH = displayableCanvas.WIDTH;
        this.HEIGHT = displayableCanvas.HEIGHT;
        MazeWonderMidlet mazeWonderMidlet = displayableCanvas.midlet;
    }

    public void resetSplash() {
        try {
            this.imgLogo = Image.createImage((String)"/res/menu/logo.png");
            this.imgSplash = Image.createImage((String)"/res/menu/splash.jpg");
            this.imgSplashLogo = Image.createImage((String)"/res/menu/splashlogo.png");
            this.imgTopBorder = Image.createImage((String)"/res/menu/bar_top.png");
            this.imgBottomBorder = Image.createImage((String)"/res/menu/bar_down.png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.MENU_MODE = 0;
    }

    public void resetMainMenu() {
        if (this.butContinue == null) {
            this.butContinue = new Button(0, 0, "/res/menu/continue0.png", "/res/menu/continue1.png");
            this.butNewGame = new Button(0, 0, "/res/menu/play0.png", "/res/menu/play1.png");
            this.butOption = new Button(0, 0, "/res/menu/option0.png", "/res/menu/option1.png");
            this.butHelp = new Button(0, 0, "/res/menu/help0.png", "/res/menu/help1.png");
            this.butAbout = new Button(0, 0, "/res/menu/about0.png", "/res/menu/about1.png");
            this.butExit = new Button(0, 0, "/res/menu/exit0.png", "/res/menu/exit1.png");
            this.butSoundon = new Button(this.WIDTH - 194 >> 1, 270, "/res/menu/soundon0.png", "/res/menu/soundon1.png");
            this.butSoundoff = new Button(this.WIDTH - 211 >> 1, 270, "/res/menu/soundoff0.png", "/res/menu/soundoff1.png");
            this.butVibrateon = new Button(this.WIDTH - 273 >> 1, this.butSoundon.y + 80, "/res/menu/vibrateon0.png", "/res/menu/vibrateon1.png");
            this.butVibrateoff = new Button(this.WIDTH - 290 >> 1, this.butSoundon.y + 80, "/res/menu/vibrateoff0.png", "/res/menu/vibrateoff1.png");
            this.buttonHome = new Button(262, 200, "/res/menu0.png", "/res/menu1.png");
            this.readSettings();
            this.butSoundon.setXY(200 - this.butSoundon.width / 2, 85);
            this.butSoundoff.setXY(200 - this.butSoundoff.width / 2, 85);
            this.butVibrateon.setXY(200 - this.butVibrateon.width / 2, 125);
            this.butVibrateoff.setXY(200 - this.butVibrateoff.width / 2, 125);
        }
        if (this.isContinue) {
            this.butContinue.setXY(this.WIDTH - 190 + (175 - this.butContinue.width >> 1), 55);
            this.butNewGame.setXY(this.WIDTH - 190 + (175 - this.butNewGame.width >> 1), this.butContinue.y + 26);
            this.butOption.setXY(this.WIDTH - 190 + (175 - this.butOption.width >> 1), this.butNewGame.y + 26);
            this.butHelp.setXY(this.WIDTH - 190 + (175 - this.butHelp.width >> 1), this.butOption.y + 26);
            this.butAbout.setXY(this.WIDTH - 190 + (175 - this.butAbout.width >> 1), this.butHelp.y + 26);
            this.butExit.setXY(this.WIDTH - 190 + (175 - this.butExit.width >> 1), this.butAbout.y + 26);
        } else {
            this.butNewGame.setXY(this.WIDTH - 190 + (175 - this.butNewGame.width >> 1), 60);
            this.butOption.setXY(this.WIDTH - 190 + (175 - this.butOption.width >> 1), this.butNewGame.y + 30);
            this.butHelp.setXY(this.WIDTH - 190 + (175 - this.butHelp.width >> 1), this.butOption.y + 30);
            this.butAbout.setXY(this.WIDTH - 190 + (175 - this.butAbout.width >> 1), this.butHelp.y + 30);
            this.butExit.setXY(this.WIDTH - 190 + (175 - this.butExit.width >> 1), this.butAbout.y + 30);
        }
        this.MENU_MODE = 1;
    }

    public void resetOptions() {
        if (this.imgOptiontitle == null) {
            try {
                this.imgOptiontitle = Image.createImage((String)"/res/menu/optionTitle.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resetHelp() {
        block5: {
            if (this.buttonHelpData == null) {
                try {
                    if (this.buttonHelpData != null) break block5;
                    try {
                        this.imgHelpText = Image.createImage((String)"/res/menu/helpText.png");
                        this.imgUpArrow = Image.createImage((String)"/res/menu/upArrow.png");
                        this.imgDownArrow = Image.createImage((String)"/res/menu/downArrow.png");
                        this.imgHelpTitle = Image.createImage((String)"/res/menu/HelpTitle.png");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.buttonHelpData = new Button(this.WIDTH - this.imgHelpText.getWidth() >> 1, 137, this.imgHelpText.getWidth(), 365, -1, -1);
                    this.buttonHelpData.setMovable(true);
                    this.buttonHelpData.nameX = this.buttonHelpData.x;
                    this.buttonHelpData.nameY = this.buttonHelpData.y;
                    this.buttonHelpData.name = null;
                    this.buttonHelpData.imgButton = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.buttonHelpData.nameY = this.buttonHelpData.y;
    }

    public void resetAbout() {
        if (this.imgAboutLogo == null) {
            try {
                this.imgAboutLogo = Image.createImage((String)"/res/menu/aboutLogo.png");
                this.imgAboutTitle = Image.createImage((String)"/res/menu/AboutTitle.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resetMode(int n) {
        switch (n) {
            case 0: {
                this.resetSplash();
                break;
            }
            case 1: {
                if (this.imgMenuLogo == null) {
                    try {
                        this.imgMenuLogo = Image.createImage((String)"/res/menu/menuLogo.png");
                        this.imgTopBorder = Image.createImage((String)"/res/menu/bar_top.png");
                        this.imgBottomBorder = Image.createImage((String)"/res/menu/bar_down.png");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.resetMainMenu();
                break;
            }
            case 2: {
                this.resetOptions();
                break;
            }
            case 3: {
                this.resetHelp();
                break;
            }
            case 4: {
                this.resetAbout();
                break;
            }
            case 5: {
                if (this.buttonSingleP != null) break;
                this.buttonSingleP = new Button(this.WIDTH - 282 >> 1, 265, "/res/menu/singleplayer0.png", "/res/menu/singleplayer1.png");
                this.buttonMultiP = new Button(this.WIDTH - 242 >> 1, 339, "/res/menu/multiplayer0.png", "/res/menu/multiplayer1.png");
                break;
            }
            case 6: {
                if (this.buttonNFC != null) break;
                this.buttonNFC = new Button(this.WIDTH - 253 >> 1, this.buttonSingleP.y - 30, "/res/menu/nfc0.png", "/res/menu/nfc1.png");
                this.buttonSamePhone = new Button(this.WIDTH - 243 >> 1, this.buttonMultiP.y + 15, "/res/menu/samephone0.png", "/res/menu/samephone1.png");
            }
        }
        this.MENU_MODE = n;
    }

    protected void pointerPressed(int n, int n2) {
        boolean bl = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isContinue && (bl = this.butContinue.isPressed(n, n2))) {
                    this.selectIndex = 0;
                }
                if (bl) break;
                bl = this.butNewGame.isPressed(n, n2);
                if (!bl) {
                    bl = this.butOption.isPressed(n, n2);
                    if (!bl) {
                        bl = this.butHelp.isPressed(n, n2);
                        if (!bl) {
                            bl = this.butAbout.isPressed(n, n2);
                            if (!bl) {
                                bl = this.butExit.isPressed(n, n2);
                                if (!bl) break;
                                this.selectIndex = 5;
                                break;
                            }
                            this.selectIndex = 4;
                            break;
                        }
                        this.selectIndex = 3;
                        break;
                    }
                    this.selectIndex = 2;
                    break;
                }
                this.selectIndex = 1;
                break;
            }
            case 2: {
                if (this.onoffs) {
                    bl = this.butSoundon.isPressed(n, n2);
                    if (bl) {
                        this.optionIndex = 0;
                    }
                } else {
                    bl = this.butSoundoff.isPressed(n, n2);
                    if (bl) {
                        this.optionIndex = 0;
                    }
                }
                this.optionIndex = (byte)-1;
                if (this.onoffv) {
                    bl = this.butVibrateon.isPressed(n, n2);
                    if (bl) {
                        this.optionIndex = 1;
                    }
                } else {
                    bl = this.butVibrateoff.isPressed(n, n2);
                    if (bl) {
                        this.optionIndex = 1;
                    }
                }
                if (!bl) {
                    bl = this.buttonHome.isPressed(n, n2);
                }
                this.optionIndex = (byte)-1;
                break;
            }
            case 3: {
                this.dragy = n2;
                bl = this.buttonHome.isPressed(n, n2);
                if (bl || n <= this.WIDTH - 30 || n2 <= this.buttonHelpData.y || n2 >= this.buttonHelpData.y + this.buttonHelpData.height) break;
                this.buttonHelpData.touchY = n2;
                break;
            }
            case 4: {
                bl = this.buttonHome.isPressed(n, n2);
                break;
            }
            case 5: {
                bl = this.buttonSingleP.isPressed(n, n2);
                if (bl || (bl = this.buttonMultiP.isPressed(n, n2))) break;
                bl = this.buttonHome.isPressed(n, n2);
                break;
            }
            case 6: {
                bl = this.buttonNFC.isPressed(n, n2);
                if (bl || (bl = this.buttonSamePhone.isPressed(n, n2))) break;
                bl = this.buttonHome.isPressed(n, n2);
            }
        }
    }

    protected void pointerReleased(int n, int n2) {
        boolean bl = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                bl = this.butExit.isReleased(n, n2);
                if (bl) {
                    System.out.println("Selected Index = " + this.selectIndex);
                    this.selection();
                } else {
                    if (this.isContinue && (bl = this.butContinue.isReleased(n, n2))) {
                        this.selection();
                    }
                    if (!bl) {
                        bl = this.butNewGame.isReleased(n, n2);
                        if (bl) {
                            this.selection();
                        } else {
                            bl = this.butOption.isReleased(n, n2);
                            if (bl) {
                                this.selection();
                            } else {
                                bl = this.butHelp.isReleased(n, n2);
                                if (bl) {
                                    this.selection();
                                } else {
                                    bl = this.butAbout.isReleased(n, n2);
                                    if (bl) {
                                        this.selection();
                                    }
                                }
                            }
                        }
                    }
                }
                this.selectIndex = -1;
                break;
            }
            case 2: {
                if (this.onoffs) {
                    bl = this.butSoundon.isReleased(n, n2);
                    if (bl) {
                        this.onoffs = false;
                    }
                } else {
                    bl = this.butSoundoff.isReleased(n, n2);
                    if (bl) {
                        this.onoffs = true;
                    }
                }
                if (this.onoffv) {
                    bl = this.butVibrateon.isReleased(n, n2);
                    if (bl) {
                        this.onoffv = false;
                    }
                } else {
                    bl = this.butVibrateoff.isReleased(n, n2);
                    if (bl) {
                        this.onoffv = true;
                    }
                }
                if (bl || !(bl = this.buttonHome.isReleased(n, n2))) break;
                this.storeSettings();
                this.resetMainMenu();
                break;
            }
            case 3: {
                bl = this.buttonHome.isReleased(n, n2);
                if (bl) {
                    this.helpTexty = 160;
                    this.MENU_MODE = 1;
                    break;
                }
                this.buttonHelpData.isReleased(n, n2);
                break;
            }
            case 4: {
                bl = this.buttonHome.isReleased(n, n2);
                if (!bl) break;
                this.MENU_MODE = 1;
                break;
            }
            case 5: {
                bl = this.buttonSingleP.isReleased(n, n2);
                if (bl) {
                    this.dc.isSinglePlayer = true;
                    this.dc.isSingleHandSet = false;
                    this.dc.initGame();
                    this.isContinue = true;
                    break;
                }
                bl = this.buttonMultiP.isReleased(n, n2);
                if (bl) {
                    this.resetMode(6);
                    break;
                }
                bl = this.buttonHome.isReleased(n, n2);
                if (!bl) break;
                this.MENU_MODE = 1;
                break;
            }
            case 6: {
                bl = this.buttonNFC.isReleased(n, n2);
                if (bl) {
                    this.dc.isSinglePlayer = false;
                    this.dc.isSingleHandSet = false;
                    this.isContinue = false;
                    break;
                }
                bl = this.buttonSamePhone.isReleased(n, n2);
                if (bl) {
                    this.dc.isSinglePlayer = false;
                    this.dc.isSingleHandSet = true;
                    this.dc.initGame();
                    this.isContinue = true;
                    break;
                }
                bl = this.buttonHome.isReleased(n, n2);
                if (!bl) break;
                this.MENU_MODE = 1;
            }
        }
    }

    public void storeSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"TennisSettings", (boolean)true);
            byte[] byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(60);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(this.onoffs);
            dataOutputStream.writeBoolean(this.onoffv);
            dataOutputStream.flush();
            dataOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            if (this.soundSettings.getNumRecords() > 0) {
                this.soundSettings.setRecord(1, byArray, 0, byArray.length);
            } else {
                this.soundSettings.addRecord(byArray, 0, byArray.length);
            }
            this.soundSettings.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void readSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"TennisSettings", (boolean)true);
            if (this.soundSettings.getNumRecords() > 0) {
                byte[] byArray = null;
                byArray = this.soundSettings.getRecord(1);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                this.onoffs = dataInputStream.readBoolean();
                this.onoffv = dataInputStream.readBoolean();
                dataInputStream.close();
            } else {
                byte[] byArray = null;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(60);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                this.onoffs = true;
                this.onoffv = true;
                dataOutputStream.writeBoolean(this.onoffs);
                dataOutputStream.writeBoolean(this.onoffv);
                dataOutputStream.flush();
                dataOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                this.soundSettings.addRecord(byArray, 0, byArray.length);
            }
            this.soundSettings.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void selection() {
        switch (this.selectIndex) {
            case 0: {
                this.dc.getClass();
                this.dc.GAME_MODE = 5;
                break;
            }
            case 1: {
                this.dc.isSinglePlayer = true;
                this.dc.isSingleHandSet = false;
                this.dc.initGame();
                this.isContinue = true;
                break;
            }
            case 2: {
                this.resetMode(2);
                break;
            }
            case 3: {
                this.resetMode(3);
                break;
            }
            case 4: {
                this.resetMode(4);
                break;
            }
            case 5: {
                this.dc.midlet.exit();
                break;
            }
            case 6: {
                this.dc.onClickBannerAd();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void input(int n) {
        block28: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block27: {
                                block26: {
                                    if (n == this.dc.KEY_RIGHT_SOFT) break block26;
                                    if (n != 35) break block27;
                                }
                                switch (this.MENU_MODE) {
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        this.resetMainMenu();
                                        break;
                                    }
                                }
                                break block28;
                            }
                            if (n == this.dc.KEY_LEFT_SOFT) break block29;
                            if (n != 42) break block30;
                        }
                        this.dc.KEY = 0;
                        break block28;
                    }
                    if (n == 49) break block28;
                    if (n != 50) break block31;
                    switch (this.MENU_MODE) {
                        case 1: {
                            if (this.isContinue) {
                                this.selectIndex = (this.selectIndex + 5) % 6;
                                break;
                            }
                            --this.selectIndex;
                            if (this.selectIndex == 0) {
                                this.selectIndex = 5;
                                break;
                            }
                            if (this.selectIndex != 6) break;
                            this.selectIndex = 5;
                            break;
                        }
                        case 2: {
                            if (this.optionIndex == 0) {
                                this.optionIndex = 1;
                                break;
                            }
                            this.optionIndex = 0;
                            break;
                        }
                        case 3: {
                            if (this.helpTexty > 155) break;
                            this.helpTexty += 5;
                            break;
                        }
                    }
                    this.dc.KEY = 0;
                    break block28;
                }
                if (n != 56) break block32;
                switch (this.MENU_MODE) {
                    case 1: {
                        if (this.isContinue) {
                            this.selectIndex = (this.selectIndex + 1) % 6;
                            break;
                        }
                        ++this.selectIndex;
                        if (this.selectIndex == 6) {
                            this.selectIndex = 1;
                            break;
                        }
                        break block28;
                    }
                    case 2: {
                        if (this.optionIndex == 0) {
                            this.optionIndex = 1;
                            break;
                        }
                        this.optionIndex = 0;
                        break;
                    }
                    case 3: {
                        if (this.helpTexty + this.imgHelpText.getHeight() + 50 >= this.WIDTH - 50) {
                            this.helpTexty -= 5;
                            break;
                        }
                        break block28;
                    }
                }
                break block28;
            }
            if (n == 53) {
                switch (this.MENU_MODE) {
                    case 1: {
                        this.selection();
                        break;
                    }
                    case 2: {
                        if (this.optionIndex == 0) {
                            this.onoffs = !this.onoffs;
                            break;
                        }
                        if (this.optionIndex != 1) break;
                        this.onoffv = !this.onoffv;
                        break;
                    }
                }
            }
        }
        this.dc.KEY = 0;
    }

    public void run() {
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter <= 60) break;
                this.imgLogo = null;
                this.imgSplashLogo = null;
                this.resetMode(1);
                this.dc.refreshTheBannerAd();
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.font);
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter < 40) {
                    graphics.setColor(0xFFFFFF);
                    graphics.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                    graphics.drawImage(this.imgLogo, this.WIDTH >> 1, this.HEIGHT >> 1, 1 | 2);
                    break;
                }
                graphics.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                graphics.drawImage(this.imgTopBorder, 0, 0, 0x10 | 4);
                graphics.drawImage(this.imgBottomBorder, 0, this.HEIGHT - this.imgBottomBorder.getHeight(), 0x10 | 4);
                graphics.drawImage(this.imgSplashLogo, this.WIDTH - this.imgSplashLogo.getWidth() >> 1, this.HEIGHT - this.imgSplashLogo.getHeight() >> 1, 0x10 | 4);
                break;
            }
            case 1: {
                graphics.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                graphics.drawImage(this.imgMenuLogo, 30, this.HEIGHT - this.imgMenuLogo.getHeight() >> 1, 4 | 0x10);
                graphics.drawImage(this.imgTopBorder, 0, 0, 0x10 | 4);
                graphics.drawImage(this.imgBottomBorder, 0, this.HEIGHT - this.imgBottomBorder.getHeight(), 0x10 | 4);
                if (this.isContinue) {
                    this.butContinue.paint(graphics);
                }
                this.butNewGame.paint(graphics);
                this.butOption.paint(graphics);
                this.butHelp.paint(graphics);
                this.butAbout.paint(graphics);
                this.butExit.paint(graphics);
                switch (this.selectIndex) {
                    case 0: {
                        if (!this.isContinue || this.butContinue.buttonState != 0) break;
                        this.butContinue.buttonState = 1;
                        this.butContinue.paint(graphics);
                        this.butContinue.buttonState = 0;
                        break;
                    }
                    case 1: {
                        if (this.butNewGame.buttonState != 0) break;
                        this.butNewGame.buttonState = 1;
                        this.butNewGame.paint(graphics);
                        this.butNewGame.buttonState = 0;
                        break;
                    }
                    case 2: {
                        if (this.butOption.buttonState != 0) break;
                        this.butOption.buttonState = 1;
                        this.butOption.paint(graphics);
                        this.butOption.buttonState = 0;
                        break;
                    }
                    case 3: {
                        if (this.butHelp.buttonState != 0) break;
                        this.butHelp.buttonState = 1;
                        this.butHelp.paint(graphics);
                        this.butHelp.buttonState = 0;
                        break;
                    }
                    case 4: {
                        if (this.butAbout.buttonState != 0) break;
                        this.butAbout.buttonState = 1;
                        this.butAbout.paint(graphics);
                        this.butAbout.buttonState = 0;
                        break;
                    }
                    case 5: {
                        if (this.butExit.buttonState != 0) break;
                        this.butExit.buttonState = 1;
                        this.butExit.paint(graphics);
                        this.butExit.buttonState = 0;
                    }
                }
                break;
            }
            case 2: {
                graphics.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                graphics.drawImage(this.imgTopBorder, 0, 1, 0x10 | 4);
                graphics.drawImage(this.imgBottomBorder, 0, this.HEIGHT - this.imgBottomBorder.getHeight(), 0x10 | 4);
                graphics.drawImage(this.imgOptiontitle, 10, 55, 0x10 | 4);
                if (this.onoffs) {
                    this.butSoundon.paint(graphics);
                } else {
                    this.butSoundoff.paint(graphics);
                }
                if (this.onoffv) {
                    this.butVibrateon.paint(graphics);
                } else {
                    this.butVibrateoff.paint(graphics);
                }
                if (this.optionIndex == 0) {
                    if (this.onoffs) {
                        if (this.butSoundon.buttonState == 0) {
                            this.butSoundon.buttonState = 1;
                            this.butSoundon.paint(graphics);
                            this.butSoundon.buttonState = 0;
                        }
                    } else if (this.butSoundoff.buttonState == 0) {
                        this.butSoundoff.buttonState = 1;
                        this.butSoundoff.paint(graphics);
                        this.butSoundoff.buttonState = 0;
                    }
                } else if (this.optionIndex == 1) {
                    if (this.onoffv) {
                        if (this.butVibrateon.buttonState == 0) {
                            this.butVibrateon.buttonState = 1;
                            this.butVibrateon.paint(graphics);
                            this.butVibrateon.buttonState = 0;
                        }
                    } else if (this.butVibrateoff.buttonState == 0) {
                        this.butVibrateoff.buttonState = 1;
                        this.butVibrateoff.paint(graphics);
                        this.butVibrateoff.buttonState = 0;
                    }
                }
                this.buttonHome.setXY(350, 17);
                this.buttonHome.paint(graphics);
                break;
            }
            case 3: {
                graphics.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                graphics.drawImage(this.imgTopBorder, 0, 1, 0x10 | 4);
                graphics.drawImage(this.imgBottomBorder, 0, this.HEIGHT - this.imgBottomBorder.getHeight(), 0x10 | 4);
                graphics.drawImage(this.imgHelpTitle, 10, 22, 0x10 | 4);
                if (this.helpTexty <= 155) {
                    graphics.drawImage(this.imgUpArrow, this.WIDTH >> 1, this.HEIGHT - 48, 1 | 2);
                }
                if (this.helpTexty + this.imgHelpText.getHeight() >= this.WIDTH - 130 + 75 - 45) {
                    graphics.drawImage(this.imgDownArrow, this.WIDTH >> 1, this.HEIGHT - 31, 1 | 2);
                }
                this.buttonHome.setXY(350, 17);
                this.buttonHome.paint(graphics);
                graphics.setClip(0, 55, this.WIDTH, this.HEIGHT - 110);
                graphics.drawImage(this.imgHelpText, this.WIDTH >> 1, this.helpTexty, 1 | 2);
                graphics.setClip(0, 0, this.WIDTH, this.HEIGHT);
                break;
            }
            case 4: {
                graphics.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                graphics.drawImage(this.imgTopBorder, 0, 1, 0x10 | 4);
                graphics.drawImage(this.imgBottomBorder, 0, this.HEIGHT - this.imgBottomBorder.getHeight(), 0x10 | 4);
                if (this.imgAboutLogo != null) {
                    graphics.drawImage(this.imgAboutLogo, this.WIDTH >> 1, (this.HEIGHT >> 1) + 5, 1 | 2);
                }
                this.buttonHome.setXY(350, 17);
                this.buttonHome.paint(graphics);
                break;
            }
            case 5: {
                graphics.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                graphics.drawImage(this.imgMenuLogo, this.WIDTH >> 1, 40, 1 | 2);
                this.buttonSingleP.paint(graphics);
                this.buttonMultiP.paint(graphics);
                this.buttonHome.paint(graphics);
                break;
            }
            case 6: {
                graphics.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                graphics.drawImage(this.imgMenuLogo, this.WIDTH >> 1, 40, 1 | 2);
                this.buttonNFC.paint(graphics);
                this.buttonSamePhone.paint(graphics);
                this.buttonHome.paint(graphics);
            }
        }
    }

    protected void pointerDragged(int n, int n2) {
        if (this.MENU_MODE == 3) {
            if (this.buttonHelpData.isMovable && this.buttonHelpData.buttonState == 1) {
                this.buttonHelpData.nameY += n2 - this.buttonHelpData.touchY;
                this.buttonHelpData.touchY = n2;
                if (this.buttonHelpData.nameY > this.buttonHelpData.y) {
                    this.buttonHelpData.nameY = this.buttonHelpData.y;
                } else if (this.buttonHelpData.nameY < this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height)) {
                    this.buttonHelpData.nameY = this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height);
                }
            }
            if (this.dragy > n2 && Math.abs(this.dragy - n2) > 10) {
                this.input(56);
            } else if (this.dragy < n2 && Math.abs(this.dragy - n2) > 10) {
                this.input(50);
            }
        }
    }
}

