/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Button;
import game.DisplayableCanvas;
import game.DrawString;
import game.SystemFont;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class MainMenu {
    DrawString ds;
    DisplayableCanvas dc;
    int MENU_MODE;
    final byte SPLASH;
    final byte MAIN_MENU;
    final byte OPTIONS = (byte)2;
    final byte HELP = (byte)3;
    final byte ABOUT = (byte)4;
    final byte LEVEL = (byte)6;
    int WIDTH;
    int HEIGHT;
    Image imgLogo;
    Image imgSplash;
    Image imgMenuLogo;
    Image imgAboutLogo;
    Font font = Font.getFont((int)0, (int)1, (int)16);
    boolean isContinue;
    boolean onoffs = true;
    boolean onoffv = true;
    Button butContinue;
    Button butNewGame;
    Button butOption;
    Button butHelp;
    Button butAbout;
    Button butExit;
    Button butSoundon;
    Button butSoundoff;
    Button butVibrateon;
    Button butVibrateoff;
    Button buttonHelpData;
    Button buttonHome;
    Image imgHelpText;
    Image imgUpArrow;
    Image imgDownArrow;
    Image imghelppatch;
    int selectIndex = 1;
    byte optionIndex;
    Image imghelpTit;
    Image imgoptTit;
    int levelindex;
    boolean ispress;
    int levelopen;
    Image imgLbar;
    Image imgRbar;
    Image imgMadal;
    RecordStore soundSettings;
    int helpHeight = 0;
    int helpTextHeight = 0;
    String helpTxt = "Fight the demon to save yourself and show him defeat.\n\nSwipe Left/Right to move back and forth.\n\nSwipe Up/Down to jump and crouch.\n\nPress 'Attack' to hit and 'Shield' to prevent damage.\n\nPress Special Attack button for a powerful fiery hit.";
    int helpStartY;
    int helpY = 0;

    public MainMenu(DisplayableCanvas dc, DrawString ds) {
        this.SPLASH = 0;
        this.MAIN_MENU = 1;
        this.dc = dc;
        this.ds = ds;
        this.WIDTH = dc.WIDTH;
        this.HEIGHT = dc.HEIGHT;
        this.readSettings();
    }

    public void resetSplash() {
        try {
            this.imgLogo = Image.createImage((String)"/res/menu/logo.png");
            this.imgSplash = Image.createImage((String)"/res/menu/splash.png");
        }
        catch (Exception io) {
            io.printStackTrace();
        }
        this.MENU_MODE = 0;
    }

    public void resetMainMenu() {
        int setx = 75;
        if (this.butContinue == null) {
            this.butContinue = new Button(0, 0, "/res/menu/continue0.png", "/res/menu/continue1.png");
            this.butNewGame = new Button(0, 0, "/res/menu/play0.png", "/res/menu/play1.png");
            this.butOption = new Button(0, 0, "/res/menu/option0.png", "/res/menu/option1.png");
            this.butHelp = new Button(0, 0, "/res/menu/help0.png", "/res/menu/help1.png");
            this.butAbout = new Button(0, 0, "/res/menu/about0.png", "/res/menu/about1.png");
            this.butExit = new Button(0, 0, "/res/menu/exit0.png", "/res/menu/exit1.png");
            this.butSoundon = new Button(0, 0, "/res/menu/soundon0.png", "/res/menu/soundon1.png");
            this.butSoundoff = new Button(0, 0, "/res/menu/soundoff0.png", "/res/menu/soundoff1.png");
            this.butVibrateon = new Button(0, 0, "/res/menu/vibrateon0.png", "/res/menu/vibrateon1.png");
            this.butVibrateoff = new Button(0, 0, "/res/menu/vibrateoff0.png", "/res/menu/vibrateoff1.png");
            this.buttonHome = new Button(365, 10, "/res/menu/home1.png", "/res/menu/home0.png");
            this.butSoundon.setXY((this.WIDTH >> 1) - this.butSoundon.width / 2 + setx, 127);
            this.butSoundoff.setXY((this.WIDTH >> 1) - this.butSoundoff.width / 2 + setx, 127);
            this.butVibrateon.setXY((this.WIDTH >> 1) - this.butVibrateon.width / 2 + setx, 167);
            this.butVibrateoff.setXY((this.WIDTH >> 1) - this.butVibrateoff.width / 2 + setx, 167);
        }
        if (this.isContinue) {
            this.butContinue.setXY((this.WIDTH - this.butContinue.width >> 1) + setx, 56);
            this.butNewGame.setXY((this.WIDTH - this.butNewGame.width >> 1) + setx, this.butContinue.y + 32);
            this.butOption.setXY((this.WIDTH - this.butOption.width >> 1) + setx, this.butNewGame.y + 32);
            this.butHelp.setXY((this.WIDTH - this.butHelp.width >> 1) + setx, this.butOption.y + 32);
            this.butAbout.setXY((this.WIDTH - this.butAbout.width >> 1) + setx, this.butHelp.y + 32);
            this.butExit.setXY((this.WIDTH - this.butExit.width >> 1) + setx, this.butAbout.y + 32);
        } else {
            this.butNewGame.setXY((this.WIDTH - this.butNewGame.width >> 1) + setx, 55);
            this.butOption.setXY((this.WIDTH - this.butOption.width >> 1) + setx, this.butNewGame.y + 40);
            this.butHelp.setXY((this.WIDTH - this.butHelp.width >> 1) + setx, this.butOption.y + 40);
            this.butAbout.setXY((this.WIDTH - this.butAbout.width >> 1) + setx, this.butHelp.y + 40);
            this.butExit.setXY((this.WIDTH - this.butExit.width >> 1) + setx, this.butAbout.y + 40);
        }
        this.MENU_MODE = 1;
    }

    public void resetOptions() {
    }

    public void resetHelp() {
        block5: {
            if (this.buttonHelpData == null) {
                try {
                    if (this.buttonHelpData != null) break block5;
                    try {
                        this.imgHelpText = Image.createImage((String)"/res/menu/helpText.png");
                        this.imgUpArrow = Image.createImage((String)"/res/menu/upArrow.png");
                        this.imgDownArrow = Image.createImage((String)"/res/menu/downArrow.png");
                        this.imghelpTit = Image.createImage((String)"/res/menu/helpTitle.png");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.buttonHelpData = new Button(this.WIDTH - this.imgHelpText.getWidth() >> 1, 137, this.imgHelpText.getWidth(), 365, -1, -1);
                    this.buttonHelpData.setMovable(true);
                    this.buttonHelpData.nameX = this.buttonHelpData.x;
                    this.buttonHelpData.nameY = this.buttonHelpData.y;
                    this.buttonHelpData.name = null;
                    this.buttonHelpData.imgButton = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.helpY = 0;
        this.buttonHelpData.nameY = this.buttonHelpData.y;
    }

    public void resetAbout() {
        try {
            if (this.imgAboutLogo == null) {
                this.imgAboutLogo = Image.createImage((String)"/res/menu/aboutLogo.png");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetLevel() {
    }

    public void resetMode(int gameMode) {
        switch (gameMode) {
            case 0: {
                this.resetSplash();
                break;
            }
            case 1: {
                if (this.imgSplash == null) {
                    try {
                        this.imgSplash = Image.createImage((String)"/res/menu/menuBg.png");
                        this.imgMadal = Image.createImage((String)"/res/menu/madal.png");
                        this.imghelppatch = Image.createImage((String)"/res/menu/helplayer.png");
                        this.imgMenuLogo = Image.createImage((String)"/res/menu/gameTitle.png");
                        this.imgLbar = Image.createImage((String)"/res/menu/lbar.png");
                        this.imgRbar = Image.createImage((String)"/res/menu/rbar.png");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.resetMainMenu();
                break;
            }
            case 2: {
                this.resetOptions();
                break;
            }
            case 3: {
                this.resetHelp();
                break;
            }
            case 4: {
                this.resetAbout();
                break;
            }
            case 6: {
                this.resetLevel();
            }
        }
        this.MENU_MODE = gameMode;
        this.dc.resetAdSetXY();
    }

    protected void pointerPressed(int x, int y) {
        boolean result = false;
        block0 : switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isContinue && (result = this.butContinue.isPressed(x, y))) {
                    this.selectIndex = 0;
                }
                if (result) break;
                result = this.butNewGame.isPressed(x, y);
                if (!result) {
                    result = this.butOption.isPressed(x, y);
                    if (!result) {
                        result = this.butHelp.isPressed(x, y);
                        if (!result) {
                            result = this.butAbout.isPressed(x, y);
                            if (!result) {
                                result = this.butExit.isPressed(x, y);
                                if (!result) break;
                                this.selectIndex = 5;
                                break;
                            }
                            this.selectIndex = 4;
                            break;
                        }
                        this.selectIndex = 3;
                        break;
                    }
                    this.selectIndex = 2;
                    break;
                }
                this.selectIndex = 1;
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                } else {
                    result = this.butSoundoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                } else {
                    result = this.butVibrateoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                }
                if (result) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 3: {
                this.helpStartY = y;
                result = this.buttonHelpData.isPressed(x, y);
                if (!result && x > this.WIDTH - 30 && y > this.buttonHelpData.y && y < this.buttonHelpData.y + this.buttonHelpData.height) {
                    this.buttonHelpData.touchY = y;
                }
                if (result) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 4: {
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 6: {
                result = this.buttonHome.isPressed(x, y);
                if (result) break;
                for (int i = 1; i <= 10; ++i) {
                    if (i <= 5) {
                        if (x <= 17 + (i - 1) * 77 || x >= 17 + (i - 1) * 77 + 60 || y <= 66 || y >= 120) continue;
                        this.levelindex = i;
                        this.ispress = true;
                        break block0;
                    }
                    if (x <= 17 + (i - 6) * 77 || x >= 17 + (i - 6) * 77 + 60 || y <= 145 || y >= 199) continue;
                    this.levelindex = i;
                    this.ispress = true;
                    break block0;
                }
                break;
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                result = this.butExit.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                if (this.isContinue && (result = this.butContinue.isReleased(x, y))) {
                    this.selection();
                }
                if (result) break;
                result = this.butNewGame.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butOption.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butHelp.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butAbout.isReleased(x, y);
                if (!result) break;
                this.selection();
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isReleased(x, y);
                    if (result) {
                        this.onoffs = false;
                    }
                } else {
                    result = this.butSoundoff.isReleased(x, y);
                    if (result) {
                        this.onoffs = true;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isReleased(x, y);
                    if (result) {
                        this.onoffv = false;
                    }
                } else {
                    result = this.butVibrateoff.isReleased(x, y);
                    if (result) {
                        this.onoffv = true;
                    }
                }
                if (result || !(result = this.buttonHome.isReleased(x, y))) break;
                this.storeSettings();
                this.resetMainMenu();
                break;
            }
            case 3: {
                result = this.buttonHome.isReleased(x, y);
                if (result) {
                    this.MENU_MODE = 1;
                    break;
                }
                this.buttonHelpData.isReleased(x, y);
                break;
            }
            case 4: {
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
                break;
            }
            case 6: {
                result = this.buttonHome.isReleased(x, y);
                if (result) {
                    this.MENU_MODE = 1;
                }
                if (!result) {
                    for (int i = 1; i <= 10; ++i) {
                        if (i <= 5 && this.ispress) {
                            if (this.levelindex != i || x <= 17 + (i - 1) * 77 || x >= 17 + (i - 1) * 77 + 60 || y <= 66 || y >= 120) continue;
                            if (this.levelindex <= this.levelopen) {
                                this.selectIndex = 7;
                                this.selection();
                            }
                            System.out.println("in press");
                            break;
                        }
                        if (!this.ispress || this.levelindex != i || x <= 17 + (i - 6) * 77 || x >= 17 + (i - 6) * 77 + 60 || y <= 145 || y >= 199) continue;
                        if (this.levelindex > this.levelopen) break;
                        this.selectIndex = 7;
                        this.selection();
                        break;
                    }
                }
                this.ispress = false;
            }
        }
    }

    private void selection() {
        switch (this.selectIndex) {
            case 0: {
                this.clearImage();
                this.dc.continueGame();
                this.dc.getClass();
                this.dc.GAME_MODE = 5;
                break;
            }
            case 1: {
                this.clearImage();
                this.dc.initGame();
                this.isContinue = true;
                break;
            }
            case 2: {
                this.resetMode(2);
                break;
            }
            case 3: {
                this.resetMode(3);
                break;
            }
            case 4: {
                this.resetMode(4);
                break;
            }
            case 5: {
                this.dc.midlet.exit();
                break;
            }
            case 6: {
                this.dc.onClickBannerAd();
                break;
            }
            case 7: {
                this.clearImage();
                DisplayableCanvas.level = this.levelindex;
                this.dc.initGame();
                this.isContinue = true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void input(int KEY) {
        block28: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block27: {
                                block26: {
                                    if (KEY == this.dc.KEY_LEFT_SOFT) break block26;
                                    if (KEY != 42) break block27;
                                }
                                this.dc.KEY = 0;
                                break block28;
                            }
                            if (KEY == this.dc.KEY_RIGHT_SOFT) break block29;
                            if (KEY != 35) break block30;
                        }
                        switch (this.MENU_MODE) {
                            case 2: 
                            case 3: 
                            case 4: {
                                this.resetMainMenu();
                                break;
                            }
                        }
                        break block28;
                    }
                    if (KEY == 49) break block28;
                    if (KEY != 50) break block31;
                    switch (this.MENU_MODE) {
                        case 1: {
                            if (this.isContinue) {
                                this.selectIndex = (this.selectIndex + (this.dc.buttonAd != null ? 6 : 5)) % (this.dc.buttonAd != null ? 7 : 6);
                                break;
                            }
                            --this.selectIndex;
                            if (this.selectIndex != 0) break;
                            this.selectIndex = this.dc.buttonAd != null ? 6 : 5;
                            break;
                        }
                        case 2: {
                            if (this.optionIndex > 0) {
                                this.optionIndex = (byte)(this.optionIndex - 1);
                                break;
                            }
                            this.optionIndex = (byte)(this.dc.buttonAd != null ? 2 : 1);
                            break;
                        }
                        case 3: {
                            if (this.helpY <= 0) break;
                            this.helpY -= SystemFont.fontHeight0;
                            break;
                        }
                    }
                    this.dc.KEY = 0;
                    break block28;
                }
                if (KEY != 56) break block32;
                switch (this.MENU_MODE) {
                    case 1: {
                        if (this.isContinue) {
                            this.selectIndex = (this.selectIndex + 1) % (this.dc.buttonAd != null ? 7 : 6);
                            break;
                        }
                        ++this.selectIndex;
                        if (this.selectIndex == (this.dc.buttonAd != null ? 7 : 6)) {
                            this.selectIndex = 1;
                            break;
                        }
                        break block28;
                    }
                    case 2: {
                        if (this.optionIndex < (this.dc.buttonAd != null ? (byte)2 : 1)) {
                            this.optionIndex = (byte)(this.optionIndex + 1);
                            break;
                        }
                        this.optionIndex = 0;
                        break;
                    }
                    case 3: {
                        if (this.helpY < this.helpHeight - 170) {
                            this.helpY += SystemFont.fontHeight0;
                            break;
                        }
                        break block28;
                    }
                }
                break block28;
            }
            if (KEY == 53) {
                switch (this.MENU_MODE) {
                    case 1: {
                        this.selection();
                        break;
                    }
                    case 2: {
                        if (this.optionIndex == 0) {
                            this.onoffs = !this.onoffs;
                            break;
                        }
                        if (this.optionIndex == 1) {
                            this.onoffv = !this.onoffv;
                            break;
                        }
                        if (this.optionIndex != 2 || this.dc.buttonAd == null) break;
                        this.dc.onClickBannerAd();
                        break;
                    }
                }
            }
        }
        this.dc.KEY = 0;
    }

    public void clearImage() {
        this.imgSplash = null;
        this.imghelppatch = null;
        this.imgoptTit = null;
        this.imgAboutLogo = null;
        this.butContinue = null;
        this.butNewGame = null;
        this.butOption = null;
        this.butHelp = null;
        this.butAbout = null;
        this.butExit = null;
        this.butSoundon = null;
        this.butSoundoff = null;
        this.butVibrateon = null;
        this.butVibrateoff = null;
        this.buttonHome = null;
        this.imgMenuLogo = null;
        this.imgLbar = null;
        this.imgRbar = null;
        this.imgMadal = null;
        System.gc();
        System.out.println("Menu Cleared");
    }

    public void run() {
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter <= 60) break;
                this.imgLogo = null;
                this.imgSplash = null;
                this.resetMode(1);
                this.dc.refreshTheBannerAd();
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter < 40) {
                    g.setColor(0xFFFFFF);
                    g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                    g.drawImage(this.imgLogo, this.WIDTH >> 1, this.HEIGHT >> 1, 1 | 2);
                    break;
                }
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                break;
            }
            case 1: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, 26, 45, 0x10 | 4);
                g.drawImage(this.imgLbar, 192, 33, 0x10 | 4);
                g.drawImage(this.imgRbar, 330, 33, 0x10 | 4);
                g.drawImage(this.imgMadal, 207, 39, 0x10 | 4);
                if (this.isContinue) {
                    this.butContinue.paint(g);
                }
                this.butNewGame.paint(g);
                this.butOption.paint(g);
                this.butHelp.paint(g);
                this.butAbout.paint(g);
                this.butExit.paint(g);
                break;
            }
            case 2: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, 26, 45, 0x10 | 4);
                g.drawImage(this.imgLbar, 192, 33, 0x10 | 4);
                g.drawImage(this.imgRbar, 330, 33, 0x10 | 4);
                g.drawImage(this.imgMadal, 207, 39, 0x10 | 4);
                g.drawImage(this.butOption.imgButton[0], (this.WIDTH >> 1) + 70, 65, 1 | 0x10);
                if (this.onoffs) {
                    this.butSoundon.paint(g);
                } else {
                    this.butSoundoff.paint(g);
                }
                if (this.onoffv) {
                    this.butVibrateon.paint(g);
                } else {
                    this.butVibrateoff.paint(g);
                }
                this.buttonHome.paint(g);
                break;
            }
            case 3: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, 26, 15, 0x10 | 4);
                g.drawImage(this.imgLbar, 164, 12, 0x10 | 4);
                g.drawImage(this.imgRbar, 349, 12, 0x10 | 4);
                g.drawImage(this.imghelppatch, 181, 14, 0x10 | 4);
                g.drawImage(this.butHelp.imgButton[0], (this.WIDTH >> 1) + 70, 29, 1 | 0x10);
                g.setFont(SystemFont.font1);
                g.setColor(0xFFFFFF);
                g.setClip(188, 50, 175, 150);
                SystemFont.drawText(this.helpTxt, g, 188, 50 - this.helpY * 3, 172, 0);
                g.setClip(0, 0, 400, 240);
                if (this.helpY <= 1) {
                    g.drawImage(this.imgDownArrow, (this.WIDTH >> 1) + 70, this.HEIGHT - 9, 1 | 2);
                } else if (this.helpY > 1 && this.helpY <= 69) {
                    g.drawImage(this.imgDownArrow, (this.WIDTH >> 1) + 70, this.HEIGHT - 9, 1 | 2);
                } else if (this.helpY >= 70) {
                    g.drawImage(this.imgUpArrow, (this.WIDTH >> 1) + 70, this.HEIGHT - 18, 1 | 2);
                }
                this.buttonHome.paint(g);
                break;
            }
            case 4: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, 26, 15, 0x10 | 4);
                g.drawImage(this.imgLbar, 164, 12, 0x10 | 4);
                g.drawImage(this.imgRbar, 349, 12, 0x10 | 4);
                g.drawImage(this.imghelppatch, 181, 14, 0x10 | 4);
                g.drawImage(this.butAbout.imgButton[0], (this.WIDTH >> 1) + 70, 29, 1 | 0x10);
                if (this.imgAboutLogo != null) {
                    g.drawImage(this.imgAboutLogo, (this.WIDTH >> 1) + 70, this.HEIGHT >> 1, 1 | 2);
                }
                this.buttonHome.paint(g);
                break;
            }
        }
    }

    public void storeSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"FishSetting", (boolean)true);
            byte[] Byte = null;
            ByteArrayOutputStream bout = new ByteArrayOutputStream(60);
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeBoolean(this.onoffs);
            dout.writeBoolean(this.onoffv);
            dout.flush();
            dout.close();
            Byte = bout.toByteArray();
            dout.close();
            if (this.soundSettings.getNumRecords() > 0) {
                this.soundSettings.setRecord(1, Byte, 0, Byte.length);
            } else {
                this.soundSettings.addRecord(Byte, 0, Byte.length);
            }
            this.soundSettings.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Store sound setings");
    }

    public void readSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"FishSetting", (boolean)true);
            if (this.soundSettings.getNumRecords() > 0) {
                byte[] Byte = null;
                Byte = this.soundSettings.getRecord(1);
                DataInputStream din = new DataInputStream(new ByteArrayInputStream(Byte));
                this.onoffs = din.readBoolean();
                this.onoffv = din.readBoolean();
                din.close();
            } else {
                byte[] Byte = null;
                ByteArrayOutputStream bout = new ByteArrayOutputStream(60);
                DataOutputStream dout = new DataOutputStream(bout);
                this.onoffs = true;
                this.onoffv = true;
                dout.writeBoolean(this.onoffs);
                dout.writeBoolean(this.onoffv);
                dout.flush();
                dout.close();
                Byte = bout.toByteArray();
                dout.close();
                this.soundSettings.addRecord(Byte, 0, Byte.length);
            }
            this.soundSettings.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("read sound setings");
    }

    protected void pointerDragged(int x, int y) {
        if (this.MENU_MODE == 3) {
            if (this.helpStartY < y) {
                if (this.helpY > 0) {
                    --this.helpY;
                }
            } else if (this.helpStartY > y && this.helpY < 70) {
                ++this.helpY;
            }
            this.helpStartY = y;
        }
    }
}

