/*
 * Decompiled with CFR 0.152.
 */
package Monster;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class LocalizationSupport {
    private static final String _MESSAGES_BUNDLE = "/Bubble/messages.properties";
    private static final String _INIT_LOCALIZATION_ERROR_MSG = "Error when initializing localization support, reason: {0}";
    private static final String _DEFAULT_STRING = "???";
    private static final String _KEY_VALUE_SEPARATORS = "=: \t\r\n\f";
    private static final String _STRICT_KEY_VALUE_SEPARTORS = "=:";
    private static final String _WHITESPACE_CHARS = " \t\r\n\f";
    private static Hashtable _messageTable;
    private static String _localizationErrorMessage;

    public static boolean initLocalizationSupport() {
        return LocalizationSupport.initLocalizationSupport(System.getProperty("microedition.locale"));
    }

    public static boolean initLocalizationSupport(String locale) {
        InputStream in = null;
        Class<?> clazz = Runtime.getRuntime().getClass();
        try {
            if (locale != null && locale.length() > 1) {
                int lastIndex = _MESSAGES_BUNDLE.lastIndexOf(46);
                String prefix = _MESSAGES_BUNDLE.substring(0, lastIndex);
                String suffix = _MESSAGES_BUNDLE.substring(lastIndex);
                locale = locale.replace('-', '_');
                in = clazz.getResourceAsStream(prefix + "_" + locale + suffix);
                if (in == null) {
                    in = clazz.getResourceAsStream(prefix + "_" + locale.substring(0, 2) + suffix);
                }
            }
            if (in == null) {
                in = clazz.getResourceAsStream(_MESSAGES_BUNDLE);
            }
            if (in != null) {
                _messageTable = new Hashtable();
                LocalizationSupport._loadMessages(in);
                return true;
            }
            _localizationErrorMessage = LocalizationSupport._processPattern(_INIT_LOCALIZATION_ERROR_MSG, new Object[]{"No messages found"});
        }
        catch (Exception e) {
            _localizationErrorMessage = LocalizationSupport._processPattern(_INIT_LOCALIZATION_ERROR_MSG, new Object[]{e.getMessage()});
        }
        return false;
    }

    public static String getErrorMessage() {
        return _localizationErrorMessage;
    }

    public static final String getMessage(String key) {
        return LocalizationSupport.getMessage(key, null);
    }

    public static final String getMessage(String key, Object[] args) {
        if (_messageTable == null && !LocalizationSupport.initLocalizationSupport()) {
            return _DEFAULT_STRING;
        }
        StringBuffer toAppendTo = new StringBuffer();
        String s = (String)_messageTable.get(key);
        if (s == null) {
            return _DEFAULT_STRING;
        }
        int l = s.length();
        int n = 0;
        int lidx = -1;
        int lastidx = 0;
        for (int i = 0; i < l; ++i) {
            if (s.charAt(i) == '{' && ++n == 1) {
                lidx = i;
                toAppendTo.append(s.substring(lastidx, i));
                lastidx = i;
            }
            if (s.charAt(i) != '}') continue;
            if (n == 1) {
                toAppendTo.append(LocalizationSupport._processPattern(s.substring(lidx + 1, i), args));
                lidx = -1;
                lastidx = i + 1;
            }
            --n;
        }
        if (n > 0) {
            toAppendTo.append(LocalizationSupport._processPattern(s.substring(lidx + 1), args));
        } else {
            toAppendTo.append(s.substring(lastidx));
        }
        return toAppendTo.toString();
    }

    private static synchronized void _loadMessages(InputStream inStream) throws IOException {
        InputStreamReader in = new InputStreamReader(inStream);
        String line;
        while ((line = LocalizationSupport._readLine(in)) != null) {
            int valueIndex;
            int separatorIndex;
            char firstChar;
            int keyStart;
            if (line.length() <= 0) continue;
            int len = line.length();
            for (keyStart = 0; keyStart < len && _WHITESPACE_CHARS.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
            }
            if (keyStart == len || (firstChar = line.charAt(keyStart)) == '#' || firstChar == '!') continue;
            while (LocalizationSupport._continueLine(line)) {
                int startIndex;
                String nextLine = LocalizationSupport._readLine(in);
                if (nextLine == null) {
                    nextLine = "";
                }
                String loppedLine = line.substring(0, len - 1);
                for (startIndex = 0; startIndex < nextLine.length() && _WHITESPACE_CHARS.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = new String(loppedLine + nextLine);
                len = line.length();
            }
            for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if (_KEY_VALUE_SEPARATORS.indexOf(currentChar) != -1) break;
            }
            for (valueIndex = separatorIndex; valueIndex < len && _WHITESPACE_CHARS.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
            }
            if (valueIndex < len && _STRICT_KEY_VALUE_SEPARTORS.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len && _WHITESPACE_CHARS.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            key = LocalizationSupport._convertString(key);
            value = LocalizationSupport._convertString(value);
            _messageTable.put(key, value);
        }
        return;
    }

    private static String _readLine(InputStreamReader in) throws IOException {
        int i;
        StringBuffer strBuf = new StringBuffer("");
        while ((i = in.read()) != -1) {
            if ((char)i == '\r' || (char)i == '\n') {
                return strBuf.toString();
            }
            strBuf.append((char)i);
        }
        return strBuf.length() > 0 ? strBuf.toString() : null;
    }

    private static boolean _continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private static String _convertString(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                return _DEFAULT_STRING;
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    private static String _processPattern(String indexString, Object[] args) {
        try {
            int index = Integer.parseInt(indexString);
            if (args != null && index >= 0 && index < args.length && args[index] != null) {
                return args[index].toString();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return _DEFAULT_STRING;
    }

    static {
        _localizationErrorMessage = null;
    }
}

