/*
 * Decompiled with CFR 0.152.
 */
package com.pim.model;

public class MarbleModel {
    public static final float DEFAULT_SIZE = 4.0f;
    public static final float DEFAULT_SIZE_HALVED = 2.0f;
    private static final float DEFAULT_Y = 10.0f;
    public static final float HYPOTENUSE = (float)Math.sqrt(8.0);
    private static final float DEFAULT_DRAG = 0.35f;
    public static final float DEFAULT_BOUNCE_DRAG = 0.14f;
    private static final int DEFAULT_MAX_VELOCITY_PER_AXIS = 5;
    private static final float FRICTION = 0.1f;
    private float[] _position = new float[3];
    private float[] _velocity = null;
    private float[] _newVelocity = null;
    private float _drag = 0.35f;
    private int _maxVelocityPerAxis = 5;

    public MarbleModel() {
        this._position[1] = 10.0f;
        this._velocity = new float[3];
        this._newVelocity = new float[3];
    }

    public void setDrag(float drag) {
        if (drag > 0.0f && (double)drag <= 1.0) {
            this._drag = drag;
        }
    }

    public final float drag() {
        return this._drag;
    }

    public void setVelocity(float[] velocity) {
        this._velocity = velocity;
    }

    public final float[] velocity() {
        return this._velocity;
    }

    public void setMaxVelocityPerAxis(int maxVelocity) {
        if (maxVelocity >= 0) {
            this._maxVelocityPerAxis = maxVelocity;
        }
    }

    public void setPosition(float[] position) {
        this._position = position;
        this._position[1] = 10.0f;
    }

    public void setPosition(float x, float y, float z) {
        this._position[0] = x;
        this._position[2] = z;
    }

    public void move(float x, float y, float z) {
        this._position[0] = this._position[0] + x;
        this._position[2] = this._position[2] + z;
    }

    public final float[] position() {
        return this._position;
    }

    public final float[] calculateVelocity(double accelerationX, double accelerationY) {
        this._newVelocity[1] = this._velocity[1];
        this._newVelocity[0] = this._velocity[0] - (float)accelerationX * this._drag;
        this._newVelocity[2] = this._velocity[2] + (float)accelerationY * this._drag;
        int i = 0;
        while (i < 3) {
            if (i != 1) {
                float absVelocity = Math.abs(this._newVelocity[i]);
                if (absVelocity < 0.1f) {
                    this._newVelocity[i] = 0.0f;
                } else {
                    int n = i;
                    this._newVelocity[n] = this._newVelocity[n] - 0.1f * (this._newVelocity[i] / absVelocity);
                }
                if (absVelocity > (float)this._maxVelocityPerAxis) {
                    this._newVelocity[i] = (float)this._maxVelocityPerAxis * (this._newVelocity[i] / absVelocity);
                }
            }
            ++i;
        }
        return this._newVelocity;
    }
}

