/*
 * Decompiled with CFR 0.152.
 */
package com.pim.model;

public class MyTimer {
    private static final int MAX_LISTENER_COUNT = 5;
    private static MyTimer _instance = null;
    private MyListener[] _listeners = new MyListener[5];
    private long _time = 0L;

    public static MyTimer instance() {
        if (_instance == null) {
            _instance = new MyTimer();
        }
        return _instance;
    }

    private MyTimer() {
    }

    public void update(long time) {
        this._time = time;
        MyListener listener = null;
        int i = 0;
        while (i < 5) {
            listener = this._listeners[i];
            if (listener != null && this._time - listener._lastTime >= (long)listener._interval) {
                listener._object.onTimeout();
                if (listener._repeat) {
                    listener._lastTime = this._time;
                } else {
                    this._listeners[i] = null;
                }
            }
            ++i;
        }
    }

    public void update() {
        this.update(System.currentTimeMillis());
    }

    public boolean addListener(Listener listener, boolean repeat, int interval) {
        if (listener == null || interval <= 0) {
            return false;
        }
        int i = 0;
        while (i < 5) {
            if (this._listeners[i] != null && this._listeners[i]._object == listener) {
                System.out.println("MyTimer::addListener(): Listener already exists.");
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < 5) {
            if (this._listeners[i] == null) {
                MyListener myListener = new MyListener();
                myListener._object = listener;
                myListener._repeat = repeat;
                myListener._interval = interval;
                myListener._lastTime = System.currentTimeMillis();
                this._listeners[i] = myListener;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeListener(Listener listener) {
        if (listener != null) {
            int i = 0;
            while (i < 5) {
                if (this._listeners[i] != null && this._listeners[i]._object == listener) {
                    this._listeners[i] = null;
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static interface Listener {
        public void onTimeout();
    }

    private class MyListener {
        private Listener _object;
        private boolean _repeat = false;
        private int _interval = 0;
        private long _lastTime = 0L;

        private MyListener() {
        }
    }
}

