/*
 * Decompiled with CFR 0.152.
 */
package com.pim.ui;

import javax.microedition.lcdui.Font;

public class TextWrapper {
    private char LINE_BREAK = (char)10;
    private char WHITE_SPACE = (char)32;
    private static TextWrapper _instance = null;
    private String _text = null;
    private Font _font;
    private int _fontHeight;
    private int _totalLength = 0;
    private int _width = 0;
    private int _start = 0;
    private int _position = 0;

    public static TextWrapper instance(Font font, int width) {
        if (_instance == null) {
            _instance = new TextWrapper(font, width);
        } else {
            _instance.setFont(font);
            _instance.setWidth(width);
        }
        return _instance;
    }

    private TextWrapper(Font font, int width) {
        if (font == null || width <= 0) {
            throw new IllegalArgumentException();
        }
        this.setFont(font);
        this.setWidth(width);
    }

    public void setFont(Font font) {
        if (font != null && this._font != font) {
            this._font = font;
            this._fontHeight = this._font.getHeight();
        }
    }

    public void setWidth(int width) {
        if (width > 0) {
            this._width = width;
        }
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        this._text = text;
        this._totalLength = this._text.length();
        this._start = 0;
        this._position = 0;
    }

    public String text() {
        return this._text;
    }

    public final int lineWidth(String line) {
        return this._font.stringWidth(line);
    }

    public final int lineHeight() {
        return this._fontHeight;
    }

    public int lineCount() {
        if (this._text == null && this._totalLength == 0) {
            return 0;
        }
        String original = this._text;
        int count = 0;
        while (this.hasMoreLines()) {
            this.nextLine();
            ++count;
        }
        this.setText(original);
        return count;
    }

    public boolean hasMoreLines() {
        return this._position < this._totalLength - 1;
    }

    public String nextLine() {
        int next = this.nextPosition();
        if (this._start >= this._totalLength || next > this._totalLength) {
            return null;
        }
        String retval = this._text.substring(this._start, next);
        this._start = next;
        if (this._totalLength - 1 > this._start && (this._text.charAt(this._start) == this.LINE_BREAK || this._text.charAt(this._start) == this.WHITE_SPACE)) {
            ++this._position;
            ++this._start;
        }
        return retval.trim();
    }

    private int nextPosition() {
        int i = this.nextWordIndex(this._position);
        int lastBreak = -1;
        String line = this._text.substring(this._position, i);
        int lineWidth = this._font.stringWidth(line);
        while (i < this._totalLength && lineWidth <= this._width) {
            if (this._text.charAt(i) == this.WHITE_SPACE) {
                lastBreak = i;
            } else if (this._text.charAt(i) == this.LINE_BREAK) {
                lastBreak = i;
                break;
            }
            if (++i >= this._totalLength) continue;
            i = this.nextWordIndex(i);
            line = this._text.substring(this._position, i);
            lineWidth = this._font.stringWidth(line);
        }
        this._position = i == this._totalLength && lineWidth <= this._width ? i : (lastBreak == this._position ? ++this._position : (lastBreak < this._position ? i : lastBreak));
        return this._position;
    }

    private int nextWordIndex(int startIndex) {
        int space = this._text.indexOf(this.WHITE_SPACE, startIndex);
        int newLine = this._text.indexOf(this.LINE_BREAK, startIndex);
        if (space == -1) {
            space = this._totalLength;
        }
        if (newLine == -1) {
            newLine = this._totalLength;
        }
        if (space < newLine) {
            return space;
        }
        return newLine;
    }
}

