/*
 * Decompiled with CFR 0.152.
 */
package com.pim.ui;

import com.pim.Main;
import com.pim.model.Maze;
import com.pim.ui.Plane;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;

public class WorldBuilder {
    private static final int MAX_NODES_TO_DESTROY_COUNT = 70;
    private static final String BACKGROUND_IMAGE_FILENAME = "/graphics/background.png";
    private static final String MARBLE_IMAGE_FILENAME = "/graphics/marble.png";
    private static final String FLOOR_IMAGE_FILENAME = "/graphics/floor.png";
    private static final String WALL_IMAGE_FILENAME = "/graphics/wall.png";
    private static final String GOAL_IMAGE_FILENAME = "/graphics/goal.png";
    private Node[] _nodesToDestroy = new Node[70];

    public void createNewMaze(World world, Maze maze, Appearance wallAppearance) {
        this.destroyMaze(world);
        maze.createNew(10);
        Enumeration wallsEnum = this.createPlanes(maze);
        maze.clear();
        while (wallsEnum.hasMoreElements()) {
            Mesh wallMesh = ((Plane)wallsEnum.nextElement()).createMesh();
            wallMesh.setAppearance(0, wallAppearance);
            world.addChild((Node)wallMesh);
            this.addNodeToDestroy((Node)wallMesh);
        }
        this.createGoalMark(world, maze);
    }

    public Background createBackground(World world) {
        Background background = new Background();
        Image backgroundImage = Main.makeImage(BACKGROUND_IMAGE_FILENAME);
        if (backgroundImage != null) {
            background.setImage(new Image2D(99, (Object)backgroundImage));
            background.setImageMode(33, 33);
            world.setBackground(background);
        }
        return background;
    }

    public void createWallAppearances(Appearance wallAppearance, Appearance wallClearAppearance) {
        PolygonMode wallPolygonMode = new PolygonMode();
        wallPolygonMode.setPerspectiveCorrectionEnable(true);
        wallClearAppearance.setPolygonMode(wallPolygonMode);
        CompositingMode wallClearCompositeMode = new CompositingMode();
        wallClearCompositeMode.setBlending(65);
        wallClearAppearance.setCompositingMode(wallClearCompositeMode);
        wallAppearance.setPolygonMode(wallPolygonMode);
        Image wallTextureImage = Main.makeImage(WALL_IMAGE_FILENAME);
        if (wallTextureImage != null) {
            Texture2D wallTexture = null;
            wallTexture = new Texture2D(new Image2D(99, (Object)wallTextureImage));
            wallTexture.setWrapping(241, 241);
            wallTexture.setBlending(228);
            wallTexture.setFiltering(209, 210);
            wallAppearance.setTexture(0, wallTexture);
            wallClearAppearance.setTexture(0, wallTexture);
        }
    }

    public void createFloor(World world) {
        float floorSide = 100.0f;
        Transform floorTransform = new Transform();
        floorTransform.postRotate(90.0f, -1.0f, 0.0f, 0.0f);
        floorTransform.postScale(floorSide, floorSide, 1.0f);
        Appearance floorAppearance = new Appearance();
        PolygonMode floorPolygonMode = new PolygonMode();
        floorPolygonMode.setPerspectiveCorrectionEnable(true);
        floorAppearance.setPolygonMode(floorPolygonMode);
        Texture2D floorTexture = null;
        Image floorTextureImage = Main.makeImage(FLOOR_IMAGE_FILENAME);
        if (floorTextureImage != null) {
            floorTexture = new Texture2D(new Image2D(99, (Object)floorTextureImage));
            floorTexture.setWrapping(241, 241);
            floorTexture.setBlending(228);
            floorTexture.setFiltering(209, 210);
            floorAppearance.setTexture(0, floorTexture);
        }
        Plane floor = new Plane(floorTransform, 10.0f);
        Mesh floorMesh = floor.createMesh();
        floorMesh.setAppearance(0, floorAppearance);
        floorMesh.setPickingEnable(false);
        world.addChild((Node)floorMesh);
    }

    private void createGoalMark(World world, Maze maze) {
        Appearance appearance = new Appearance();
        CompositingMode compositingMode = new CompositingMode();
        compositingMode.setBlending(64);
        appearance.setCompositingMode(compositingMode);
        Texture2D texture = null;
        Image textureImage = Main.makeImage(GOAL_IMAGE_FILENAME);
        if (textureImage != null) {
            texture = new Texture2D(new Image2D(100, (Object)textureImage));
            texture.setWrapping(240, 240);
            texture.setBlending(228);
            texture.setFiltering(210, 210);
            appearance.setTexture(0, texture);
        }
        Plane goalMarkPlane = this.createGoalMark(maze);
        Mesh goalMarkMesh = goalMarkPlane.createMesh();
        goalMarkMesh.setAppearance(0, appearance);
        goalMarkMesh.setPickingEnable(false);
        world.addChild((Node)goalMarkMesh);
        this.addNodeToDestroy((Node)goalMarkMesh);
    }

    public Mesh createMarble(World world) {
        Transform transform = new Transform();
        transform.postRotate(90.0f, -1.0f, 0.0f, 0.0f);
        transform.postScale(4.0f, 4.0f, 1.0f);
        Appearance appearance = new Appearance();
        CompositingMode compositingMode = new CompositingMode();
        compositingMode.setBlending(64);
        appearance.setCompositingMode(compositingMode);
        Texture2D texture = null;
        Image marbleImage = Main.makeImage(MARBLE_IMAGE_FILENAME);
        if (marbleImage != null) {
            texture = new Texture2D(new Image2D(100, (Object)marbleImage));
            texture.setWrapping(240, 240);
            texture.setBlending(228);
            texture.setFiltering(210, 210);
            appearance.setTexture(0, texture);
        }
        Plane marblePlane = new Plane(transform, 1.0f);
        Mesh marble = marblePlane.createMesh();
        marble.setAppearance(0, appearance);
        marble.setRenderingEnable(false);
        marble.setPickingEnable(false);
        world.addChild((Node)marble);
        return marble;
    }

    public void destroyMaze(World world) {
        if (this._nodesToDestroy != null) {
            int i = 0;
            while (i < 70) {
                if (this._nodesToDestroy[i] != null) {
                    world.removeChild(this._nodesToDestroy[i]);
                }
                ++i;
            }
            this._nodesToDestroy = null;
        }
    }

    private boolean addNodeToDestroy(Node node) {
        if (this._nodesToDestroy == null) {
            this._nodesToDestroy = new Node[70];
            this._nodesToDestroy[0] = node;
            return true;
        }
        int i = 0;
        while (i < 70) {
            if (this._nodesToDestroy[i] == null) {
                this._nodesToDestroy[i] = node;
                return true;
            }
            ++i;
        }
        System.out.println("WorldBuilder::addNodeToDestroy(): The array is full!");
        return false;
    }

    private Plane createGoalMark(Maze maze) {
        Transform markTransform = new Transform();
        markTransform.postTranslate(maze.origin() + (float)maze.goalX() * maze.spaceBetweenPlanes(), maze.height() / 2.0f + 0.2f, -maze.origin() - 5.0f);
        markTransform.postScale(10.0f, 10.0f, 10.0f);
        markTransform.postRotate(90.0f, -1.0f, 0.0f, 0.0f);
        return new Plane(markTransform, 1.0f);
    }

    private Enumeration createPlanes(Maze maze) {
        float wallWidth;
        Transform planeTransform;
        int steps;
        long[] mazeArray = maze.array();
        if (mazeArray == null || mazeArray.length == 0) {
            return null;
        }
        float spaceBetweenPlanes = maze.spaceBetweenPlanes();
        float mazeOrigin = maze.origin();
        float mazeHeight = maze.height();
        Vector<Plane> allPlanes = new Vector<Plane>();
        int i = 0;
        while (i < mazeArray.length) {
            int startX = -1;
            int j = 0;
            while (j < mazeArray.length) {
                long shift = 1L << j;
                if ((mazeArray[i] & shift) == shift && startX == -1) {
                    startX = j;
                } else if (((mazeArray[i] & shift) == 0L || j == mazeArray.length - 1) && startX >= 0) {
                    steps = j - startX;
                    if (steps == 1) {
                        startX = -1;
                    } else {
                        if (j == mazeArray.length - 1) {
                            ++steps;
                        }
                        planeTransform = new Transform();
                        wallWidth = maze.spaceBetweenPlanes() * (float)(steps - 1) / 2.0f;
                        planeTransform.postTranslate(mazeOrigin + spaceBetweenPlanes * (float)startX + wallWidth, mazeHeight, mazeOrigin + spaceBetweenPlanes * (float)i);
                        planeTransform.postScale(wallWidth, mazeHeight, 1.0f);
                        allPlanes.addElement(new Plane(planeTransform, 1.0f));
                        startX = -1;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < mazeArray.length) {
            int startY = -1;
            long shift = 1L << i;
            int j = 0;
            while (j < mazeArray.length) {
                if ((mazeArray[j] & shift) == shift && startY == -1) {
                    startY = j;
                } else if (((mazeArray[j] & shift) == 0L || j == mazeArray.length - 1) && startY >= 0) {
                    steps = j - startY;
                    if (steps == 1) {
                        startY = -1;
                    } else {
                        if (j == mazeArray.length - 1) {
                            ++steps;
                        }
                        planeTransform = new Transform();
                        wallWidth = spaceBetweenPlanes * (float)(steps - 1) / 2.0f;
                        planeTransform.postTranslate(mazeOrigin + spaceBetweenPlanes * (float)i, mazeHeight, mazeOrigin + spaceBetweenPlanes * (float)startY + wallWidth);
                        planeTransform.postRotate(90.0f, 0.0f, 1.0f, 0.0f);
                        planeTransform.postScale(wallWidth, mazeHeight, 1.0f);
                        allPlanes.addElement(new Plane(planeTransform, 1.0f));
                        startY = -1;
                    }
                }
                ++j;
            }
            ++i;
        }
        return allPlanes.elements();
    }
}

