/*
 * Decompiled with CFR 0.152.
 */
package com.pim;

import com.pim.Button;
import com.pim.ImageLoader;
import com.pim.Main;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class SplashScreen
extends GameCanvas {
    private Image infoImg;
    private Button startBtn;
    private Button exitBtn;
    private Button about;
    private Button help;

    public SplashScreen() {
        super(false);
        this.setFullScreenMode(true);
        int horizontalCenter = this.getWidth() / 2;
        int verticalCenter = this.getHeight() / 2;
        this.infoImg = ImageLoader.loadImage("/background.jpg");
        this.startBtn = new Button("/start.png", "/start_pressed.png", "/start.png", new Button.Listener(){

            public void clicked(Button button) {
                Main.getInstance().start();
            }
        });
        this.startBtn.setPosition(horizontalCenter - this.startBtn.getWidth() / 2, verticalCenter + 40);
        this.about = new Button("/about.png", "/about_pressed.png", "/about.png", new Button.Listener(){

            public void clicked(Button button) {
                Main.getInstance().about();
            }
        });
        this.about.setPosition(horizontalCenter - this.about.getWidth() / 2, verticalCenter + 70);
        this.help = new Button("/help.png", "/help_pressed.png", "/help.png", new Button.Listener(){

            public void clicked(Button button) {
                Main.getInstance().help();
            }
        });
        this.help.setPosition(horizontalCenter - this.help.getWidth() / 2, verticalCenter + 110);
        this.exitBtn = new Button("/exit.png", "/exit_pressed.png", "/exit.png", new Button.Listener(){

            public void clicked(Button button) {
                Main.getInstance().exit();
            }
        });
        this.exitBtn.setPosition(horizontalCenter - this.exitBtn.getWidth() / 2, verticalCenter + 150);
    }

    protected void render() {
        Graphics g = this.getGraphics();
        g.drawImage(this.infoImg, this.getWidth() / 2, this.getHeight() / 2, 3);
        this.startBtn.paint(g);
        this.exitBtn.paint(g);
        this.help.paint(g);
        this.about.paint(g);
        this.flushGraphics();
    }

    protected void showNotify() {
        this.render();
    }

    protected void pointerPressed(int x, int y) {
        this.startBtn.pointerPressed(x, y);
        this.exitBtn.pointerPressed(x, y);
        this.help.pointerPressed(x, y);
        this.about.pointerPressed(x, y);
        this.render();
    }

    protected void pointerDragged(int x, int y) {
        this.startBtn.pointerDragged(x, y);
        this.exitBtn.pointerDragged(x, y);
        this.help.pointerDragged(x, y);
        this.about.pointerDragged(x, y);
        this.render();
    }

    protected void pointerReleased(int x, int y) {
        this.startBtn.pointerReleased(x, y);
        this.exitBtn.pointerReleased(x, y);
        this.help.pointerReleased(x, y);
        this.about.pointerReleased(x, y);
        this.render();
    }
}

