/*
 * Decompiled with CFR 0.152.
 */
package com.pim.sensors;

import com.pim.ArrayUtils;
import com.pim.sensors.AccelerationProvider;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

class AccelerationProviderImpl
extends AccelerationProvider
implements DataListener {
    private SensorConnection sensor;
    private int dataType;

    public AccelerationProviderImpl() throws IOException {
        this.initConnection();
    }

    public void close() {
        this.sensor.removeDataListener();
        try {
            this.sensor.close();
            this.sensor = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dataReceived(SensorConnection sc, Data[] data, boolean isDataLost) {
        switch (this.dataType) {
            case 1: {
                this.dataReceived(ArrayUtils.getLast(data[0].getDoubleValues()), ArrayUtils.getLast(data[1].getDoubleValues()), ArrayUtils.getLast(data[2].getDoubleValues()));
                break;
            }
        }
    }

    private void initConnection() throws IOException {
        SensorInfo[] infos = SensorManager.findSensors((String)"acceleration", null);
        if (infos.length > 0) {
            this.dataType = infos[0].getChannelInfos()[0].getDataType();
            try {
                this.sensor = (SensorConnection)Connector.open((String)infos[0].getUrl());
                this.sensor.setDataListener((DataListener)this, 1);
            }
            catch (SecurityException se) {
                throw new IOException("could not open sensor");
            }
            catch (IOException ioe) {
                throw new IOException("could not open sensor");
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("could not open sensor");
            }
        } else {
            throw new IOException("acceleration sensor not found");
        }
    }
}

