/*
 * Decompiled with CFR 0.152.
 */
package com.pim.ui;

public class DoubleTapDetector {
    private static final int DOUBLE_TAP_TIMEOUT = 400;
    private static final int JITTER_THRESHOLD = 20;
    private final Listener _listener;
    private long _lastTapTime = 0L;
    private int[] _lastTapCoordinate = new int[2];

    public DoubleTapDetector(Listener listener) {
        this._listener = listener;
        this._lastTapCoordinate[0] = -1;
        this._lastTapCoordinate[1] = -1;
    }

    public boolean onTapped(int x, int y) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this._lastTapTime < 400L && Math.abs(this._lastTapCoordinate[0] - x) < 20 && Math.abs(this._lastTapCoordinate[1] - y) < 20) {
            if (this._listener != null) {
                this._listener.onDoubleTapDetected();
            }
            this._lastTapCoordinate[0] = -1;
            this._lastTapCoordinate[1] = -1;
            return true;
        }
        this._lastTapTime = currentTime;
        this._lastTapCoordinate[0] = x;
        this._lastTapCoordinate[1] = y;
        return false;
    }

    public static interface Listener {
        public void onDoubleTapDetected();
    }
}

