/*
 * Decompiled with CFR 0.152.
 */
package com.pim.ui;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class IconButton {
    public static final int EXIT = 0;
    public static final int INFO = 1;
    public static final int PAUSE = 2;
    public static final int VIEW_MODE = 3;
    private static final String EXIT_NORMAL = "/graphics/exit-button-normal-30.png";
    private static final String EXIT_PRESSED = "/graphics/exit-button-pressed-30.png";
    private static final String INFO_NORMAL = "/graphics/info-button-normal-30.png";
    private static final String INFO_PRESSED = "/graphics/info-button-pressed-30.png";
    private static final String PAUSE_NORMAL = "/graphics/pause-button-normal-30.png";
    private static final String PAUSE_PRESSED = "/graphics/pause-button-pressed-30.png";
    private static final String VIEW_MODE_NORMAL = "/graphics/view-mode-button-normal-30.png";
    private static final String VIEW_MODE_PRESSED = "/graphics/view-mode-button-pressed-30.png";
    private Image _normalImage = null;
    private Image _pressedImage = null;
    private final int _type;
    private boolean _pressed = false;

    public IconButton(int type) {
        this._type = type;
        this.createImages(true);
    }

    public void setPressed(boolean pressed) {
        this._pressed = pressed;
    }

    public final boolean pressed() {
        return this._pressed;
    }

    public void setIsPortrait(boolean isPortrait) {
        this.createImages(isPortrait);
    }

    public void paint(Graphics graphics, int x, int y) {
        if (this._pressed && this._pressedImage != null) {
            graphics.drawImage(this._pressedImage, x, y, 20);
        } else if (this._normalImage != null) {
            graphics.drawImage(this._normalImage, x, y, 20);
        }
    }

    private Image createImage(String source, boolean isPortrait) {
        Image image = null;
        try {
            image = Image.createImage((String)source);
            if (!isPortrait && image != null) {
                image = Image.createImage((Image)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (int)5);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    private final void createImages(boolean isPortrait) {
        switch (this._type) {
            case 0: {
                this._normalImage = this.createImage(EXIT_NORMAL, isPortrait);
                this._pressedImage = this.createImage(EXIT_PRESSED, isPortrait);
                break;
            }
            case 1: {
                this._normalImage = this.createImage(INFO_NORMAL, isPortrait);
                this._pressedImage = this.createImage(INFO_PRESSED, isPortrait);
                break;
            }
            case 2: {
                this._normalImage = this.createImage(PAUSE_NORMAL, isPortrait);
                this._pressedImage = this.createImage(PAUSE_PRESSED, isPortrait);
                break;
            }
            case 3: {
                this._normalImage = this.createImage(VIEW_MODE_NORMAL, isPortrait);
                this._pressedImage = this.createImage(VIEW_MODE_PRESSED, isPortrait);
            }
        }
    }
}

