/*
 * Decompiled with CFR 0.152.
 */
package com.pim.ui;

import com.pim.gestures.SafeGestureEvent;
import com.pim.gestures.SafeGestureInteractiveZone;
import com.pim.gestures.SafeGestureListener;
import com.pim.gestures.SafeGestureRegistrationManager;
import com.pim.model.GameModel;
import com.pim.model.MarbleModel;
import com.pim.sensors.AccelerationProvider;
import com.pim.ui.DoubleTapDetector;
import com.pim.ui.MazeCanvas;
import com.pim.ui.Menu;
import com.pim.ui.MenuItem;
import com.pim.ui.TipBox;

public class InteractionManager
implements AccelerationProvider.Listener,
DoubleTapDetector.Listener,
SafeGestureListener,
Menu.Listener {
    public static final float ACCELERATION_THRESHOLD = 1.5f;
    public static final float ACCELERATION_COEFFICIENT_X = 1.5f;
    public static final float ACCELERATION_COEFFICIENT_Y = 0.3f;
    private static final int MIN_CALIBRATION_VALUE = -6;
    public static final int UNDEFINED = -20;
    private static final int ZOOM_INTERVAL = 10;
    private final MazeCanvas _mazeCanvas;
    private final GameModel _gameModel;
    private final MarbleModel _marbleModel;
    private DoubleTapDetector _doubleTapDetector = null;
    private double _calibration = -20.0;
    private double _ax;
    private double _ay;

    public InteractionManager(MazeCanvas mazeCanvas, GameModel gameModel) {
        if (mazeCanvas == null || gameModel == null) {
            throw new IllegalArgumentException("Null arguments!");
        }
        this._mazeCanvas = mazeCanvas;
        this._gameModel = gameModel;
        this._marbleModel = this._gameModel.marble();
        this._doubleTapDetector = new DoubleTapDetector(this);
        SafeGestureRegistrationManager.setListener(this._mazeCanvas, this);
        SafeGestureInteractiveZone gestureZone = new SafeGestureInteractiveZone();
        gestureZone.setGesture(64);
        gestureZone.setRectangle(0, 0, this._mazeCanvas.getWidth(), this._mazeCanvas.getHeight());
        SafeGestureRegistrationManager.register(this._mazeCanvas, gestureZone);
    }

    public void onDataReceived(double ax, double ay, double az) {
        if (this._mazeCanvas.gameState() != 2) {
            return;
        }
        if (this._calibration == -20.0) {
            if (this._mazeCanvas.isPortrait()) {
                this.setCalibration(-ay);
            } else {
                this.setCalibration(-ax);
            }
        }
        if (this._mazeCanvas.isPortrait()) {
            this._ax = ax;
            this._ay = ay + this._calibration;
        } else {
            this._ax = ax + this._calibration;
            this._ay = ay;
        }
    }

    public void onDoubleTapDetected() {
        if (!this._mazeCanvas.povMode()) {
            this._mazeCanvas.resetZoom();
        }
    }

    public void gestureAction(Object container, SafeGestureInteractiveZone gestureInteractiveZone, SafeGestureEvent gestureEvent) {
        if (!this._mazeCanvas.povMode() && gestureEvent.getType() == 64) {
            if (gestureEvent.getPinchDistanceChange() < 0) {
                this._mazeCanvas.doZoom(10.0f);
            } else if (gestureEvent.getPinchDistanceChange() > 0) {
                this._mazeCanvas.doZoom(-10.0f);
            }
        }
    }

    public void onMenuItemSelected(int index) {
        if (this._mazeCanvas.gameState() == 3) {
            if (index == 0) {
                this._mazeCanvas.resume();
            } else if (index == 1) {
                this._mazeCanvas.setBackground(!this._mazeCanvas.hasBackground());
                MenuItem item = this._mazeCanvas.menu().itemAt(1);
                if (item != null) {
                    item.setText(this._mazeCanvas.hasBackground() ? "Set background off" : "Set background on");
                }
            } else if (index == 2) {
                this._mazeCanvas._debugMode = !this._mazeCanvas._debugMode;
                MenuItem item = this._mazeCanvas.menu().itemAt(2);
                if (item != null) {
                    item.setText(this._mazeCanvas._debugMode ? "Switch debug mode off" : "Switch debug mode on");
                }
            } else if (index == 3) {
                this._mazeCanvas.startNewGame();
            }
        }
    }

    public void onUIInitialized() {
        AccelerationProvider.getProvider(this);
    }

    public void setCalibration(double calibration) {
        this._calibration = calibration;
        if (this._calibration < -6.0 && this._calibration != -20.0) {
            this._calibration = -6.0;
        }
    }

    public final double calibration() {
        return this._calibration;
    }

    public void reset() {
        this._marbleModel.setVelocity(new float[]{0.0f, 0.0f, 0.0f});
    }

    public void onKeyPressed(int key) {
        System.out.println("InteractionManager::onKeyPressed(): " + key);
    }

    public void onPointerPressed(int x, int y) {
        if (TipBox.visible()) {
            TipBox.hide();
            return;
        }
        if (this._mazeCanvas.infoDialogVisible()) {
            if (x > 6 && x < 234 && y > 300 && y < 340) {
                this._mazeCanvas.openProjectsLink();
            } else {
                this._mazeCanvas.setInfoDialogVisible(false);
            }
            return;
        }
        int width = this._mazeCanvas.getWidth();
        int height = this._mazeCanvas.getHeight();
        if (this._mazeCanvas.gameState() == 0 || this._mazeCanvas.gameState() == 3 || this._mazeCanvas.gameState() == 5) {
            if (x > width - 42 && y > height - 42) {
                this._mazeCanvas.setButtonPressed(0);
            } else if (x < 42 && y > height - 42) {
                this._mazeCanvas.setButtonPressed(1);
            } else {
                switch (this._mazeCanvas.gameState()) {
                    case 0: {
                        this._mazeCanvas.startNewGame();
                        break;
                    }
                    case 3: {
                        this._mazeCanvas.menu().onPressed(x, y);
                        break;
                    }
                    case 5: {
                        this._mazeCanvas.cameraAnimator().startAnimation(3);
                    }
                }
            }
            return;
        }
        if (this._doubleTapDetector.onTapped(x, y)) {
            return;
        }
        if (x > width - 42 && y > height - 42) {
            this._mazeCanvas.setButtonPressed(2);
        } else if (x < 42) {
            // empty if block
        }
    }

    public void onPointerReleased(int x, int y) {
        int width = this._mazeCanvas.getWidth();
        int height = this._mazeCanvas.getHeight();
        if (this._mazeCanvas.gameState() == 0 || this._mazeCanvas.gameState() == 3 || this._mazeCanvas.gameState() == 5) {
            if (x > width - 42 && y > height - 42) {
                this._mazeCanvas.quit();
            } else if (x < 42 && y > height - 42) {
                this._mazeCanvas.setInfoDialogVisible(true);
            } else {
                this._mazeCanvas.menu().onReleased(x, y);
            }
            this._mazeCanvas.setButtonPressed(-1);
            return;
        }
        if (this._mazeCanvas.gameState() == 2) {
            if (x > width - 42 && y > height - 42) {
                System.out.println("MazeCanvas::pointerReleased(): Do pause");
                this._mazeCanvas.pause();
            } else if (x < 42 && y > height - 42) {
                this._mazeCanvas.toggleViewMode();
            }
        }
        this._mazeCanvas.setButtonPressed(-1);
    }

    public void onPointerDragged(int x, int y) {
        if (this._mazeCanvas.gameState() == 3) {
            this._mazeCanvas.menu().onPressed(x, y);
        }
    }

    public void onPointerRepeated(int x, int y) {
        this.onPointerPressed(x, y);
    }

    public final double ax() {
        return this._ax;
    }

    public final double ay() {
        return this._ay;
    }
}

