/*
 * Decompiled with CFR 0.152.
 */
package com.pim.ui;

import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.orientation.Orientation;
import com.nokia.mid.ui.orientation.OrientationListener;
import com.pim.Main;
import com.pim.model.GameModel;
import com.pim.model.MarbleModel;
import com.pim.model.Maze;
import com.pim.model.MyTimer;
import com.pim.ui.CameraAnimator;
import com.pim.ui.IconButton;
import com.pim.ui.InfoDialog;
import com.pim.ui.InteractionManager;
import com.pim.ui.Menu;
import com.pim.ui.MenuItem;
import com.pim.ui.TipBox;
import com.pim.ui.WorldBuilder;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;

public class MazeCanvas
extends GameCanvas
implements Runnable,
OrientationListener,
CameraAnimator.Listener {
    private static final int MILLIS_PER_TICK = 5;
    private static final float DEFAULT_TOP_CAMERA_ANGLE = 75.0f;
    private static final float PAUSE_CAMERA_ANGLE = 45.0f;
    private static final float DEFAULT_ZOOM = 1.0f;
    public static final int MIN_ZOOM = -70;
    public static final int MAX_ZOOM = 70;
    public static final float ANGLE_STEP = 8.0f;
    private static final float MAX_TILT_COEFFICIENT = 3.0f;
    private static final float TILT_THRESHOLD = 0.1f;
    private static final int LEVEL_TIME = 60;
    private static final int MIN_UPDATE_INTERVAL = 20;
    private static final int MIN_FPS_STATS_COUNT = 20;
    public static final int NOT_STARTED = 0;
    public static final int TRANSITION_ANIMATION_ONGOING = 1;
    public static final int ONGOING = 2;
    public static final int PAUSED = 3;
    public static final int LEVEL_FINISHED = 4;
    public static final int GAME_OVER = 5;
    private static final int MARGIN = 6;
    public static final int TEXT_COLOR = -8267009;
    private final Main _midlet;
    private WorldBuilder _builder;
    private Menu _menu;
    private final MenuItem _blinkingMenuItem = new MenuItem("Tap screen to start game");
    private Thread _mainThread = null;
    private GameModel _gameModel = null;
    private InteractionManager _interactionManager = null;
    private Maze _maze = null;
    private MarbleModel _marbleModel = null;
    private Graphics3D _graphics3d;
    private World _world;
    private Camera _topCamera = null;
    private Camera _povCamera = null;
    private Background _background = null;
    private Graphics _graphics = null;
    private CameraAnimator _cameraAnimator = null;
    private Appearance _wallClearAppearance = new Appearance();
    private Appearance _wallAppearance = new Appearance();
    private Mesh _marble = null;
    private IconButton[] _iconButtons = new IconButton[4];
    private InfoDialog _infoDialog = null;
    private float _zoom = 1.0f;
    private float _previousZoom = -70.0f;
    private float _relativeZoom = 0.5f;
    private float _cameraOffset = 1.0f;
    private float _povAngleY = 0.0f;
    private boolean _povMode = true;
    private float _prevTiltX = 0.0f;
    private float _prevTiltY = 0.0f;
    private volatile boolean _running = true;
    private int _gameState = 0;
    private float _stepLengthX = 0.0f;
    private float _stepLengthZ = -3.0f;
    private volatile int _loopCounter = 1;
    private long _drawingTime = 0L;
    private volatile float _fps = 0.0f;
    private float _averageFps = 0.0f;
    private int _fpsCount = 0;
    private volatile long _levelStartTime = 0L;
    private volatile long _timeUsed = 0L;
    private volatile long _timeToBeat = 0L;
    private int _level = 1;
    private int _width = 0;
    private int _height = 0;
    private boolean _isPortrait = true;
    private boolean _hasBackground = true;
    private boolean _firstTime = true;
    public boolean _debugMode = false;

    public MazeCanvas(Main midlet) {
        super(true);
        this._midlet = midlet;
    }

    protected void keyPressed(int key) {
        this._interactionManager.onKeyPressed(key);
    }

    protected void pointerPressed(int x, int y) {
        this._interactionManager.onPointerPressed(x, y);
    }

    protected void pointerReleased(int x, int y) {
        this._interactionManager.onPointerReleased(x, y);
    }

    protected void pointerDragged(int x, int y) {
        this._interactionManager.onPointerDragged(x, y);
    }

    protected void pointerRepeated(int x, int y) {
        this._interactionManager.onPointerRepeated(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._graphics = this.getGraphics();
        long tempTime = System.currentTimeMillis();
        long tempTimeForPause = 0L;
        while (this._running) {
            long timeTaken;
            long startTime = System.currentTimeMillis();
            if (this.isShown()) {
                MyTimer.instance().update(startTime);
                if (this._gameState == 2) {
                    this._timeUsed = startTime - this._levelStartTime;
                    if (this._timeToBeat - this._timeUsed <= 0L) {
                        this.endGame();
                    }
                    if (!this._povMode) {
                        float[] position = this._marbleModel.position();
                        this._marble.setTranslation(position[0] + 4.0f, position[1], position[2] + 4.0f);
                    }
                    if (startTime - tempTime > 20L) {
                        if (this._povMode) {
                            this.moveMarbleInPovMode();
                        } else {
                            this.moveMarble();
                        }
                        this.updateCamera();
                        if (this._loopCounter % 2 == 0) {
                            this.tiltBoard();
                        }
                        if (this._loopCounter % 9 == 0 && !this._gameModel.goalReached() && this._gameModel.isAtEnd()) {
                            this._gameModel.setGoalReached(true);
                            this.finishLevel();
                        }
                        this._loopCounter = this._loopCounter > 9 ? 1 : ++this._loopCounter;
                        tempTime = startTime;
                    }
                }
                if (this._cameraAnimator.running()) {
                    this._cameraAnimator.update();
                    if (this._cameraAnimator.animationType() == 0 && startTime - tempTimeForPause > 20L) {
                        this.shiftBackground(-1);
                        tempTimeForPause = startTime;
                    }
                }
                this.updateGraphics();
            }
            if ((timeTaken = System.currentTimeMillis() - startTime) < 5L) {
                MazeCanvas mazeCanvas = this;
                synchronized (mazeCanvas) {
                    try {
                        this.wait(5L - timeTaken);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            Thread.yield();
        }
    }

    public void displayOrientationChanged(int newDisplayOrientation) {
        System.out.println("MazeCanvas::displayOrientationChanged(): " + newDisplayOrientation);
        boolean orientationChanged = false;
        if (newDisplayOrientation == 2 && !this._povMode && this._isPortrait) {
            orientationChanged = true;
            this._isPortrait = false;
        } else if (!this._isPortrait) {
            orientationChanged = true;
            this._isPortrait = true;
        }
        if (orientationChanged) {
            this._iconButtons[2].setIsPortrait(this._isPortrait);
            this._topCamera.setTransform(this.defaultTopCameraTransform());
            this._interactionManager.setCalibration(-20.0);
        }
    }

    public void onAnimationFinished(int animationType) {
        System.out.println("MazeCanvas::onAnimationFinished(): " + animationType);
        switch (animationType) {
            case 0: {
                this.transitionToCurrentViewMode();
                break;
            }
            case 1: {
                this._world.setActiveCamera(this._povCamera);
                this._marble.setRenderingEnable(false);
                this._gameState = 2;
                this.updateCamera();
                this._averageFps = 0.0f;
                this._fpsCount = 0;
                break;
            }
            case 2: {
                this._world.setActiveCamera(this._topCamera);
                this._marble.setRenderingEnable(true);
                this._gameState = 2;
                this.updateCamera();
                this._averageFps = 0.0f;
                this._fpsCount = 0;
                break;
            }
            case 3: {
                if (this._gameState == 4) {
                    this.nextLevel();
                    this.transitionToCurrentViewMode();
                    break;
                }
                this.createNewLevel();
                this.showStartMenu();
            }
        }
    }

    public synchronized void setRunning(boolean running) {
        this._running = running;
        if (this._running && this._mainThread == null) {
            this._mainThread = new Thread(this);
            this._mainThread.start();
        }
    }

    public void init() {
        this._gameModel = GameModel.instance();
        this._interactionManager = new InteractionManager(this, this._gameModel);
        this._maze = this._gameModel.maze();
        this._marbleModel = this._gameModel.marble();
        this._topCamera = new Camera();
        this._povCamera = new Camera();
        this.setFullScreenMode(true);
        this._width = this.getWidth();
        this._height = this.getHeight();
        this._menu = new Menu(this._interactionManager, this._width, this._height);
        this._graphics3d = Graphics3D.getInstance();
        this._iconButtons[0] = new IconButton(0);
        this._iconButtons[1] = new IconButton(1);
        this._iconButtons[2] = new IconButton(2);
        this._iconButtons[3] = new IconButton(3);
        this._world = new World();
        this._world.addChild((Node)this._topCamera);
        this._world.addChild((Node)this._povCamera);
        this._world.setActiveCamera(this._topCamera);
        this._builder = new WorldBuilder();
        this._background = this._builder.createBackground(this._world);
        this._builder.createFloor(this._world);
        this._builder.createWallAppearances(this._wallAppearance, this._wallClearAppearance);
        this._marble = this._builder.createMarble(this._world);
        this._povCamera.setPerspective(60.0f, (float)this.getWidth() / (float)this.getHeight(), 0.1f, 1000.0f);
        this._povMode = false;
        this._povAngleY = -180.0f;
        this.calculateRelativeZoomAndCameraOffset();
        this._cameraAnimator = new CameraAnimator(this, this._world, this._topCamera);
        this.createNewLevel();
        this.setRunning(true);
        this._interactionManager.onUIInitialized();
        Orientation.addOrientationListener((OrientationListener)this);
        this.showStartMenu();
    }

    public void setBackground(boolean on) {
        if (on && this._background == null) {
            this._background = this._builder.createBackground(this._world);
        } else if (!on && this._background != null) {
            this._world.setBackground(null);
            this._background = null;
        }
        this._hasBackground = on;
        this._averageFps = 0.0f;
        this._fpsCount = 0;
    }

    public final boolean hasBackground() {
        return this._hasBackground;
    }

    public void startNewGame() {
        this._gameModel.setGoalReached(false);
        this._level = 1;
        this._levelStartTime = System.currentTimeMillis();
        this._timeToBeat = 60000L;
        this._timeUsed = 0L;
        if (this._gameState == 0) {
            MyTimer.instance().removeListener(this._blinkingMenuItem);
        } else {
            this.createNewLevel();
        }
        if (this._cameraAnimator.running()) {
            this._cameraAnimator.stopAnimation();
        } else {
            this._gameState = 2;
        }
        this._interactionManager.reset();
        DeviceControl.setLights((int)0, (int)100);
        TipBox.showTips();
    }

    public void resume() {
        System.out.println("MazeCanvas::resume()");
        if (this._gameState == 3) {
            this._levelStartTime = System.currentTimeMillis() - this._timeUsed;
            this._cameraAnimator.stopAnimation();
        } else {
            System.out.println("MazeCanvas::resume(): No game to resume!");
        }
    }

    public void pause() {
        if (this._gameState == 3) {
            return;
        }
        this._menu.clear();
        this._menu.addItem("Resume");
        this._menu.addItem(this._hasBackground ? "Set background off" : "Set background on");
        this._menu.addItem(this._debugMode ? "Switch debug mode off" : "Switch debug mode on");
        this._menu.addItem("Restart game");
        Transform targetTransform = new Transform();
        targetTransform.postRotate(45.0f, -1.0f, 0.0f, 0.0f);
        targetTransform.postTranslate(0.0f, 0.0f, 200.0f);
        this._cameraAnimator.startAnimation(0, targetTransform, null);
        this._interactionManager.setCalibration(-20.0);
        this._gameState = 3;
    }

    public void endGame() {
        this._gameState = 5;
        this._menu.clear();
        MenuItem item = new MenuItem("Game Over");
        item.setDisabled(true);
        this._menu.addItem(item);
        this._menu.addItem("You reached level " + this._level);
        this._blinkingMenuItem.setText("Tap screen to continue");
        MyTimer.instance().addListener(this._blinkingMenuItem, true, 500);
        this._menu.addItem(this._blinkingMenuItem);
        this._cameraAnimator.startAnimation(0);
    }

    public void finishLevel() {
        this._gameState = 4;
        this._menu.clear();
        this._menu.addItem("Level " + this._level + " finished!");
        this._cameraAnimator.startAnimation(3);
    }

    public final boolean isPortrait() {
        return this._isPortrait;
    }

    public void setInfoDialogVisible(boolean visible) {
        if (visible) {
            if (this._infoDialog == null) {
                this._infoDialog = new InfoDialog();
            }
        } else {
            this._infoDialog = null;
        }
    }

    public final boolean infoDialogVisible() {
        return this._infoDialog != null;
    }

    public void openProjectsLink() {
        System.out.println("MazeCanvas::openProjectsLink()");
        try {
            if (this._midlet.platformRequest("http://projects.developer.nokia.com/amaze")) {
                this.quit();
            }
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            // empty catch block
        }
    }

    public final void quit() {
        this._midlet.quitApp();
    }

    public final int gameState() {
        return this._gameState;
    }

    public final Menu menu() {
        return this._menu;
    }

    public final Camera topCamera() {
        return this._topCamera;
    }

    public final CameraAnimator cameraAnimator() {
        return this._cameraAnimator;
    }

    public void doZoom(float diff) {
        this._zoom += diff;
        if (this._zoom < -70.0f) {
            this._zoom = -70.0f;
        } else if (this._zoom > 70.0f) {
            this._zoom = 70.0f;
        }
        this.calculateRelativeZoomAndCameraOffset();
        this.updateCamera();
    }

    public void resetZoom() {
        if (this._povMode) {
            return;
        }
        if (this._zoom != 1.0f) {
            System.out.println("MazeCanvas::resetZoom(): Resetting the default zoom.");
            this._previousZoom = this._zoom;
            this._zoom = 1.0f;
        } else {
            System.out.println("MazeCanvas::resetZoom(): Restoring the previous zoom.");
            this._zoom = this._previousZoom;
        }
        this.calculateRelativeZoomAndCameraOffset();
        this.updateCamera();
    }

    public void setPovAngleY(float angle) {
        this._povAngleY = angle;
        this._stepLengthX = 3.0f * (float)Math.sin(Math.toRadians(this._povAngleY));
        this._stepLengthZ = 3.0f * (float)Math.cos(Math.toRadians(this._povAngleY));
    }

    public final float povAngleY() {
        return this._povAngleY;
    }

    public void rotatePovAngleY(float diff) {
        this._povAngleY += diff;
        this._stepLengthX = 3.0f * (float)Math.sin(Math.toRadians(this._povAngleY));
        this._stepLengthZ = 3.0f * (float)Math.cos(Math.toRadians(this._povAngleY));
    }

    public final float stepLengthX() {
        return this._stepLengthX;
    }

    public final float stepLengthZ() {
        return this._stepLengthZ;
    }

    public final boolean povMode() {
        return this._povMode;
    }

    public void toggleViewMode() {
        this._povMode = !this._povMode;
        System.out.println("MazeCanvas::toggleViewMode(): To " + (this._povMode ? "POV" : "TOP"));
        if (this._povMode) {
            this._iconButtons[3].setPressed(true);
        } else {
            this._iconButtons[3].setPressed(false);
        }
        this.transitionToCurrentViewMode();
    }

    public void setButtonPressed(int id) {
        this._iconButtons[0].setPressed(false);
        this._iconButtons[1].setPressed(false);
        this._iconButtons[2].setPressed(false);
        if (id == 0 || id == 1 || id == 2) {
            this._iconButtons[id].setPressed(true);
        }
    }

    public final int buttonPressed() {
        if (this._iconButtons[0].pressed()) {
            return 0;
        }
        if (this._iconButtons[1].pressed()) {
            return 1;
        }
        if (this._iconButtons[2].pressed()) {
            return 2;
        }
        return -1;
    }

    public final void shiftBackground(int delta) {
        if (this._background != null) {
            this._background.setCrop(this._background.getCropX() + delta, 0, this._width, this._height);
        }
    }

    public final float averageFps() {
        if (this._fpsCount < 20) {
            return -1.0f;
        }
        return this._averageFps;
    }

    public void updateCamera() {
        float[] position = this._marbleModel.position();
        if (this._povMode) {
            this._povCamera.setOrientation(this._povAngleY, 0.0f, 1.0f, 0.0f);
            this._povCamera.setTranslation(position[0], 10.0f, position[2]);
        } else {
            this._topCamera.setTranslation(position[0] / this._cameraOffset, this._zoom, position[2] / this._cameraOffset);
        }
    }

    public final int detectCollision(float stepX, float stepZ) {
        float[] position = this._marbleModel.position();
        float x = position[0] + stepX;
        float z = position[2] + stepZ;
        float mazeSize = 98.0f;
        int outside = 0;
        if (x - 2.0f <= -mazeSize || x + 2.0f > mazeSize) {
            outside = 1;
        }
        if (z - 2.0f <= -mazeSize || z + 2.0f > mazeSize) {
            outside += 2;
        }
        if (outside > 0) {
            System.out.println("MazeCanvas::canMoveTo(): Would go outside of the maze.");
            return outside;
        }
        return this.marbleCollidesAt(x, z);
    }

    private final int marbleCollidesAt(float x, float z) {
        float distance;
        Node selected;
        RayIntersection intersection = new RayIntersection();
        float minimumDistance = 4.5f;
        if (this._world.pick(-1, x, 2.0f, z, 2.0f, 0.1f, 2.0f, intersection) && (selected = intersection.getIntersected()) instanceof Mesh && (distance = intersection.getDistance()) < 4.5f) {
            float[] position = this._marbleModel.position();
            int retval = 0;
            if (this._world.pick(-1, x, 2.0f, position[2], 2.0f, 0.1f, 2.0f, intersection) && (distance = intersection.getDistance()) < 4.5f) {
                retval = 1;
            }
            if (this._world.pick(-1, position[0], 2.0f, z, 2.0f, 0.1f, 2.0f, intersection) && (distance = intersection.getDistance()) < 4.5f) {
                retval += 2;
            }
            return retval;
        }
        return 0;
    }

    private void showStartMenu() {
        this._gameState = 0;
        this._menu.clear();
        MyTimer.instance().removeListener(this._blinkingMenuItem);
        this._blinkingMenuItem.setText("Tap screen to start game");
        MyTimer.instance().addListener(this._blinkingMenuItem, true, 500);
        this._menu.addItem(this._blinkingMenuItem);
        float width = this._width;
        float height = this._height;
        this._topCamera.setPerspective(60.0f, width / height, 0.1f, 1000.0f);
        Transform transform = new Transform();
        transform.postRotate(45.0f, -1.0f, 0.0f, 0.0f);
        transform.postTranslate(0.0f, 0.0f, 200.0f);
        this._topCamera.setTransform(transform);
        this.updateCamera();
        this._cameraAnimator.startAnimation(0);
    }

    private void createNewLevel() {
        System.out.println("MazeCanvas::createNewLevel()");
        this._builder.createNewMaze(this._world, this._maze, this._wallAppearance);
        this._marbleModel.setPosition(this._maze.startPosition());
    }

    private void nextLevel() {
        System.out.println("MazeCanvas::nextLevel()");
        this._gameModel.setGoalReached(false);
        ++this._level;
        this._levelStartTime = System.currentTimeMillis();
        this._timeToBeat = 60000L + this._timeToBeat - this._timeUsed - (long)((this._level - 1) * 5000);
        if (this._timeToBeat < 10000L) {
            this._timeToBeat = 10000L;
        }
        this._timeUsed = 0L;
        this.createNewLevel();
        this.updateCamera();
        this._interactionManager.reset();
    }

    private Transform defaultTopCameraTransform() {
        Transform transform = new Transform();
        if (this._isPortrait) {
            transform.postRotate(75.0f, -1.0f, 0.0f, 0.0f);
        } else {
            transform.postRotate(90.0f, -1.0f, 0.0f, 0.0f);
            transform.postRotate(15.0f, 0.0f, -1.0f, 0.0f);
        }
        transform.postTranslate(0.0f, 0.0f, 200.0f);
        return transform;
    }

    private void transitionToCurrentViewMode() {
        if (this._povMode) {
            this._cameraAnimator.startAnimation(1, this._povCamera);
        } else {
            Transform transform = this.defaultTopCameraTransform();
            float[] orientation = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            this._cameraAnimator.startAnimation(2, transform, orientation);
        }
    }

    private final void calculateRelativeZoomAndCameraOffset() {
        int scale = 140;
        this._relativeZoom = (this._zoom - -70.0f) / 140.0f;
        this._cameraOffset = this._relativeZoom * 4.0f;
        if (this._cameraOffset < 1.0f) {
            this._cameraOffset = 1.0f;
        }
    }

    private final void tiltBoard() {
        float tiltX = (float)(-this._interactionManager.ax());
        float tiltY = (float)(-this._interactionManager.ay());
        boolean updateTilt = false;
        if (Math.abs(tiltX - this._prevTiltX) > 0.1f) {
            this._prevTiltX = tiltX;
            updateTilt = true;
        }
        if (Math.abs(tiltY - this._prevTiltY) > 0.1f) {
            this._prevTiltY = tiltY;
            updateTilt = true;
        }
        if (updateTilt) {
            float coefficient = this._relativeZoom * 3.0f;
            this._topCamera.setOrientation(this._prevTiltY * coefficient, 1.0f, 0.0f, 0.0f);
            this._topCamera.postRotate(this._prevTiltX * coefficient, 0.0f, 0.0f, 1.0f);
        }
    }

    private final void moveMarbleInPovMode() {
        float stepZ;
        float stepLength;
        int mark;
        float stepX;
        int collision;
        float absCalibratedAy;
        double ax = this._interactionManager.ax();
        double ay = this._interactionManager.ay();
        if (Math.abs(ax) > 1.5) {
            this.rotatePovAngleY((float)ax * 1.5f);
            this.shiftBackground((int)(-ax * 1.5) * 3);
        }
        if ((absCalibratedAy = (float)Math.abs(ay)) > 1.5f && (collision = this.detectCollision(stepX = (float)(mark = ay > 0.0 ? 1 : -1) * (stepLength = 3.0f * (absCalibratedAy * 0.3f)) * (float)Math.sin(Math.toRadians(this._povAngleY)), stepZ = (float)mark * stepLength * (float)Math.cos(Math.toRadians(this._povAngleY)))) == 0) {
            this._marbleModel.move(stepX, 0.0f, stepZ);
        }
    }

    private final void moveMarble() {
        float[] velocity = this._marbleModel.calculateVelocity(this._interactionManager.ax(), this._interactionManager.ay());
        int collision = -1;
        int safety = 0;
        while (collision != 0 && safety < 4) {
            collision = this.detectCollision(velocity[0], velocity[2]);
            if (collision == 1 || collision == 3) {
                velocity[0] = -velocity[0] * 0.14f;
            } else if (collision == 2 || collision == 3) {
                velocity[2] = -velocity[2] * 0.14f;
            }
            ++safety;
        }
        this._marbleModel.setVelocity(velocity);
        this._marbleModel.move(velocity[0], 0.0f, velocity[2]);
    }

    private final void updateGraphics() {
        if (this._debugMode || this._fpsCount < 20) {
            this._drawingTime = System.currentTimeMillis();
        }
        this.draw3D(this._graphics);
        this.draw2D(this._graphics);
        if (this._debugMode || this._fpsCount < 20) {
            this._drawingTime = System.currentTimeMillis() - this._drawingTime;
            if (this._drawingTime > 0L) {
                this._fps = 1000L / this._drawingTime;
            }
            if (this._debugMode) {
                this._graphics.setColor(-8267009);
                this._graphics.drawString("FPS: " + this._fps + " (" + (this._fpsCount < 20 ? -1.0f : this._averageFps) + ")", 42, this._height, 36);
            }
            if (this._fpsCount < 20) {
                this._averageFps += this._fps;
                ++this._fpsCount;
                if (this._fpsCount == 20) {
                    this._averageFps /= (float)this._fpsCount;
                    if (this._firstTime && this._averageFps > 1.0f) {
                        if (this._averageFps < 25.0f) {
                            this.setBackground(false);
                        }
                        this._firstTime = false;
                    }
                }
            }
        }
        this.flushGraphics();
    }

    private void draw2D(Graphics graphics) {
        graphics.setColor(-8267009);
        if (this._debugMode) {
            graphics.drawString("AX: " + (float)this._interactionManager.ax(), 42, this._height - 30, 36);
            graphics.drawString("AY: " + (float)this._interactionManager.ay(), 42, this._height - 15, 36);
        }
        if (this._isPortrait && (this._gameState == 2 || this._gameState == 3 || this._gameState == 5)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Level ").append(this._level);
            graphics.drawString(buffer.toString(), 6, 6, 20);
            buffer.delete(0, buffer.length());
            buffer.append("Time left: ");
            buffer.append((this._timeToBeat - this._timeUsed) / 1000L);
            graphics.drawString(buffer.toString(), this._width - 6, 6, 24);
        }
        if (this._gameState == 0 || this._gameState == 3 || this._gameState == 5) {
            if (this._infoDialog == null) {
                this._menu.paint(graphics);
                this._iconButtons[1].paint(graphics, 6, this._height - 36);
                this._iconButtons[0].paint(graphics, this._width - 36, this._height - 36);
            } else {
                this._infoDialog.paint(graphics);
            }
        } else if (this._gameState == 2) {
            this._iconButtons[2].paint(graphics, this._width - 36, this._height - 36);
            if (this._isPortrait) {
                this._iconButtons[3].paint(graphics, 6, this._height - 36);
                if (TipBox.visible()) {
                    TipBox.paint(graphics);
                }
            }
        } else if (this._gameState == 4) {
            this._menu.paint(graphics);
        }
    }

    private void draw3D(Graphics graphics) {
        boolean bound = false;
        try {
            this._graphics3d.bindTarget((Object)graphics);
            bound = true;
            this._world.animate((int)(System.currentTimeMillis() - this._levelStartTime));
            this._graphics3d.render(this._world);
        }
        finally {
            if (bound) {
                this._graphics3d.releaseTarget();
            }
        }
    }
}

