/*
 * Decompiled with CFR 0.152.
 */
package com.sensiblemobiles.game;

import com.sensiblemobiles.game.BlastAnimation;
import com.sensiblemobiles.game.Bulet;
import com.sensiblemobiles.game.Enymy;
import com.sensiblemobiles.game.Gun;
import com.sensiblemobiles.game.MainGameCanvas;
import com.sensiblemobiles.game.PointInfo;
import com.sensiblemobiles.game.SoundHandler;
import com.sensiblemobiles.game.TrigMath;
import com.sensiblemobiles.killrobber.CommanFunctions;
import com.sensiblemobiles.killrobber.Constants;
import com.sensiblemobiles.killrobber.KillTheRobberMidlet;
import com.sensiblemobiles.killrobber.MainCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CoreGame {
    private int MAXENEMY = 5;
    Enymy[] enymy;
    Gun gun;
    private int maxBulet = 10;
    Bulet[] bulets;
    private Image shootingPoint;
    BlastAnimation blastAnimation;
    private PointInfo pointInfo;
    public Image currentBackground;
    public Image shoot;
    private int score = 0;
    public static int backgroundIndexNumber = -1;
    private int spx;
    private int spy;
    private int _10PW;
    private int _80PW;
    private int _4PH;
    private int levelTime;
    private int powerRectW;
    private Font font = Font.getFont((int)0, (int)0, (int)8);
    private int NRX1 = 50;
    private int NRY1;
    int y1;
    private int baseHeight = 400;
    private int baseWeight = 240;
    SoundHandler soundHandler;
    private int topAddHeight;
    private int radious = 100;
    private int rectW = 30;
    int timerHelper = 0;
    private boolean isTouchNavigator = false;
    private int xTouch;
    private int yTouch;
    public static int buletAngle = 0;
    private int pressedKey = 0;
    private int gmCounter = 0;

    public CoreGame() {
        try {
            this.enymy = new Enymy[this.MAXENEMY];
            this.gun = new Gun();
            this.spx = MainGameCanvas.screenWidth / 2;
            this.spy = MainGameCanvas.screenHeight / 2;
            this._10PW = CommanFunctions.getPercentage(MainGameCanvas.screenWidth, 10);
            this.powerRectW = this._80PW / 20;
            this._4PH = CommanFunctions.getPercentage(MainGameCanvas.screenHeight, 4);
            this.bulets = new Bulet[this.maxBulet];
            this.soundHandler = new SoundHandler(KillTheRobberMidlet.midlet);
            this.soundHandler.On_eventSound();
            this.shootingPoint = Image.createImage((String)"/res/shotingPoint.png");
            this.shoot = Image.createImage((String)"/res/game/shoot.png");
            this.currentBackground = Image.createImage((String)"/res/levelBackground/0.png");
            if (MainGameCanvas.screenHeight != this.baseHeight || MainGameCanvas.screenWidth != this.baseWeight) {
                this.currentBackground = CommanFunctions.scale(this.currentBackground, MainGameCanvas.screenWidth, MainGameCanvas.screenHeight);
            }
            this.pointInfo = new PointInfo();
            this.y1 = MainGameCanvas.screenHeight - (MainGameCanvas.mainGameCanvas.backButton.getHeight() + 110);
            this.NRY1 = this.y1 + 50;
            this.genrateEnemy();
            this.levelTime = 600;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void genrateEnemy() {
        for (int i = 0; i < this.MAXENEMY; ++i) {
            if (this.enymy[i] != null) continue;
            this.enymy[i] = new Enymy();
            if (backgroundIndexNumber == 0) {
                this.enymy[i].setXYPos(Constants.xyPos0);
                break;
            }
            if (backgroundIndexNumber == 1) {
                this.enymy[i].setXYPos(Constants.xyPos1);
                break;
            }
            if (backgroundIndexNumber == 2) {
                this.enymy[i].setXYPos(Constants.xyPos2);
                break;
            }
            if (backgroundIndexNumber != 3) break;
            this.enymy[i].setXYPos(Constants.xyPos3);
            break;
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.currentBackground, MainGameCanvas.screenWidth / 2, MainGameCanvas.screenHeight / 2, 3);
        this.topAddHeight = MainGameCanvas.mainGameCanvas.advertisements.getTopAddHeight();
        this.drawEnemy(g);
        this.drawBulet(g);
        this.drawBlast(g);
        this.gun.paint(g);
        g.drawImage(this.shootingPoint, this.spx, this.spy, 3);
        this.buleInvisibleJugaad();
        this.gunMove();
        this.drawGunPower(g);
        this.genrateEnemy();
        if (this.pointInfo != null) {
            this.pointInfo.paint(g);
        }
        g.setFont(this.font);
        g.setColor(255);
        g.drawString("Level " + MainGameCanvas.level, MainGameCanvas.screenWidth - 1, this.topAddHeight, 24);
        g.drawString("Score " + this.score, 1, this.topAddHeight, 0);
        g.drawString("Time " + this.levelTime, MainGameCanvas.screenWidth / 2, this.topAddHeight, 17);
        if (MainCanvas.isTouchEnable) {
            this.navigation_Fire_Key(g);
        }
    }

    private void drawEnemy(Graphics g) {
        for (int i = 0; i < this.MAXENEMY; ++i) {
            if (this.enymy[i] == null) continue;
            this.enymy[i].paint(g);
            this.enymy[i].changeEnemyPosition(false);
        }
    }

    private void navigation_Fire_Key(Graphics g) {
        g.drawImage(this.shoot, MainGameCanvas.screenWidth - 10, this.topAddHeight + 10, 24);
    }

    private void drawGunPower(Graphics g) {
        if (this.levelTime == 0) {
            MainGameCanvas.mainGameCanvas.setScreenValue(MainGameCanvas.gameOverScreen);
        } else {
            --this.levelTime;
        }
    }

    private void buleInvisibleJugaad() {
        for (int i = 0; i < this.maxBulet; ++i) {
            if (this.bulets[i] == null || this.gun == null) continue;
            if (this.gun.getGunSprite().collidesWith(this.bulets[i].getBuletSprite(), true)) {
                this.bulets[i].getBuletSprite().setVisible(false);
                continue;
            }
            if (this.bulets[i].getBuletY() <= MainGameCanvas.screenHeight - 53) continue;
            this.bulets[i].getBuletSprite().setVisible(true);
        }
    }

    private void drawBlast(Graphics g) {
        if (this.blastAnimation != null) {
            this.blastAnimation.paint(g);
            if (!this.blastAnimation.isAlive) {
                this.blastAnimation = null;
            }
        }
    }

    private void resetGame() {
        this.levelTime = 600;
    }

    private void makeBuletNull() {
        for (int i = 0; i < this.maxBulet; ++i) {
            if (this.bulets[i] == null) continue;
            this.bulets[i] = null;
        }
    }

    private void makeEnemyNull() {
        for (int i = 0; i < this.MAXENEMY; ++i) {
            if (this.enymy[i] == null) continue;
            this.enymy[i] = null;
        }
    }

    public void setLevel(int level, boolean flag) {
        this.pointInfo.setValue("", 0, -10, 0);
        this.makeBuletNull();
        this.makeEnemyNull();
        MainGameCanvas.level = level;
        System.out.println(" level " + level + " score " + this.score);
        try {
            if (flag) {
                backgroundIndexNumber = MainGameCanvas.level <= 4 ? MainGameCanvas.level - 1 : CommanFunctions.randam(0, 4);
                this.currentBackground = Image.createImage((String)("/res/levelBackground/" + backgroundIndexNumber + ".png"));
            }
            if (MainGameCanvas.screenHeight != this.baseHeight || MainGameCanvas.screenWidth != this.baseWeight) {
                this.currentBackground = CommanFunctions.scale(this.currentBackground, MainGameCanvas.screenWidth, MainGameCanvas.screenHeight);
            }
            if (backgroundIndexNumber == 0) {
                if (this.enymy[0] != null) {
                    this.enymy[0].setXYPos(Constants.xyPos0);
                }
            } else if (backgroundIndexNumber == 1) {
                if (this.enymy[0] != null) {
                    this.enymy[0].setXYPos(Constants.xyPos1);
                }
            } else if (backgroundIndexNumber == 2) {
                if (this.enymy[0] != null) {
                    this.enymy[0].setXYPos(Constants.xyPos2);
                }
            } else if (backgroundIndexNumber == 3 && this.enymy[0] != null) {
                this.enymy[0].setXYPos(Constants.xyPos3);
            }
            this.resetGame();
            MainGameCanvas.mainGameCanvas.setScreenValue(MainGameCanvas.gameScreen);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void pointerPressed(int x, int y) {
        int YS = this.topAddHeight + 10;
        if (x > MainGameCanvas.screenWidth - (this.shoot.getWidth() + 10) && x < MainGameCanvas.screenWidth - 10 && y > YS && y < YS + this.shoot.getHeight()) {
            this.keyPressed(-5);
            return;
        }
        this.spx = x;
        this.spy = y;
        this.xTouch = x;
        this.yTouch = y;
    }

    protected void pointerDragged(int x, int y) {
        if (this.isTouchNavigator) {
            int xDiff = 0;
            int yDiff = 0;
            xDiff = x > this.xTouch ? x - this.xTouch : this.xTouch - x;
            if (xDiff > (yDiff = y > this.yTouch ? y - this.yTouch : this.yTouch - y)) {
                if (x > this.xTouch) {
                    ++this.NRX1;
                    this.keyPressed(-4);
                } else {
                    --this.NRX1;
                    this.keyPressed(-3);
                }
            } else if (y > this.yTouch) {
                ++this.NRY1;
                this.keyPressed(-2);
            } else {
                --this.NRY1;
                this.keyPressed(-1);
            }
            if (this.NRX1 + this.rectW > this.radious + 5) {
                this.NRX1 = this.radious - 25;
            }
            if (this.NRX1 < 5) {
                this.NRX1 = 5;
            }
            if (this.NRY1 + this.rectW > this.y1 + this.radious) {
                this.NRY1 = this.y1 + this.radious - this.rectW;
            }
            if (this.NRY1 < this.y1) {
                this.NRY1 = this.y1;
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        this.isTouchNavigator = false;
        this.pressedKey = 0;
    }

    private void genrateBulet() {
        int x = MainGameCanvas.screenWidth / 2;
        int y = MainGameCanvas.screenHeight;
        boolean xDiff = false;
        boolean yDiff = false;
        boolean distance = true;
        buletAngle = (int)this.getAngle(x, y);
        for (int i = 0; i < this.maxBulet; ++i) {
            if (this.bulets[i] != null) continue;
            System.out.println("gun index " + this.gun.getGunIndex());
            System.out.println("angle " + buletAngle);
            this.gun.changeGunIndex(buletAngle);
            this.bulets[i] = new Bulet(x, y, buletAngle);
            this.soundHandler.playSound(1, this.soundHandler.onevent);
            break;
        }
    }

    public double getAngle(int x, int y) {
        double dy = -(this.spy - y);
        double dx = this.spx - x;
        double inRads = TrigMath.atan2(dy, dx);
        inRads = inRads < 0.0 ? Math.abs(inRads) : Math.PI * 2 - inRads;
        return Math.toDegrees(inRads);
    }

    private void drawBulet(Graphics g) {
        for (int i = 0; i < this.maxBulet; ++i) {
            if (this.bulets[i] == null) continue;
            this.bulets[i].paint(g);
            if (this.bulets[i].getBuletY() < MainGameCanvas.screenHeight / 2) {
                this.bulets[i].setSmallAnimationShow(true);
            }
            if (this.bulets[i].getBuletY() >= MainGameCanvas.screenHeight / 4 && this.bulets[i].getBuletY() <= MainGameCanvas.screenHeight) continue;
            this.bulets[i] = null;
        }
        this.checkCollision();
    }

    private void checkCollision() {
        for (int i = 0; i < this.maxBulet; ++i) {
            for (int j = 0; j < this.MAXENEMY; ++j) {
                if (this.bulets[i] == null || this.enymy[j] == null || !this.bulets[i].getBuletSprite().collidesWith(this.enymy[j].getEnymySprite(), true)) continue;
                int en = this.enymy[j].getPlayerNumber();
                this.enymy[j].changeEnemyPosition(true);
                this.bulets[i].setSmallAnimationShow(true);
                if (en == 0) {
                    this.score += 25;
                    this.pointInfo.setValue("+25", this.bulets[i].getBuletX(), this.bulets[i].getBuletY(), 160);
                } else {
                    this.score -= 25;
                    this.pointInfo.setValue("-25", this.bulets[i].getBuletX(), this.bulets[i].getBuletY(), 0xFF0000);
                }
                int targetScore = MainGameCanvas.level * 250;
                if (this.score == targetScore) {
                    MainGameCanvas.mainGameCanvas.setScreenValue(MainGameCanvas.levelComScreen);
                }
                this.blastAnimation = new BlastAnimation(this.bulets[i].getBuletX(), this.bulets[i].getBuletY());
                this.bulets[i] = null;
            }
        }
    }

    private void gunMove() {
        int x = MainGameCanvas.screenWidth / 2;
        int y = MainGameCanvas.screenHeight;
        ++this.gmCounter;
        int gunIndex = this.gun.getGunIndex();
        if (this.pressedKey == 1) {
            if (gunIndex < this.gun.getMaxFrame() - 1 && this.gmCounter % 3 == 0) {
                this.gun.setGunIndex(++gunIndex);
                buletAngle = (int)this.getAngle(x, y);
            }
            if (this.spx < MainGameCanvas.screenWidth - 5) {
                this.spx += 5;
            }
        } else if (this.pressedKey == 2) {
            if (gunIndex > 0 && this.gmCounter % 3 == 0) {
                this.gun.setGunIndex(--gunIndex);
                buletAngle = (int)this.getAngle(x, y);
            }
            if (this.spx > 5) {
                this.spx -= 5;
            }
        } else if (this.pressedKey == 3) {
            if (this.spy > 5) {
                this.spy -= 5;
            }
        } else if (this.pressedKey == 4 && this.spy < MainGameCanvas.screenHeight - 5) {
            this.spy += 5;
        }
    }

    protected void keyPressed(int keyCode) {
        switch (keyCode) {
            case -4: {
                this.pressedKey = 1;
                break;
            }
            case -3: {
                this.pressedKey = 2;
                break;
            }
            case -1: {
                this.pressedKey = 3;
                break;
            }
            case -2: {
                this.pressedKey = 4;
                break;
            }
            case -5: {
                this.genrateBulet();
            }
        }
    }

    protected void keyReleased(int keyCode) {
        this.pressedKey = 0;
    }
}

