/*
 * Decompiled with CFR 0.152.
 */
package com.sensiblemobiles.game;

import com.sensiblemobiles.game.MainGameCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Gun {
    private Sprite gunSprite;
    private int frameWidth;
    private int frameHeight;
    private int maxFrame = 15;
    private int gunIndex = 7;

    public Gun() {
        try {
            Image img = Image.createImage((String)"/res/gun.png");
            this.frameWidth = img.getWidth() / this.maxFrame;
            this.frameHeight = img.getHeight();
            this.gunSprite = new Sprite(img, this.frameWidth, this.frameHeight);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void changeGunIndex(int angle) {
        System.out.println("changeGunIndex " + angle);
        int a = angle - 180;
        System.out.println("changeGunIndex a " + a);
        int b = a / 10;
        System.out.println("changeGunIndex b " + b);
        this.gunIndex = b >= 0 && b < this.maxFrame ? b : (b >= this.maxFrame ? this.maxFrame - 1 : 0);
    }

    public void paint(Graphics g) {
        this.gunSprite.setPosition(MainGameCanvas.screenWidth / 2 - this.frameWidth / 2, MainGameCanvas.screenHeight - this.frameHeight);
        this.gunSprite.setFrame(this.gunIndex);
        this.gunSprite.paint(g);
    }

    public static Image rotateImage(Image src, float angle) {
        int sw = src.getWidth();
        int sh = src.getHeight();
        int[] srcData = new int[sw * sh];
        src.getRGB(srcData, 0, sw, 0, 0, sw, sh);
        int[] dstData = new int[sw * sh];
        double rads = (double)angle * Math.PI / 180.0;
        float sa = (float)Math.sin(rads);
        float ca = (float)Math.cos(rads);
        int isa = (int)(256.0f * sa);
        int ica = (int)(256.0f * ca);
        int my = -(sh >> 1);
        for (int i = 0; i < sh; ++i) {
            int wpos = i * sw;
            int xacc = my * isa - (sw >> 1) * ica + (sw >> 1 << 8);
            int yacc = my * ica + (sw >> 1) * isa + (sh >> 1 << 8);
            for (int j = 0; j < sw; ++j) {
                int srcx = xacc >> 8;
                int srcy = yacc >> 8;
                if (srcx < 0) {
                    srcx = 0;
                }
                if (srcy < 0) {
                    srcy = 0;
                }
                if (srcx > sw - 1) {
                    srcx = sw - 1;
                }
                if (srcy > sh - 1) {
                    srcy = sh - 1;
                }
                dstData[wpos++] = srcData[srcx + srcy * sw];
                xacc += ica;
                yacc -= isa;
            }
            ++my;
        }
        return Image.createRGBImage((int[])dstData, (int)sw, (int)sh, (boolean)true);
    }

    public int getGunIndex() {
        return this.gunIndex;
    }

    public void setGunIndex(int gunIndex) {
        this.gunIndex = gunIndex;
    }

    public Sprite getGunSprite() {
        return this.gunSprite;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public int getMaxFrame() {
        return this.maxFrame;
    }
}

