/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl.migration;

import java.io.DataInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.SerializationManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.migration.HashtableValueNullable;
import net.sourceforge.floggy.persistence.migration.Enumeration;
import net.sourceforge.floggy.persistence.migration.FieldPersistableInfo;

public abstract class AbstractEnumerationImpl
implements Enumeration {
    protected PersistableManager a = PersistableManager.getInstance();
    protected PersistableMetadata b;
    protected PersistableMetadata c;
    protected RecordEnumeration d;
    protected RecordStore e;
    protected boolean f;
    protected boolean g;
    protected int h = -1;

    protected AbstractEnumerationImpl(PersistableMetadata persistableMetadata, PersistableMetadata persistableMetadata2, RecordEnumeration recordEnumeration, RecordStore recordStore, boolean bl, boolean bl2) {
        this.c = persistableMetadata;
        this.b = persistableMetadata2;
        this.d = recordEnumeration;
        this.e = recordStore;
        this.g = bl;
        this.f = bl2;
    }

    public int delete() {
        if (this.h != -1) {
            try {
                this.e.deleteRecord(this.h);
                int n2 = this.h;
                this.h = -1;
                return n2;
            }
            catch (RecordStoreException recordStoreException) {
                RecordStoreException recordStoreException2 = recordStoreException;
                throw Utils.handleException((Exception)((Object)recordStoreException));
            }
        }
        throw new FloggyException("There isn't a register to delete. You have to iterate over the enumeration before call delete.");
    }

    public int getSize() {
        return this.d.numRecords();
    }

    public boolean hasMoreElements() {
        return this.d.hasNextElement();
    }

    public Hashtable nextElement() {
        if (this.h != -1 && !this.f) {
            throw new FloggyException("You should delete or update the current register before step into the next one.");
        }
        HashtableValueNullable hashtableValueNullable = new HashtableValueNullable();
        try {
            this.h = this.d.nextRecordId();
            byte[] byArray = this.e.getRecord(this.h);
            this.a(this.c, byArray, hashtableValueNullable);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw Utils.handleException(exception);
        }
        return hashtableValueNullable;
    }

    public int update(Persistable persistable) {
        if (this.h != -1) {
            persistable = Utils.checkArgumentAndCast(persistable);
            persistable.__setId(this.h);
            int n2 = this.a.save(persistable);
            this.h = -1;
            return n2;
        }
        throw new FloggyException("There isn't a register to update. You have to iterate over the enumeration before call update.");
    }

    protected abstract void a(PersistableMetadata var1, byte[] var2, Hashtable var3);

    protected final Object a(int n2, String string, DataInputStream dataInputStream) {
        Object[] objectArray = null;
        if (dataInputStream.readByte() == 0) {
            int n3 = dataInputStream.readInt();
            if ((n2 & 0x40000) == 262144) {
                switch (n2 &= 0xFFFBFFFF) {
                    case 1: {
                        DataInputStream dataInputStream2 = dataInputStream;
                        int n4 = n3;
                        boolean[] blArray = new boolean[n4];
                        for (int i2 = 0; i2 < blArray.length; ++i2) {
                            blArray[i2] = dataInputStream2.readBoolean();
                        }
                        objectArray = blArray;
                        break;
                    }
                    case 2: {
                        DataInputStream dataInputStream3 = dataInputStream;
                        int n5 = n3;
                        byte[] byArray = new byte[n5];
                        for (int i3 = 0; i3 < byArray.length; ++i3) {
                            byArray[i3] = dataInputStream3.readByte();
                        }
                        objectArray = byArray;
                        break;
                    }
                    case 8: {
                        DataInputStream dataInputStream4 = dataInputStream;
                        int n6 = n3;
                        char[] cArray = new char[n6];
                        for (int i4 = 0; i4 < cArray.length; ++i4) {
                            cArray[i4] = dataInputStream4.readChar();
                        }
                        objectArray = cArray;
                        break;
                    }
                    case 32: {
                        DataInputStream dataInputStream5 = dataInputStream;
                        int n7 = n3;
                        double[] dArray = new double[n7];
                        for (int i5 = 0; i5 < dArray.length; ++i5) {
                            dArray[i5] = dataInputStream5.readDouble();
                        }
                        objectArray = dArray;
                        break;
                    }
                    case 64: {
                        DataInputStream dataInputStream6 = dataInputStream;
                        int n8 = n3;
                        float[] fArray = new float[n8];
                        for (int i6 = 0; i6 < fArray.length; ++i6) {
                            fArray[i6] = dataInputStream6.readFloat();
                        }
                        objectArray = fArray;
                        break;
                    }
                    case 256: {
                        DataInputStream dataInputStream7 = dataInputStream;
                        int n9 = n3;
                        int[] nArray = new int[n9];
                        for (int i7 = 0; i7 < nArray.length; ++i7) {
                            nArray[i7] = dataInputStream7.readInt();
                        }
                        objectArray = nArray;
                        break;
                    }
                    case 512: {
                        DataInputStream dataInputStream8 = dataInputStream;
                        int n10 = n3;
                        long[] lArray = new long[n10];
                        for (int i8 = 0; i8 < lArray.length; ++i8) {
                            lArray[i8] = dataInputStream8.readLong();
                        }
                        objectArray = lArray;
                        break;
                    }
                    case 2048: {
                        DataInputStream dataInputStream9 = dataInputStream;
                        int n11 = n3;
                        short[] sArray = new short[n11];
                        for (int i9 = 0; i9 < sArray.length; ++i9) {
                            sArray[i9] = dataInputStream9.readShort();
                        }
                        objectArray = sArray;
                    }
                }
            } else {
                Object[] objectArray2;
                int n12 = n3;
                int n13 = n2;
                switch (n13) {
                    case 1: {
                        objectArray2 = new Boolean[n12];
                        break;
                    }
                    case 2: {
                        objectArray2 = new Byte[n12];
                        break;
                    }
                    case 4: {
                        objectArray2 = new Calendar[n12];
                        break;
                    }
                    case 8: {
                        objectArray2 = new Character[n12];
                        break;
                    }
                    case 16: {
                        objectArray2 = new Date[n12];
                        break;
                    }
                    case 32: {
                        objectArray2 = new Double[n12];
                        break;
                    }
                    case 64: {
                        objectArray2 = new Float[n12];
                        break;
                    }
                    case 128: {
                        objectArray2 = new Hashtable[n12];
                        break;
                    }
                    case 256: {
                        objectArray2 = new Integer[n12];
                        break;
                    }
                    case 512: {
                        objectArray2 = new Long[n12];
                        break;
                    }
                    case 1024: {
                        objectArray2 = new FieldPersistableInfo[n12];
                        break;
                    }
                    case 2048: {
                        objectArray2 = new Short[n12];
                        break;
                    }
                    case 4096: {
                        objectArray2 = new Stack[n12];
                        break;
                    }
                    case 8192: {
                        objectArray2 = new String[n12];
                        break;
                    }
                    case 16384: {
                        objectArray2 = new StringBuffer[n12];
                        break;
                    }
                    case 32768: {
                        objectArray2 = new TimeZone[n12];
                        break;
                    }
                    case 65536: {
                        objectArray2 = new Vector[n12];
                        break;
                    }
                    default: {
                        throw new FloggyException("Type Unknow: " + n13);
                    }
                }
                objectArray = objectArray2;
                for (n12 = 0; n12 < n3; ++n12) {
                    objectArray[n12] = this.b(n2, string, dataInputStream);
                }
            }
        }
        return objectArray;
    }

    protected final Object b(int n2, String string, DataInputStream dataInputStream) {
        switch (n2) {
            case 1: {
                return SerializationManager.readBoolean(dataInputStream);
            }
            case 2: {
                return SerializationManager.readByte(dataInputStream);
            }
            case 4: {
                return SerializationManager.readCalendar(dataInputStream);
            }
            case 8: {
                return SerializationManager.readChar(dataInputStream);
            }
            case 16: {
                return SerializationManager.readDate(dataInputStream);
            }
            case 32: {
                return SerializationManager.readDouble(dataInputStream);
            }
            case 64: {
                return SerializationManager.readFloat(dataInputStream);
            }
            case 128: {
                return SerializationManager.readHashtable(dataInputStream);
            }
            case 256: {
                return SerializationManager.readInt(dataInputStream);
            }
            case 512: {
                return SerializationManager.readLong(dataInputStream);
            }
            case 1024: {
                FieldPersistableInfo fieldPersistableInfo = null;
                string = this.c.getPersistableImplementationClassForField(string);
                switch (dataInputStream.readByte()) {
                    case -1: {
                        string = dataInputStream.readUTF();
                    }
                    case 0: {
                        int n3 = dataInputStream.readInt();
                        fieldPersistableInfo = new FieldPersistableInfo(n3, string);
                    }
                }
                return fieldPersistableInfo;
            }
            case 2048: {
                return SerializationManager.readShort(dataInputStream);
            }
            case 4096: {
                return SerializationManager.readStack(dataInputStream, this.g);
            }
            case 8192: {
                return SerializationManager.readString(dataInputStream);
            }
            case 16384: {
                return SerializationManager.readStringBuffer(dataInputStream);
            }
            case 32768: {
                return SerializationManager.readTimeZone(dataInputStream);
            }
            case 65536: {
                return SerializationManager.readVector(dataInputStream, this.g);
            }
        }
        throw new FloggyException("Type Unknow: " + n2);
    }

    protected static Object a(int n2, DataInputStream dataInputStream) {
        switch (n2) {
            case 1: {
                if (dataInputStream.readBoolean()) {
                    return Utils.TRUE;
                }
                return Utils.FALSE;
            }
            case 2: {
                return new Byte(dataInputStream.readByte());
            }
            case 8: {
                return new Character(dataInputStream.readChar());
            }
            case 32: {
                return new Double(dataInputStream.readDouble());
            }
            case 64: {
                return new Float(dataInputStream.readFloat());
            }
            case 256: {
                return new Integer(dataInputStream.readInt());
            }
            case 512: {
                return new Long(dataInputStream.readLong());
            }
            case 2048: {
                return new Short(dataInputStream.readShort());
            }
        }
        throw new FloggyException("Type Unknow: " + n2);
    }

    void a() {
        if (!this.d.hasNextElement()) {
            this.d.destroy();
            RecordStoreManager.closeRecordStore(this.e);
            if (this.c != this.b) {
                try {
                    this.b.setRecordId(this.c.getRecordId());
                    this.b.setRecordStoreVersion(PersistableMetadataManager.getBytecodeVersion());
                    PersistableMetadataManager.saveRMSStructure(this.b);
                    return;
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    throw Utils.handleException(exception);
                }
            }
        } else {
            throw new FloggyException("The enumeration must be whole processed before finish the process!");
        }
    }
}

