/*
 * Decompiled with CFR 0.152.
 */
package org.fruct.yar.tea;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import org.fruct.yar.tea.Button;
import org.fruct.yar.tea.ImageLoader;
import org.fruct.yar.tea.Listener;
import org.fruct.yar.tea.TagApplication;

public class MainScreen
extends GameCanvas
implements CommandListener {
    private Image infoImage;
    private Image logoImage;
    private Button newGameButton;
    private Button exitButton;
    private Button continueButton;
    private Button recordsButton;
    private Button aboutButton;
    private int horizontalCenter = this.getWidth() / 2;
    private int verticalCenter = this.getHeight() / 2;

    public MainScreen() {
        super(false);
        this.setFullScreenMode(true);
        this.infoImage = ImageLoader.loadImage("main_screen.png");
        this.logoImage = ImageLoader.loadImage("logo1.png");
        this.initNgButton();
        if (System.getProperty("microedition.platform").startsWith("Nokia501")) {
            Command exitCommand = new Command("Exit", 7, 1);
            this.addCommand(exitCommand);
            this.setCommandListener(this);
        } else {
            this.initExitButton();
        }
        this.initContButton();
        this.initRecButton();
        this.initAboutButton();
    }

    public void initNgButton() {
        this.newGameButton = new Button(true, "ng.png", this.horizontalCenter - 92, this.verticalCenter - 26, new Listener(){

            public void clicked(Button button) {
                TagApplication.getInstance().viewTagCanvas();
            }
        });
    }

    public void initExitButton() {
        this.exitButton = new Button(true, "exit.png", this.horizontalCenter - 92, this.verticalCenter + 158, new Listener(){

            public void clicked(Button button) {
                TagApplication.getInstance().showExitPrompt();
            }
        });
    }

    public void initContButton() {
        this.continueButton = new Button(true, "cont.png", this.horizontalCenter - 92, this.verticalCenter + 20, new Listener(){

            public void clicked(Button button) {
                TagApplication.getInstance().viewContTagCanvas();
            }
        });
        try {
            RecordStore gameState = RecordStore.openRecordStore((String)"GameState", (boolean)true);
            System.out.print(gameState.getNumRecords());
            if (gameState.getNumRecords() == 0) {
                this.continueButton.disable();
            }
            gameState.closeRecordStore();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public void initRecButton() {
        this.recordsButton = new Button(true, "rec.png", this.horizontalCenter - 92, this.verticalCenter + 66, new Listener(){

            public void clicked(Button button) {
                TagApplication.getInstance().viewRecordsScreen();
            }
        });
    }

    public void initAboutButton() {
        this.aboutButton = new Button(true, "aboutApp.png", this.horizontalCenter - 92, this.verticalCenter + 112, new Listener(){

            public void clicked(Button button) {
                TagApplication.getInstance().viewDescriptionScreen();
            }
        });
    }

    protected void render() {
        Graphics g = this.getGraphics();
        g.drawImage(this.infoImage, this.getWidth() / 2, this.getHeight() / 2, 3);
        g.drawImage(this.logoImage, this.getWidth() / 2, this.getHeight() / 5, 3);
        this.newGameButton.paint(g);
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.exitButton.paint(g);
        }
        this.continueButton.paint(g);
        this.recordsButton.paint(g);
        this.aboutButton.paint(g);
        this.flushGraphics();
    }

    protected void showNotify() {
        this.render();
    }

    protected void pointerPressed(int x, int y) {
        this.newGameButton.pointerPressed(x, y);
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.exitButton.pointerPressed(x, y);
        }
        this.continueButton.pointerPressed(x, y);
        this.recordsButton.pointerPressed(x, y);
        this.aboutButton.pointerPressed(x, y);
        this.render();
    }

    protected void pointerDragged(int x, int y) {
        this.newGameButton.pointerDragged(x, y);
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.exitButton.pointerDragged(x, y);
        }
        this.continueButton.pointerDragged(x, y);
        this.recordsButton.pointerDragged(x, y);
        this.aboutButton.pointerDragged(x, y);
        this.render();
    }

    protected void pointerReleased(int x, int y) {
        this.newGameButton.pointerReleased(x, y);
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.exitButton.pointerReleased(x, y);
        }
        this.continueButton.pointerReleased(x, y);
        this.recordsButton.pointerReleased(x, y);
        this.aboutButton.pointerReleased(x, y);
        this.render();
    }

    public void commandAction(Command command, Displayable displayable) {
        TagApplication.getInstance().showExitPrompt();
    }
}

