/*
 * Decompiled with CFR 0.152.
 */
package org.fruct.yar.tea;

import com.nokia.mid.ui.TextEditor;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import org.fruct.yar.tea.Button;
import org.fruct.yar.tea.ImageLoader;
import org.fruct.yar.tea.Listener;
import org.fruct.yar.tea.RecordManager;
import org.fruct.yar.tea.TagApplication;

public class VictoryScreen
extends GameCanvas
implements CommandListener {
    private Button back;
    private Button newGame;
    private Image logoImage;
    private long[] recordsArray = new long[5];
    private String victoryTimeTxt;
    private int numOfRecords;
    private boolean isSameRecord;

    public VictoryScreen(RecordManager a) {
        super(false);
        this.numOfRecords = a.getNumOfRecords();
        this.setFullScreenMode(true);
        this.logoImage = ImageLoader.loadImage("victory_screen.png");
        this.initNavigButtons();
        this.victoryTimeTxt = this.convertTime(a.getCurGameTime());
        for (int i = 0; i < this.numOfRecords; ++i) {
            this.recordsArray[i] = a.getRecordsArray(i);
        }
    }

    public void inputAction(TextEditor textEditor, int actions) {
    }

    protected void render() {
        Graphics g = this.getGraphics();
        g.drawImage(this.logoImage, this.getWidth() / 2, this.getHeight() / 2, 3);
        g.drawString(this.victoryTimeTxt, this.getWidth() / 2 - 20, this.getHeight() / 2 + 105, 20);
        this.drawRecords();
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.paint(g);
        }
        this.newGame.paint(g);
        this.flushGraphics();
    }

    protected void showNotify() {
        this.render();
    }

    protected void pointerPressed(int x, int y) {
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.pointerPressed(x, y);
        }
        this.newGame.pointerPressed(x, y);
        this.render();
    }

    protected void pointerDragged(int x, int y) {
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.pointerDragged(x, y);
        }
        this.newGame.pointerDragged(x, y);
        this.render();
    }

    protected void pointerReleased(int x, int y) {
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.pointerReleased(x, y);
        }
        this.newGame.pointerReleased(x, y);
        this.render();
    }

    private void initNavigButtons() {
        if (System.getProperty("microedition.platform").startsWith("Nokia501")) {
            Command backCommand = new Command("Back", 2, 1);
            this.addCommand(backCommand);
            this.setCommandListener(this);
        } else {
            this.back = new Button(true, "back.png", this.getWidth() / 2 - 120, this.getHeight() / 2 + 110, new Listener(){

                public void clicked(Button button) {
                    TagApplication.getInstance().viewSplashScreen();
                }
            });
        }
        this.newGame = new Button(true, "vcng.png", this.getWidth() / 2 + 24, this.getHeight() / 2 + 110, new Listener(){

            public void clicked(Button button) {
                TagApplication.getInstance().viewTagCanvas();
            }
        });
    }

    private String convertTime(long s) {
        long m = s / 60L;
        s %= 60L;
        StringBuffer str = new StringBuffer(5);
        if (m < 10L) {
            str.append('0');
        }
        str.append(m);
        str.append(':');
        if (s < 10L) {
            str.append('0');
        }
        str.append(s);
        return str.toString();
    }

    private void drawRecords() {
        Graphics g = this.getGraphics();
        for (int i = this.numOfRecords - 1; i != -1; --i) {
            g.setColor(0, 0, 0);
            if (this.convertTime(this.recordsArray[i]).equals(this.victoryTimeTxt) && !this.isSameRecord) {
                g.setColor(220, 20, 60);
                g.drawString(this.convertTime(this.recordsArray[i]), this.getWidth() / 2 - 20, this.getHeight() / 2 - 25 + i * 20, 20);
                this.isSameRecord = true;
                continue;
            }
            g.drawString(this.convertTime(this.recordsArray[i]), this.getWidth() / 2 - 20, this.getHeight() / 2 - 25 + i * 20, 20);
        }
        this.drawNumbersOfRec();
    }

    private void drawNumbersOfRec() {
        Graphics g = this.getGraphics();
        g.setColor(128, 128, 128);
        g.setFont(Font.getFont((int)0, (int)1, (int)8));
        for (int i = 0; i < this.numOfRecords; ++i) {
            g.drawString(i + 1 + ".", this.getWidth() / 2 - 40, this.getHeight() / 2 - 23 + i * 20, 20);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        TagApplication.getInstance().viewSplashScreen();
    }
}

