/*
 * Decompiled with CFR 0.152.
 */
package org.fruct.yar.tea;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import org.fruct.yar.tea.TagCanvas;

public class RecordManager {
    private byte[] curData;
    private byte[] data;
    private long[] recordsArr = new long[5];
    private long record;
    private int numOfRecords;
    private boolean addedRec;
    private String str = "GameTimes";

    public void saveCurGameTime(TagCanvas a) {
        try {
            RecordStore gameTimes = RecordStore.openRecordStore((String)this.str, (boolean)true);
            if (gameTimes.getNumRecords() == 0) {
                gameTimes.addRecord(a.getTime(), 0, a.getTime().length);
                this.addedRec = true;
            }
            this.curData = a.getTime();
            this.data = a.getTime();
            if (!this.addedRec && gameTimes.getNumRecords() < 5) {
                gameTimes.addRecord(this.data, 0, this.data.length);
            }
            if (!this.addedRec && gameTimes.getNumRecords() == 5) {
                this.addNewRecord();
            } else {
                this.readRecordStore();
                this.sortRecordsArray(gameTimes.getNumRecords());
                this.writeRecordStore();
            }
            this.numOfRecords = gameTimes.getNumRecords();
            gameTimes.closeRecordStore();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public long getCurGameTime() {
        try {
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(this.curData));
            return din.readLong();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long getRecordsArray(int i) {
        try {
            RecordStore gameTimes = RecordStore.openRecordStore((String)this.str, (boolean)true);
            try {
                DataInputStream tmparr = new DataInputStream(new ByteArrayInputStream(gameTimes.getRecord(i + 1)));
                this.recordsArr[i] = tmparr.readLong();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            gameTimes.closeRecordStore();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        return this.recordsArr[i];
    }

    public int getNumOfRecords() {
        return this.numOfRecords;
    }

    private void sortRecordsArray(int sortBound) {
        for (int i = 0; i < sortBound; ++i) {
            long min = this.recordsArr[i];
            int imin = i;
            for (int j = i + 1; j < sortBound; ++j) {
                if (this.recordsArr[j] >= min) continue;
                min = this.recordsArr[j];
                imin = j;
            }
            if (i == imin) continue;
            long temp = this.recordsArr[i];
            this.recordsArr[i] = this.recordsArr[imin];
            this.recordsArr[imin] = temp;
        }
    }

    private void readLastResult() {
        try {
            DataInputStream tmpdin = new DataInputStream(new ByteArrayInputStream(this.curData));
            this.record = tmpdin.readLong();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeRecordStore() {
        try {
            RecordStore gameTimes = RecordStore.openRecordStore((String)this.str, (boolean)true);
            for (int i = 0; i < gameTimes.getNumRecords(); ++i) {
                ByteArrayOutputStream bout = null;
                try {
                    bout = new ByteArrayOutputStream();
                    DataOutputStream dout = new DataOutputStream(bout);
                    dout.writeLong(this.recordsArr[i]);
                    bout.toByteArray();
                    gameTimes.setRecord(i + 1, bout.toByteArray(), 0, bout.toByteArray().length);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            gameTimes.closeRecordStore();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    private void readRecordStore() {
        try {
            RecordStore gameTimes = RecordStore.openRecordStore((String)this.str, (boolean)true);
            for (int i = 0; i < gameTimes.getNumRecords(); ++i) {
                try {
                    DataInputStream tmparr = new DataInputStream(new ByteArrayInputStream(gameTimes.getRecord(i + 1)));
                    this.recordsArr[i] = tmparr.readLong();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            gameTimes.closeRecordStore();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    private void addNewRecord() {
        this.readLastResult();
        this.readRecordStore();
        this.sortRecordsArray(this.recordsArr.length);
        if (this.record < this.recordsArr[4]) {
            this.recordsArr[4] = this.record;
            this.sortRecordsArray(this.recordsArr.length);
        }
        this.writeRecordStore();
    }
}

