/*
 * Decompiled with CFR 0.152.
 */
package org.fruct.yar.tea;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import org.fruct.yar.tea.Button;
import org.fruct.yar.tea.ImageLoader;
import org.fruct.yar.tea.Listener;
import org.fruct.yar.tea.TagApplication;

public class RecordsScreen
extends GameCanvas
implements CommandListener {
    private Image logoImage;
    private Image recordsLabel;
    private Button back;
    private Button clear;
    private long[] recordsArr;
    private int numOfRecords;
    private String gStore = "GameTimes";
    private boolean isEmpty;

    public RecordsScreen() {
        super(false);
        this.setFullScreenMode(true);
        this.recordsArr = new long[5];
        this.logoImage = ImageLoader.loadImage("main_screen.png");
        this.recordsLabel = ImageLoader.loadImage("records_label.png");
        this.initNavigButtons();
        if (this.getNumOfRecords() == 0) {
            this.isEmpty = true;
            this.clear.disable();
        } else {
            for (int i = 0; i < this.getNumOfRecords(); ++i) {
                this.recordsArr[i] = this.getRecordsArray(i);
            }
        }
    }

    protected void render() {
        Graphics g = this.getGraphics();
        g.drawImage(this.logoImage, this.getWidth() / 2, this.getHeight() / 2, 3);
        g.drawImage(this.recordsLabel, this.getWidth() / 2, this.getHeight() / 5, 3);
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.paint(g);
        }
        this.clear.paint(g);
        if (this.isEmpty) {
            g.drawString("Records list is empty.", this.getWidth() / 2 - 80, this.getHeight() / 3 - 12, 20);
            this.clear.disable();
        } else {
            this.drawRecords();
            this.clear.enable();
        }
        this.flushGraphics();
    }

    protected void showNotify() {
        this.render();
    }

    protected void pointerPressed(int x, int y) {
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.pointerPressed(x, y);
        }
        this.clear.pointerPressed(x, y);
        this.render();
    }

    protected void pointerDragged(int x, int y) {
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.pointerDragged(x, y);
        }
        this.clear.pointerDragged(x, y);
        this.render();
    }

    protected void pointerReleased(int x, int y) {
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.pointerReleased(x, y);
        }
        this.clear.pointerReleased(x, y);
        this.render();
    }

    private void initNavigButtons() {
        if (System.getProperty("microedition.platform").startsWith("Nokia501")) {
            Command exitCommand = new Command("Exit", 7, 1);
            this.addCommand(exitCommand);
            this.setCommandListener(this);
        } else {
            this.back = new Button(true, "back.png", this.getWidth() / 2 - 120, this.getHeight() / 2 + 100, new Listener(){

                public void clicked(Button button) {
                    TagApplication.getInstance().viewSplashScreen();
                }
            });
        }
        this.clear = new Button(true, "clear.png", this.getWidth() / 2 + 24, this.getHeight() / 2 + 100, new Listener(){

            public void clicked(Button button) {
                TagApplication.getInstance().showCleanPrompt();
            }
        });
    }

    private void drawRecords() {
        Graphics g = this.getGraphics();
        for (int i = this.numOfRecords - 1; i != -1; --i) {
            g.drawString(this.convertTime(this.recordsArr[i]), this.getWidth() / 2 - 20, this.getHeight() / 3 - 15 + i * 20, 20);
        }
        this.drawNumbersOfRec();
    }

    private void drawNumbersOfRec() {
        Graphics g = this.getGraphics();
        g.setColor(128, 128, 128);
        g.setFont(Font.getFont((int)0, (int)1, (int)8));
        for (int i = 0; i < this.numOfRecords; ++i) {
            g.drawString(i + 1 + ".", this.getWidth() / 2 - 40, this.getHeight() / 3 - 12 + i * 20, 20);
        }
    }

    public long getRecordsArray(int i) {
        try {
            RecordStore gameTimes = RecordStore.openRecordStore((String)this.gStore, (boolean)true);
            try {
                DataInputStream tmparr = new DataInputStream(new ByteArrayInputStream(gameTimes.getRecord(i + 1)));
                this.recordsArr[i] = tmparr.readLong();
                gameTimes.closeRecordStore();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        return this.recordsArr[i];
    }

    private String convertTime(long s) {
        long m = s / 60L;
        s %= 60L;
        StringBuffer str = new StringBuffer(5);
        if (m < 10L) {
            str.append('0');
        }
        str.append(m);
        str.append(':');
        if (s < 10L) {
            str.append('0');
        }
        str.append(s);
        return str.toString();
    }

    private int getNumOfRecords() {
        try {
            RecordStore gameTimes = RecordStore.openRecordStore((String)this.gStore, (boolean)true);
            this.numOfRecords = gameTimes.getNumRecords();
            gameTimes.closeRecordStore();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        return this.numOfRecords;
    }

    public void commandAction(Command command, Displayable displayable) {
        TagApplication.getInstance().viewSplashScreen();
    }
}

