/*
 * Decompiled with CFR 0.152.
 */
package org.fruct.yar.tea;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import org.fruct.yar.tea.DescriptionScreen;
import org.fruct.yar.tea.MainScreen;
import org.fruct.yar.tea.RecordManager;
import org.fruct.yar.tea.RecordsScreen;
import org.fruct.yar.tea.TagCanvas;
import org.fruct.yar.tea.VictoryScreen;

public class TagApplication
extends MIDlet
implements CommandListener {
    private TagCanvas tagCanvas;
    private static TagApplication self;
    private Display display;
    private MainScreen mainScreen;
    private DescriptionScreen descriptionScreen;
    private String strYes = "Yes";
    private String strNo = "No";
    private String strAreYouSure = "Are you sure?";
    private Alert exitPrompt = new Alert("Exit?", "Exit, really?", null, AlertType.CONFIRMATION);
    private Alert restartPrompt = new Alert("Restart?", this.strAreYouSure, null, AlertType.CONFIRMATION);
    private Alert backPrompt = new Alert("Back to the main screen?", this.strAreYouSure, null, AlertType.CONFIRMATION);
    private Alert cleanPrompt = new Alert("Delete all the records?", this.strAreYouSure, null, AlertType.CONFIRMATION);
    private Command exitYes = new Command(this.strYes, 4, 1);
    private Command exitNo = new Command(this.strNo, 3, 2);
    private Command restartYes = new Command(this.strYes, 4, 1);
    private Command restartNo = new Command(this.strNo, 3, 2);
    private Command backYes = new Command(this.strYes, 4, 1);
    private Command backNo = new Command(this.strNo, 3, 2);
    private Command cleanYes = new Command(this.strYes, 4, 1);
    private Command cleanNo = new Command(this.strNo, 3, 2);
    private VictoryScreen victoryScreen;
    private RecordManager records;
    private RecordsScreen recordsScreen;
    private boolean closed;
    private boolean continueGame;

    public static TagApplication getInstance() {
        return self;
    }

    protected void startApp() {
        self = this;
        if (this.display == null) {
            this.display = Display.getDisplay((MIDlet)this);
            this.mainScreen = new MainScreen();
            this.display.setCurrent((Displayable)this.mainScreen);
        }
        this.addExitCommands();
        this.addRestartCommands();
        this.addBackCommands();
        this.addCleanCommands();
    }

    private void addExitCommands() {
        this.exitPrompt.addCommand(this.exitYes);
        this.exitPrompt.addCommand(this.exitNo);
        this.exitPrompt.setCommandListener((CommandListener)this);
    }

    private void addCleanCommands() {
        this.cleanPrompt.addCommand(this.cleanYes);
        this.cleanPrompt.addCommand(this.cleanNo);
        this.cleanPrompt.setCommandListener((CommandListener)this);
    }

    private void addRestartCommands() {
        this.restartPrompt.addCommand(this.restartYes);
        this.restartPrompt.addCommand(this.restartNo);
        this.restartPrompt.setCommandListener((CommandListener)this);
    }

    private void addBackCommands() {
        this.backPrompt.addCommand(this.backYes);
        this.backPrompt.addCommand(this.backNo);
        this.backPrompt.setCommandListener((CommandListener)this);
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void commandAction(Command command, Displayable displayable) {
        this.exitCase(command);
        this.restartCase(command);
        this.backCase(command);
        this.cleanCase(command);
    }

    private void exitCase(Command command) {
        if (command == this.exitYes) {
            this.exit();
            TagApplication.getInstance().notifyDestroyed();
        } else if (command == this.exitNo) {
            this.display.setCurrent((Displayable)this.mainScreen);
        } else if (command == Alert.DISMISS_COMMAND) {
            this.display.setCurrent((Displayable)this.mainScreen);
        }
    }

    private void restartCase(Command command) {
        if (command == this.restartYes) {
            this.continueGame = false;
            this.tagCanvas = new TagCanvas(this);
            this.display.setCurrent((Displayable)this.tagCanvas);
        } else if (command == this.restartNo) {
            this.display.setCurrent((Displayable)this.tagCanvas);
        } else if (command == Alert.DISMISS_COMMAND) {
            this.display.setCurrent((Displayable)this.tagCanvas);
        }
    }

    private void backCase(Command command) {
        if (command == this.backYes) {
            TagApplication.getInstance().viewSplashScreen();
        } else if (command == this.backNo) {
            this.display.setCurrent((Displayable)this.tagCanvas);
        } else if (command == Alert.DISMISS_COMMAND) {
            this.display.setCurrent((Displayable)this.tagCanvas);
        }
    }

    private void cleanCase(Command command) {
        if (command == this.cleanYes) {
            try {
                RecordStore.deleteRecordStore((String)"GameTimes");
            }
            catch (RecordStoreException e) {
                e.printStackTrace();
            }
            TagApplication.getInstance().viewRecordsScreen();
        } else if (command == this.cleanNo) {
            this.display.setCurrent((Displayable)this.recordsScreen);
        } else if (command == Alert.DISMISS_COMMAND) {
            this.display.setCurrent((Displayable)this.recordsScreen);
        }
    }

    public void exit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void viewTagCanvas() {
        this.continueGame = false;
        this.tagCanvas = new TagCanvas(this);
        this.display.setCurrent((Displayable)this.tagCanvas);
    }

    public void viewContTagCanvas() {
        this.continueGame = true;
        this.tagCanvas = new TagCanvas(this);
        this.tagCanvas.loadGameState();
        this.display.setCurrent((Displayable)this.tagCanvas);
    }

    public void viewVictoryScreen() {
        this.records = new RecordManager();
        this.records.saveCurGameTime(this.tagCanvas);
        this.victoryScreen = new VictoryScreen(this.records);
        this.display.setCurrent((Displayable)this.victoryScreen);
    }

    public void viewSplashScreen() {
        this.mainScreen = new MainScreen();
        this.display.setCurrent((Displayable)this.mainScreen);
    }

    public void viewDescriptionScreen() {
        this.descriptionScreen = new DescriptionScreen();
        this.display.setCurrent((Displayable)this.descriptionScreen);
    }

    public void viewRecordsScreen() {
        this.recordsScreen = new RecordsScreen();
        this.display.setCurrent((Displayable)this.recordsScreen);
    }

    public void showExitPrompt() {
        this.display.setCurrent((Displayable)this.exitPrompt);
    }

    public void showRestartPrompt() {
        this.display.setCurrent((Displayable)this.restartPrompt);
    }

    public void showBackPrompt() {
        this.display.setCurrent((Displayable)this.backPrompt);
    }

    public void showCleanPrompt() {
        this.display.setCurrent((Displayable)this.cleanPrompt);
    }

    public boolean isContinueGame() {
        return this.continueGame;
    }
}

