/*
 * Decompiled with CFR 0.152.
 */
package org.fruct.yar.tea;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import org.fruct.yar.tea.Button;
import org.fruct.yar.tea.ImageLoader;
import org.fruct.yar.tea.Listener;
import org.fruct.yar.tea.TagApplication;
import org.fruct.yar.tea.TagGameEngine;

public class TagCanvas
extends GameCanvas
implements CommandListener {
    private int centerX;
    private int centerY;
    private final Image background;
    private final Image gameBackground;
    private Graphics g;
    private Button[] puzzle;
    private TagGameEngine game;
    private Button back;
    private Button restart;
    private Button ctp;
    private Timer timer;
    private long startTime;
    private long victoryTimeSeconds = -1L;
    private Button elapsed;
    private static final int TEXT_COLOR = 0xFFFFFF;
    private String text = "";
    private boolean finishGame;
    private boolean isInterrupt;
    private TagApplication main;
    private String gState = "GameState";

    public TagCanvas(TagApplication tagApp) {
        super(false);
        this.setFullScreenMode(true);
        this.main = tagApp;
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.background = ImageLoader.loadImage("main_screen.png");
        this.gameBackground = ImageLoader.loadImage("game_background.png");
        this.initNavigButtons();
        this.isInterrupt = true;
        this.game = new TagGameEngine();
        this.puzzle = new Button[15];
        this.initAllPuzzles();
        this.initCtpButton();
        this.initTimer();
        this.refresh();
    }

    public void renderTime(Graphics a) {
        a.setColor(0xFFFFFF);
        a.drawImage(this.background, this.centerX - 15, this.centerY - 320, 3);
        a.drawString(this.text, this.centerX - 15, this.centerY - 150, 20);
        this.flushGraphics(this.centerX - 15, this.centerY - 150, 62, 20);
        this.elapsed.paint(a);
    }

    private void render(Graphics a) {
        int anchor = 3;
        a.drawImage(this.background, this.centerX, this.centerY, anchor);
        a.drawImage(this.gameBackground, this.centerX, this.centerY, anchor);
        this.paintAllButtons();
        this.flushGraphics(0, this.centerY - 115, 240, 355);
    }

    private void renderGameField(Graphics a) {
        int anchor = 3;
        a.drawImage(this.gameBackground, this.centerX, this.centerY, anchor);
        a.drawImage(this.background, this.centerX, this.centerY + 320, anchor);
        this.paintAllButtons();
        this.flushGraphics(0, this.centerY - 115, 240, 355);
        a = null;
    }

    protected void showNotify() {
        this.g = this.getGraphics();
        this.render(this.g);
    }

    protected void hideNotify() {
        if (!this.main.isClosed() && !this.finishGame) {
            this.saveGameState();
            if (this.isInterrupt) {
                TagApplication.getInstance().viewSplashScreen();
            }
        }
    }

    private void initTimer() {
        this.elapsed = new Button(false, "time.png", this.centerX - 35, this.centerY - 150, new Listener(){

            public void clicked(Button button) {
            }
        });
    }

    private void initNavigButtons() {
        if (System.getProperty("microedition.platform").startsWith("Nokia501")) {
            Command backCommand = new Command("Back", 2, 1);
            this.addCommand(backCommand);
            this.setCommandListener(this);
        } else {
            this.back = new Button(true, "back.png", this.centerX - 120, this.centerY + 112, new Listener(){

                public void clicked(Button button) {
                    TagCanvas.this.isInterrupt = false;
                    TagApplication.getInstance().showBackPrompt();
                }
            });
        }
        this.restart = new Button(true, "res.png", this.centerX + 24, this.centerY + 112, new Listener(){

            public void clicked(Button button) {
                TagCanvas.this.isInterrupt = false;
                TagApplication.getInstance().showRestartPrompt();
            }
        });
        this.restart.disable();
    }

    private void initCtpButton() {
        this.ctp = new Button(true, "ctp.png", this.centerX - 115, this.centerY - 115, new Listener(){

            public void clicked(Button button) {
                TagCanvas.this.ctp.disable();
                TagCanvas.this.restart.enable();
                if (!TagCanvas.this.main.isContinueGame()) {
                    TagCanvas.this.game.shuffleTags();
                    TagCanvas.this.refresh();
                    TagCanvas.this.startTimer();
                    TagCanvas.this.startTime = System.currentTimeMillis();
                } else {
                    TagCanvas.this.refresh();
                    TagCanvas.this.startTimer();
                }
            }
        });
    }

    private void initAllPuzzles() {
        for (int i = 0; i < 15; ++i) {
            String name = i + 1 + ".png";
            final int buttonNumber = i;
            this.puzzle[i] = new Button(false, name, 0, 0, new Listener(){

                public void clicked(Button button) {
                    TagCanvas.this.clickPuzzle(buttonNumber);
                }
            });
        }
    }

    private void paintAllButtons() {
        for (int i = 0; i < 15; ++i) {
            this.puzzle[i].paint(this.g);
        }
        this.elapsed.paint(this.g);
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.paint(this.g);
        }
        this.restart.paint(this.g);
        this.ctp.paint(this.g);
    }

    protected void pointerPressed(int x, int y) {
        this.g = this.getGraphics();
        for (int i = 0; i < 15; ++i) {
            this.puzzle[i].pointerPressed(x, y);
        }
        this.elapsed.pointerPressed(x, y);
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.pointerPressed(x, y);
        }
        this.restart.pointerPressed(x, y);
        this.ctp.pointerPressed(x, y);
        this.renderGameField(this.g);
    }

    protected void pointerDragged(int x, int y) {
        this.g = this.getGraphics();
        this.elapsed.pointerDragged(x, y);
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.pointerDragged(x, y);
        }
        this.restart.pointerDragged(x, y);
        this.ctp.pointerDragged(x, y);
        this.renderGameField(this.g);
    }

    protected void pointerReleased(int x, int y) {
        this.g = this.getGraphics();
        for (int i = 0; i < 15; ++i) {
            this.puzzle[i].pointerReleased(x, y);
        }
        this.elapsed.pointerReleased(x, y);
        if (!System.getProperty("microedition.platform").startsWith("Nokia501")) {
            this.back.pointerReleased(x, y);
        }
        this.restart.pointerReleased(x, y);
        this.ctp.pointerReleased(x, y);
        this.renderGameField(this.g);
    }

    private void clickPuzzle(int numOfBut) {
        if (this.game.move(this.convScrX(this.puzzle[numOfBut].getX()), this.convScrY(this.puzzle[numOfBut].getY()))) {
            this.refresh();
            if (this.game.checkGameOver()) {
                try {
                    RecordStore.deleteRecordStore((String)this.gState);
                }
                catch (RecordStoreException e) {
                    e.printStackTrace();
                }
                this.victoryTimeSeconds = this.getElapsedSeconds();
                this.stopTimer();
                this.finishGame = true;
                TagApplication.getInstance().viewVictoryScreen();
            }
        }
    }

    public void refresh() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.game.getTag(i, j) == 0) continue;
                this.puzzle[this.game.getTag(i, j) - 1].setPosition(this.upconvScrX(i), this.upconvScrY(j));
            }
        }
    }

    private int convScrX(int scrX) {
        if (scrX == this.centerX - 110) {
            return 0;
        }
        if (scrX == this.centerX - 55) {
            return 1;
        }
        if (scrX == this.centerX) {
            return 2;
        }
        if (scrX == this.centerX + 55) {
            return 3;
        }
        return 0;
    }

    private int convScrY(int scrY) {
        if (scrY == this.centerY - 110) {
            return 0;
        }
        if (scrY == this.centerY - 55) {
            return 1;
        }
        if (scrY == this.centerY) {
            return 2;
        }
        if (scrY == this.centerY + 55) {
            return 3;
        }
        return 0;
    }

    private int upconvScrX(int modelX) {
        if (modelX == 0) {
            return this.centerX - 110;
        }
        if (modelX == 1) {
            return this.centerX - 55;
        }
        if (modelX == 2) {
            return this.centerX;
        }
        if (modelX == 3) {
            return this.centerX + 55;
        }
        return 0;
    }

    private int upconvScrY(int modelY) {
        if (modelY == 0) {
            return this.centerY - 110;
        }
        if (modelY == 1) {
            return this.centerY - 55;
        }
        if (modelY == 2) {
            return this.centerY;
        }
        if (modelY == 3) {
            return this.centerY + 55;
        }
        return 0;
    }

    public void startTimer() {
        final Graphics tg = this.getGraphics();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                TagCanvas.this.renderTime(tg);
            }
        }, 0L, 20L);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                TagCanvas.this.updateElapsed();
            }
        }, 0L, 1000L);
    }

    public void stopTimer() {
        this.timer.cancel();
        this.timer = null;
    }

    public long getElapsedSeconds() {
        if (this.victoryTimeSeconds > -1L) {
            return this.victoryTimeSeconds;
        }
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    private void setElapsedSeconds(long elapsedSeconds) {
        if (this.game.checkGameOver()) {
            this.victoryTimeSeconds = elapsedSeconds;
        }
        this.startTime = System.currentTimeMillis() - elapsedSeconds * 1000L;
    }

    private void updateElapsed() {
        long s = this.getElapsedSeconds();
        long m = s / 60L;
        s %= 60L;
        StringBuffer str = new StringBuffer(5);
        if (m < 10L) {
            str.append('0');
        }
        str.append(m);
        str.append(':');
        if (s < 10L) {
            str.append('0');
        }
        str.append(s);
        this.setText(str.toString());
    }

    public void setText(String text) {
        this.text = text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTime() {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeLong(this.getElapsedSeconds());
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isGameFinished() {
        return this.finishGame;
    }

    public void saveGameState() {
        try {
            RecordStore gameState = RecordStore.openRecordStore((String)this.gState, (boolean)true);
            byte[] data = this.getState();
            if (gameState.getNumRecords() == 0) {
                gameState.addRecord(data, 0, data.length);
            }
            gameState.setRecord(1, data, 0, data.length);
            gameState.closeRecordStore();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public byte[] getState() {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    dout.writeByte(this.game.getTag(i, j));
                }
            }
            dout.writeLong(this.getElapsedSeconds());
            return bout.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    public void setState(byte[] state) {
        try {
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(state));
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.game.setTag(i, j, din.readByte());
                }
            }
            this.setElapsedSeconds(din.readLong());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadGameState() {
        try {
            RecordStore gameState = RecordStore.openRecordStore((String)this.gState, (boolean)true);
            if (gameState.getNumRecords() == 0) {
                return;
            }
            this.setState(gameState.getRecord(1));
            gameState.closeRecordStore();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        this.isInterrupt = false;
        TagApplication.getInstance().showBackPrompt();
    }
}

