/*
 * Decompiled with CFR 0.152.
 */
package org.fruct.yar.tea;

import java.util.Random;

public class TagGameEngine {
    private int[][] field = new int[4][4];

    public int getTag(int a, int b) {
        return this.field[a][b];
    }

    public void setTag(int a, int b, int x) {
        this.field[a][b] = x;
    }

    public void shuffleTags() {
        Random r = new Random(System.currentTimeMillis());
        for (int i = 0; i < 150; ++i) {
            int x = r.nextInt(4);
            int y = r.nextInt(4);
            this.move(x, y);
        }
    }

    private void genNormalField() {
        for (int i = 0; i < 15; ++i) {
            this.field[i % 4][i / 4] = i + 1;
        }
    }

    public TagGameEngine() {
        this.genNormalField();
    }

    public boolean move(int x, int y) {
        boolean res = false;
        int px0 = this.searchEmptyPlaceX(-1);
        int py0 = this.searchEmptyPlaceY(-1);
        if (px0 == x || py0 == y) {
            if (px0 != x || py0 != y) {
                this.searchStepOnY(px0, py0, x, y);
                this.searchStepOnX(px0, py0, x, y);
                this.field[x][y] = 0;
                res = true;
            } else {
                res = false;
            }
        }
        return res;
    }

    private int searchEmptyPlaceX(int x0) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.field[i][j] != 0) continue;
                x0 = i;
            }
        }
        return x0;
    }

    private int searchEmptyPlaceY(int y0) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.field[i][j] != 0) continue;
                y0 = j;
            }
        }
        return y0;
    }

    private void searchStepOnY(int x0, int y0, int x1, int y1) {
        block4: {
            if (x0 != x1) break block4;
            if (y0 < y1) {
                for (int i = y0 + 1; i <= y1; ++i) {
                    this.field[x1][i - 1] = this.field[x1][i];
                }
            } else {
                for (int i = y0; i > y1; --i) {
                    this.field[x1][i] = this.field[x1][i - 1];
                }
            }
        }
    }

    private void searchStepOnX(int x0, int y0, int x1, int y1) {
        block4: {
            if (y0 != y1) break block4;
            if (x0 < x1) {
                for (int i = x0 + 1; i <= x1; ++i) {
                    this.field[i - 1][y1] = this.field[i][y1];
                }
            } else {
                for (int i = x0; i > x1; --i) {
                    this.field[i][y1] = this.field[i - 1][y1];
                }
            }
        }
    }

    public boolean checkGameOver() {
        int a = 1;
        boolean res = true;
        block0: for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (i == 3 && j == 3) {
                    a = 0;
                }
                if (this.field[j][i] != a) {
                    res = false;
                    continue block0;
                }
                ++a;
            }
        }
        return res;
    }
}

