/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class BTWSoundPlayer {
    private InputStream inBGM;
    private InputStream inOwn;
    private InputStream inMenu;
    private Player pBGM;
    private Player pOwn;
    private Player pMenu;
    private VolumeControl vc;
    private boolean isMute = false;

    public BTWSoundPlayer() {
        try {
            this.inOwn = this.getClass().getResourceAsStream("/LaguLogoOwnGames.mid");
            this.pOwn = Manager.createPlayer((InputStream)this.inOwn, (String)"audio/midi");
            this.pOwn.realize();
            this.inBGM = this.getClass().getResourceAsStream("/bgmGamePlay.mp3");
            this.pBGM = Manager.createPlayer((InputStream)this.inBGM, (String)"audio/mpeg");
            this.pBGM.realize();
            this.pBGM.setLoopCount(-1);
            this.inMenu = this.getClass().getResourceAsStream("/bgmUtama.mp3");
            this.pMenu = Manager.createPlayer((InputStream)this.inMenu, (String)"audio/mpeg");
            this.pMenu.realize();
            this.pMenu.setLoopCount(-1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playOwn() {
        this.play(this.pOwn);
    }

    public void stopOwn() {
        this.stop(this.pOwn);
    }

    public void playBGM() {
        this.play(this.pBGM);
    }

    public void stopBGM() {
        this.stop(this.pBGM);
    }

    public void playMenu() {
        this.play(this.pMenu);
    }

    public void stopMenu() {
        this.stop(this.pMenu);
    }

    public void stopAll() {
        this.stopOwn();
        this.stopBGM();
        this.stopMenu();
    }

    public void muteSound() {
        this.stopAll();
        this.isMute = true;
    }

    public void unMuteSound() {
        this.isMute = false;
    }

    private void play(Player p) {
        try {
            if (p != null && p.getState() == 400) {
                p.stop();
                p.deallocate();
            }
            this.vc = (VolumeControl)p.getControl("VolumeControl");
            if (this.vc != null) {
                if (this.isMute) {
                    this.vc.setLevel(0);
                } else {
                    this.vc.setLevel(50);
                }
            }
            p.realize();
            p.prefetch();
            p.setMediaTime(-1L);
            if (!this.isMute) {
                p.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stop(Player p) {
        try {
            if (p != null && p.getState() == 400) {
                p.stop();
                p.deallocate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

