/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ScrollableTextFieldExt {
    static final String VOID_STRING = "";
    static final char SPACE_CHAR = ' ';
    static final int SCROLL_STEP = 45;
    public int scrollbarWidth = 4;
    public int scrollbarHeight = 0;
    int scrollbarTop = 0;
    public int scrollbarColor = 255;
    public int borderWidth = 1;
    public int borderColor = 0;
    public int bgColor = 0xFFFFFF;
    public Font textFont = Font.getDefaultFont();
    public int textColor = 0xFFFFFF;
    int padding = 1;
    int interline = 2;
    int width = 0;
    int height = 0;
    int innerWidth = 0;
    int innerHeight = 0;
    int currentY = 0;
    int textHeight = 0;
    String[] textRows = null;

    public ScrollableTextFieldExt(int width, int height) {
        this.width = width;
        this.height = height;
        this.innerWidth = width - 2 * this.borderWidth - 2 * this.padding - this.scrollbarWidth;
        this.innerHeight = height - 2 * this.borderWidth - 2 * this.padding;
    }

    public void paint(Graphics g) {
        g.setColor(this.borderColor);
        g.drawRect(this.borderWidth, this.borderWidth, this.width - 2 * this.borderWidth, this.height - 2 * this.borderWidth);
        g.setColor(this.textColor);
        g.setFont(this.textFont);
        g.translate(this.borderWidth + this.padding, this.borderWidth + this.padding);
        g.setClip(0, 0, this.innerWidth, this.innerHeight);
        if (this.textRows != null) {
            int i = 0;
            while (i < this.textRows.length) {
                g.drawString(this.textRows[i], 0, i * (this.textFont.getHeight() + this.interline) - this.currentY, 20);
                ++i;
            }
        }
        g.setClip(0, 0, this.width, this.height);
        g.setColor(this.scrollbarColor);
        g.fillRect(this.innerWidth, this.scrollbarTop, this.scrollbarWidth, this.scrollbarHeight);
        g.translate(-(this.borderWidth + this.padding), -(this.borderWidth + this.padding));
    }

    public void scrollDown() {
        this.scroll(45);
    }

    public void scrollUp() {
        this.scroll(-45);
    }

    private void scroll(int delta) {
        this.currentY += delta;
        if (this.currentY < 0) {
            this.currentY = 0;
        } else if (this.currentY > this.textHeight - this.innerHeight) {
            this.currentY = Math.max(0, this.textHeight - this.innerHeight);
        }
        this.scrollbarTop = this.innerHeight * this.currentY / this.textHeight;
    }

    public void setText(String text) {
        this.textRows = ScrollableTextFieldExt.getTextRows(text, this.textFont, this.innerWidth);
        this.textHeight = this.textRows.length * (this.interline + this.textFont.getHeight());
        this.scrollbarHeight = Math.min(this.innerHeight, this.innerHeight * this.innerHeight / this.textHeight);
        this.scrollbarTop = 0;
        this.currentY = 0;
    }

    public static String[] getTextRows(String text, Font font, int width) {
        char spaceChar = ' ';
        Vector<String> rowsVector = new Vector<String>();
        StringBuffer currentRowText = new StringBuffer();
        int prevIndex = 0;
        int currIndex = text.indexOf(spaceChar);
        int rowWidth = 0;
        int tokenWidth = 0;
        int whitespaceWidth = font.stringWidth(" ");
        String currentToken = null;
        while (currIndex != -1) {
            currentToken = text.substring(prevIndex, currIndex);
            String s = VOID_STRING;
            boolean red_str = false;
            int i = 0;
            while (i < currentToken.length()) {
                if (currentToken.charAt(i) != '\r' && currentToken.charAt(i) != '\n') {
                    s = String.valueOf(s) + currentToken.charAt(i);
                } else {
                    red_str = true;
                }
                ++i;
            }
            currentToken = s;
            tokenWidth = font.stringWidth(currentToken);
            rowWidth += tokenWidth;
            if (currentRowText.length() > 0) {
                rowWidth += whitespaceWidth;
            }
            if (currentRowText.length() > 0 && rowWidth > width || red_str) {
                rowsVector.addElement(currentRowText.toString());
                currentRowText.setLength(0);
                currentRowText.append(currentToken);
                rowWidth = tokenWidth;
            } else {
                if (currentRowText.length() > 0) {
                    currentRowText.append(spaceChar);
                }
                currentRowText.append(currentToken);
            }
            if (currIndex == text.length()) break;
            prevIndex = currIndex + 1;
            if ((currIndex = text.indexOf(spaceChar, prevIndex)) != -1) continue;
            currIndex = text.length();
        }
        if (currentRowText.length() > 0) {
            rowsVector.addElement(currentRowText.toString());
        }
        Object[] rowsArray = new String[rowsVector.size()];
        rowsVector.copyInto(rowsArray);
        return rowsArray;
    }
}

