/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStreamReader;
import java.io.Reader;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Info
extends Canvas
implements Runnable {
    private GameMidlet midlet = null;
    private volatile Thread thread = null;
    private Font font = null;
    private Image imgBackground = null;
    private Image imgExit = null;
    private int screenW;
    private int screenH;
    private int wExit;
    private int hExit;
    private int xExit;
    private int yExit;
    private int xField;
    private int yField;
    private int wField;
    private int hField;
    private boolean loop = false;
    ScrollableTextFieldExt field = null;
    private boolean scroll;
    private int yScroll;

    Info(GameMidlet midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        try {
            this.imgBackground = Image.createImage((String)"/background.png");
            this.imgExit = Image.createImage((String)"/b_back.png");
        }
        catch (Exception ex) {
            System.err.println("background.png it is not loaded");
        }
        this.screenW = this.getWidth();
        this.screenH = this.getHeight();
        this.wExit = this.imgExit.getWidth();
        this.hExit = this.imgExit.getHeight();
        this.xExit = 1;
        this.yExit = 1;
        this.xField = 5;
        this.yField = this.hExit + 5;
        this.wField = this.screenW - 2 * this.xField;
        this.hField = this.screenH - this.yField - 40;
        this.field = new ScrollableTextFieldExt(this.wField, this.hField);
        this.scroll = false;
        this.yScroll = 0;
    }

    public void start() {
        this.loop = true;
        this.thread = new Thread(this);
        this.thread.start();
        if (this.midlet.infoButton == "h") {
            this.field.setText(this.getText("/info/help"));
        } else if (this.midlet.infoButton == "a") {
            this.field.setText(this.getText("/info/about"));
        }
    }

    public void stop() {
        this.loop = false;
        this.thread = null;
        System.gc();
    }

    public void run() {
        while (this.loop) {
            this.repaint();
            try {
                Thread.sleep(20L);
            }
            catch (Exception ex) {
                System.err.println("Class Help  metod run()");
            }
        }
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.screenW, this.screenH);
        this.font = Font.getFont((int)32, (int)0, (int)0);
        graphics.setFont(this.font);
        graphics.drawImage(this.imgBackground, 0, 0, 0x10 | 4);
        graphics.drawImage(this.imgExit, this.xExit, this.yExit, 0x10 | 4);
        graphics.translate(this.xField, this.yField);
        this.field.paint(graphics);
        graphics.translate(this.xField, -this.yField);
    }

    protected void pointerPressed(int x, int y) {
        if (this.isPressed(x, y, this.xExit, this.yExit, this.wExit, this.hExit)) {
            this.stop();
            this.midlet.mainMenuGame();
        }
        if (this.isPressed(x, y, this.xField, this.yField, this.wField, this.hField)) {
            this.scroll = true;
            this.yScroll = y;
        }
    }

    protected void pointerDragged(int x, int y) {
        int xOld = x;
        int yOld = y;
        if (y > yOld + 10) {
            System.out.println("UP");
        }
    }

    protected void pointerReleased(int x, int y) {
        if (this.scroll) {
            if (this.yScroll > y + 5) {
                System.out.println("DOWN");
                this.field.scrollDown();
            } else if (this.yScroll < y - 5) {
                System.out.println("UP");
                this.field.scrollUp();
            }
            this.scroll = false;
            this.yScroll = 0;
        }
    }

    protected int returnCoordinate(int percent, int sizeH) {
        int pix = percent * sizeH / 100;
        return pix;
    }

    protected boolean isPressed(int x, int y, int xi, int yi, int wi, int hi) {
        boolean rezult = false;
        if (x > xi && y > yi && x < xi + wi && y < yi + hi) {
            rezult = true;
        }
        return rezult;
    }

    public String getText(String path) {
        String text = "";
        String content = "";
        try {
            int read;
            InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream(path), "UTF-8");
            StringBuffer temp = new StringBuffer(1024);
            char[] buffer = new char[1024];
            while ((read = ((Reader)in).read(buffer, 0, buffer.length)) != -1) {
                temp.append(buffer, 0, read);
            }
            content = temp.toString();
            int i = 0;
            while (i < content.length()) {
                text = String.valueOf(text) + content.charAt(i);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR in getText() " + e);
        }
        return text;
    }
}

