/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class MainMenu
extends Canvas
implements Runnable {
    private GameMidlet midlet = null;
    private Image imgBackground = null;
    private Image imgPlay = null;
    private Image imgExit = null;
    private Image imgAbout = null;
    private Image imgHelp = null;
    private volatile Thread thread = null;
    private Font font = null;
    private boolean loop = false;
    private int wPlay;
    private int hPlay;
    private int xPlay;
    private int yPlay;
    private int xExit;
    private int yExit;
    private int wExit;
    private int hExit;
    private int wAbout;
    private int hAbout;
    private int xAbout;
    private int yAbout;
    private int wHelp;
    private int hHelp;
    private int xHelp;
    private int yHelp;
    private int w;
    private int h;
    private ParserTxt parserTxt;

    MainMenu(GameMidlet midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        try {
            this.imgBackground = Image.createImage((String)"/background1.png");
            this.imgPlay = Image.createImage((String)"/playbutton.png");
            this.imgExit = Image.createImage((String)"/b_close.png");
            this.imgAbout = Image.createImage((String)"/b_about.png");
            this.imgHelp = Image.createImage((String)"/b_help.png");
        }
        catch (Exception ex) {
            System.err.println("Menu -> image it is not loaded");
        }
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.wPlay = this.imgPlay.getWidth();
        this.hPlay = this.imgPlay.getHeight();
        this.xPlay = this.returnCenterX(this.wPlay, this.w);
        this.yPlay = this.returnCoordinate(70, this.h);
        this.xExit = 2;
        this.yExit = 2;
        this.wExit = this.imgExit.getWidth();
        this.hExit = this.imgExit.getHeight();
        this.wAbout = this.imgAbout.getWidth();
        this.hAbout = this.imgAbout.getHeight();
        this.xAbout = this.w - this.wAbout - 2;
        this.yAbout = 2;
        this.wHelp = this.imgHelp.getWidth();
        this.hHelp = this.imgHelp.getHeight();
        this.xHelp = this.w - this.wHelp - 2;
        this.yHelp = this.returnCoordinate(20, this.h);
        this.parserTxt = new ParserTxt();
    }

    public void start() {
        this.midlet.dict = this.parserTxt.getDictionary("/text/" + this.midlet.language + ".txt");
        this.loop = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.loop = false;
        this.thread = null;
        System.gc();
    }

    public void run() {
        while (this.loop) {
            this.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (Exception ex) {
                System.err.println("Class Menu  metod run()");
            }
        }
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        this.font = Font.getFont((int)32, (int)0, (int)16);
        graphics.setFont(this.font);
        graphics.drawImage(this.imgBackground, 0, 0, 0);
        graphics.drawImage(this.imgPlay, this.xPlay, this.yPlay, 0x10 | 4);
        graphics.setColor(0, 0, 0);
        graphics.drawString(this.midlet.dict.get("play").toString(), this.w / 2, this.yPlay + 12, 0x10 | 1);
        graphics.drawImage(this.imgExit, this.xExit, this.yExit, 0x10 | 4);
        graphics.drawImage(this.imgHelp, this.w - 1, this.yHelp, 0x10 | 8);
        graphics.drawImage(this.imgAbout, this.w - 1, this.yAbout, 0x10 | 8);
    }

    protected void pointerPressed(int x, int y) {
        if (this.isPressed(x, y, this.xPlay, this.yPlay, this.wPlay, this.hPlay)) {
            this.stop();
            this.midlet.initializationGame();
        }
        if (this.isPressed(x, y, this.xExit, this.yExit, this.wExit, this.hExit)) {
            this.stop();
            this.midlet.exitGame();
        }
        if (this.isPressed(x, y, this.xHelp, this.yHelp, this.wHelp, this.hHelp)) {
            this.stop();
            System.out.println("Help");
            this.midlet.infoButton = "h";
            this.midlet.Info();
        }
        if (this.isPressed(x, y, this.xAbout, this.yAbout, this.wAbout, this.hAbout)) {
            this.stop();
            System.out.println("About");
            this.midlet.infoButton = "a";
            this.midlet.Info();
        }
    }

    protected int returnCoordinate(int percent, int sizeH) {
        int pix = percent * sizeH / 100;
        return pix;
    }

    protected boolean isPressed(int x, int y, int xi, int yi, int wi, int hi) {
        boolean rezult = false;
        if (x > xi && y > yi && x < xi + wi && y < yi + hi) {
            rezult = true;
        }
        return rezult;
    }

    protected int returnCenterX(int wi, int sizeW) {
        int x = sizeW / 2 - wi / 2;
        return x;
    }
}

