/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class MyGameCanvas
extends GameCanvas
implements Runnable {
    private GameMidlet midlet = null;
    private Graphics graphics = null;
    private volatile Thread animationThread = null;
    private LayerManager gameManager = null;
    private int NLETTERS = 12;
    private int LEVEL = 36;
    private Plate[] plateWood = new Plate[this.NLETTERS];
    private Plate[] plate = null;
    private Sprite[] square = new Sprite[25];
    private Symbol[] symbol = new Symbol[this.NLETTERS];
    private Symbol[] symPlate = null;
    private Random random = null;
    private Font font = null;
    private int fps = 30;
    int screenW = 0;
    int screenH = 0;
    private Image imgBackground = null;
    private Image imgPlateWood = null;
    private Image imgPlate = null;
    private Image imgPic = null;
    private Image imgField = null;
    private Image imgSquare = null;
    private Image imgPlateMoney = null;
    private Image imgPlateLevel = null;
    private Image imgRemoveLettersButton = null;
    private Image imgShowLettersButton = null;
    private Sprite sprRemoveLettersButton = null;
    private Sprite sprShowLettersButton = null;
    private Image imgMenu = null;
    private Sprite sprMenu = null;
    private Sprite sprButton = null;
    private Sprite sprButtonOk = null;
    private Sprite sprButtonNot = null;
    private Sprite sprMessage = null;
    private Sprite sprMessageWrong = null;
    private int plateWoodH;
    private int plateWoodW;
    private int plateH;
    private int plateW;
    private int xPic;
    private int yPic;
    private int xField;
    private int yField;
    private String pic;
    private int xLevel;
    private int yLevel;
    private int xMoney;
    private int yMoney;
    private String dblevel;
    private String dbmoney;
    private int game;
    private int level;
    private int money;
    private String lang;
    private Hashtable NamesPicAndWord = new Hashtable();
    private String keyword;
    private int lenKeyword;
    private int[] posLetters;
    private int[] mixedArrayLetters;
    private String letters;
    private int lenPartWord1;
    private int lenPartWord2;
    private int pressPlateWood;
    private int numSymPlate;
    private boolean removeLastLetter;
    private Timer t;
    private TimerShow tt;
    private boolean openLetter;
    private boolean removeLetters;
    private boolean fewCoins;
    private boolean OkKeyWord;
    private boolean OkGame;
    private int[] pixelArray = null;
    private Player scroll = null;
    private int showLetter;
    private int countOpenSquare;

    public MyGameCanvas(GameMidlet midlet) throws Exception {
        super(true);
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.graphics = this.getGraphics();
        this.screenW = this.getWidth();
        this.screenH = this.getHeight();
        this.random = new Random();
        this.createGame();
    }

    public void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                long endTime;
                if (currentThread != this.animationThread) {
                    return;
                }
                long startTime = System.currentTimeMillis();
                if (this.isShown()) {
                    this.updateGame();
                    this.draw();
                    this.flushGraphics();
                    System.gc();
                }
                if ((endTime = System.currentTimeMillis() - startTime) < (long)this.fps) {
                    MyGameCanvas myGameCanvas = this;
                    synchronized (myGameCanvas) {
                        this.wait((long)this.fps - endTime);
                    }
                }
                Thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        this.animationThread = null;
    }

    private void draw() {
        try {
            this.graphics.setColor(0, 0, 0);
            this.graphics.fillRect(0, 0, this.screenW, this.screenH);
            this.gameManager.paint(this.graphics, 0, 0);
            int i = 0;
            while (i < this.NLETTERS) {
                this.symbol[i].draw(this.graphics);
                ++i;
            }
            i = 0;
            while (i < this.lenKeyword) {
                this.symPlate[i].draw(this.graphics);
                ++i;
            }
            this.font = Font.getFont((int)32, (int)0, (int)8);
            this.graphics.setFont(this.font);
            this.graphics.drawImage(this.imgPlateLevel, this.xLevel, this.yLevel, 0x10 | 1);
            this.graphics.drawString(String.valueOf(this.midlet.dict.get("level").toString()) + ": " + this.level, this.xLevel, this.yLevel, 0x10 | 1);
            this.graphics.drawImage(this.imgPlateMoney, this.xMoney, this.yMoney, 0x10 | 8);
            this.graphics.drawString(new Integer(this.money).toString(), this.xMoney - 1, this.yMoney + 2, 0x10 | 8);
            this.graphics.drawImage(this.imgPic, this.xPic, this.yPic, 0x10 | 1);
            this.graphics.drawImage(this.imgField, this.xField, this.yField, 0x10 | 1);
            this.graphics.drawString("\u041c\u043e\u0436\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0442\u044c " + this.countOpenSquare + " \u043a\u0432\u0430\u0434\u0440\u0430\u0442\u0438\u043a\u043e\u0432", this.xField, this.yField + 2, 0x10 | 1);
            i = 0;
            while (i < 25) {
                this.square[i].paint(this.graphics);
                ++i;
            }
            if (this.openLetter || this.removeLetters) {
                this.displayMessages();
            }
            if (this.removeLastLetter) {
                this.sprMessageWrong.setRefPixelPosition(this.screenW / 2, this.returnCoordinate(40, this.screenH));
                this.sprMessageWrong.paint(this.graphics);
                this.graphics.drawString(this.midlet.dict.get("incorrect_word").toString(), this.screenW / 2, this.sprMessageWrong.getY() + 10, 0x10 | 1);
            }
            if (this.fewCoins) {
                this.sprMessageWrong.setRefPixelPosition(this.screenW / 2, this.returnCoordinate(40, this.screenH));
                this.sprMessageWrong.paint(this.graphics);
                this.graphics.drawString(this.midlet.dict.get("not_enough_money").toString(), this.screenW / 2, this.sprMessageWrong.getY() + 10, 0x10 | 1);
            }
            if (this.OkKeyWord || this.OkGame) {
                this.graphics.setColor(0, 0, 0);
                if (this.pixelArray == null) {
                    this.pixelArray = new int[this.screenW * this.screenH];
                }
                i = 0;
                while (i < this.pixelArray.length) {
                    this.pixelArray[i] = -1610612737;
                    ++i;
                }
                this.graphics.drawRGB(this.pixelArray, 0, this.screenW, 0, 0, this.screenW, this.screenH, true);
                this.graphics.drawRect(0, 0, this.screenW, this.screenH);
                this.sprButton.defineReferencePixel(this.sprButton.getWidth() / 2, 0);
                String text = "";
                if (this.OkKeyWord) {
                    text = this.midlet.dict.get("next_puzzle").toString();
                } else if (this.OkGame) {
                    text = String.valueOf(this.midlet.dict.get("set_completed").toString()) + this.game + " !";
                }
                int y = this.lenPartWord2 == 0 ? 210 : 240;
                this.font = Font.getFont((int)32, (int)0, (int)8);
                this.graphics.setFont(this.font);
                this.sprButton.setRefPixelPosition(this.screenW / 2, y);
                this.sprButton.paint(this.graphics);
                this.graphics.drawString(text, this.screenW / 2, this.sprButton.getY() + 20, 0x10 | 1);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR is draw");
        }
    }

    public void createGame() throws Exception {
        try {
            this.imgBackground = Image.createImage((String)"/background.png");
            this.imgPlateWood = Image.createImage((String)"/letterbutton.png");
            int i = 0;
            while (i < this.plateWood.length) {
                this.plateWood[i] = new Plate(this.imgPlateWood);
                ++i;
            }
            this.plateWoodH = this.imgPlateWood.getHeight();
            this.plateWoodW = this.imgPlateWood.getWidth();
            this.imgPlate = Image.createImage((String)"/letterplate.png");
            this.plateW = this.imgPlate.getWidth();
            this.plateH = this.imgPlate.getHeight();
            this.imgField = Image.createImage((String)"/field.png");
            this.imgPlateMoney = Image.createImage((String)"/levelplate.png");
            this.imgPlateLevel = Image.createImage((String)"/moneyplate.png");
            this.imgRemoveLettersButton = Image.createImage((String)"/removelettersbutton.png");
            this.imgShowLettersButton = Image.createImage((String)"/showlettersbutton.png");
            this.sprRemoveLettersButton = new Sprite(this.imgRemoveLettersButton);
            this.sprShowLettersButton = new Sprite(this.imgShowLettersButton);
            this.imgMenu = Image.createImage((String)"/b_menu.png");
            this.sprMenu = new Sprite(this.imgMenu);
            this.sprButton = new Sprite(Image.createImage((String)"/button.png"));
            this.sprButtonOk = new Sprite(Image.createImage((String)"/button_ok.png"));
            this.sprButtonOk.defineReferencePixel(this.sprButtonOk.getWidth(), 0);
            this.sprButtonNot = new Sprite(Image.createImage((String)"/button_ok.png"));
            this.sprButtonNot.defineReferencePixel(0, 0);
            this.sprMessage = new Sprite(Image.createImage((String)"/message.png"));
            this.sprMessage.defineReferencePixel(this.sprMessage.getWidth() / 2, this.sprMessage.getHeight());
            this.sprMessageWrong = new Sprite(Image.createImage((String)"/messagewrong.png"));
            this.sprMessageWrong.defineReferencePixel(this.sprMessageWrong.getWidth() / 2, this.sprMessageWrong.getHeight() / 2);
            this.imgSquare = Image.createImage((String)"/square.png");
            int squareW = this.imgSquare.getWidth();
            int squareH = this.imgSquare.getHeight();
            int i2 = 0;
            int k = 0;
            int y = 25;
            while (i2 < 5) {
                int x = 60;
                int j = 0;
                while (j < 5) {
                    this.square[k] = new Sprite(this.imgSquare);
                    this.square[k].setPosition(x, y);
                    x += squareW;
                    ++k;
                    ++j;
                }
                y += squareH;
                ++i2;
            }
            this.scroll = this.createSound("/list3.mp3", "audio/mpeg");
        }
        catch (Exception ex) {
            System.err.println("Image it is not loaded");
        }
    }

    public void setGame() throws Exception {
        this.gameManager = new LayerManager();
        this.countOpenSquare = 6;
        int step = 4;
        this.numSymPlate = 0;
        this.removeLastLetter = false;
        this.removeLetters = false;
        this.openLetter = false;
        this.fewCoins = false;
        this.OkKeyWord = false;
        this.OkGame = false;
        this.lang = this.midlet.language;
        this.showLetter = -1;
        if (this.midlet.game == 1) {
            this.dblevel = this.midlet.DBLEVEL1;
            this.dbmoney = this.midlet.DBMONEY1;
        } else if (this.midlet.game == 2) {
            this.dblevel = this.midlet.DBLEVEL2;
            this.dbmoney = this.midlet.DBMONEY2;
        }
        this.level = this.loadData(this.dblevel);
        this.money = this.loadData(this.dbmoney);
        if (this.money == -1) {
            this.money = 30;
        }
        if (this.level == -1) {
            this.level = 1;
        }
        this.NamesPicAndWord = this.getNamesPicAndWord("/lang/" + this.lang + this.midlet.game, this.level);
        this.pic = this.NamesPicAndWord.get("pic").toString();
        this.keyword = this.NamesPicAndWord.get("keyword").toString();
        this.removeSpace();
        this.lenKeyword = this.keyword.length();
        this.plate = new Plate[this.lenKeyword];
        this.symPlate = new Symbol[this.lenKeyword];
        int i = 0;
        while (i < this.lenKeyword) {
            this.plate[i] = new Plate(this.imgPlate);
            this.symPlate[i] = new Symbol(' ');
            this.symPlate[i].setVisible(false);
            this.symPlate[i].chageFontSize(8);
            ++i;
        }
        this.dottingPlate();
        i = 0;
        while (i < this.lenKeyword) {
            this.gameManager.append((Layer)this.plate[i]);
            ++i;
        }
        this.imgPic = Image.createImage((String)("/level" + this.midlet.game + '/' + this.pic + ".jpg"));
        this.yPic = 25;
        this.xPic = this.screenW / 2;
        this.yField = 150;
        this.xField = this.screenW / 2;
        this.yLevel = 0;
        this.xLevel = this.screenW / 2;
        this.yMoney = 1;
        this.xMoney = this.screenW - 5;
        this.sprMenu.setPosition(1, 1);
        this.sprMenu.setVisible(true);
        this.gameManager.append((Layer)this.sprMenu);
        String mixedLetters = this.getMixedLetters();
        String lettersAlf = this.getLettersAlf();
        this.posLetters = this.getArrayPosLetters();
        this.letters = this.getLetters(mixedLetters, lettersAlf);
        i = 0;
        while (i < this.NLETTERS) {
            this.symbol[i] = new Symbol(this.letters.charAt(i));
            ++i;
        }
        int y = this.lenPartWord2 == 0 ? 210 : 240;
        i = 0;
        int k = 0;
        while (i < 2) {
            int x = 4;
            int j = 0;
            while (j < this.NLETTERS / 2) {
                this.plateWood[k].setPosition(x, y);
                this.symbol[k].setPos(x, y, this.plateWoodW, this.plateWoodH);
                x += this.plateWoodW + step;
                this.plateWood[k].setVisible(true);
                this.gameManager.append((Layer)this.plateWood[k++]);
                ++j;
            }
            if (i == 0) {
                this.sprRemoveLettersButton.setPosition(x, y);
                this.sprRemoveLettersButton.setVisible(true);
                this.gameManager.append((Layer)this.sprRemoveLettersButton);
            } else if (i == 1) {
                this.sprShowLettersButton.setPosition(x, y);
                this.sprShowLettersButton.setVisible(true);
                this.gameManager.append((Layer)this.sprShowLettersButton);
            }
            y += 35;
            ++i;
        }
        i = 0;
        while (i < 25) {
            this.square[i].setVisible(true);
            ++i;
        }
        this.gameManager.append((Layer)new Sprite(this.imgBackground));
    }

    private void updateGame() {
        try {
            if (this.removeLastLetter && this.tt.isTask()) {
                this.symPlate[this.lenKeyword - 1].setVisible(false);
                this.plateWood[this.symPlate[this.lenKeyword - 1].getIndexPlateWood()].setVisible(true);
                this.symbol[this.symPlate[this.lenKeyword - 1].getIndexPlateWood()].setVisible(true);
                this.removeLastLetter = false;
                --this.numSymPlate;
                this.tt.setTask(false);
                this.removeLastLetter = false;
            }
            if (this.fewCoins && this.tt.isTask()) {
                this.tt.setTask(false);
                this.fewCoins = false;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR is updateGame");
        }
    }

    protected void pointerPressed(int x, int y) {
        try {
            if (this.OkGame && this.isPressed(x, y, this.sprButton.getX(), this.sprButton.getY(), this.sprButton.getWidth(), this.sprButton.getHeight())) {
                this.stop();
                this.writeToFile(this.dblevel, 1);
                this.writeToFile(this.dbmoney, 0);
                System.gc();
                this.midlet.gameMenu();
                return;
            }
            if (this.OkKeyWord && this.isPressed(x, y, this.sprButton.getX(), this.sprButton.getY(), this.sprButton.getWidth(), this.sprButton.getHeight())) {
                ++this.level;
                this.money += 10;
                this.writeToFile(this.dblevel, this.level);
                this.writeToFile(this.dbmoney, this.money);
                try {
                    this.setGame();
                }
                catch (Exception e) {
                    System.out.println("ERROR is setGame");
                }
                return;
            }
            if (!(this.removeLastLetter || this.removeLetters || this.openLetter || this.OkKeyWord || this.OkGame)) {
                int i = 0;
                while (i < 25) {
                    if (this.isPressed(x, y, this.square[i].getX(), this.square[i].getY(), this.square[i].getWidth(), this.square[i].getHeight()) && this.square[i].isVisible() && this.countOpenSquare > 0) {
                        this.square[i].setVisible(false);
                        --this.countOpenSquare;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.NLETTERS) {
                    if (this.isPressed(x, y, this.plateWood[i].getX(), this.plateWood[i].getY(), this.plateWood[i].getWidth(), this.plateWood[i].getHeight()) && this.plateWood[i].isVisible()) {
                        this.plateWood[i].setVisible(false);
                        this.symbol[i].setVisible(false);
                        int j = 0;
                        while (j < this.lenKeyword) {
                            if (!this.symPlate[j].isVisible()) {
                                this.symPlate[j].changeSymbol(this.symbol[i].getSymbol());
                                this.symPlate[j].setVisible(true);
                                this.symPlate[j].setIndexPlateWood(i);
                                ++this.numSymPlate;
                                break;
                            }
                            ++j;
                        }
                        if (this.numSymPlate == this.lenKeyword && !this.isCheckAnswer(this.keyword, this.symPlate)) {
                            this.removeLastLetter = true;
                            this.t = new Timer();
                            this.tt = new TimerShow();
                            this.t.schedule((TimerTask)this.tt, 1000L);
                        } else if (this.numSymPlate == this.lenKeyword && this.isCheckAnswer(this.keyword, this.symPlate)) {
                            if (this.level + 1 > this.LEVEL) {
                                this.OkGame = true;
                            } else {
                                this.OkKeyWord = true;
                            }
                            i = 0;
                            while (i < this.NLETTERS) {
                                this.plateWood[i].setVisible(false);
                                this.symbol[i].setVisible(false);
                                ++i;
                            }
                            this.sprRemoveLettersButton.setVisible(false);
                            this.sprShowLettersButton.setVisible(false);
                            i = 0;
                            while (i < 25) {
                                this.square[i].setVisible(false);
                                ++i;
                            }
                            return;
                        }
                        this.startScrollSound();
                        this.println("plateWood");
                        return;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.lenKeyword) {
                    if (this.isPressed(x, y, this.plate[i].getX(), this.plate[i].getY(), this.plate[i].getWidth(), this.plate[i].getHeight()) && this.symPlate[i].isVisible()) {
                        this.symPlate[i].setVisible(false);
                        this.plateWood[this.symPlate[i].getIndexPlateWood()].setVisible(true);
                        this.symbol[this.symPlate[i].getIndexPlateWood()].setVisible(true);
                        --this.numSymPlate;
                        this.startScrollSound();
                        if (this.showLetter != -1 && this.mixedArrayLetters[this.showLetter] == i) {
                            this.showLetter = -1;
                        }
                        this.println("plate");
                        return;
                    }
                    ++i;
                }
                if (this.isPressed(x, y, this.sprRemoveLettersButton.getX(), this.sprRemoveLettersButton.getY(), this.sprRemoveLettersButton.getWidth(), this.sprRemoveLettersButton.getHeight()) && this.sprRemoveLettersButton.isVisible()) {
                    this.removeLetters = true;
                    this.startScrollSound();
                    return;
                }
                if (this.isPressed(x, y, this.sprShowLettersButton.getX(), this.sprShowLettersButton.getY(), this.sprShowLettersButton.getWidth(), this.sprShowLettersButton.getHeight()) && this.sprShowLettersButton.isVisible()) {
                    this.openLetter = true;
                    this.startScrollSound();
                    return;
                }
                if (this.isPressed(x, y, this.sprMenu.getX(), this.sprMenu.getY(), this.sprMenu.getWidth(), this.sprMenu.getHeight())) {
                    this.writeToFile(this.dblevel, this.level);
                    this.writeToFile(this.dbmoney, this.money);
                    this.startScrollSound();
                    this.stop();
                    System.gc();
                    this.midlet.gameMenu();
                }
            }
            if (this.openLetter && this.isPressed(x, y, this.sprButtonOk.getX(), this.sprButtonOk.getY(), this.sprButtonOk.getWidth(), this.sprButtonOk.getHeight())) {
                if (this.money < 40) {
                    this.fewCoins = true;
                    this.t = new Timer();
                    this.tt = new TimerShow();
                    this.t.schedule((TimerTask)this.tt, 1000L);
                } else {
                    this.showLetter();
                    this.sprShowLettersButton.setVisible(false);
                    this.money -= 40;
                    this.numSymPlate = 1;
                }
                this.openLetter = false;
                return;
            }
            if (this.openLetter && this.isPressed(x, y, this.sprButtonNot.getX(), this.sprButtonNot.getY(), this.sprButtonNot.getWidth(), this.sprButtonNot.getHeight())) {
                this.openLetter = false;
                return;
            }
            if (this.removeLetters && this.isPressed(x, y, this.sprButtonOk.getX(), this.sprButtonOk.getY(), this.sprButtonOk.getWidth(), this.sprButtonOk.getHeight())) {
                if (this.money < 30) {
                    this.fewCoins = true;
                    this.t = new Timer();
                    this.tt = new TimerShow();
                    this.t.schedule((TimerTask)this.tt, 1000L);
                } else {
                    boolean r = this.RemoveThreeLetters();
                    if (r) {
                        this.sprRemoveLettersButton.setVisible(false);
                        this.money -= 30;
                        this.numSymPlate = this.showLetter != -1 ? 1 : 0;
                    }
                }
                this.removeLetters = false;
                return;
            }
            if (this.removeLetters && this.isPressed(x, y, this.sprButtonNot.getX(), this.sprButtonNot.getY(), this.sprButtonNot.getWidth(), this.sprButtonNot.getHeight())) {
                this.removeLetters = false;
                return;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR is pointerPressed");
        }
    }

    protected int returnCoordinate(int percent, int sizeH) {
        int pix = percent * sizeH / 100;
        return pix;
    }

    protected boolean isPressed(int x, int y, int xi, int yi, int wi, int hi) {
        boolean rezult = false;
        if (x > xi && y > yi && x < xi + wi && y < yi + hi) {
            rezult = true;
        }
        return rezult;
    }

    protected int returnCenterX(int wi, int sizeW) {
        int x = sizeW / 2 - wi / 2;
        return x;
    }

    private boolean isCheckAnswer(String keyword, Symbol[] s) {
        int i = 0;
        while (i < this.lenKeyword) {
            if (keyword.charAt(i) != s[i].getSymbol()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void displayMessages() {
        try {
            String text1 = "";
            String text2 = "";
            String buttonOk = this.midlet.dict.get("ok").toString();
            String buttonNot = this.midlet.dict.get("cancel").toString();
            if (this.removeLetters) {
                text1 = this.midlet.dict.get("hide_incorrect_letters_from_puzzle_cost").toString();
                text2 = this.midlet.dict.get("coins30").toString();
            } else if (this.openLetter) {
                text1 = this.midlet.dict.get("show_correct_letters_cost").toString();
                text2 = this.midlet.dict.get("coins40").toString();
            }
            if (this.pixelArray == null) {
                this.pixelArray = new int[this.screenW * this.screenH];
            }
            int i = 0;
            while (i < this.pixelArray.length) {
                this.pixelArray[i] = -1627389952;
                ++i;
            }
            this.graphics.drawRGB(this.pixelArray, 0, this.screenW, 0, 0, this.screenW, this.screenH, true);
            this.graphics.drawRect(0, 0, this.screenW, this.screenH);
            this.sprMessage.setRefPixelPosition(this.screenW / 2, this.returnCoordinate(50, this.screenH));
            this.sprMessage.paint(this.graphics);
            this.sprMessage.setVisible(true);
            this.graphics.setColor(250, 250, 250);
            this.font = Font.getFont((int)32, (int)0, (int)8);
            this.graphics.setFont(this.font);
            this.graphics.drawString(text1, this.screenW / 2, this.sprMessage.getY() + 10, 0x10 | 1);
            this.graphics.drawString(text2, this.screenW / 2, this.sprMessage.getY() + 30, 0x10 | 1);
            this.graphics.setColor(0, 0, 0);
            this.sprButtonOk.setRefPixelPosition(this.screenW / 2, this.returnCoordinate(50, this.screenH));
            this.sprButtonOk.paint(this.graphics);
            this.graphics.drawString(buttonOk, this.sprButtonOk.getX() + this.sprButtonOk.getWidth() / 2, this.sprButtonOk.getY() + 10, 0x10 | 1);
            this.sprButtonNot.setRefPixelPosition(this.screenW / 2, this.returnCoordinate(50, this.screenH));
            this.sprButtonNot.paint(this.graphics);
            this.graphics.drawString(buttonNot, this.sprButtonNot.getX() + this.sprButtonNot.getWidth() / 2, this.sprButtonNot.getY() + 10, 0x10 | 1);
        }
        catch (Exception e) {
            System.out.println("ERROR is displayMessage");
        }
    }

    private boolean RemoveThreeLetters() {
        int iter = 3;
        boolean r = true;
        try {
            int i = 0;
            while (i < this.NLETTERS) {
                if (this.showLetter != -1 && this.posLetters[this.showLetter] != i) {
                    this.plateWood[i].setVisible(true);
                    this.symbol[i].setVisible(true);
                } else if (this.showLetter == -1) {
                    this.plateWood[i].setVisible(true);
                    this.symbol[i].setVisible(true);
                }
                ++i;
            }
            i = 0;
            while (i < this.lenKeyword) {
                if (this.showLetter != -1 && this.mixedArrayLetters[this.showLetter] != i) {
                    this.symPlate[i].setVisible(false);
                } else if (this.showLetter == -1) {
                    this.symPlate[i].setVisible(false);
                }
                ++i;
            }
            if (this.lenKeyword > this.NLETTERS - 3) {
                iter = this.NLETTERS - this.lenKeyword;
            }
            r = iter != 0;
            i = 0;
            while (i < iter) {
                boolean b = true;
                while (b) {
                    int index = this.random.nextInt(this.NLETTERS);
                    if (this.searchItem(this.posLetters, index) || !this.plateWood[index].isVisible()) continue;
                    this.plateWood[index].setVisible(false);
                    this.symbol[index].setVisible(false);
                    b = false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR is RemoveThreeLetters");
        }
        return r;
    }

    private void showLetter() {
        try {
            int i = 0;
            while (i < this.lenKeyword) {
                if (this.symPlate[i].isVisible()) {
                    this.symPlate[i].setVisible(false);
                    this.plateWood[this.symPlate[i].getIndexPlateWood()].setVisible(true);
                    this.symbol[this.symPlate[i].getIndexPlateWood()].setVisible(true);
                }
                ++i;
            }
            boolean b = true;
            while (b) {
                int index = this.random.nextInt(this.NLETTERS);
                if (!this.searchItem(this.posLetters, index)) continue;
                this.plateWood[index].setVisible(false);
                this.symbol[index].setVisible(false);
                int p = 0;
                while (p < this.posLetters.length) {
                    if (this.posLetters[p] == index) break;
                    ++p;
                }
                i = this.mixedArrayLetters[p];
                this.symPlate[i].changeSymbol(this.symbol[index].getSymbol());
                this.symPlate[i].setVisible(true);
                this.symPlate[i].setIndexPlateWood(index);
                b = false;
                this.showLetter = p;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR is showLetter");
        }
    }

    private void removeSpace() {
        String s = "";
        this.lenPartWord1 = this.keyword.length();
        this.lenPartWord2 = 0;
        try {
            int i = 0;
            while (i < this.keyword.length()) {
                if (this.keyword.charAt(i) != ' ') {
                    s = String.valueOf(s) + this.keyword.charAt(i);
                } else {
                    this.lenPartWord1 = i;
                    this.lenPartWord2 = this.keyword.length() - i - 1;
                }
                ++i;
            }
            this.keyword = s;
        }
        catch (Exception e) {
            System.out.println("ERROR is removeSpace");
        }
    }

    private void dottingPlate() {
        int step = 0;
        int x = this.screenW / 2;
        try {
            x = this.lenPartWord1 % 2 == 0 ? x - step / 2 - this.plateW * this.lenPartWord1 / 2 - step * (this.lenPartWord1 / 2 - 1) : x - this.plateW / 2 - this.plateW * (this.lenPartWord1 / 2) - step * (this.lenPartWord1 / 2);
            int y = 175;
            int k = 0;
            int i = 0;
            while (i < this.lenPartWord1) {
                this.plate[k].setPosition(x, y);
                this.symPlate[k].setPos(x, y, this.plate[k].getWidth(), this.plate[k].getHeight());
                x = x + this.plateW + step;
                ++i;
                ++k;
            }
            if (this.lenPartWord2 != 0) {
                x = this.screenW / 2;
                x = this.lenPartWord2 % 2 == 0 ? x - step / 2 - this.plateW * this.lenPartWord2 / 2 - step * (this.lenPartWord2 / 2 - 1) : x - this.plateW / 2 - this.plateW * (this.lenPartWord2 / 2) - step * (this.lenPartWord2 / 2);
                y = 35;
                i = 0;
                while (i < this.lenPartWord2) {
                    this.plate[k].setPosition(x, y);
                    this.symPlate[k].setPos(x, y, this.plate[k].getWidth(), this.plate[k].getHeight());
                    x = x + this.plateW + step;
                    ++i;
                    ++k;
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR is dottingPlate");
        }
    }

    private int loadData(String dbname) {
        int readIntData = -1;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)dbname, (boolean)false);
            byte[] record = recordStore.getRecord(1);
            ByteArrayInputStream bais = new ByteArrayInputStream(record);
            DataInputStream dis = new DataInputStream(bais);
            readIntData = dis.readInt();
        }
        catch (Exception e) {
            System.out.println("Exception in loading data: " + e);
        }
        System.gc();
        return readIntData;
    }

    private void writeToFile(String dbname, int data) {
        block34: {
            ByteArrayOutputStream baos = null;
            FilterOutputStream d = null;
            RecordStore recordStore = null;
            try {
                try {
                    recordStore = RecordStore.openRecordStore((String)dbname, (boolean)true);
                    baos = new ByteArrayOutputStream();
                    d = new DataOutputStream(baos);
                    ((DataOutputStream)d).writeInt(data);
                    byte[] record = baos.toByteArray();
                    if (recordStore.getNumRecords() == 0) {
                        recordStore.addRecord(record, 0, record.length);
                    } else {
                        recordStore.setRecord(1, record, 0, record.length);
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception: " + e);
                    if (d != null) {
                        try {
                            d.close();
                        }
                        catch (IOException ioe) {
                            System.err.println("Failed close d");
                        }
                    }
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException ioe) {
                            System.err.println("Failed close b");
                        }
                    }
                    if (recordStore != null) {
                        try {
                            recordStore.closeRecordStore();
                        }
                        catch (RecordStoreException rse) {
                            System.err.println("Failed close store");
                        }
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (d != null) {
                    try {
                        d.close();
                    }
                    catch (IOException ioe) {
                        System.err.println("Failed close d");
                    }
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException ioe) {
                        System.err.println("Failed close b");
                    }
                }
                if (recordStore != null) {
                    try {
                        recordStore.closeRecordStore();
                    }
                    catch (RecordStoreException rse) {
                        System.err.println("Failed close store");
                    }
                }
                throw throwable;
            }
            if (d != null) {
                try {
                    d.close();
                }
                catch (IOException ioe) {
                    System.err.println("Failed close d");
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ioe) {
                    System.err.println("Failed close b");
                }
            }
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException rse) {
                    System.err.println("Failed close store");
                }
            }
        }
        System.gc();
    }

    private Hashtable getNamesPicAndWord(String path, int level) {
        String strBuff = "";
        Hashtable<String, String> param = new Hashtable<String, String>();
        int c = 1;
        boolean b = false;
        String content = "";
        try {
            int read;
            InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream(path), "UTF-8");
            StringBuffer temp = new StringBuffer(1024);
            char[] buffer = new char[1024];
            while ((read = ((Reader)in).read(buffer, 0, buffer.length)) != -1) {
                temp.append(buffer, 0, read);
            }
            content = temp.toString();
            int i = 0;
            while (i < content.length() && !b) {
                strBuff = String.valueOf(strBuff) + content.charAt(i);
                if (content.charAt(i) == '\n' && c == level) {
                    b = true;
                    strBuff = strBuff.substring(0, strBuff.length() - 1);
                } else if (content.charAt(i) == '\n' && c != level) {
                    strBuff = "";
                    ++c;
                }
                ++i;
            }
            ((Reader)in).close();
        }
        catch (Exception e) {
            System.err.println("ERROR in getText() " + e);
        }
        int begin = strBuff.indexOf(58) + 1;
        int end = strBuff.indexOf(58, begin);
        param.put("pic", new String(strBuff.substring(begin, end)));
        begin = end + 1;
        end = strBuff.indexOf(58, begin);
        param.put("keyword", new String(strBuff.substring(begin, end)));
        return param;
    }

    private String getMixedLetters() {
        String mixedLetters = "";
        this.mixedArrayLetters = new int[this.lenKeyword];
        try {
            int i = 0;
            while (i < this.lenKeyword) {
                this.mixedArrayLetters[i] = -1;
                ++i;
            }
            i = 0;
            while (i < this.lenKeyword) {
                boolean bool = true;
                while (bool) {
                    int randLetter = this.random.nextInt(this.lenKeyword);
                    char ch = this.keyword.charAt(randLetter);
                    if (this.searchItem(this.mixedArrayLetters, randLetter)) continue;
                    mixedLetters = String.valueOf(mixedLetters) + ch;
                    this.mixedArrayLetters[i] = randLetter;
                    bool = false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR is getMixedLetters");
        }
        return mixedLetters;
    }

    private int[] getArrayPosLetters() {
        int[] posLetters = new int[this.lenKeyword];
        try {
            int i = 0;
            while (i < this.lenKeyword) {
                posLetters[i] = -1;
                ++i;
            }
            i = 0;
            while (i < this.lenKeyword) {
                boolean bool = true;
                while (bool) {
                    int item = this.random.nextInt(this.NLETTERS);
                    if (this.searchItem(posLetters, item)) continue;
                    posLetters[i] = item;
                    bool = false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR is getArrayPosLetters");
        }
        posLetters = this.sortArray(posLetters);
        return posLetters;
    }

    private boolean searchItem(int[] mas, int item) {
        int i = 0;
        while (i < mas.length) {
            if (mas[i] == item) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int[] sortArray(int[] mas) {
        int len = mas.length;
        int i = 0;
        while (i < len - 1) {
            int min = i;
            int j = i;
            while (j < len) {
                if (mas[min] > mas[j]) {
                    min = j;
                }
                ++j;
            }
            int tmp = mas[min];
            mas[min] = mas[i];
            mas[i] = tmp;
            ++i;
        }
        return mas;
    }

    private String getLettersAlf() {
        String ru;
        String lettersAlf = "";
        String alf = "";
        alf = ru = "\u0419\u0426\u0423\u041a\u0415\u041d\u0413\u0428\u0429\u0417\u0425\u042a\u0424\u042b\u0412\u0410\u041f\u0420\u041e\u041b\u0414\u0416\u042d\u042f\u0427\u0421\u041c\u0418\u0422\u042c\u0411\u042e\u0401";
        int lenAlf = alf.length();
        try {
            int i = 0;
            while (i < this.NLETTERS - this.lenKeyword) {
                boolean bool = true;
                while (bool) {
                    int randLetter = this.random.nextInt(lenAlf);
                    char ch = alf.charAt(randLetter);
                    if (this.keyword.indexOf(ch) != -1 || lettersAlf.indexOf(ch) != -1) continue;
                    lettersAlf = String.valueOf(lettersAlf) + ch;
                    bool = false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR is getLettersAlf");
        }
        return lettersAlf;
    }

    private String getLetters(String mixedLetters, String lettersAlf) {
        int p = 0;
        int k = 0;
        String letters = "";
        try {
            int i = 0;
            while (i < this.NLETTERS) {
                letters = p < this.posLetters.length && i == this.posLetters[p] ? String.valueOf(letters) + mixedLetters.charAt(p++) : String.valueOf(letters) + lettersAlf.charAt(k++);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR is getLetters");
        }
        return letters;
    }

    private void println(String s) {
        System.out.println(s);
    }

    private Player createSound(String file, String format) {
        Player player = null;
        try {
            InputStream input = this.getClass().getResourceAsStream(file);
            player = Manager.createPlayer((InputStream)input, (String)format);
            player.prefetch();
        }
        catch (IOException iOException) {
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        return player;
    }

    private void startScrollSound() {
        if (this.scroll != null) {
            try {
                this.scroll.stop();
                this.scroll.setMediaTime(0L);
                this.scroll.start();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }
}

