/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class Menu
extends Canvas
implements Runnable {
    private GameMidlet midlet = null;
    private volatile Thread thread = null;
    private Image imgMenu = null;
    private Image imgPlay = null;
    private Image imgExit = null;
    private Font font = null;
    private boolean loop = false;
    private int game1;
    private int game2;
    private int w;
    private int h;
    private int wPlay;
    private int hPlay;
    private int wExit;
    private int hExit;
    private int xPlay1;
    private int yPlay1;
    private int xPlay2;
    private int yPlay2;
    private int xExit;
    private int yExit;

    public Menu(GameMidlet midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        try {
            this.imgMenu = Image.createImage((String)"/background.png");
            this.imgPlay = Image.createImage((String)"/playbutton.png");
            this.imgExit = Image.createImage((String)"/b_back.png");
        }
        catch (Exception ex) {
            System.err.println("In the block =menu=  images are not loaded");
        }
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.wPlay = this.imgPlay.getWidth();
        this.hPlay = this.imgPlay.getHeight();
        this.xPlay1 = this.returnCenterX(this.wPlay, this.w);
        this.yPlay1 = this.returnCoordinate(15, this.h);
        this.xPlay2 = this.returnCenterX(this.wPlay, this.w);
        this.yPlay2 = this.returnCoordinate(35, this.h);
        this.wExit = this.imgExit.getWidth();
        this.hExit = this.imgExit.getHeight();
        this.xExit = 1;
        this.yExit = 1;
    }

    public void start() {
        this.game1 = this.loadData(this.midlet.DBLEVEL1);
        if (this.game1 == -1) {
            this.game1 = 1;
        }
        if (this.game2 == -1) {
            this.game2 = 1;
        }
        this.loop = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        while (this.loop) {
            this.repaint();
            try {
                Thread.sleep(20L);
            }
            catch (Exception ex) {
                System.err.println("Class Menu  metod run()");
            }
        }
    }

    public void stop() {
        this.loop = false;
        this.thread = null;
        System.gc();
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.w, this.h);
        graphics.drawImage(this.imgMenu, 0, 0, 0);
        graphics.setColor(250, 250, 250);
        this.font = Font.getFont((int)32, (int)0, (int)0);
        graphics.setFont(this.font);
        graphics.drawString(String.valueOf(this.midlet.dict.get("choose_game").toString()) + ":", this.w / 2, this.returnCoordinate(5, this.h), 0x10 | 1);
        graphics.setColor(0, 0, 0);
        graphics.drawImage(this.imgPlay, this.xPlay1, this.yPlay1, 0x10 | 4);
        graphics.drawString(String.valueOf(this.midlet.dict.get("first_set").toString()) + "  -  " + this.game1 + "/" + 36, this.w / 2, this.yPlay1 + 12, 0x10 | 1);
        graphics.drawImage(this.imgPlay, this.xPlay2, this.yPlay2, 0x10 | 4);
        graphics.drawString(String.valueOf(this.midlet.dict.get("second_set").toString()) + "  -  " + this.game2 + "/" + 36, this.w / 2, this.yPlay2 + 12, 0x10 | 1);
        graphics.drawImage(this.imgExit, 1, 1, 0x10 | 4);
    }

    protected void pointerPressed(int x, int y) {
        if (this.isPressed(x, y, this.xPlay1, this.yPlay1, this.wPlay, this.hPlay)) {
            this.stop();
            this.midlet.game = 1;
            this.midlet.newGame();
        }
        if (this.isPressed(x, y, this.xPlay2, this.yPlay2, this.wPlay, this.hPlay)) {
            this.stop();
            this.midlet.game = 2;
            this.midlet.newGame();
        }
        if (this.isPressed(x, y, this.xExit, this.yExit, this.wExit, this.hExit)) {
            this.stop();
            this.midlet.mainMenuGame();
        }
    }

    protected int loadData(String dbname) {
        int readIntData = -1;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)dbname, (boolean)false);
            byte[] record = recordStore.getRecord(1);
            ByteArrayInputStream bais = new ByteArrayInputStream(record);
            DataInputStream dis = new DataInputStream(bais);
            readIntData = dis.readInt();
        }
        catch (Exception e) {
            System.out.println("Exception in loading data: " + e);
        }
        System.gc();
        return readIntData;
    }

    protected int returnCoordinate(int percent, int sizeH) {
        int pix = percent * sizeH / 100;
        return pix;
    }

    protected boolean isPressed(int x, int y, int xi, int yi, int wi, int hi) {
        boolean rezult = false;
        if (x > xi && y > yi && x < xi + wi && y < yi + hi) {
            rezult = true;
        }
        return rezult;
    }

    protected int returnCenterX(int wi, int sizeW) {
        int x = sizeW / 2 - wi / 2;
        return x;
    }
}

