/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

final class Storage {
    static final String FILE_ALL_PAK = "/all";
    static final String FILE_MENU_PAK = "/menu";
    static final String FILE_WIN_PAK = "/win";
    static final String FILE_LOSE_PAK = "/lose";
    static final String FILE_GAME_PAK = "/game";
    static final String FILE_TEXT_PAK = "/txt";
    static final String FILE_FONT_PAK = "/font";
    static final String FILE_SPLASH = "/splash.s2";
    static final String FILE_TITLE_SPLASH = "/title.s2";
    static final String FILE_MOREGAMES = "/mg.s2";
    static final String FILE_BRICKS = "/bricks.s2";
    static final String FILE_WORLD_PREFIX = "/w";
    static final String FILE_LEVEL_PREFIX = "/l";
    static final int RMS_DATA_SAVEGAME = 0;
    static final int RMS_DATA_GAME_STATS = 1;
    static final int RMS_DATA_HIGHSCORE = 2;
    static final int RMS_DATA_HIGHSCORE2 = 3;
    static final int RMS_DATA_HIGHSCORE3 = 4;
    static final int RMS_DATA_SLOT_COUNT = 5;
    static final int TOC_ENTRY_SIZE = 6;
    static final int TOC_SIZE_OFFSET = 0;
    static final int TOC_TYPE_OFFSET = 4;
    static final int TOC_ID_OFFSET = 5;
    byte[] toc = null;
    Object[] files = null;
    private static final String OPTIONS_RMS = "o";
    private static final String RMS_DATA = "d";
    private static final String VERSION_RMS = "v";
    static int packageFileSize = 0;
    static final int OPTION_SOUND = 0;
    static final int OPTION_VOLUME = 1;
    static final int OPTION_VIBRATION = 2;
    static final int OPTION_LANGUAGE = 3;
    static final int OPTION_RESET = 4;
    static final int OPTION_ROTATE_SCREEN = 5;
    static final int OPTION_COUNT = 6;
    static int[] optionSelections = null;
    static int[] optionDefaults = null;
    static int[] optionStrings = null;
    static int[][] optionValues = null;
    static byte[] optionEnabled = null;
    static Object[] optionValueStrings = null;
    static final int ENABLE_MENU = 1;
    static final int ENABLE_GAME = 2;
    static final int TYPE_RAW = 0;
    static final int TYPE_MIDI_SOUND = 3;
    static final int TYPE_SPRITE2 = 5;
    static final int TYPE_AMR_SOUND = 6;
    static final int TYPE_TONE_SOUND = 7;
    static final int TYPE_WAV_SOUND = 8;
    static final int TYPE_GAME_TEXT = 9;
    static final int TYPE_MMF_SOUND = 10;
    static final int TYPE_LVL_MAP = 11;
    static final int TYPE_LVL_ITEMS = 12;
    private static boolean rmsDataDirty;
    private static byte[][] rmsData;

    Storage() {
    }

    static final int convertByte(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    static final byte[] getIntBytes(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2] = (byte)(n & 0xFF);
        return byArray;
    }

    static final int parseInt(byte[] byArray, int n) {
        return Storage.convertByte(byArray[n++]) << 24 | Storage.convertByte(byArray[n++]) << 16 | Storage.convertByte(byArray[n++]) << 8 | Storage.convertByte(byArray[n]);
    }

    static final int parseUnsignedShort(byte[] byArray, int n) {
        return Storage.convertByte(byArray[n++]) << 8 | Storage.convertByte(byArray[n]);
    }

    static final int countBits(int n) {
        int n2 = 0;
        while (n != 0) {
            if ((n & 1) != 0) {
                ++n2;
            }
            n >>>= 1;
        }
        return n2;
    }

    static final int readInteger(InputStream inputStream) throws IOException {
        return inputStream.read() << 24 | inputStream.read() << 16 | inputStream.read() << 8 | inputStream.read();
    }

    static final int readUnsignedShort(InputStream inputStream) throws IOException {
        return inputStream.read() << 8 | inputStream.read();
    }

    static final void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    static final void writeInteger(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >>> 24 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    static final short readUnsignedByte(InputStream inputStream) throws IOException {
        return (short)inputStream.read();
    }

    static final int readArray(InputStream inputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = n3;
        int n5 = 0;
        do {
            int n6;
            if ((n6 = n2 - n5) > 1024) {
                n6 = 1024;
            }
            if ((n6 = inputStream.read(byArray, n, n6)) < 1) break;
            n5 += n6;
            n += n6;
            if (n4 <= 0) continue;
            n4 -= Screen.advanceProgress(n6 * n3 / n2);
        } while (n5 < n2);
        if (n4 > 0) {
            Screen.advanceProgress(n4);
        }
        return n5;
    }

    static final void skip(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3 = 0;
        do {
            n2 = n - n3;
        } while ((n2 = (int)inputStream.skip(n2)) >= 1 && (n3 += n2) < n);
    }

    static byte[] readPackageToc(InputStream inputStream) throws IOException {
        int n = Storage.readInteger(inputStream);
        Storage.readUnsignedShort(inputStream);
        byte[] byArray = new byte[n];
        if (Storage.readArray(inputStream, byArray, 0, n, 0) != n) {
            throw new IOException();
        }
        return byArray;
    }

    static Object[] readPackageFiles(InputStream inputStream, byte[] byArray, byte[] byArray2, boolean bl, int n) throws IOException {
        int n2;
        Screen.watchdog = 0L;
        if (byArray2 != null) {
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                if (Storage.getFileIndex(byArray, byArray2[n2]) >= 0) continue;
                throw new IOException("Invalid id " + byArray2[n2]);
            }
        }
        n2 = Storage.getTotalPackageSize(byArray);
        int n3 = 0;
        Object[] objectArray = new Object[byArray.length / 6];
        int n4 = 0;
        for (int i = 0; i < objectArray.length && (byArray2 == null || n3 < byArray2.length); ++i) {
            boolean bl2;
            int n5 = Storage.parseInt(byArray, n4 + 0);
            byte by = bl ? (byte)0 : byArray[n4 + 4];
            byte by2 = byArray[n4 + 5];
            int n6 = n5 * n / n2;
            n -= n6;
            n2 -= n5;
            if (byArray2 != null) {
                bl2 = true;
                for (int j = 0; j < byArray2.length; ++j) {
                    if (by2 != byArray2[j]) continue;
                    bl2 = false;
                    break;
                }
            } else {
                bl2 = false;
            }
            if (bl2) {
                Storage.skip(inputStream, n5);
                objectArray[i] = null;
                Screen.advanceProgress(n6);
            } else {
                ++n3;
                if (by == 5) {
                    Sprite2Data sprite2Data = Sprite2Data.load(inputStream, (byte[][])null, n6);
                    objectArray[i] = sprite2Data;
                    System.gc();
                } else if (by == 11) {
                    Game.loadMap(inputStream, n6);
                } else if (by == 12) {
                    Game.loadItems(inputStream, n6);
                } else {
                    byte[] byArray3 = new byte[n5];
                    Storage.readArray(inputStream, byArray3, 0, byArray3.length, n6);
                    objectArray[i] = byArray3;
                }
            }
            n4 += 6;
        }
        return objectArray;
    }

    static int getFileIndex(byte[] byArray, int n) {
        for (int i = 5; i < byArray.length; i += 6) {
            if (byArray[i] != n) continue;
            return i / 6;
        }
        return -1;
    }

    static int getFileType(byte[] byArray, int n) {
        return byArray[n * 6 + 4];
    }

    static int getTotalPackageSize(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; i += 6) {
            n += Storage.parseInt(byArray, i);
        }
        return n;
    }

    static Storage loadPackage(String string, byte[] byArray, boolean bl, int n) throws IOException {
        Screen.watchdog = 0L;
        Storage storage = new Storage();
        InputStream inputStream = string.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(string + " not found");
        }
        storage.toc = Storage.readPackageToc(inputStream);
        storage.files = Storage.readPackageFiles(inputStream, storage.toc, byArray, bl, n);
        inputStream.close();
        inputStream = null;
        return storage;
    }

    static InputStream getPackageFileStream(String string, int n, boolean bl) throws IOException {
        Screen.watchdog = 0L;
        InputStream inputStream = string.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(string + " not found");
        }
        byte[] byArray = Storage.readPackageToc(inputStream);
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            int n4 = Storage.parseInt(byArray, n2 + 0);
            byte by = byArray[n2 + 5];
            if (bl && n3 == n || !bl && by == n) {
                packageFileSize = n4;
                return inputStream;
            }
            Storage.skip(inputStream, n4);
            n2 += 6;
            ++n3;
        }
        inputStream.close();
        inputStream = null;
        return null;
    }

    int getFileType(int n) {
        int n2 = Storage.getFileIndex(this.toc, n);
        return n2 >= 0 ? Storage.getFileType(this.toc, n2) : -1;
    }

    Object getFile(int n) {
        int n2 = Storage.getFileIndex(this.toc, n);
        return n2 < 0 ? null : this.files[n2];
    }

    Sprite2Data getSpriteData(int n) {
        return (Sprite2Data)this.getFile(n);
    }

    void getFiles(int n, int n2, Object[] objectArray) {
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.toc.length) {
            int n5;
            if (this.files[n4] != null && this.toc[n3 + 4] == n && (n5 = this.toc[n3 + 5] + n2) >= 0 && n5 < objectArray.length) {
                objectArray[n5] = this.files[n4];
            }
            n3 += 6;
            ++n4;
        }
    }

    byte[] getData(int n) {
        return (byte[])this.getFile(n);
    }

    static void deleteAllRecordStores(int n) {
        Screen.watchdog = 0L;
        try {
            String[] stringArray = RecordStore.listRecordStores();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    RecordStore.deleteRecordStore((String)stringArray[i]);
                    n -= Screen.advanceProgress(n / (stringArray.length - i));
                }
            }
        }
        catch (Exception exception) {
            Screen.lastIgnoredException = exception;
        }
        rmsData = null;
        Screen.advanceProgress(n);
    }

    static void init(int n) {
        Object object;
        Object object2;
        RecordEnumeration recordEnumeration;
        Screen.watchdog = 0L;
        boolean bl = false;
        String string = Screen.theMidlet.getAppProperty("MIDlet-Version");
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)VERSION_RMS, (boolean)false);
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                object2 = recordEnumeration.nextRecord();
                recordStore.closeRecordStore();
                object = new String((byte[])object2);
                bl = string.compareTo((String)object) == 0;
            }
        }
        catch (Exception exception) {
            Screen.lastIgnoredException = exception;
        }
        n -= Screen.advanceProgress(n / 3);
        if (!bl) {
            int n2 = n >> 1;
            n -= n2;
            Storage.deleteAllRecordStores(n2);
            try {
                recordEnumeration = RecordStore.openRecordStore((String)VERSION_RMS, (boolean)true);
                object2 = recordEnumeration.enumerateRecords(null, null, false);
                object = string.getBytes();
                if (object2.hasNextElement()) {
                    recordEnumeration.setRecord(object2.nextRecordId(), (byte[])object, 0, ((Object)object).length);
                } else {
                    recordEnumeration.addRecord((byte[])object, 0, ((Object)object).length);
                }
                recordEnumeration.closeRecordStore();
            }
            catch (Exception exception) {
                Screen.lastIgnoredException = exception;
            }
            Screen.advanceProgress(n);
        } else {
            Storage.loadOptions(n);
        }
    }

    static void masterReset(int n) {
        Screen.watchdog = 0L;
        Storage.resetOptions(0, false);
        int n2 = n / 2;
        Storage.deleteAllRecordStores(n2);
        n -= n2;
        Storage.init(n2);
        Game.loadStats();
        Game.loadedHighscore = -1;
        Dialog.initBackground();
        Storage.setOptionValue(3, Text.localeLoaded, 0, false, false);
        Storage.saveOptions();
    }

    static boolean isOptionValueValid(int[] nArray, int n) {
        if (nArray == null) {
            return false;
        }
        if (nArray[0] == -100) {
            if (n < 0 || n >= nArray[1]) {
                return false;
            }
        } else if (nArray[0] == -101) {
            if (Text.languageCount > 0 && (n < 0 || n >= Text.languageCount)) {
                return false;
            }
        } else {
            if (nArray[0] == -102) {
                return (Screen.getKeyBit(n) & 0x400) == 0;
            }
            if (n < 0 || n >= nArray.length) {
                return false;
            }
        }
        return true;
    }

    static int getOptionNextValue(int[] nArray, int n, boolean bl) {
        byte by = (byte)(n + (bl ? -1 : 1));
        if (nArray[0] == -100) {
            if (by < 0) {
                by = (byte)(nArray[1] - 1);
            } else if (by >= (byte)nArray[1]) {
                by = 0;
            }
        } else if (nArray[0] == -101) {
            if (by < 0) {
                by = (byte)(Text.languageCount - 1);
            } else if (by >= Text.languageCount) {
                by = 0;
            }
        } else {
            if (nArray[0] == -102) {
                return n;
            }
            if (by < 0) {
                by = (byte)(nArray.length - 1);
            } else if (by >= nArray.length) {
                by = 0;
            }
        }
        return by;
    }

    static boolean setOptionValue(int n, int n2, int n3, boolean bl, boolean bl2) {
        if (n >= 0 && n < optionSelections.length) {
            if (n2 != optionSelections[n]) {
                if (Storage.isOptionValueValid(optionValues[n], n2)) {
                    int n4 = -1;
                    if (optionValues[n] != null && optionValues[n][0] == -102) {
                        for (int i = 0; i < optionValues.length; ++i) {
                            if (i == n || optionValues[i] == null || optionValues[i][0] != -102 || optionSelections[i] != n2) continue;
                            Storage.optionSelections[i] = optionSelections[n];
                            Storage.optionValueStrings[i] = optionValueStrings[n];
                            n4 = i;
                            break;
                        }
                    }
                    Storage.optionSelections[n] = n2;
                    Storage.optionValueStrings[n] = Storage.getOptionValueString(optionValues[n], n2);
                    if (bl2) {
                        Storage.saveOptions();
                    }
                    Storage.optionChanged(n, n2, n3);
                    if (n4 >= 0) {
                        Storage.optionChanged(n4, optionSelections[n4], 0);
                    }
                    return true;
                }
            } else if (bl) {
                Storage.optionChanged(n, n2, n3);
                return false;
            }
        } else {
            Storage.optionChanged(n, n2, n3);
            return true;
        }
        Screen.advanceProgress(n3);
        return false;
    }

    static void optionChanged(int n, int n2, int n3) {
        if (n == 0) {
            if (!Storage.isOptionOn(n)) {
                Sound.fade(-5);
            }
        } else if (n == 5) {
            Screen.setScreenMode((byte)n2);
        } else if (n == 3) {
            // empty if block
        }
        Screen.optionChanged(n, n2, n3);
    }

    static Object getOptionValueString(int n) {
        if (optionValueStrings[n] == null) {
            Storage.optionValueStrings[n] = Storage.getOptionValueString(optionValues[n], optionSelections[n]);
        }
        return optionValueStrings[n];
    }

    static Object getOptionValueString(int[] nArray, int n) {
        if (nArray == null) {
            return null;
        }
        if (nArray[0] == -100) {
            return Text.convertNumber(Storage.getOptionValueNumber(nArray, n), 0, null, 0);
        }
        if (nArray[0] == -101) {
            return new int[]{0};
        }
        if (nArray[0] == -102) {
            return Text.convertChar((char)n, null, 0, 0);
        }
        Text.setStringFormat(nArray[n], 0, 0);
        return new int[]{nArray[n]};
    }

    static int getOptionValueNumber(int n) {
        return Storage.getOptionValueNumber(optionValues[n], optionSelections[n]);
    }

    static int getOptionValueNumber(int[] nArray, int n) {
        if (nArray[0] == -100) {
            return nArray[2] + n * nArray[3];
        }
        return 0;
    }

    static void loadOptions(int n) {
        Screen.watchdog = 0L;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)OPTIONS_RMS, (boolean)false);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                recordStore.closeRecordStore();
                if (byArray.length >> 2 == optionSelections.length) {
                    boolean bl = true;
                    for (int i = 0; i < optionSelections.length; ++i) {
                        int n2 = Storage.parseInt(byArray, i << 2);
                        if (optionValues[i] != null && !Storage.isOptionValueValid(optionValues[i], n2)) {
                            bl = false;
                            break;
                        }
                        Storage.optionSelections[i] = n2;
                    }
                    if (bl) {
                        Screen.advanceProgress(n);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            Screen.lastIgnoredException = exception;
        }
        System.arraycopy(optionDefaults, 0, optionSelections, 0, optionSelections.length);
        Screen.advanceProgress(n);
    }

    private static void saveOptions() {
        Screen.watchdog = 0L;
        try {
            byte[] byArray = new byte[optionSelections.length << 2];
            for (int i = 0; i < optionSelections.length; ++i) {
                Storage.getIntBytes(optionSelections[i], byArray, i << 2);
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)OPTIONS_RMS, (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                recordStore.setRecord(recordEnumeration.nextRecordId(), byArray, 0, byArray.length);
            } else {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            Screen.lastIgnoredException = exception;
        }
    }

    static void resetOptions(int n, boolean bl) {
        Screen.watchdog = 0L;
        for (int i = 0; i < optionSelections.length; ++i) {
            int n2 = n / (optionSelections.length - i + 1);
            n -= n2;
            Storage.setOptionValue(i, optionDefaults[i], n2, false, false);
        }
        if (bl) {
            try {
                RecordStore.deleteRecordStore((String)OPTIONS_RMS);
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            }
            catch (Exception exception) {
                Screen.lastIgnoredException = exception;
            }
        }
        Screen.advanceProgress(n);
    }

    static int getOption(int n) {
        return optionSelections[n];
    }

    static boolean isOptionOn(int n) {
        return optionEnabled[n] != 0 && optionValues[n][optionSelections[n]] != 11;
    }

    static boolean hasData(int n) {
        Screen.watchdog = 0L;
        if (rmsData == null) {
            Storage.synchronizeData();
        }
        return rmsData[n] != null;
    }

    static void deleteData(int n) {
        Screen.watchdog = 0L;
        if (rmsData == null) {
            Storage.synchronizeData();
        }
        if (n >= 0 && n < rmsData.length) {
            Storage.rmsData[n] = null;
            rmsDataDirty = true;
        }
    }

    static void saveData(int n, byte[] byArray, int n2, int n3) {
        Screen.watchdog = 0L;
        if (rmsData == null) {
            Storage.synchronizeData();
        }
        if (rmsData[n] == null || rmsData[n].length != n3) {
            Storage.rmsData[n] = new byte[n3];
        }
        System.arraycopy(byArray, n2, rmsData[n], 0, n3);
        rmsDataDirty = true;
    }

    static byte[] loadData(int n) {
        Screen.watchdog = 0L;
        if (rmsData == null) {
            Storage.synchronizeData();
        }
        return rmsData[n];
    }

    static void synchronizeData() {
        block14: {
            block13: {
                Screen.watchdog = 0L;
                if (rmsData != null) break block13;
                rmsDataDirty = false;
                rmsData = new byte[5][];
                try {
                    byte[] byArray = null;
                    RecordStore recordStore = RecordStore.openRecordStore((String)RMS_DATA, (boolean)false);
                    RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
                    if (recordEnumeration.hasNextElement()) {
                        byArray = recordEnumeration.nextRecord();
                        recordStore.closeRecordStore();
                    }
                    if (byArray != null) {
                        int n = 0;
                        for (int i = 0; i < 5; ++i) {
                            int n2 = Storage.parseInt(byArray, n);
                            n += 4;
                            if (n2 > 0) {
                                Storage.rmsData[i] = new byte[n2];
                                System.arraycopy(byArray, n, rmsData[i], 0, n2);
                                n += n2;
                                continue;
                            }
                            Storage.rmsData[i] = null;
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    Screen.lastIgnoredException = exception;
                }
                for (int i = 0; i < 5; ++i) {
                    Storage.rmsData[i] = null;
                }
                break block14;
            }
            if (!rmsDataDirty) break block14;
            rmsDataDirty = false;
            int n = 0;
            for (int i = 0; i < 5; ++i) {
                n += 4;
                if (rmsData[i] == null) continue;
                n += rmsData[i].length;
            }
            byte[] byArray = new byte[n];
            int n3 = 0;
            for (int i = 0; i < 5; ++i) {
                Storage.getIntBytes(rmsData[i] != null ? rmsData[i].length : 0, byArray, n3);
                n3 += 4;
                if (rmsData[i] == null) continue;
                System.arraycopy(rmsData[i], 0, byArray, n3, rmsData[i].length);
                n3 += rmsData[i].length;
            }
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)RMS_DATA, (boolean)true);
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
                if (recordEnumeration.hasNextElement()) {
                    recordStore.setRecord(recordEnumeration.nextRecordId(), byArray, 0, byArray.length);
                } else {
                    recordStore.addRecord(byArray, 0, byArray.length);
                }
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                Screen.lastIgnoredException = exception;
            }
        }
    }

    static {
        optionStrings = new int[]{5, 6, 7, 8, 9, -1};
        optionValues = new int[][]{{10, 11}, {-100, 1, 1, 1}, {10, 11}, {-101}, null, {-100, 4, 0, 90}};
        optionDefaults = new int[]{0, 0, 0, -1, 0, 0};
        optionEnabled = new byte[]{3, 3, 3, 0, 1, 0};
        optionSelections = new int[optionDefaults.length];
        optionValueStrings = new Object[optionDefaults.length];
        System.arraycopy(optionDefaults, 0, optionSelections, 0, optionSelections.length);
        rmsDataDirty = false;
        rmsData = null;
    }
}

