/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

final class Dialog
extends Entity {
    static final int SCROLLBAR_WIDTH = 8;
    static final int FRAME_COLOR = 0xFFFFFF;
    static final int FADE_COLOR = 0;
    static final int CONTENTS_MARGIN = 6;
    static final int CONTENTS_MARGIN_X2 = 12;
    static final int BOX_MARGIN = 6;
    static final int BOX_MARGIN_X2 = 12;
    static final int FRAME_THICKNESS = 2;
    static final int FRAME_THICKNESS_X2 = 4;
    static final int TITLE_UNDERLINE = 2;
    private static final int TRANSITION_START = 288;
    private static final boolean GUI_PARTICLES = true;
    private static final int MAX_NAME_LENGTH = 16;
    static final int DESTINATION = 0;
    static final int ORIGIN = 1;
    static final int ON_SCREEN = 2;
    static final int COLLAPSED = 3;
    static final int POSITION_COUNT = 4;
    static final int CONTENT_POSITION_COUNT = 2;
    int boxPosition = 2;
    int initScreenModeChangeCount = 0;
    int boxX;
    int boxY;
    int boxWidth;
    int boxHeight;
    int frameColor;
    int boxColor;
    int contentPos;
    int[] boxHeightAnim = new int[4];
    int[] frameColorAnim = new int[4];
    int[] backColorAnim = new int[4];
    int[] contentPosAnim = new int[2];
    private int transitionFactor = 0;
    private int contentTransitionFactor = 0;
    private int itemSpacing = 0;
    private int contentsWidth = 0;
    private int contentsHeight = 0;
    private int scrollVolume = 0;
    private int selectedIndex;
    private int page = 0;
    DialogItem[] items = null;
    private DialogItem title = null;
    private int leftCmd = -1;
    private int rightCmd = -1;
    private DialogItem resultItem = null;
    private int result = -1;
    Entity background = null;
    private static int bgVelX = 500;
    private static int bgVelY = 200;
    private static final int SPRITE_BACK_TILES = 0;
    private static final int SPRITE_BRICKS1 = 1;
    private static final int SPRITE_BRICKS2 = 2;
    private static final int SPRITE_BRICKS3 = 3;
    private static final int SPRITE_BRICKS4 = 4;
    private static final int SPRITE_LOGO = 5;
    private static final int SPRITE_COUNT = 6;
    private static final int SPRITE_BRICK_COUNT = 4;
    private static Sprite2Data[] sprites = null;
    private static final int ID_GAMEOVER_SPRITE = 0;
    private static final int ID_GAMEOVER_MUSIC = 1;
    public static final int[] COLOR_BOX_BACKGROUND = new int[]{1131888, 3821847, 8395541, 6179876};
    static final int[] SCROLLBAR_BACK_COLOR = new int[]{6186, 1585408, 4851712, 2693128};
    static final int[] SCROLLBAR_COLOR1 = new int[]{879526, 5405481, 11868176, 8086338};
    static final int[] SCROLLBAR_COLOR2 = new int[]{1081800, 6460466, 14096403, 9730128};
    static final int MORE_GAMES_MAIN_MENU_INDEX = 6;
    static final int[] MAIN_MENU = new int[]{29, 20, 4, 40, 59, 22, -1, 3};
    private static final int[] PAUSE_MENU = new int[]{13, 20, 4, 12};
    private static final int[] PAUSE_MENU_TUTORIAL = new int[]{13, 79, 20, 4, 12};
    private static final int[] PAUSE_MENU_SIMPLE = new int[]{13, 20, 12};
    private static final int[] PAUSE_MENU_TUTORIAL_SIMPLE = new int[]{13, 79, 20, 12};
    private static final int[] DIFFICULTY_MENU = new int[]{37, 38, 39};
    private static final int[] RESUME_SAVED_GAME_MENU = new int[]{13, 30};
    static final int[] YES_NO = new int[]{18, 19};
    static final int[] NO_YES = new int[]{19, 18};
    private static int mainMenuSelection = 0;
    private static final int BACKGROUND_POS_SHIFT = 4;
    private static final int BACKGROUND_VEL_RANGE = 3;
    private static int[] backgroundMap;
    private static int backgroundTileMapWidth;
    private static int backgroundTileMapHeight;
    private static int backgroundPosX;
    private static int backgroundPosY;
    private static int backgroundUnitWidth;
    private static int backgroundUnitHeight;
    private static int backgroundVelX;
    private static int backgroundVelY;
    private static int backgroundVelXTarget;
    private static int backgroundVelYTarget;
    private static int backgroundTimer;
    private static SceneParticles[] brickParticles;
    private static int[] camRect;

    Dialog() {
    }

    static boolean isResourceLoaded() {
        return sprites != null;
    }

    static void loadResources(int n) throws IOException {
        Storage storage = Storage.loadPackage("/menu", null, false, n);
        sprites = new Sprite2Data[6];
        storage.getFiles(5, 0, sprites);
        Sound.loadSound(15, storage, 20);
        Sound.loadSound(16, storage, 20);
        Dialog.initBackground();
    }

    static void initBackground() {
        int n;
        if (sprites == null) {
            return;
        }
        if (sprites[0] != null) {
            backgroundUnitWidth = Dialog.sprites[0].box[2] << 4;
            backgroundUnitHeight = Dialog.sprites[0].box[3] << 4;
            backgroundTileMapWidth = 2 + Screen.width / Dialog.sprites[0].box[2];
            backgroundTileMapHeight = 2 + Screen.height / Dialog.sprites[0].box[3];
            n = backgroundTileMapWidth * backgroundTileMapHeight;
            if (backgroundMap == null || backgroundMap.length != n) {
                backgroundMap = new int[n];
            }
            for (int i = 0; i < backgroundMap.length; ++i) {
                Dialog.backgroundMap[i] = Game.levelWorld;
            }
            backgroundVelX = 0;
            backgroundVelY = 0;
            backgroundTimer = 0;
        }
        if (sprites[1] != null) {
            if (brickParticles == null) {
                brickParticles = new SceneParticles[4];
                for (n = 0; n < brickParticles.length; ++n) {
                    Dialog.brickParticles[n] = new SceneParticles();
                    brickParticles[n].setType(7);
                    brickParticles[n].create(16);
                    brickParticles[n].setSprite(sprites[1 + n], 0, false);
                    Dialog.brickParticles[n].drag = 245;
                    Dialog.brickParticles[n].animSpeed = 2;
                    Dialog.brickParticles[n].gravity = 3;
                    brickParticles[n].setProperties(27);
                    brickParticles[n].setPosition(0, 0, true);
                    Dialog.brickParticles[n].enabled = true;
                }
            }
            Dialog.camRect[2] = (Screen.width << 8) / 48;
            Dialog.camRect[3] = (Screen.height << 8) / 48;
            Dialog.camRect[4] = camRect[2] >> 1;
            Dialog.camRect[5] = camRect[3] >> 1;
        }
    }

    static void unloadResources() {
        sprites = null;
        Sound.unloadSound(15, true);
        Sound.unloadSound(16, true);
        backgroundMap = null;
        brickParticles = null;
    }

    void initDialog(DialogItem[] dialogItemArray, DialogItem dialogItem, int n, int n2, int n3, int n4) {
        this.reset();
        this.set(n3, true);
        this.items = dialogItemArray;
        this.title = dialogItem;
        this.leftCmd = n;
        this.rightCmd = n2;
        this.itemSpacing = n4;
        this.selectedIndex = -1;
        this.boxPosition = this.isAnyOf(132096) ? 2 : 3;
        this.initDimensions();
    }

    void initCaptionDialog(int n, int n2, int n3, int n4) {
        DialogItem dialogItem = new DialogItem();
        dialogItem.initStringItem(0, n, 1024);
        this.initDialog(new DialogItem[]{dialogItem}, null, n2, n3, n4, 0);
    }

    static DialogItem createTitleItem(int n) {
        DialogItem dialogItem = new DialogItem();
        dialogItem.initStringItem(0, n, 1024);
        return dialogItem;
    }

    static int fullWrapWidth() {
        return Screen.width - 36;
    }

    int getTitlePixelHeight() {
        if (this.title != null) {
            return this.title.getPixelHeight() + 12 + 2;
        }
        return 0;
    }

    int getTitlePixelWidth() {
        if (this.title != null) {
            return this.title.getPixelWidth() + 12;
        }
        return 0;
    }

    void initDimensions() {
        this.initScreenModeChangeCount = Screen.screenModeChangeCounter;
        int n = Dialog.fullWrapWidth();
        if (this.title != null) {
            this.title.initDimensions(n);
        }
        Screen.computeSoftSpace();
        int n2 = this.getTitlePixelHeight();
        int n3 = this.getTitlePixelWidth();
        int n4 = Screen.top + Screen.softSpaceTop;
        if (this.is(256) && Dialog.sprites[5].box[3] <= Screen.height >> 2) {
            n4 += Dialog.sprites[5].box[3] + 6 + 4;
        }
        if (Screen.softSpaceTop == 0) {
            n4 += 6;
        }
        int n5 = Screen.bottom - Screen.softSpaceBottom;
        if (Screen.softSpaceBottom == 0) {
            n5 -= 6;
        }
        int n6 = n5 - n4;
        int n7 = n6 - 4 - n2;
        int n8 = n + 12;
        int n9 = Screen.width >> 1;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            this.items[i].initDimensions(n);
        }
        this.contentsHeight = this.getContentsHeight(false) + 12;
        this.contentsWidth = this.getContentsWidth(false) + 12;
        if (this.contentsWidth < n3) {
            this.contentsWidth = n3;
        }
        if (!this.is(512)) {
            if (this.contentsWidth < n8) {
                n8 = this.contentsWidth;
            }
            if (this.contentsHeight < n7) {
                n7 = this.contentsHeight;
            }
            if (n8 < n9) {
                n8 = n9;
            }
        }
        this.frameColor = 0xFFFFFF;
        this.boxColor = COLOR_BOX_BACKGROUND[Game.levelWorld];
        this.boxHeight = n7 + 4 + n2;
        this.boxWidth = n8 + 4;
        this.scrollVolume = this.contentsHeight - n7;
        if (this.scrollVolume <= 0 || this.is(262144)) {
            this.scrollVolume = 0;
        } else {
            this.boxWidth += 8;
        }
        this.boxX = Screen.hMiddle - (this.boxWidth >> 1);
        this.boxY = n4 + (n6 >> 1);
        this.contentPos = 0;
        this.boxHeightAnim[2] = this.boxHeightAnim[0] = this.boxHeight;
        this.boxHeightAnim[3] = 0;
        this.frameColorAnim[2] = this.frameColorAnim[0] = this.frameColor;
        this.frameColorAnim[3] = 0;
        this.backColorAnim[2] = this.backColorAnim[0] = this.boxColor;
        this.backColorAnim[3] = 0;
        this.contentPosAnim[0] = this.contentPos;
        this.transitionFactor = 0;
        this.contentTransitionFactor = 0;
        this.page = n7 - 12 - Text.lineHeight[0];
        this.setBoxPos(this.boxPosition);
        this.scrollToItem(this.selectedIndex, false);
        this.set(0x400000, true);
    }

    void setBoxPos(int n) {
        this.boxHeight = this.boxHeightAnim[n];
        this.frameColor = this.frameColorAnim[n];
        this.boxColor = this.backColorAnim[n];
        this.transitionFactor = 0;
        this.boxPosition = n;
    }

    void moveBox(int n) {
        this.boxHeightAnim[1] = this.boxHeight;
        this.frameColorAnim[1] = this.frameColor;
        this.backColorAnim[1] = this.boxColor;
        this.boxHeightAnim[0] = this.boxHeightAnim[n];
        this.frameColorAnim[0] = this.frameColorAnim[n];
        this.backColorAnim[0] = this.backColorAnim[n];
        this.transitionFactor = 288;
        this.boxPosition = n;
    }

    void destroy() {
        if (!this.is(1)) {
            this.set(1, true);
            while (!this.is(2)) {
                Thread.yield();
            }
        }
    }

    void finishDialog(boolean bl) {
        boolean bl2 = this.is(524288);
        if (!bl2 || this.leftCmd != -1) {
            Screen.setSoftkeyLabel(0, -1);
        }
        if (!bl2 || this.rightCmd != -1) {
            Screen.setSoftkeyLabel(1, -1);
        }
        if (!this.isAnyOf(0x220000)) {
            this.moveBox(3);
            this.set(0x200000, true);
            if (bl) {
                Screen.show(this, 40, 1, 0);
            }
        }
        if (bl && this.result != -1) {
            Screen.resetKeyClickedState();
        }
    }

    int showDialog(boolean bl, int n) {
        this.result = -1;
        if (this.initScreenModeChangeCount != Screen.screenModeChangeCounter) {
            this.initDimensions();
            Dialog.initBackground();
        }
        if (this.background == null && !this.is(2048)) {
            Game.currentCameraRect = camRect;
            Game.currentCameraX = 0;
            Game.currentCameraY = 0;
        }
        this.set(0x200000, false);
        this.moveBox(2);
        if (bl) {
            Screen.resetKeyClickedState();
            Screen.show(this, 40, 1, n);
        }
        return this.result;
    }

    void endDialog(DialogItem dialogItem, int n) {
        this.resultItem = dialogItem;
        this.result = n;
        this.set(1, true);
    }

    int getResult() {
        return this.result;
    }

    DialogItem getResultItem() {
        return this.resultItem;
    }

    DialogItem getSelectedItem() {
        return this.selectedIndex >= 0 ? this.items[this.selectedIndex] : null;
    }

    int getSelectedIndex() {
        return this.selectedIndex;
    }

    void setSelectedIndex(int n, boolean bl) {
        if (this.selectedIndex >= 0) {
            this.items[this.selectedIndex].select(false);
        }
        if (n >= 0 && this.items[n] != null) {
            if (this.items[n].is(8192)) {
                this.items[n].select(true);
                this.selectedIndex = n;
                this.scrollToItem(n, bl);
            }
        } else {
            this.selectedIndex = -1;
        }
    }

    private int getItemOffset(int n, boolean bl) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.items[i] == null) continue;
            if (n2 != 0) {
                n2 += this.itemSpacing;
            }
            n2 += bl ? this.items[i].getPixelWidth() : this.items[i].getPixelHeight();
        }
        return n2;
    }

    private int getScrollDistance(int n) {
        int n2 = 0;
        if (this.items[n] != null) {
            int n3 = this.getTitlePixelHeight();
            int n4 = this.boxHeightAnim[2] - n3 - 12 - 4;
            int n5 = this.items[n].getPixelHeight();
            int n6 = this.getItemOffset(n, false);
            int n7 = this.contentPosAnim[0] + n6;
            if (this.is(0x100000)) {
                int n8 = (n4 - n5 >> 1) - (n == 0 ? 0 : this.itemSpacing);
                n2 = n8 - n7;
            } else {
                int n9 = n4;
                if (n7 < 0 || n5 > n9) {
                    n2 = -n7;
                } else {
                    int n10 = n9 - n5;
                    if (n7 > n10) {
                        n2 = n10 - n7;
                    }
                }
            }
        }
        return n2;
    }

    void scrollToItem(int n, boolean bl) {
        if (n >= 0) {
            int n2 = this.getScrollDistance(n);
            int n3 = this.contentPosAnim[0];
            if ((n3 += n2) < -this.scrollVolume) {
                n3 = -this.scrollVolume;
            } else if (n3 > 0) {
                n3 = 0;
            }
            if (bl) {
                this.contentPosAnim[1] = this.contentPos;
                this.contentPosAnim[0] = n3;
                this.contentTransitionFactor = 288;
            } else {
                this.contentPos = n3;
            }
        }
    }

    void scrollPage(boolean bl) {
        if (this.scrollVolume > 0) {
            int n = this.contentPosAnim[0];
            if (bl) {
                if ((n -= this.page) < -this.scrollVolume) {
                    n = -this.scrollVolume;
                }
            } else if ((n += this.page) > 0) {
                n = 0;
            }
            this.contentPosAnim[1] = this.contentPos;
            this.contentPosAnim[0] = n;
            this.contentTransitionFactor = 288;
        }
    }

    void menuSelect(boolean bl) {
        if (bl) {
            int n;
            for (n = this.selectedIndex + 1; !(n >= this.items.length || this.items[n] != null && this.items[n].is(8192)); ++n) {
            }
            if (n < this.items.length && this.items[n] != null) {
                this.setSelectedIndex(n, true);
            } else if (this.is(128)) {
                int n2;
                for (n2 = 0; !(n2 >= this.items.length || this.items[n2] != null && this.items[n2].is(8192)); ++n2) {
                }
                if (n2 < this.items.length && this.items[n2] != null) {
                    this.setSelectedIndex(n2, true);
                }
            }
        } else {
            int n;
            for (n = this.selectedIndex - 1; !(n < 0 || this.items[n] != null && this.items[n].is(8192)); --n) {
            }
            if (n >= 0 && this.items[n] != null) {
                this.setSelectedIndex(n, true);
            } else if (this.is(128)) {
                int n3;
                for (n3 = this.items.length - 1; !(n3 < 0 || this.items[n3] != null && this.items[n3].is(8192)); --n3) {
                }
                if (n3 >= 0 && this.items[n3] != null) {
                    this.setSelectedIndex(n3, true);
                }
            }
        }
    }

    void scrollSelect(boolean bl) {
        if (bl) {
            int n;
            for (n = this.selectedIndex + 1; !(n >= this.items.length || this.items[n] != null && this.items[n].is(8192)); ++n) {
            }
            if (n < this.items.length && this.items[n] != null) {
                int n2 = this.getScrollDistance(n);
                if (this.is(8192) || Math.abs(n2) < this.page) {
                    this.setSelectedIndex(n, true);
                } else {
                    this.scrollPage(bl);
                }
            } else if (this.contentPosAnim[0] > -this.scrollVolume) {
                this.scrollPage(bl);
            } else if (this.is(128)) {
                int n3;
                for (n3 = 0; !(n3 >= this.items.length || this.items[n3] != null && this.items[n3].is(8192)); ++n3) {
                }
                if (n3 < this.items.length && this.items[n3] != null) {
                    this.setSelectedIndex(n3, true);
                }
            }
        } else {
            int n;
            for (n = this.selectedIndex - 1; !(n < 0 || this.items[n] != null && this.items[n].is(8192)); --n) {
            }
            if (n >= 0 && this.items[n] != null) {
                int n4 = this.getScrollDistance(n);
                if (this.is(8192) || Math.abs(n4) < this.page) {
                    this.setSelectedIndex(n, true);
                } else {
                    this.scrollPage(bl);
                }
            } else if (this.contentPosAnim[0] < 0) {
                this.scrollPage(bl);
            } else if (this.is(128)) {
                int n5;
                for (n5 = this.items.length - 1; !(n5 < 0 || this.items[n5] != null && this.items[n5].is(8192)); --n5) {
                }
                if (n5 >= 0 && this.items[n5] != null) {
                    this.setSelectedIndex(n5, true);
                }
            }
        }
    }

    private int getContentsWidth(boolean bl) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            n2 = this.items[i].getPixelWidth();
            if (bl) {
                if (n != 0) {
                    n += this.itemSpacing;
                }
                n += n2;
                continue;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int getContentsHeight(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            int n2 = this.items[i].getPixelHeight();
            if (bl) {
                if (n2 <= n) continue;
                n = n2;
                continue;
            }
            if (n != 0) {
                n += this.itemSpacing;
            }
            n += n2;
        }
        return n;
    }

    void update() {
        int n;
        if (this.initScreenModeChangeCount != Screen.screenModeChangeCounter) {
            this.initDimensions();
            Dialog.initBackground();
        }
        this.updateBackground();
        if (this.transitionFactor > 0) {
            this.transitionFactor -= 32;
            if (this.transitionFactor < 0) {
                this.transitionFactor = 0;
            }
            int n2 = n = this.transitionFactor == 256 ? 256 : Entity.getRestitutedValue2(this.transitionFactor);
            if (n == 0) {
                this.transitionFactor = 0;
            }
            if (!this.is(1024)) {
                if (this.boxHeight != this.boxHeightAnim[0]) {
                    this.boxHeight = this.boxHeightAnim[1] * n + this.boxHeightAnim[0] * (256 - n) >> 8;
                }
                if (this.frameColor != this.frameColorAnim[0]) {
                    this.frameColor = Entity.blendColors(this.frameColorAnim[1], this.frameColorAnim[0], n);
                }
                if (this.boxColor != this.backColorAnim[0]) {
                    this.boxColor = Entity.blendColors(this.backColorAnim[1], this.backColorAnim[0], n);
                }
            }
        }
        if (this.contentTransitionFactor > 0) {
            this.contentTransitionFactor -= 32;
            if (this.contentTransitionFactor < 0) {
                this.contentTransitionFactor = 0;
            }
            if (this.contentPos != this.contentPosAnim[0]) {
                n = this.contentTransitionFactor == 256 ? 256 : Entity.getRestitutedValue2(this.contentTransitionFactor);
                this.contentPos = this.contentPosAnim[1] * n + this.contentPosAnim[0] * (256 - n) >> 8;
            }
        }
        if (!this.is(0x200000)) {
            for (n = 0; n < this.items.length; ++n) {
                if (this.items[n] == null) continue;
                this.items[n].update(this);
            }
            int n3 = n = this == Screen.rootEntity ? 1 : 0;
            if (n != 0) {
                int n4 = Screen.getKeysClicked();
                if (n4 != 0) {
                    if ((n4 & 0x2000300) != 0) {
                        if (this.leftCmd != -1) {
                            this.endDialog(this.selectedIndex < 0 ? null : this.items[this.selectedIndex], this.leftCmd);
                        }
                    } else if ((n4 & 0x400) != 0) {
                        if (this.rightCmd != -1) {
                            this.endDialog(this.selectedIndex < 0 ? null : this.items[this.selectedIndex], this.rightCmd);
                        }
                    } else if ((n4 & 0x10000040) != 0) {
                        this.scrollSelect(true);
                    } else if ((n4 & 0x400002) != 0) {
                        this.scrollSelect(false);
                    } else if ((n4 & 0x4000020) != 0 && this.is(0x800000)) {
                        this.endDialog(this.selectedIndex < 0 ? null : this.items[this.selectedIndex], -12);
                    } else if ((n4 & 0x1000004) != 0 && this.is(0x1000000)) {
                        this.endDialog(this.selectedIndex < 0 ? null : this.items[this.selectedIndex], -13);
                    }
                }
                boolean bl = false;
                boolean bl2 = this.is(524288);
                int n5 = this.selectedIndex >= 0 && this.items[this.selectedIndex].getLeftCmd() != -1 ? this.items[this.selectedIndex].getLeftCmd() : this.leftCmd;
                if (!bl2 || n5 != -1) {
                    Screen.setSoftkeyLabel(0, n5);
                }
                bl |= n5 == -23;
                n5 = this.selectedIndex >= 0 && this.items[this.selectedIndex].getRightCmd() != -1 ? this.items[this.selectedIndex].getRightCmd() : this.rightCmd;
                if (!bl2 || n5 != -1) {
                    Screen.setSoftkeyLabel(1, n5);
                }
                if ((bl |= n5 == -23) && (n4 & 0x40000) != 0) {
                    this.endDialog(this.selectedIndex < 0 ? null : this.items[this.selectedIndex], -23);
                }
            }
        } else if (this.transitionFactor == 0) {
            this.set(1, true);
        }
    }

    void paint(Graphics graphics) {
        if (this.background != null) {
            this.background.paint(graphics);
            this.background.paintOverlay(graphics);
        } else {
            if (!this.is(2048)) {
                this.paintBackground(graphics);
            } else {
                Screen.clear(graphics, this.getBackColor());
            }
            if (!this.is(4096)) {
                this.paintParticles(graphics, 0);
            }
            if (this.is(256) && Dialog.sprites[5].box[3] <= Screen.height >> 2) {
                short s = Dialog.sprites[5].box[3];
                int n = Screen.top + (Screen.softSpaceTop == 0 ? 6 : Screen.softSpaceTop);
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(Screen.left, n, Screen.width, 2);
                graphics.fillRect(Screen.left, (n += 2) + s, Screen.width, 2);
                graphics.setColor(COLOR_BOX_BACKGROUND[Game.levelWorld]);
                graphics.fillRect(Screen.left, n, Screen.width, (int)s);
                sprites[5].paint(graphics, Screen.hMiddle - (Dialog.sprites[5].box[2] >> 1), n, 1, 0);
            }
            if (!this.is(4096)) {
                this.paintParticles(graphics, 1);
            }
        }
    }

    void paintOverlay(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        int n5 = this.getColor();
        int n6 = this.getShadowColor();
        int n7 = this.boxX;
        int n8 = this.boxY - (this.boxHeight >> 1);
        int n9 = this.boxWidth;
        int n10 = this.boxHeight;
        boolean bl2 = bl = !this.is(1024);
        if (bl) {
            Screen.drawFramedBox(graphics, n7, n8, n9, n10, 2, this.boxColor, n5);
        }
        int n11 = (n7 += 2) + ((n9 -= 4) >> 1);
        int n12 = n7 + 6;
        int n13 = 0;
        n13 += this.boxY - (this.boxHeightAnim[2] >> 1) + 2;
        Screen.pushClip(graphics, n7, n8 += 2, n9, n10 -= 4);
        if (this.title != null) {
            n4 = this.getTitlePixelHeight();
            graphics.setColor(n5);
            graphics.fillRect(n7, n13 + n4 - 2, n9, 2);
            n3 = this.title.is(1024) ? n11 : n12;
            this.title.paint(graphics, this.title.is(1024) ? n11 : n12, n13 + 6, n5, n6);
            n13 += n4;
            n10 -= n4;
            n8 += n4;
        }
        if (this.scrollVolume > 0) {
            n9 -= 8;
            n4 = n10 * n10 / this.contentsHeight - 2;
            if (n4 <= 0) {
                n4 = 1;
            }
            n3 = n10 - n4 - 2;
            n2 = -(this.contentPos * n3) / this.scrollVolume;
            graphics.setColor(SCROLLBAR_BACK_COLOR[Game.levelWorld]);
            n = n7 + n9;
            graphics.fillRect(n, n8, 8, n10);
            graphics.setColor(Screen.anim == 0 ? SCROLLBAR_COLOR1[Game.levelWorld] : SCROLLBAR_COLOR2[Game.levelWorld]);
            graphics.fillRect(n + 1, n8 + n2 + 1, 6, n4);
        }
        Screen.clipRect(graphics, n7, n8, n9, n10);
        n4 = this.contentPos + n13 + 6;
        graphics.setColor(n5);
        for (n = 0; n < this.items.length; ++n) {
            if (this.items[n] == null) continue;
            n3 = this.items[n].getPixelHeight();
            if (n4 + n3 > Screen.clipTop) {
                if (n4 >= Screen.clipBottom) break;
                n2 = this.items[n].is(1024) ? n11 : n12;
                this.items[n].paint(graphics, n2, n4, n5, n6);
            }
            n4 += n3 + this.itemSpacing;
        }
        Screen.popClip(graphics, true);
    }

    boolean mustScroll() {
        return this.scrollVolume != 0;
    }

    int getWidth() {
        return this.background != null ? this.background.getWidth() : 0;
    }

    int getHeight() {
        return this.background != null ? this.background.getHeight() : 0;
    }

    int getColor() {
        return this.frameColor;
    }

    void optionChanged(int n, int n2, int n3) {
        boolean bl = !this.is(0x400000);
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            this.items[i].optionChanged(n, n2, 0);
            bl |= !this.items[i].is(0x400000);
        }
        if (n == 5) {
            bl = true;
            Dialog.initBackground();
        } else if (n == 3) {
            bl = true;
        } else if (n == 2) {
            Screen.vibrate(500);
        }
        if (this.background != null) {
            this.background.optionChanged(n, n2, 0);
        }
        if (bl) {
            this.initDimensions();
        }
        Screen.advanceProgress(n3);
    }

    void beep() {
        if (Storage.isOptionOn(0) && (!Sound.isLoaded(15) || this.is(64))) {
            Sound.play(16, true, 0);
        }
    }

    void initMenu(int[] nArray, DialogItem dialogItem, int n, int n2) {
        DialogItem[] dialogItemArray = new DialogItem[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0 && (nArray[i] != 46 || Screen.mgSetup != 0)) {
                dialogItemArray[i] = new DialogItem();
                dialogItemArray[i].initStringItem(nArray[i], nArray[i], 9216);
                dialogItemArray[i].setCommands(-24, -1);
                continue;
            }
            dialogItemArray[i] = null;
        }
        this.initDialog(dialogItemArray, dialogItem, -1, n, n2 | 0x2000 | 0x80 | 0x100000, 0);
        this.setSelectedIndex(0, false);
    }

    static int showMainMenu() throws IOException {
        int n;
        int n2;
        int n3 = 256;
        if (!Dialog.isResourceLoaded()) {
            Dialog.loadResources(Screen.initProgress());
            Screen.endProgress(true);
        }
        Dialog.initBackground();
        Screen.viewTrack = null;
        Dialog dialog = new Dialog();
        Dialog.playMenuMusic();
        boolean bl = true;
        do {
            n = 3;
            if (bl) {
                dialog.initMenu(MAIN_MENU, null, -22, n3);
                bl = false;
            }
            dialog.setSelectedIndex(mainMenuSelection, false);
            n2 = dialog.showDialog(true, 0);
            dialog.finishDialog(true);
            mainMenuSelection = dialog.getSelectedIndex();
            if (n2 == -24) {
                n = dialog.getSelectedItem().id;
                if (n == 29) {
                    Dialog dialog2;
                    int n4 = 30;
                    Game.loadGame();
                    if (Game.currentLevel > 0) {
                        dialog2 = new Dialog();
                        dialog2.initMenu(RESUME_SAVED_GAME_MENU, null, -23, n3);
                        do {
                            n4 = dialog2.showDialog(true, 0);
                            dialog2.finishDialog(true);
                            if (n4 != -24 || (n4 = dialog2.getSelectedItem().id) != 30 || Dialog.choice(65568, NO_YES, dialog2, n3) != 19) continue;
                            n4 = 19;
                        } while (n4 == 19);
                    }
                    if (n4 == 30) {
                        dialog2 = new Dialog();
                        dialog2.initMenu(DIFFICULTY_MENU, Dialog.createTitleItem(30), -23, n3);
                        dialog2.setSelectedIndex(Game.levelDifficulty, false);
                        n4 = dialog2.showDialog(true, 0);
                        dialog2.finishDialog(true);
                        if (n4 == -24) {
                            Game.resetGame(dialog2.getSelectedIndex(), true);
                        }
                    }
                    if (n4 != -23) {
                        n2 = -1;
                    }
                } else if (n == 3) {
                    n2 = -22;
                } else {
                    Dialog.showScreen(n, null, n3);
                    if (n == 4) {
                        bl = true;
                    }
                }
            }
            if (n2 != -22) continue;
            Dialog.stopMenuMusic();
            if (Dialog.choice(16, NO_YES, null, n3) == 18) continue;
            n2 = -24;
            Dialog.playMenuMusic();
        } while (n2 == -24);
        Dialog.stopMenuMusic();
        return n;
    }

    static boolean showMoreGames() {
        int n = 0;
        Screen.fadeOut(false, COLOR_BOX_BACKGROUND[Game.levelWorld], 0);
        Object var1_1 = null;
        Screen.fadeIn(0, Game.WORLD_BACK_COLOR[Game.levelWorld]);
        DialogItem[] dialogItemArray = new DialogItem[3];
        dialogItemArray[1] = new DialogItem(0, 0, 2, 2);
        int n2 = 0;
        if (Screen.mgProducts.length > 1) {
            dialogItemArray[0] = new DialogItem().initArrowItem(15, 2, 3, 128);
            dialogItemArray[2] = new DialogItem().initArrowItem(15, 0, 3, 128);
        } else {
            dialogItemArray[0] = null;
            dialogItemArray[2] = null;
            if (Screen.mgProducts.length > 1) {
                n2 |= 0x44000;
            }
        }
        DialogItem dialogItem = new DialogItem().initCompositeItem(0, dialogItemArray, 66560);
        DialogItem dialogItem2 = new DialogItem();
        DialogItem[] dialogItemArray2 = new DialogItem[4];
        dialogItemArray2[2] = new DialogItem();
        dialogItemArray2[3] = new DialogItem();
        for (int i = 0; i < dialogItemArray2.length; ++i) {
            dialogItemArray2[i] = new DialogItem();
        }
        Dialog dialog = new Dialog();
        dialog.initDialog(dialogItemArray2, Dialog.createTitleItem(46), -24, -23, 25174016, 0);
        int n3 = 0;
        int n4 = 2;
        do {
            int n5 = 0;
            dialogItem2.initStringItem(0, Screen.getMoreGamesString(n3, 50), 1024);
            dialogItem2.setFormat(0, 0, 0, 0);
            dialogItemArray2[n5] = dialogItem2;
            dialogItemArray[1].initStringItem(0, Screen.getMoreGamesString(n3, 65587), n2 | 0x80);
            dialogItem.setFormat(4, 4, 0, 0);
            dialogItemArray2[++n5] = dialogItem;
            ++n5;
            if (Screen.mgBuyURI != null && Screen.mgBuyURI[n3] != null) {
                dialogItemArray2[n5].initStringItem(1, 48, 9216);
            } else {
                dialogItemArray2[n5].initSpacerItem(0);
                n4 = n5 + 1;
            }
            ++n5;
            if (Screen.mgSetup != 1 || Screen.mgCatURI != null && Screen.mgCatURI[n3] != null) {
                dialogItemArray2[n5].initStringItem(2, Screen.getMoreGamesString(n3, 52), 9216);
            } else {
                dialogItemArray2[n5].initSpacerItem(0);
                n4 = n5 - 1;
            }
            ++n5;
            dialog.initDimensions();
            dialog.setSelectedIndex(n4, false);
            int n6 = dialog.showDialog(true, 0);
            n4 = dialog.getSelectedIndex();
            if (n6 == -24) {
                dialog.finishDialog(true);
                int n7 = dialog.getSelectedItem().id;
                String string = null;
                string = Screen.mgBuyURI != null ? (n7 == 1 ? Screen.mgBuyURI[n3] : Screen.mgCatURI[n3]) : null;
                if (string != null) {
                    Dialog.stopMenuMusic();
                    if (Dialog.choice(65583, NO_YES, null, n) == 18 && Screen.launchUrl(string)) {
                        return true;
                    }
                    Dialog.playMenuMusic();
                }
                if (string != null) continue;
                Dialog.popup(65585, 0, n, null);
                continue;
            }
            if (n6 == -23) {
                n3 = -1;
                continue;
            }
            if (n6 == -13) {
                if (--n3 >= 0) continue;
                n3 = Screen.mgProducts.length - 1;
                continue;
            }
            if (n6 != -12 || ++n3 < Screen.mgProducts.length) continue;
            n3 = 0;
        } while (n3 >= 0);
        dialog.finishDialog(true);
        Screen.fadeOut(false, Game.WORLD_BACK_COLOR[Game.levelWorld], 0);
        Screen.fadeIn(0, COLOR_BOX_BACKGROUND[Game.levelWorld]);
        return false;
    }

    static void showScreen(int n, Entity entity, int n2) {
        if (n == 4) {
            Dialog.showOptions(entity, n2);
        } else if (n == 20) {
            Dialog.showHelp(entity, n2);
        } else if (n == 59) {
            Dialog.showAchievements(entity, n2, false, Game.achievementsUnlocked);
        } else if (n == 40) {
            Dialog.showHighscores(entity, n2);
        } else if (n == 22) {
            Dialog.showAbout(entity, n2);
        }
    }

    static void showAchievements(Entity entity, int n, boolean bl, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = n2; n4 != 0; n4 >>>= 1) {
            if ((n4 & 1) == 0) continue;
            ++n5;
        }
        n4 = bl ? n5 : Game.ACHIEVEMENT_ENABLED_COUNT + 3;
        int n6 = bl ? 0 : 3;
        DialogItem[] dialogItemArray = new DialogItem[n4 << 1];
        int n7 = n2;
        int n8 = 0;
        while (n7 != 0) {
            if ((n7 & 1) != 0) {
                Object object = Game.getAchievementText(n8);
                dialogItemArray[n6] = new DialogItem(n6 == 0 ? 0 : 2, 0, 0, 0).initStringItem(0, object, -1, 1024);
                dialogItemArray[++n6] = new DialogItem().initEntityItem(0, Game.getAchievementValueEntity(n8, Screen.achievements, 2), 1024);
                ++n6;
            }
            n7 >>>= 1;
            ++n8;
        }
        if (!bl) {
            int n9 = 0;
            int n10 = 0;
            int n11 = n2;
            for (int i = 0; i < Game.ACHIEVEMENT_COUNT; ++i) {
                if (Game.ACHIEVEMENTS[i * 7 + 6] == 0) {
                    int n12 = Game.ACHIEVEMENTS[i * 7 + 2];
                    if ((n11 & 1) == 0) {
                        Object object = Game.getAchievementText(i);
                        dialogItemArray[n6] = new DialogItem(n6 == 0 ? 0 : 4, 0, 0, 0).initStringItem(0, object, -1, 1024);
                        dialogItemArray[++n6] = new DialogItem().initEntityItem(0, Game.getAchievementValueEntity(i, Screen.achievements, 1), 1024);
                        ++n6;
                        n9 += n12;
                    } else {
                        n10 += n12;
                    }
                }
                n11 >>>= 1;
            }
            DialogItem[] dialogItemArray2 = new DialogItem[2];
            Sprite2 sprite2 = new Sprite2(Screen.achievements);
            sprite2.frame = (byte)2;
            dialogItemArray2[0] = new DialogItem().initEntityItem(0, sprite2, 128);
            int n13 = Text.getChar(':', 0);
            int n14 = Text.getChar('/', 0);
            Object object = Text.assertTextSize(null, 7);
            object = Text.copyChar(n13, object, 0);
            object = Text.convertNumber(n10, 1, object, Text.appendPos + 1);
            object = Text.copyChar(n14, object, Text.appendPos);
            object = Text.convertNumber(n9 + n10, 1, object, Text.appendPos);
            dialogItemArray2[1] = new DialogItem(0, 0, 0, 2).initStringItem(0, object, -1, 128);
            dialogItemArray[0] = new DialogItem().initStringItem(0, 65596, 0);
            dialogItemArray[1] = new DialogItem(2, 2, 0, 0).initCompositeItem(0, dialogItemArray2, 66560);
            dialogItemArray[2] = new DialogItem().initStringItem(0, 59, 0);
            n7 = 59;
            n8 = -1;
            n3 = -23;
        } else {
            n7 = 61;
            n8 = -24;
            n3 = -1;
        }
        Dialog dialog = new Dialog();
        dialog.background = entity;
        dialog.initDialog(dialogItemArray, Dialog.createTitleItem(n7), n8, n3, n, 0);
        dialog.showDialog(true, 0);
        dialog.finishDialog(true);
    }

    static void showHighscores(Entity entity, int n) {
        int n2;
        Dialog dialog = new Dialog();
        dialog.background = entity;
        dialog.initMenu(DIFFICULTY_MENU, Dialog.createTitleItem(41), -23, n);
        int n3 = -1;
        Dialog dialog2 = null;
        DialogItem[] dialogItemArray = null;
        do {
            int n4;
            n2 = dialog.showDialog(true, 0);
            dialog.finishDialog(true);
            if (n2 == -23) continue;
            int n5 = dialog.getSelectedIndex();
            if (dialog2 == null) {
                dialog2 = new Dialog();
                dialog2.background = entity;
                dialogItemArray = new DialogItem[Game.highscoreValues.length << 1];
                n4 = 0;
                while (n4 < dialogItemArray.length) {
                    dialogItemArray[n4++] = new DialogItem(n4 == 0 ? 0 : 4, 0, 0, 0);
                    dialogItemArray[n4++] = new DialogItem();
                }
            }
            if (n5 != n3) {
                Game.loadHighScores(n5, 0);
                n4 = 0;
                for (int i = 0; i < Game.highscoreValues.length; ++i) {
                    dialogItemArray[n4].initStringItem(0, Game.highscoreNames[i], -1, 1024);
                    Object object = Text.convertNumber(Game.highscoreValues[i], 1, null, 0);
                    dialogItemArray[++n4].initStringItem(0, object, -1, 1024);
                    ++n4;
                }
                n3 = n5;
            }
            dialog2.initDialog(dialogItemArray, Dialog.createTitleItem(40), -1, -23, n, 0);
            dialog2.showDialog(true, 0);
            dialog2.finishDialog(true);
        } while (n2 != -23);
    }

    static Object showEnterHighscores(Entity entity, int n, Object object) throws IOException {
        int n2;
        if (!Dialog.isResourceLoaded()) {
            Dialog.loadResources(Screen.initProgress());
            Screen.endProgress(true);
        }
        int n3 = Text.getTextLength(43);
        DialogItem[] dialogItemArray = new DialogItem[n3 + 1];
        int n4 = -Screen.arrows.box[2] >> 1;
        for (n2 = 0; n2 < n3; ++n2) {
            dialogItemArray[n2] = new DialogItem(0, 0, n4, n4);
            dialogItemArray[n2].initCharItem(0, Text.getCharAt(43, n2), 8192);
        }
        dialogItemArray[n2] = new DialogItem();
        dialogItemArray[n2].initStringItem(44, 44, 8192);
        dialogItemArray[n2].setShortcut(524288);
        DialogItem[] dialogItemArray2 = new DialogItem[3];
        dialogItemArray2[0] = new DialogItem();
        dialogItemArray2[0].initCompositeItem(0, dialogItemArray, 1647616);
        int n5 = Text.getTextLength(object);
        dialogItemArray2[1] = new DialogItem();
        dialogItemArray2[1].initStringItem(0, object, n5, 0x800400);
        dialogItemArray2[2] = new DialogItem();
        dialogItemArray2[2].initStringItem(45, 45, 9216);
        Dialog dialog = new Dialog();
        dialog.initDialog(dialogItemArray2, Dialog.createTitleItem(42), -24, -1, n | 0x2000 | 0x80, 2);
        dialog.background = entity;
        int n6 = -1;
        int n7 = 0;
        dialog.setSelectedIndex(n7, false);
        do {
            int n8 = -1;
            n6 = dialog.showDialog(true, 0);
            if (n6 == -24) {
                n7 = dialog.getSelectedItem().id;
                if (n7 == 45) {
                    n6 = 45;
                } else {
                    DialogItem dialogItem = dialogItemArray[dialogItemArray2[0].selection];
                    if (dialogItem.id == 44) {
                        n6 = 44;
                    } else {
                        n8 = dialogItem.getChar();
                    }
                }
            } else if (n6 == -2) {
                n6 = dialog.getResultItem().id;
            }
            boolean bl = false;
            if (n6 == 44) {
                if (n5 > 0) {
                    Text.delete(object, --n5, 1);
                    bl = true;
                }
            } else if (n8 >= 0 && n5 < 16 && (n8 != 0 || n5 != 0)) {
                object = Text.copyChar(n8, object, n5);
                ++n5;
                bl = true;
            }
            if (!bl) continue;
            dialogItemArray2[1].initStringItem(0, object, n5, 0x800400);
            dialogItemArray2[1].initDimensions(Dialog.fullWrapWidth());
        } while (n6 != 45);
        dialog.finishDialog(true);
        return object;
    }

    static void showOptions(Entity entity, int n) {
        int n2;
        int n3 = 0;
        int n4 = (n & 0x40) != 0 ? 2 : 1;
        for (n2 = 0; n2 < Storage.optionEnabled.length; ++n2) {
            if ((Storage.optionEnabled[n2] & n4) == 0) continue;
            ++n3;
        }
        n2 = 0;
        DialogItem[] dialogItemArray = new DialogItem[n3];
        for (int i = 0; i < Storage.optionValues.length; ++i) {
            if ((Storage.optionEnabled[i] & n4) == 0) continue;
            dialogItemArray[n2] = new DialogItem();
            if (Storage.optionValues[i] == null || Storage.optionValues[i][0] == -101) {
                dialogItemArray[n2].initStringItem(i, Storage.optionStrings[i], 9216);
                dialogItemArray[n2].setCommands(-24, -1);
            } else {
                dialogItemArray[n2].initOptionItem(i, 9216);
            }
            ++n2;
        }
        Dialog dialog = new Dialog();
        dialog.initDialog(dialogItemArray, Dialog.createTitleItem(4), -1, -23, n | 0x2000 | 0x80 | 0x100000, 4);
        dialog.background = entity;
        int n5 = -1;
        int n6 = 0;
        while (n5 == -1) {
            int n7;
            dialog.setSelectedIndex(n6, false);
            n5 = dialog.showDialog(true, 0);
            n6 = dialog.getSelectedIndex();
            if (n5 != -24) continue;
            dialog.finishDialog(true);
            DialogItem dialogItem = dialog.getResultItem();
            if (dialogItem.id == 4) {
                if (Dialog.choice(65550, NO_YES, dialog, n) == 18) {
                    Screen.fadeOut(false, COLOR_BOX_BACKGROUND[Game.levelWorld], 0);
                    Storage.masterReset(Screen.initProgress());
                    dialog.initDimensions();
                    Screen.endProgress(true);
                    Screen.fadeIn(0, COLOR_BOX_BACKGROUND[Game.levelWorld]);
                }
            } else if (dialogItem.id == 3 && (n7 = Dialog.showLanguageSelection(null, 256)) >= 0) {
                Screen.fadeOut(false, COLOR_BOX_BACKGROUND[Game.levelWorld], 0);
                try {
                    Text.loadText(n7, Screen.initProgress());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException(iOException.getMessage());
                }
                Storage.setOptionValue(3, n7, 0, true, true);
                dialog.initDimensions();
                Screen.endProgress(true);
                Screen.fadeIn(0, COLOR_BOX_BACKGROUND[Game.levelWorld]);
            }
            n5 = -1;
        }
        dialog.finishDialog(true);
    }

    static void showAbout(Entity entity, int n) {
        DialogItem[] dialogItemArray = new DialogItem[4];
        int n2 = 0;
        dialogItemArray[n2] = new DialogItem();
        String string = Screen.theMidlet.getAppProperty("MIDlet-Name");
        if (string == null) {
            dialogItemArray[n2].initStringItem(0, 65559, 131072);
        } else {
            dialogItemArray[n2].initStringItem(0, Text.convertString(string, null, 0, 0), -1, 131072);
        }
        ++n2;
        String string2 = Screen.theMidlet.getAppProperty("MIDlet-Version");
        if (string2 != null) {
            int n3 = Text.getTextLength(24) + string2.length() + 1;
            Object object = Text.assertTextSize(null, n3);
            object = Text.copy(24, object, 0);
            object = Text.convertString(string2, object, Text.appendPos + 1, 0);
            dialogItemArray[n2] = new DialogItem();
            dialogItemArray[n2].initStringItem(0, object, -1, 131072);
        } else {
            dialogItemArray[n2] = null;
        }
        dialogItemArray[++n2] = new DialogItem();
        dialogItemArray[n2].initStringItem(0, 65561, 131072);
        Dialog dialog = new Dialog();
        dialog.background = entity;
        dialog.initDialog(dialogItemArray, Dialog.createTitleItem(22), -1, -23, n, 2);
        dialog.showDialog(true, 0);
        dialog.finishDialog(true);
    }

    static void showPauseMenu() {
        int n;
        Sound.setMusic(-1, 2);
        Dialog dialog = new Dialog();
        dialog.background = Entity.game;
        int n2 = 0;
        boolean bl = true;
        do {
            if (bl) {
                dialog.initMenu(Game.tutorialMode ? PAUSE_MENU_TUTORIAL : PAUSE_MENU, null, -23, 64);
                bl = false;
            }
            dialog.setSelectedIndex(n2, false);
            n = dialog.showDialog(true, 0);
            dialog.finishDialog(true);
            n2 = dialog.getSelectedIndex();
            if (n == -24) {
                int n3 = dialog.getSelectedItem().id;
                if (n3 == 13) {
                    n = -23;
                } else if (n3 == 79) {
                    Game.tutorialMode = false;
                    n = -23;
                } else if (n3 == 12) {
                    if (Dialog.choice(65551, NO_YES, Entity.game, 64) == 18) {
                        n = -1;
                        if (Screen.rootEntity instanceof Dialog) {
                            Dialog dialog2 = (Dialog)Screen.rootEntity;
                            dialog2.set(0x200000, true);
                            dialog2.endDialog(null, -1);
                        }
                        Game.exit();
                    }
                } else if (n3 == 4) {
                    Sound.setMusic(65549, 2);
                    Dialog.showOptions(Entity.game, 64);
                    bl = true;
                } else {
                    Dialog.showScreen(n3, Entity.game, 64);
                }
            }
            if (n != -23) continue;
            dialog.finishDialog(true);
            Sound.setMusic(65549, 2);
        } while (n == -24);
    }

    static void showLevelDialog(int n, int n2) {
        DialogItem[] dialogItemArray = new DialogItem[2];
        int n3 = 0;
        Object object = Text.assertTextSize(null, Text.getTextLength(33) + 2);
        object = Text.copy(33, object, 0);
        object = Text.convertNumber(n2 + 1, 0, object, Text.appendPos + 1);
        dialogItemArray[n3] = new DialogItem().initStringItem(0, object, -1, 1024);
        object = Text.assertTextSize(null, Text.getTextLength(34) + 3);
        object = Text.copy(34, object, 0);
        object = Text.convertNumber(n + 1 - Game.LEVELS_PER_WORLD * n2, 0, object, Text.appendPos + 1);
        dialogItemArray[++n3] = new DialogItem().initStringItem(0, object, -1, 1024);
        Dialog dialog = new Dialog();
        dialog.background = Entity.game;
        dialog.initDialog(dialogItemArray, null, -1, -1, 0, 0);
        dialog.showDialog(true, 2000);
        dialog.finishDialog(true);
    }

    static void showHelp(Entity entity, int n) {
        DialogItem[] dialogItemArray = new DialogItem[]{new DialogItem()};
        dialogItemArray[0].initStringItem(0, 65557, 131072);
        Dialog dialog = new Dialog();
        dialog.background = entity;
        dialog.initDialog(dialogItemArray, Dialog.createTitleItem(20), -1, -23, n, 2);
        dialog.showDialog(true, 0);
        dialog.finishDialog(true);
    }

    static int choice(int n, int[] nArray, Entity entity, int n2) {
        DialogItem[] dialogItemArray = new DialogItem[nArray.length + 1];
        dialogItemArray[0] = new DialogItem(0, 4, 0, 0);
        dialogItemArray[0].initStringItem(0, n, 1024);
        for (int i = 0; i < nArray.length; ++i) {
            dialogItemArray[i + 1] = new DialogItem();
            dialogItemArray[i + 1].initStringItem(nArray[i], nArray[i], 9216);
        }
        Dialog dialog = new Dialog();
        dialog.background = entity;
        dialog.initDialog(dialogItemArray, null, -24, -1, n2 | 0x2000 | 0x80, 0);
        dialog.setSelectedIndex(1, false);
        int n3 = dialog.showDialog(true, 0);
        dialog.finishDialog(true);
        return dialog.getSelectedItem().id;
    }

    static boolean popup(int n, int n2, int n3, Entity entity) {
        Dialog dialog = new Dialog();
        dialog.background = entity;
        dialog.initCaptionDialog(n, n2 == 0 || (n3 & 0x10) != 0 ? -24 : -1, -1, n3);
        int n4 = dialog.showDialog(true, n2);
        dialog.finishDialog(true);
        return n4 == -24;
    }

    static int showLanguageSelection(Entity entity, int n) {
        int n2 = Text.getLoadedText();
        int n3 = Storage.getOption(3);
        if (n3 < 0) {
            n3 = 0;
        }
        DialogItem[] dialogItemArray = new DialogItem[Text.languageCount];
        for (int i = 0; i < Text.languageCount; ++i) {
            dialogItemArray[i] = new DialogItem();
            dialogItemArray[i].initStringItem(i, Text.localeStrings[i], -1, 9216);
        }
        Dialog dialog = new Dialog();
        dialog.initDialog(dialogItemArray, null, -24, n3 != n2 ? -1 : -23, n | 0x2000 | 0x80 | 0x100000, 2);
        dialog.background = entity;
        dialog.setSelectedIndex(n3, false);
        if (dialog.showDialog(true, 0) == -24) {
            n3 = dialog.getSelectedIndex();
        }
        dialog.finishDialog(true);
        if (n3 != n2) {
            return n3;
        }
        return -1;
    }

    static boolean showGameOverRetry(boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        Sprite2 sprite2 = null;
        try {
            Storage storage = Storage.loadPackage(bl ? "/win" : "/lose", null, false, Screen.initProgress());
            Screen.endProgress(true);
            Sound.loadSound(14, storage, 20);
            Sound.setMusic(14, 2);
            sprite2 = new Sprite2(storage.getSpriteData(0));
            sprite2.set(32, true);
            Screen.initScene(sprite2, 3);
            Screen.show(sprite2, 40, 1, 1500);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (bl) {
            Dialog.popup(65572, 0, 6176, sprite2);
            bl2 = false;
        } else {
            bl2 = Dialog.choice(65571, YES_NO, sprite2, 6176) == 18;
        }
        Sound.unloadSound(14, false);
        return bl2;
    }

    private void updateBackground() {
        if (this.background != null) {
            this.background.update();
            if (this.is(16384)) {
                int n = Screen.viewLeft;
                int n2 = Screen.viewTop;
                Screen.moveView(bgVelX, bgVelY, true);
                if (n == Screen.viewLeft) {
                    bgVelX *= -1;
                }
                if (n2 == Screen.viewTop) {
                    bgVelY *= -1;
                }
            }
        } else {
            int n;
            int n3;
            int n4;
            if (!this.is(2048)) {
                int n5;
                if (--backgroundTimer < 0) {
                    backgroundTimer = 100;
                    backgroundVelXTarget = ((Entity.random.nextInt() & 0x1FF) - 256) * 48 >> 8;
                    backgroundVelYTarget = ((Entity.random.nextInt() & 0x1FF) - 256) * 48 >> 8;
                }
                if (backgroundVelX > backgroundVelXTarget) {
                    --backgroundVelX;
                }
                if (backgroundVelX < backgroundVelXTarget) {
                    ++backgroundVelX;
                }
                if (backgroundVelY > backgroundVelYTarget) {
                    --backgroundVelY;
                }
                if (backgroundVelY < backgroundVelYTarget) {
                    ++backgroundVelY;
                }
                backgroundPosY += backgroundVelY;
                if ((backgroundPosX += backgroundVelX) >= backgroundUnitWidth) {
                    backgroundPosX -= backgroundUnitWidth;
                    n4 = 0;
                    for (n3 = 0; n3 < backgroundTileMapHeight; ++n3) {
                        for (n = backgroundTileMapWidth - 2; n >= 0; --n) {
                            Dialog.backgroundMap[n4 + n + 1] = backgroundMap[n4 + n];
                        }
                        n = Entity.random.nextInt() & 0x1F;
                        n = n < 4 ? (n &= 3) : Game.levelWorld;
                        Dialog.backgroundMap[n4] = n;
                        n4 += backgroundTileMapWidth;
                    }
                }
                if (backgroundPosX < 0) {
                    backgroundPosX += backgroundUnitWidth;
                    n4 = 0;
                    for (n3 = 0; n3 < backgroundTileMapHeight; ++n3) {
                        for (n = 0; n < backgroundTileMapWidth - 1; ++n) {
                            Dialog.backgroundMap[n4 + n] = backgroundMap[n4 + n + 1];
                        }
                        n = Entity.random.nextInt() & 0x1F;
                        n = n < 4 ? (n &= 3) : Game.levelWorld;
                        Dialog.backgroundMap[n4 + Dialog.backgroundTileMapWidth - 1] = n;
                        n4 += backgroundTileMapWidth;
                    }
                }
                if (backgroundPosY >= backgroundUnitHeight) {
                    backgroundPosY -= backgroundUnitHeight;
                    n4 = (backgroundTileMapHeight - 1) * backgroundTileMapWidth;
                    for (n3 = backgroundTileMapHeight - 1; n3 >= 0; --n3) {
                        for (n = 0; n < backgroundTileMapWidth; ++n) {
                            if (n3 == 0) {
                                n5 = Entity.random.nextInt() & 0x1F;
                                n5 = n5 < 4 ? (n5 &= 3) : Game.levelWorld;
                                Dialog.backgroundMap[n4 + n] = n5;
                                continue;
                            }
                            Dialog.backgroundMap[n4 + n] = backgroundMap[n4 + n - backgroundTileMapWidth];
                        }
                        n4 -= backgroundTileMapWidth;
                    }
                }
                if (backgroundPosY < 0) {
                    backgroundPosY += backgroundUnitHeight;
                    n4 = 0;
                    for (n3 = 0; n3 < backgroundTileMapHeight; ++n3) {
                        for (n = 0; n < backgroundTileMapWidth; ++n) {
                            if (n3 == backgroundTileMapHeight - 1) {
                                n5 = Entity.random.nextInt() & 0x1F;
                                n5 = n5 < 4 ? (n5 &= 3) : Game.levelWorld;
                                Dialog.backgroundMap[n4 + n] = n5;
                                continue;
                            }
                            Dialog.backgroundMap[n4 + n] = backgroundMap[n4 + n + backgroundTileMapWidth];
                        }
                        n4 += backgroundTileMapWidth;
                    }
                }
            }
            if (!this.is(4096)) {
                if (brickParticles != null) {
                    for (n4 = 0; n4 < brickParticles.length; ++n4) {
                        brickParticles[n4].update();
                        brickParticles[n4].updateToScreen();
                        brickParticles[n4].postUpdate();
                    }
                }
                if ((Screen.tick & 3) == 0) {
                    n4 = (Entity.random.nextInt() & 0x7FFFFFF) % brickParticles.length;
                    n3 = (Entity.random.nextInt() & 0xFF) * Screen.width / 48;
                    n = ((Entity.random.nextInt() & 0x1FF) - 256) * 48 >> 8;
                    brickParticles[n4].emitParticleAbs(n3, -64, n, 0, 110, 0);
                }
            }
        }
    }

    private void paintBackground(Graphics graphics) {
        int n = 0;
        int n2 = Screen.top - Dialog.sprites[0].box[3];
        int n3 = backgroundPosX >> 4;
        int n4 = backgroundPosY >> 4;
        for (int i = 0; i < backgroundTileMapHeight; ++i) {
            int n5 = Screen.left - Dialog.sprites[0].box[2];
            for (int j = 0; j < backgroundTileMapWidth; ++j) {
                sprites[0].paint(graphics, n5 + n3, n2 + n4, backgroundMap[n++] + 1, 0);
                n5 += Dialog.sprites[0].box[2];
            }
            n2 += Dialog.sprites[0].box[3];
        }
    }

    private void paintParticles(Graphics graphics, int n) {
        if (brickParticles != null) {
            for (int i = 2 * n; i < 2 * (n + 1); ++i) {
                brickParticles[i].paint(graphics, true);
            }
        }
    }

    static void playMenuMusic() {
        Sound.setMusic(15, 2);
    }

    static void stopMenuMusic() {
        Sound.setMusic(-1, 2);
    }

    static {
        camRect = new int[6];
    }
}

