/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;

class Entity {
    static final byte TYPE_UNSPECIFIED = 0;
    static final int INVISIBLE = 1;
    static final int INACTIVE = 2;
    static final int DRAW_FIRST = 4;
    static final int COLLIDABLE = 8;
    static final int DISMISSABLE = 16;
    static final int CLR_BACK = 32;
    static final int SKIP_INTRO = 64;
    static final int READY = 64;
    static final int RESOURCES_LOADED = 128;
    static final int IGNORE_KEYS = 256;
    static final int BOMB_BLAST = 512;
    static final int PAUSE = 1024;
    static final int STEP_FRAME = 2048;
    static final int UNLIMITED_BALLS = 4096;
    static final int AIM_ACTIVE = 8192;
    static final int CHEATING = 16384;
    static final int BOSS_LEVEL = 32768;
    static final int HIDDEN_FIGURE_LEVEL = 65536;
    static final int COMPLETING_LEVEL = 131072;
    static final int TUTORIAL_ACTIVE = 262144;
    static final int ENTER_PAUSE = 524288;
    static final int QUEST_MODE = 0x100000;
    static final int GAME_COMPLETED = 0x200000;
    static final int IN_GAME = 64;
    static final int WRAP_SELECTION = 128;
    static final int SHOW_LOGO = 256;
    static final int MAXIMIZED = 512;
    static final int NO_BOX = 1024;
    static final int NO_BACKGROUND = 2048;
    static final int NO_FALLING_BRICKS = 4096;
    static final int ALWAYS_SELECT = 8192;
    static final int SCROLLING_BACKGROUND = 16384;
    static final int NO_ANIMATION = 131072;
    static final int NO_SCROLLING = 262144;
    static final int LEAVE_UNUSED_COMMANDS = 524288;
    static final int CENTER_SELECTED = 0x100000;
    static final int END_DIALOG = 0x200000;
    static final int DIMENSIONS_INITIALIZED = 0x400000;
    static final int HAS_NEXT = 0x800000;
    static final int HAS_PREVIOUS = 0x1000000;
    static final int VALIGN_CENTER = 128;
    static final int VALIGN_BOTTOM = 256;
    static final int ALIGN_RIGHT = 512;
    static final int ALIGN_CENTER = 1024;
    static final int COMPACT = 2048;
    static final int KEYSET_STATE = 4096;
    static final int SELECTABLE = 8192;
    static final int SELECTED = 16384;
    static final int MARQUEE = 32768;
    static final int COMPOSITE_INLINE = 65536;
    static final int MAXIMIZED_WIDTH = 131072;
    static final int REVERSE_ARROWS = 262144;
    static final int CAN_SCROLL = 524288;
    static final int STORED_OPTION = 0x200000;
    static final int QUOTED = 0x800000;
    static final int ANIMATION_COMPLETE = 64;
    static final int ANIMATION_LOOPED = 128;
    static final int IMAGE_GRID = 256;
    static final int HCENTER = 1;
    static final int VCENTER = 2;
    static final int LEFT = 4;
    static final int RIGHT = 8;
    static final int TOP = 16;
    static final int BOTTOM = 32;
    int state = 0;
    int posX = 0;
    int posY = 0;
    static Random random = new Random();
    private static int[] tempV = new int[4];
    static int defaultColor = 0xFFFFFF;
    static int defaultBackColor = 0;
    static int defaultShadowColor = 0;
    static Game game = null;
    private static final int resAF = -42;
    private static final int resBF = 64;
    private static int resMaxF = 256;

    Entity() {
    }

    void update() {
    }

    void paint(Graphics graphics) {
        this.paint(graphics, Screen.toScreenPixelX(this.posX), Screen.toScreenPixelY(this.posY));
    }

    void paint(Graphics graphics, int n, int n2) {
    }

    void paintOverlay(Graphics graphics) {
    }

    int getColor() {
        return defaultColor;
    }

    int getBackColor() {
        return defaultBackColor;
    }

    int getShadowColor() {
        return defaultShadowColor;
    }

    final boolean is(int n) {
        return (this.state & n) == n;
    }

    final boolean isOnOff(int n, int n2) {
        return (this.state & n) == n && (this.state & n2) == 0;
    }

    final boolean isAnyOf(int n) {
        return (this.state & n) != 0;
    }

    final boolean toggle(int n) {
        this.state ^= n;
        return (this.state & n) != 0;
    }

    final void set(int n, boolean bl) {
        this.state = bl ? (this.state |= n) : (this.state &= ~n);
    }

    final void onOff(int n, int n2) {
        this.state |= n;
        this.state &= ~n2;
    }

    final void copyState(Entity entity, int n) {
        this.state &= ~n;
        this.state |= entity.state & n;
    }

    void suspend() {
    }

    void resume() {
    }

    void reset() {
        this.state = 0;
    }

    void optionChanged(int n, int n2, int n3) {
        Screen.advanceProgress(n3);
    }

    int getCenterX() {
        return this.getLeft() + (this.getWidth() >> 1);
    }

    int getCenterY() {
        return this.getTop() + (this.getHeight() >> 1);
    }

    int getPixelWidth() {
        return 0;
    }

    int getPixelHeight() {
        return 0;
    }

    int getHeight() {
        return Entity.scaleFromPixel(this.getPixelHeight());
    }

    int getWidth() {
        return Entity.scaleFromPixel(this.getPixelWidth());
    }

    int getLeft() {
        return this.posX;
    }

    int getTop() {
        return this.posY;
    }

    int getRight() {
        return this.posX + this.getWidth();
    }

    int getBottom() {
        return this.posY + this.getHeight();
    }

    void setPosition(int n, int n2) {
        this.posX = n;
        this.posY = n2;
    }

    short[] getCollisionRect() {
        return Screen.NULL_RECT;
    }

    void updateDrawOrder() {
    }

    int getDrawOrder() {
        return this.is(4) ? 0 : Integer.MAX_VALUE;
    }

    void getCollisionBoundaries(int n, int n2, int[] nArray) {
        short[] sArray = this.getCollisionRect();
        nArray[0] = n + Entity.scaleFromPixel(sArray[0]);
        nArray[1] = n2 + Entity.scaleFromPixel(sArray[1]);
        nArray[2] = nArray[0] + Entity.scaleFromPixel(sArray[2]);
        nArray[3] = nArray[1] + Entity.scaleFromPixel(sArray[3]);
    }

    boolean checkCollision(int[] nArray) {
        this.getCollisionBoundaries(this.posX, this.posY, tempV);
        return Entity.isIntersecting(tempV, nArray);
    }

    void align(int n, int n2, int n3, boolean bl) {
        int n4;
        if (bl) {
            this.getCollisionBoundaries(this.posX, this.posY, tempV);
        } else {
            Entity.tempV[0] = this.posX;
            Entity.tempV[1] = this.posY;
            Entity.tempV[2] = this.getRight();
            Entity.tempV[3] = this.getBottom();
        }
        if ((n3 & 0xD) != 0) {
            Entity.tempV[2] = tempV[2] - tempV[0];
            tempV[0] = tempV[0] - this.posX;
            n4 = (n3 & 1) != 0 ? tempV[0] + tempV[2] / 2 : ((n3 & 8) != 0 ? tempV[0] + tempV[2] : tempV[0]);
            n -= n4;
        }
        if ((n3 & 0x32) != 0) {
            Entity.tempV[3] = tempV[3] - tempV[1];
            tempV[1] = tempV[1] - this.posY;
            n4 = (n3 & 2) != 0 ? tempV[1] + tempV[3] / 2 : ((n3 & 0x20) != 0 ? tempV[1] + tempV[3] : tempV[1]);
            n2 -= n4;
        }
        this.setPosition(n, n2);
    }

    void align(Entity entity, int n, int n2, boolean bl, boolean bl2) {
        if (bl2) {
            entity.getCollisionBoundaries(entity.posX, entity.posY, tempV);
        } else {
            Entity.tempV[0] = entity.posX;
            Entity.tempV[1] = entity.posY;
            Entity.tempV[2] = entity.getRight();
            Entity.tempV[3] = entity.getBottom();
        }
        int n3 = 0;
        int n4 = 0;
        if ((n2 & 0xD) != 0) {
            n3 = (n2 & 1) != 0 ? (tempV[0] + tempV[2]) / 2 : ((n2 & 8) != 0 ? tempV[2] : tempV[0]);
        }
        if ((n2 & 0x32) != 0) {
            n4 = (n2 & 2) != 0 ? (tempV[1] + tempV[3]) / 2 : ((n2 & 0x20) != 0 ? tempV[3] : tempV[1]);
        }
        this.align(n3, n4, n, bl);
    }

    static final int pointToLineDistance(int n, int n2, int n3, int n4, int n5, int n6) {
        long l = n6 - n4;
        long l2 = n5 - n3;
        return (int)((l * (long)(n - n3) - l2 * (long)(n2 - n4)) / (Entity.fpSqrtFast(l2 * l2 + l * l) >> 8));
    }

    static final int perpProduct(int n, int n2, int n3, int n4) {
        return (int)((long)n * (long)n4 - (long)n3 * (long)n2 >> 8);
    }

    static final int scaleToPixel(int n) {
        return n >> 8;
    }

    static final int scaleFromPixel(int n) {
        return n << 8;
    }

    static final String fpToString(int n) {
        return "" + (n >> 8) + "." + ((n & 0xFF) * 100 >> 8);
    }

    static final boolean areRectsIntersecting(short[] sArray, short[] sArray2) {
        return sArray[0] < sArray2[0] + sArray2[2] && sArray[0] + sArray[2] > sArray2[0] && sArray[1] < sArray2[1] + sArray2[3] && sArray[1] + sArray[3] > sArray2[1];
    }

    static final boolean axisAlignedPlaneLineIntersection(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray, int[] nArray2) {
        int n8;
        if (nArray[2] < nArray[5]) {
            n8 = nArray[2];
            nArray[2] = nArray[5];
            nArray[2] = n8;
        }
        if (nArray[0] == nArray[3]) {
            return Entity.xAlignedPlaneLineIntersection(n, n2, n3, n4, n5, n6, nArray[0], nArray[1], nArray[2] - n7, nArray[4], nArray[5], nArray2);
        }
        if (nArray[1] == nArray[4]) {
            if (Entity.xAlignedPlaneLineIntersection(n2, n, n3, n5, n4, n6, nArray[1], nArray[0], nArray[2] - n7, nArray[3], nArray[5], nArray2)) {
                n8 = nArray2[0];
                nArray2[0] = nArray2[1];
                nArray2[1] = n8;
                return true;
            }
        } else if (nArray[2] == nArray[5]) {
            if (Entity.xAlignedPlaneLineIntersection(n3, n2, n, n6, n5, n4, nArray[2], nArray[1], nArray[0], nArray[4], nArray[3], nArray2)) {
                n8 = nArray2[0];
                nArray2[0] = nArray2[2];
                nArray2[2] = n8;
                return true;
            }
        } else {
            throw new IllegalArgumentException();
        }
        return false;
    }

    static final int random(int n, int n2) {
        return Entity.range(random.nextInt(), n, n2);
    }

    static final int range(int n, int n2, int n3) {
        return (n < 0 ? -n : n) % (++n3 - n2) + n2;
    }

    static final void scaleVector(int[] nArray, int n) {
        nArray[0] = (int)((long)nArray[0] * (long)n >> 8);
        nArray[1] = (int)((long)nArray[1] * (long)n >> 8);
        nArray[2] = (int)((long)nArray[2] * (long)n >> 8);
    }

    static final void scaleVector2D(int[] nArray, int n) {
        nArray[0] = (int)((long)nArray[0] * (long)n >> 8);
        nArray[1] = (int)((long)nArray[1] * (long)n >> 8);
    }

    static final boolean checkPointToLineDistance(int n, int n2, int n3, int n4, int n5, int n6, long l) {
        long l2 = n6 - n4;
        long l3 = n5 - n3;
        long l4 = l2 * (long)(n - n3) - l3 * (long)(n2 - n4);
        long l5 = l4 * l4 / (l3 * l3 + l2 * l2);
        return l5 <= l * l;
    }

    static final boolean checkRange(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return (long)(n -= n4) * (long)n + (long)(n2 -= n5) * (long)n2 + (long)(n3 -= n6) * (long)n3 <= (long)n7 * (long)n7;
    }

    static final int dotProduct(int n, int n2, int n3, int n4) {
        return (int)((long)n * (long)n3 + (long)n2 * (long)n4 >> 8);
    }

    static final boolean isIntersecting(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n < n7 && n3 > n5 && n2 < n8 && n4 > n6;
    }

    static final boolean isIntersecting(int[] nArray, int[] nArray2) {
        return nArray[0] < nArray2[2] && nArray[2] > nArray2[0] && nArray[1] < nArray2[3] && nArray[3] > nArray2[1];
    }

    static final int isIntersecting(int n, int n2, int n3, int n4, int[][] nArray, int n5) {
        for (int i = n5; i < nArray.length; ++i) {
            if (!Entity.isIntersecting(n, n2, n3, n4, nArray[i][0], nArray[i][1], nArray[i][2], nArray[i][3])) continue;
            return i;
        }
        return -1;
    }

    static final boolean xAlignedLineWithLineIntersection(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        if (n == n3) {
            return false;
        }
        long l = ((long)(n4 - n2) << 16) / (long)(n3 - n);
        int n6 = (int)(l * (long)(n5 - n) >> 16) + n2;
        nArray[0] = n5;
        nArray[1] = n6;
        return true;
    }

    static final boolean xAlignedLineSegmentWithLineIntersection(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n == n3) {
            return false;
        }
        long l = ((long)(n4 - n2) << 16) / (long)(n3 - n);
        int n8 = (int)(l * (long)(n5 - n) >> 16) + n2;
        if (n8 < n6 && n8 < n7 || n8 > n6 && n8 > n7) {
            return false;
        }
        nArray[0] = n5;
        nArray[1] = n8;
        return true;
    }

    static final boolean xAlignedLineSegmentWithLineSegmentIntersection(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n5 < n && n5 < n3 || n5 > n && n5 > n3) {
            return false;
        }
        return Entity.xAlignedLineSegmentWithLineIntersection(n, n2, n3, n4, n5, n6, n7, nArray);
    }

    static final boolean xAlignedPlaneLineIntersection(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int[] nArray) {
        if (Entity.xAlignedLineSegmentWithLineSegmentIntersection(n, n3, n4, n6, n7, n9, n11, nArray)) {
            nArray[2] = nArray[1];
            if (Entity.xAlignedLineSegmentWithLineSegmentIntersection(n, n2, n4, n5, n7, n8, n10, nArray)) {
                return true;
            }
        }
        return false;
    }

    static final boolean lineIntersection(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        long l;
        long l2;
        long l3 = n3 - n;
        long l4 = n4 - n2;
        long l5 = n7 - n5;
        long l6 = n8 - n6;
        long l7 = n - n5;
        long l8 = n2 - n6;
        long l9 = l6 * l3 - l5 * l4;
        if (l9 != 0L && (l2 = (l5 * l8 - l6 * l7 << 16) / l9) >= 0L && l2 <= 65536L && (l = (l3 * l8 - l4 * l7 << 16) / l9) >= 0L && l <= 65536L) {
            nArray[0] = (int)((long)n + (l3 * l2 >> 24));
            nArray[1] = (int)((long)n2 + (l4 * l2 >> 24));
            return true;
        }
        return false;
    }

    static final long fpSqrtFast(long l) {
        long l2 = l >> 1;
        for (int i = 0; i < 5 && l2 != 0L; ++i) {
            l2 = l2 + (l << 16) / l2 >> 1;
        }
        return l2;
    }

    static final long getVectorLength(long l, long l2, long l3) {
        return Entity.fpSqrtFast(l * l + l2 * l2 + l3 * l3) >> 8;
    }

    static final long getVectorLength(long l, long l2) {
        return Entity.fpSqrtFast(l * l + l2 * l2) >> 8;
    }

    static final void setVectorLength(int[] nArray, int n) {
        Entity.setVectorLength(nArray, (int)Entity.getVectorLength(nArray[0], nArray[1], nArray[2]), n);
    }

    static final void setVectorLength2D(int[] nArray, int n) {
        Entity.setVectorLength2D(nArray, (int)Entity.getVectorLength(nArray[0], nArray[1], 0L), n);
    }

    static final void setVectorLength(int[] nArray, int n, int n2) {
        if (n != 0) {
            nArray[0] = (int)((long)nArray[0] * (long)n2 / (long)n);
            nArray[1] = (int)((long)nArray[1] * (long)n2 / (long)n);
            nArray[2] = (int)((long)nArray[2] * (long)n2 / (long)n);
        } else {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
        }
    }

    static final void setVectorLength2D(int[] nArray, int n, int n2) {
        if (n != 0) {
            nArray[0] = (int)((long)nArray[0] * (long)n2 / (long)n);
            nArray[1] = (int)((long)nArray[1] * (long)n2 / (long)n);
        } else {
            nArray[0] = 0;
            nArray[1] = 0;
        }
    }

    static int blendColors(int n, int n2, int n3) {
        int n4 = 256 - n3;
        return (n >>> 16 & 0xFF) * n3 + (n2 >>> 16 & 0xFF) * n4 >>> 8 << 16 | (n >>> 8 & 0xFF) * n3 + (n2 >>> 8 & 0xFF) * n4 >>> 8 << 8 | (n & 0xFF) * n3 + (n2 & 0xFF) * n4 >>> 8;
    }

    static int scaleColor(int n, int n2, int n3) {
        if (n3 <= 0) {
            return n;
        }
        if (n3 >= 256) {
            return n2;
        }
        int n4 = (n & 0xFF0000) >>> 16;
        int n5 = (n & 0xFF00) >>> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >>> 16;
        int n8 = (n2 & 0xFF00) >>> 8;
        int n9 = n2 & 0xFF;
        int n10 = n7 - n4;
        int n11 = n8 - n5;
        int n12 = n9 - n6;
        int n13 = n4 + (n10 * n3 >>> 8) & 0xFF;
        int n14 = n5 + (n11 * n3 >>> 8) & 0xFF;
        int n15 = n6 + (n12 * n3 >>> 8) & 0xFF;
        return n13 << 16 | n14 << 8 | n15;
    }

    static int getRestitutedValue(int n) {
        long l = n * n;
        long l2 = ((long)(-42 * n) * l >> 16) + (64L * l >> 8);
        return (int)(l2 / (long)resMaxF);
    }

    static int getRestitutedValue2(long l) {
        long l2 = l * l;
        l = ((-42L * l * l2 >> 16) + (64L * l2 >> 8)) / (long)resMaxF;
        l2 = l * l;
        return (int)(((-42L * l * l2 >> 16) + (64L * l2 >> 8)) / (long)resMaxF);
    }

    public static boolean intersectingRect(int[] nArray, int n, int n2, int[] nArray2) {
        int n3;
        int n4;
        int n5 = nArray2[0] + nArray2[4];
        int n6 = nArray[0] + nArray[4] + n;
        return Math.abs(n5 - n6) <= nArray[4] + nArray2[4] && Math.abs((n4 = nArray2[1] + nArray2[5]) - (n3 = nArray[1] + nArray[5] + n2)) <= nArray[5] + nArray2[5];
    }

    public static boolean intersectingSpheres(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n4 - n;
        int n8 = n5 - n2;
        int n9 = n7 * n7 + n8 * n8;
        int n10 = n3 + n6;
        return n9 <= n10 * n10;
    }

    public static boolean rectContaining(int[] nArray, int n, int n2) {
        return n >= nArray[0] && n <= nArray[0] + nArray[2] && n2 >= nArray[1] && n2 <= nArray[1] + nArray[3];
    }

    static {
        resMaxF = Entity.getRestitutedValue(256);
    }
}

