/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

final class Screen
extends GameCanvas
implements CommandListener {
    static boolean screenInitInRun = false;
    static int softkeyW = 40;
    static int softkeyH = 40;
    static final boolean OPTION_SAVE_SOUND = true;
    static final boolean NEED_RESET_FULL_SCREEN = true;
    static final int auto = -1;
    static final int no = 0;
    static final int disable = 0;
    static final int yes = 1;
    static final int enable = 1;
    private static final String SRC = "Samsung_i900_EFIGSC";
    static final boolean DEBUG = false;
    static final boolean DEBUG_QUICK_START = false;
    static final boolean DEBUG_PROGRESS = false;
    static final boolean DEBUG_HIGHSCORE = false;
    static final boolean DEBUG_LOADING = false;
    static final boolean DEBUG_TEXT = false;
    static final boolean ENABLE_CHEATS = true;
    static final boolean ENABLE_SPLASH_SKIP = true;
    static final boolean ENABLE_KILOO_OPTIONS_IN_JAD = false;
    static final String DEMO_CODE = null;
    static final int DEMO_END_LEVEL = 3;
    static final boolean USE_NUMBER_FONT = true;
    static final boolean USE_MENU_BACKGROUND = true;
    static final boolean USE_OUTRO = true;
    static final boolean USE_TUTORIAL = true;
    static final boolean USE_ACHIEVEMENTS = true;
    static final boolean USE_PARTICLES = true;
    static final boolean USE_ROBOTS = true;
    static final boolean USE_BACKGROUND = true;
    static final boolean USE_MOREGAMES = false;
    static final boolean USE_MOREGAMES_IMAGES = false;
    static final boolean USE_TITLE_SPLASH = true;
    static final boolean USE_REDUCED_TILESET = false;
    static final int WORLD_COUNT = 4;
    static final boolean USE_FULLSCREEN = true;
    static final int WATCHDOG_TIME = 0;
    static final boolean SUSPEND_ON_INTERRUPTION = true;
    static final boolean SPRITE_CAN_TRANSFORM = true;
    static final boolean SPRITE_CAN_PRETRANSFORM = false;
    static final int SPRITE_UNPACK_FRAMES = 1;
    static final boolean NO_SOFTKEY_RELEASE_EVENT = false;
    static final boolean WAIT_FOR_SCREEN = true;
    static final boolean SOUND_ENABLE = true;
    static final boolean SOUND_STATIC_DATA = false;
    static final boolean SOUND_MUSIC_ENABLE = true;
    static final boolean SOUND_MUSIC_INGAME = true;
    static final boolean SOUND_SFX_INGAME = false;
    static final boolean SOUND_VOLUME_ENABLE = true;
    static final int SOUND_VOLUME_STEPS = 1;
    static final int SOUND_VOLUME_MIN_AMR = 30;
    static final int SOUND_VOLUME_MAX_AMR = 100;
    static final int SOUND_VOLUME_MIN_MIDI = 10;
    static final int SOUND_VOLUME_MAX_MIDI = 100;
    static final int SOUND_VOLUME_MIN_WAV = 10;
    static final int SOUND_VOLUME_MAX_WAV = 100;
    static final int SOUND_VOLUME_MIN_TONE = 10;
    static final int SOUND_VOLUME_MAX_TONE = 100;
    static final int SOUND_FADE_STEP = 5;
    static final int SOUND_MINIMIUM_INTERVAL = 100;
    static final int SOUND_MUSIC_PAUSE = 0;
    static final int SOUND_MAX_REALIZE_COUNT = 0;
    static final boolean SOUND_STOP_BEFORE_SUSPEND = true;
    static final boolean SOUND_BUG_SETMEDIATIME = true;
    static final boolean SOUND_BUG_GETPLAYERSTATE = false;
    static final boolean SOUND_BUG_NOKIA_INIT = false;
    static final boolean SOUND_ALWAYS_REALLOCATE = false;
    static final boolean SOUND_NEVER_REALLOCATE = false;
    static final boolean SOUND_DONT_INTERRUPT = false;
    static final boolean SOUND_DEALLOCATE_PLAYER_ON_STOP = true;
    static final boolean SOUND_BUG_PLAYER_INVALID_WHEN_DONE = false;
    static final boolean SOUND_WAIT_FOR_STOP = true;
    static final boolean SOUND_SET_VOLUME_BEFORE_START = false;
    static final int SOUND_COUNT = 18;
    static final int SOUND_ID_OFFSET = 20;
    private static final int VIBRATION = 0;
    static final boolean VIBRATION_STOPS_SOUND = false;
    static final boolean CAN_CONNECT = true;
    static final boolean CONNECT_MUST_EXIT_APP = true;
    static final int CONNECT_SLEEP_BEFORE_EXIT = 0;
    static final boolean RMS_IS_SLOW = false;
    static final boolean RMS_COMBINE_DATA = true;
    static final boolean TEXT_CUSTOM_FONT = true;
    static final boolean TEXT_MIXED_CASE = true;
    static final boolean TEXT_LONG_WORD_EXCEPTION = true;
    static final boolean TEXT_ENABLE_SHADOWS = true;
    static final int TEXT_Y_OFFSET = 0;
    static final int TEXT_HEIGHT_ADJUST = 0;
    static final int PIXEL_SHIFT = 8;
    static final boolean DYNAMIC_SCREEN_SIZE = true;
    static final int FORCE_SCREEN_WIDTH = 0;
    static final int FORCE_SCREEN_HEIGHT = 0;
    static final int DIALOG_ITEM_SPACING = 2;
    static final int DIALOG_FRAME_THICKNESS = 2;
    static final int DIALOG_SCROLLBAR_WIDTH = 8;
    static final int DIALOG_MARGIN = 6;
    static final int DIALOG_LARGE_ARROW_SIZE = 15;
    static final int DIALOG_LARGE_ARROW_ANIMATION = 3;
    static final boolean DIALOG_DISABLE_LOGO = false;
    static final int GAME_CRATE_BORDER = 4;
    static final int GAME_ORIGINAL_TILE_SIZE = 32;
    static final int GAME_TILE_SIZE = 48;
    static final int GAME_BRICK_TILE_WIDTH = 12;
    static final int GAME_BRICK_TILE_HEIGHT = 17;
    static final int GAME_BRICK_TILE_STACKED_HEIGHT = 13;
    static final boolean GAME_OVER_SHOW_TEXT = true;
    static final int GAME_MAP_Y_OFFSET = 0;
    static final int LOADING_SPEED_NUMERATOR = 1;
    static final int LOADING_SPEED_DENOMINATOR = 1;
    static final boolean SPLASH_ANIMATE = true;
    static final int GUI_SPEED = 32;
    static final boolean GUI_ANIMATE = true;
    static final int GUI_MARQUEE_SCROLL_PAUSE = 40;
    static final int GUI_MARQUEE_SCROLL_SPEED = 2;
    static final boolean FADE_ENABLE = true;
    private static final int FADE_SPEED = 20;
    private static final int FADE_BAR_COUNT = 20;
    private static final int FADE_DELTA = 5;
    static final int GAMELOOP_UPDATES = 1;
    static final int GAMELOOP_MIN_TIME = 40;
    private static final int GAMELOOP_MIN_SLEEP_TIME = 10;
    static final int GAMELOOP_TICKS_PER_SECOND = 10;
    private static final boolean SCREEN_ROTATION_ENABLE = false;
    private static final boolean SCREEN_USE_FLUSHGRAPHICS = false;
    static final int MEMORY_UNLOADING = 0;
    static final boolean LOCALE_ENABLE_OPTION = true;
    static final boolean LOCALE_ONLY_ONE = false;
    static final int GAME_BACKGROUND_ITEM_COUNT = 16;
    static final int GAME_FREE_ITEM_COUNT = 16;
    static final boolean GAME_USE_TILE_BUFFER = false;
    static final int DEFAULT_GRAVITY = 10;
    static final int PLAYER_GRAVITY = 10;
    static final int PLAYER_DRAGV = 208;
    static final int PLAYER_DRAGH = 160;
    static final int PLAYER_AIRSPEED = 14;
    static final int PLAYER_WALKSPEED = 14;
    static final int PLAYER_JUMPVELOCITY = 128;
    static final int GUI_PARTICLE_COUNT_BRICKS = 16;
    static final int GAME_PARTICLE_COUNT_STARS = 32;
    static final int GAME_PARTICLE_COUNT_SMOKE = 32;
    static final int GAME_PARTICLE_COUNT_SPARKS = 32;
    static final int GAME_PARTICLE_COUNT_FILLER = 32;
    static final int GAME_PARTICLE_COUNT_SMASH = 16;
    static final int GAME_PARTICLE_COUNT_SMOKE2 = 16;
    static final int GAME_PARTICLE_COUNT_JUMPEX = 16;
    static final int GAME_PARTICLE_COUNT_ELECTRICITY = 16;
    static final int GAME_PARTICLE_COUNT_LEAVES = 32;
    static final int GAME_PARTICLE_SYSTEM_COUNT = 9;
    static final boolean KEYS_SWAP_SOFTKEYS = false;
    static final boolean KEYS_FORCE_DEFAULT = false;
    static final boolean KEYS_SOFTKEY_COMMANDS = false;
    static final int KEY_UP_ARROW = -1;
    static final int KEY_DOWN_ARROW = -2;
    static final int KEY_LEFT_ARROW = -3;
    static final int KEY_RIGHT_ARROW = -4;
    static final int KEY_FIRE = -5;
    static final int KEY_BACK = 111;
    static final int KEY_C = 0;
    static final int KEY_MENU = 0;
    static final int KEY_ANSWER = 0;
    static final int KEY_HANGUP = 0;
    static final int _SOFTKEY_LEFT = -6;
    static final int _SOFTKEY_RIGHT = -7;
    static final int SOFTKEY_TOP_LEFT = 0;
    static final int SOFTKEY_TOP_RIGHT = 0;
    static final int SOFTKEY_LEFT = -6;
    static final int SOFTKEY_RIGHT = -7;
    private static final int GAMEACTION_UP = 0;
    private static final int GAMEACTION_DOWN = 0;
    private static final int GAMEACTION_LEFT = 0;
    private static final int GAMEACTION_RIGHT = 0;
    private static final int GAMEACTION_FIRE = 0;
    private static final int GAMEACTION_A = 0;
    private static final int GAMEACTION_B = 0;
    private static final int GAMEACTION_C = 0;
    private static final int GAMEACTION_D = 0;
    private static final boolean USE_GAMEACTIONS = false;
    private static final int[] GAMEACTION_MAP = new int[]{0, 1, 0, 6, 0, 2, 0, 5, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12};
    private static final String[] GAMEACTION_NAMES = new String[]{" UP", " DOWN", " LEFT", " RIGHT", " FIRE", " GAME_A", " GAME_B", " GAME_C", " GAME_D"};
    static final int TITLE_SCREEN_DURATION = 1000;
    static final int SPLASH_TIME = 2000;
    static final int SPLASH_TITLE_TIME = 5000;
    static final int SPLASH_OUTTRO_TIME = 3000;
    static final int LEVEL_POPUP_DURATION = 2000;
    static final boolean DIALOGITEM_ENABLE_SPACER = true;
    static final boolean DIALOGITEM_ENABLE_OPTION = true;
    static final boolean DIALOGITEM_ENABLE_STRING_OBJ = true;
    static final boolean DIALOGITEM_ENABLE_STRING = true;
    static final boolean DIALOGITEM_ENABLE_ENTITY = true;
    static final boolean DIALOGITEM_ENABLE_COMPOSITE = true;
    static final boolean DIALOGITEM_ENABLE_KEY_OPTION = true;
    static final boolean DIALOGITEM_ENABLE_CHAR = true;
    static final boolean DIALOGITEM_ENABLE_ARROW = true;
    static final boolean DIALOGITEM_ENABLE_IMAGE = true;
    public static final int COLOR_INTRO_SCREEN = 0xFFFFFF;
    public static final int COLOR_LOADING_SCREEN = 0;
    public static final int COLOR_TITLE_SPLASH = 255;
    public static final int COLOR_PROGRESS_FILL = 0x515151;
    public static final int COLOR_PROGRESS_FRAME = 0xC0C0C0;
    static final short[] NULL_RECT = new short[]{0, 0, 0, 0};
    static final int FP_BITS = 8;
    static final int ONE_PIXEL = Entity.scaleFromPixel(1);
    static final int SQRT_ITERATIONS = 5;
    static final int KEY_UP_BIT = 2;
    static final int KEY_LEFT_BIT = 4;
    static final int KEY_RIGHT_BIT = 32;
    static final int KEY_DOWN_BIT = 64;
    static final int KEY_FIRE_BIT = 256;
    static final int KEY_LEFT_SOFT_BIT = 512;
    static final int KEY_RIGHT_SOFT_BIT = 1024;
    static final int KEY_MENU_BIT = 4096;
    static final int KEY_ANSWER_BIT = 8192;
    static final int KEY_HANGUP_BIT = 16384;
    static final int KEY_POUND_BIT = 65536;
    static final int KEY_STAR_BIT = 131072;
    static final int KEY_BACK_BIT = 262144;
    static final int KEY_C_BIT = 524288;
    static final int KEY_NUM0_BIT = 0x100000;
    static final int KEY_NUM1_BIT = 0x200000;
    static final int KEY_NUM2_BIT = 0x400000;
    static final int KEY_NUM3_BIT = 0x800000;
    static final int KEY_NUM4_BIT = 0x1000000;
    static final int KEY_NUM5_BIT = 0x2000000;
    static final int KEY_NUM6_BIT = 0x4000000;
    static final int KEY_NUM7_BIT = 0x8000000;
    static final int KEY_NUM8_BIT = 0x10000000;
    static final int KEY_NUM9_BIT = 0x20000000;
    static final int KEY_MENU_LEFT_BIT = 0x1000004;
    static final int KEY_MENU_RIGHT_BIT = 0x4000020;
    static final int KEY_MENU_UP_BIT = 0x400002;
    static final int KEY_MENU_DOWN_BIT = 0x10000040;
    static final int KEY_MENU_LEFTSOFT_BIT = 0x2000300;
    static final int KEY_MENU_RIGHTSOFT_BIT = 1024;
    static final int KEY_MENU_ANY_SOFT_BIT = 1792;
    static final int KEY_PAUSE_BIT = 1024;
    static final int KEY_GAME_LEFT_BIT = 18874372;
    static final int KEY_GAME_RIGHT_BIT = 75497504;
    static final int KEY_GAME_UP_BIT = 0xE00002;
    static final int KEY_GAME_DOWN_BIT = 0x10000040;
    static final int KEY_GAME_FIRE_BIT = 0x2000100;
    static final int KEY_GAME_THROW_LEFT_BITS = 0x8000000;
    static final int KEY_GAME_THROW_RIGHT_BITS = 0x20080000;
    static final int KEY_GAME_THROW_BITS = 0x28080000;
    private static final int[] ROTATIONS = new int[]{0, 5, 3, 6};
    static Screen screen = null;
    static MIDlet theMidlet;
    static int hMiddle;
    static int vMiddle;
    static int left;
    static int top;
    static int right;
    static int bottom;
    private static final int CLIP_STACK_INITIAL_SIZE = 20;
    private static final int CLIP_STACK_SIZE_INCREMENT = 4;
    private static int clipStackTop;
    private static int[] clipStack;
    static int clipLeft;
    static int clipTop;
    static int clipRight;
    static int clipBottom;
    static int clipWidth;
    static int clipHeight;
    static int width;
    static int height;
    static int drawAreaWidth;
    static int drawAreaHeight;
    static final int FORCE_DRAW_AREA_WIDTH = 240;
    static final int FORCE_DRAW_AREA_HEIGHT = 260;
    static final int FORCE_LANDSCAPE_DRAW_AREA_WIDTH = 260;
    static final int FORCE_LANDSCAPE_DRAW_AREA_HEIGHT = 188;
    static int actualDeviceWidth;
    static int actualDeviceHeight;
    static int sceneAlignFlags;
    static int viewLeft;
    static int viewTop;
    static int viewWidth;
    static int viewHeight;
    static int viewRight;
    static int viewBottom;
    static int viewMiddleX;
    static int viewMiddleY;
    static int viewPixelLeft;
    static int viewPixelTop;
    static int viewPixelRight;
    static int viewPixelBottom;
    static Entity viewTrack;
    static boolean viewTrackRestrictToScene;
    static boolean viewInPlace;
    static int viewSluggishness;
    static int sceneLeft;
    static int sceneTop;
    static int sceneRight;
    static int sceneBottom;
    static int sceneWidth;
    static int sceneHeight;
    private static int progress;
    private static int progressBrick;
    private static int progressSize;
    static Entity rootEntity;
    static final int INPUT_NORMAL = 0;
    static final int INPUT_GETKEY = 1;
    private static int keysPressed;
    private static int keysReleased;
    private static int keysClicked;
    private static int latchedKeysPressed;
    private static int latchedKeysClicked;
    private static int lastKeysPressed;
    private static long lastKeyLatchTime;
    private static int inputMode;
    static int getKey;
    private static Command rightSoft;
    private static Command leftSoft;
    private static int gameKeyState;
    private static char[] inputBuffer;
    private static int inputCursor;
    static String input;
    static int lastKeyPressed;
    static Exception lastIgnoredException;
    private static boolean painting;
    private static int shakingTick;
    private static boolean suspended;
    private static boolean hidden;
    static boolean needsClearBorder;
    static int scheduleClearColor;
    static long time;
    static int tick;
    private static boolean fadingOut;
    private static Image backBuffer;
    private static Graphics backBufferGraphics;
    private static Graphics graphics;
    private static byte screenRot;
    static int screenModeChangeCounter;
    static final int ID_BUTTONS = 0;
    static final int ID_ARROWS = 1;
    static final int ID_ACHIEVEMENTS = 2;
    static Sprite2Data buttons;
    static Sprite2Data arrows;
    static Sprite2Data achievements;
    static final int ARROW_LEFT = 1;
    static final int ARROW_UP = 2;
    static final int ARROW_RIGHT = 3;
    static final int ARROW_DOWN = 4;
    static final int ACHIEVEMENT_LOCKED_FRAME = 1;
    static final int ACHIEVEMENT_UNLOCKED_FRAME = 2;
    static int marquee;
    static int anim;
    static int animTick;
    static boolean showDebugInfo;
    static boolean enableDebug;
    static boolean enableSuspend;
    static long watchdog;
    static final boolean TOUCH_PAD_SUPPORT = true;
    static final int SW = 0;
    static final int SE = 1;
    static final int NE = 2;
    static final int NW = 3;
    static final int SOFTPOS_KEY0 = 0;
    static final int SOFTPOS_KEY1 = 1;
    static final int SOFTPOS_HUD0 = 2;
    static final int SOFTPOS_HUD1 = 3;
    static final int SOFTPOS_PORTRAIT_KEY0 = 0;
    static final int SOFTPOS_PORTRAIT_KEY1 = 1;
    static final int SOFTPOS_PORTRAIT_HUD0 = 3;
    static final int SOFTPOS_PORTRAIT_HUD1 = 2;
    static final int SOFTPOS_LANDSCAPE_KEY0 = 0;
    static final int SOFTPOS_LANDSCAPE_KEY1 = 1;
    static final int SOFTPOS_LANDSCAPE_HUD0 = 3;
    static final int SOFTPOS_LANDSCAPE_HUD1 = 2;
    static int softX;
    static int softY;
    static int softHiddenY;
    static int softSpaceTop;
    static int softSpaceBottom;
    static int[] cmd;
    private static int[] cmdPrevious;
    private static int[] cmdTransition;
    private static int[] cmdOrigin;
    private static int[] cmdHidden;
    private static int[] cmdDestination;
    private static int[] cmdPosition;
    private static int[] cmdX;
    private static int[] cmdPreviousX;
    private static int fadeStep;
    private static int fadeBarsHeight;
    private static int fadeFromColor;
    private static int fadeToColor;
    private static int fadeColor;
    private static int[] fadeBarX;
    private static final String MG_BUYURI_KEY_PREFIX = "MG_BUYURI_";
    private static final String MG_CATURI_KEY_PREFIX = "MG_CATURI_";
    private static final String MG_PRODUCTS_KEY = "MG_PRODUCTS";
    private static final String[] MG_PRODUCTS_ENUM;
    private static final String MG_SETUP_KEY = "MG_Impl";
    private static final String[] MG_SETUP_ENUM;
    static final int MG_SETUP_OFF = 0;
    static final int MG_SETUP_WAP = 1;
    static final int MG_SETUP_STATIC = 2;
    static final int MG_SETUP_WAPSTATIC = 3;
    static final int MG_STRING_COUNT = 3;
    static int[] mgProducts;
    static String[] mgBuyURI;
    static String[] mgCatURI;
    static int mgSetup;

    private Screen() {
        super(false);
    }

    static void init(MIDlet mIDlet) {
        if (screen == null) {
            theMidlet = mIDlet;
            width = 0;
            height = 0;
            screen = new Screen();
            showDebugInfo = false;
            enableDebug = false;
            buttons = null;
            viewTrack = null;
            viewTrackRestrictToScene = true;
            viewInPlace = true;
            viewSluggishness = 42;
            progress = -1;
            progressSize = 0;
            rootEntity = null;
            sceneAlignFlags = 0;
            inputBuffer = null;
            inputCursor = 0;
            input = null;
            lastKeyPressed = 0;
            inputMode = 0;
            getKey = 0;
            painting = false;
            shakingTick = -1;
            suspended = false;
            hidden = false;
            enableSuspend = false;
            needsClearBorder = true;
            scheduleClearColor = 0;
            fadingOut = false;
            fadeStep = -1;
            fadeFromColor = 0;
            fadeToColor = 0;
            fadeColor = 0;
            fadeBarX = new int[20];
            marquee = 0;
            anim = 0;
            animTick = 0;
            backBuffer = null;
            graphics = null;
            screenRot = (byte)-1;
            screenModeChangeCounter = 0;
            clipStackTop = 0;
            clipStack = new int[20];
            Display display = Display.getDisplay((MIDlet)theMidlet);
            screen.setFullScreenMode(true);
            display.setCurrent((Displayable)screen);
            Screen.updateMoreGamesSettings();
            while (display.getCurrent() != screen) {
                Thread.yield();
            }
            Storage.optionEnabled[5] = 0;
            Screen.setScreenMode(0);
            Storage.optionEnabled[1] = 0;
            Storage.optionEnabled[2] = 0;
            Screen.reset();
            Screen.initScene(null, 17);
        } else {
            Screen.resetKeyState();
            needsClearBorder = true;
            Sound.stopCurrent();
            Display display = Display.getDisplay((MIDlet)theMidlet);
            if (display.getCurrent() != screen) {
                display.setCurrent((Displayable)screen);
            }
        }
    }

    public void sizeChanged(int n, int n2) {
        this.setFullScreenMode(false);
        this.setFullScreenMode(true);
    }

    static void loadResources(int n) throws IOException {
        Storage storage = Storage.loadPackage("/all", null, false, n);
        buttons = storage.getSpriteData(0);
        arrows = storage.getSpriteData(1);
        achievements = storage.getSpriteData(2);
    }

    static void setScreenMode(int n) {
        n = 0;
        screenRot = (byte)n;
        actualDeviceWidth = screen.getWidth();
        if (actualDeviceWidth < (actualDeviceHeight = screen.getHeight())) {
            drawAreaWidth = 240;
            drawAreaHeight = 260;
        } else {
            drawAreaWidth = 260;
            drawAreaHeight = 188;
        }
        if (screenRot == 1 || screenRot == 3) {
            int n2 = drawAreaWidth;
            drawAreaWidth = drawAreaHeight;
            drawAreaHeight = n2;
        }
        width = drawAreaWidth;
        height = drawAreaHeight;
        left = drawAreaWidth - width >> 1;
        top = drawAreaHeight - height >> 1;
        right = left + width;
        bottom = top + height;
        hMiddle = left + right >> 1;
        vMiddle = top + bottom >> 1;
        graphics = null;
        Screen.reset();
        Screen.initFade();
        Screen.resetSoftkeyLabelPositions();
        Screen.alignSceneToScreen(sceneAlignFlags);
        Game.initCameras();
        ++screenModeChangeCounter;
        Touch.setSkWH(softkeyW, softkeyH);
        if (actualDeviceWidth < actualDeviceHeight) {
            Touch.intiTouch(actualDeviceWidth, actualDeviceHeight, drawAreaWidth, drawAreaHeight);
        } else {
            Touch.reIntiTouch(actualDeviceWidth, actualDeviceHeight, drawAreaWidth, drawAreaHeight);
        }
    }

    static void reset() {
        needsClearBorder = true;
        scheduleClearColor = 0;
        Screen.setViewRect(Entity.scaleFromPixel(left), Entity.scaleFromPixel(top), Entity.scaleFromPixel(width), Entity.scaleFromPixel(height));
        Screen.resetKeyState();
    }

    static void setViewRect(int n, int n2, int n3, int n4) {
        viewLeft = n;
        viewTop = n2;
        viewWidth = n3;
        viewHeight = n4;
        viewRight = n + n3;
        viewBottom = n2 + n4;
        viewMiddleX = n + n3 / 2;
        viewMiddleY = n2 + n4 / 2;
        viewPixelLeft = Entity.scaleToPixel(viewLeft);
        viewPixelTop = Entity.scaleToPixel(viewTop);
        viewPixelRight = Entity.scaleToPixel(viewRight);
        viewPixelBottom = Entity.scaleToPixel(viewBottom);
    }

    static void moveView(int n, int n2, boolean bl) {
        if (bl) {
            if (sceneWidth <= viewWidth) {
                n = 0;
            } else if (n < sceneLeft - viewLeft) {
                n = sceneLeft - viewLeft;
            } else if (n > sceneRight - viewRight) {
                n = sceneRight - viewRight;
            }
            if (sceneHeight <= viewHeight) {
                n2 = 0;
            } else if (n2 < sceneTop - viewTop) {
                n2 = sceneTop - viewTop;
            } else if (n2 > sceneBottom - viewBottom) {
                n2 = sceneBottom - viewBottom;
            }
        }
        if (n != 0) {
            viewMiddleX += n;
            viewPixelLeft = Entity.scaleToPixel(viewLeft += n);
            viewPixelRight = Entity.scaleToPixel(viewRight += n);
        }
        if (n2 != 0) {
            viewMiddleY += n2;
            viewPixelTop = Entity.scaleToPixel(viewTop += n2);
            viewPixelBottom = Entity.scaleToPixel(viewBottom += n2);
        }
    }

    static void suspend() {
        if (enableSuspend) {
            Sound.onPaused();
            if (rootEntity != null) {
                rootEntity.suspend();
            }
            if (Entity.game != null && !Entity.game.is(1024)) {
                Entity.game.set(524288, true);
            }
            suspended = true;
            Screen.setSoftkeyLabel(0, -1);
            Screen.setSoftkeyLabel(1, -23);
            Text.setStringFormat(1, 0, 0);
        }
    }

    static void resume() {
        Screen.resetKeyState();
        suspended = false;
        if (rootEntity != null) {
            rootEntity.resume();
        }
    }

    protected void hideNotify() {
        hidden = true;
        screen.suspend();
    }

    protected void showNotify() {
        hidden = false;
        Screen.init(theMidlet);
    }

    static void initScene(Entity entity, int n) {
        if (entity != null) {
            sceneLeft = entity.getLeft();
            sceneTop = entity.getTop();
            sceneWidth = entity.getWidth();
            sceneHeight = entity.getHeight();
            sceneRight = sceneLeft + sceneWidth;
            sceneBottom = sceneTop + sceneHeight;
            sceneAlignFlags = n;
            Screen.alignSceneToScreen(n);
        } else {
            sceneLeft = 0;
            sceneTop = 0;
            sceneWidth = 0;
            sceneHeight = 0;
            sceneRight = 0;
            sceneBottom = 0;
            Screen.setViewRect(0, 0, viewWidth, viewHeight);
        }
    }

    static void alignSceneToScreen(int n) {
        int n2 = sceneLeft;
        if ((n & 1) != 0) {
            n2 = sceneLeft + (sceneWidth >> 1) - (viewWidth >> 1);
        } else if ((n & 8) != 0) {
            n2 = sceneLeft + sceneWidth - viewWidth;
        }
        int n3 = sceneTop;
        if ((n & 2) != 0) {
            n3 = sceneTop + (sceneHeight >> 1) - (viewHeight >> 1);
        } else if ((n & 0x20) != 0) {
            n3 = sceneTop + sceneHeight - viewHeight;
        }
        Screen.setViewRect(n2, n3, viewWidth, viewHeight);
        if (viewTrack != null) {
            int n4 = viewTrack.getCenterX() - viewMiddleX;
            int n5 = viewTrack.getCenterY() - viewMiddleY;
            Screen.moveView(n4, n5, viewTrackRestrictToScene);
        }
    }

    static void show(Entity entity, int n, int n2, int n3) {
        watchdog = 0L;
        Entity entity2 = rootEntity;
        long l = n3;
        if (l > 0L) {
            l += System.currentTimeMillis();
        }
        rootEntity = entity;
        entity.set(3, false);
        while (!entity.is(1)) {
            time = System.currentTimeMillis();
            if (l > 0L && time > l) break;
            for (int i = 0; i < n2; ++i) {
                Screen.latchKeyState();
                Screen.update();
            }
            Screen.requestRepaint(true, (long)n - (System.currentTimeMillis() - time));
        }
        entity.set(2, true);
        rootEntity = entity2;
        watchdog = 0L;
    }

    static int advanceProgress(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("progress bogus");
        }
        if (n != 0) {
            if ((progress += n) > progressSize) {
                progress = progressSize;
            }
            Screen.requestRepaint(true, 0L);
        }
        return n;
    }

    static int initProgress() {
        progress = 0;
        progressBrick = Entity.random(1, Game.bricks.frameCount - 1);
        progressSize = width * 2 / 3;
        short s = Game.bricks.getImageBoundingRect(progressBrick)[2];
        int n = progressSize % s;
        progressSize -= n;
        if (n > s >> 1) {
            progressSize += s;
        }
        return progressSize;
    }

    static void endProgress(boolean bl) {
        if (bl && progress >= 0) {
            Screen.advanceProgress(progressSize - progress);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        progress = -1;
    }

    static void clipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (n > clipLeft) {
            clipLeft = n;
        }
        if (n5 < clipRight) {
            clipRight = n5;
        }
        clipWidth = clipRight - clipLeft;
        if (n2 > clipTop) {
            clipTop = n2;
        }
        if (n6 < clipBottom) {
            clipBottom = n6;
        }
        clipHeight = clipBottom - clipTop;
        if (clipWidth <= 0 || clipHeight <= 0) {
            clipLeft = 0;
            clipTop = 0;
            clipRight = 0;
            clipBottom = 0;
            clipWidth = 0;
            clipHeight = 0;
        }
        graphics.setClip(clipLeft, clipTop, clipWidth, clipHeight);
    }

    static void setClip(Graphics graphics, int n, int n2, int n3, int n4) {
        clipLeft = n;
        clipTop = n2;
        clipWidth = n3;
        clipHeight = n4;
        clipRight = clipLeft + clipWidth;
        clipBottom = clipTop + clipHeight;
        graphics.setClip(clipLeft, clipTop, clipWidth, clipHeight);
    }

    static void pushClip(Graphics graphics, int n, int n2, int n3, int n4) {
        Screen.pushClip();
        Screen.clipRect(graphics, n, n2, n3, n4);
    }

    static void pushClip() {
        if (clipStackTop == clipStack.length) {
            int[] nArray = new int[clipStack.length + 4];
            System.arraycopy(clipStack, 0, nArray, 0, clipStack.length);
            clipStack = nArray;
        }
        Screen.clipStack[Screen.clipStackTop++] = clipLeft;
        Screen.clipStack[Screen.clipStackTop++] = clipTop;
        Screen.clipStack[Screen.clipStackTop++] = clipWidth;
        Screen.clipStack[Screen.clipStackTop++] = clipHeight;
    }

    static void popClip(Graphics graphics, boolean bl) {
        if (graphics != null) {
            int n = clipStack[clipStackTop - 1];
            int n2 = clipStack[clipStackTop - 2];
            int n3 = clipStack[clipStackTop - 3];
            int n4 = clipStack[clipStackTop - 4];
            Screen.setClip(graphics, n4, n3, n2, n);
        }
        if (bl) {
            clipStackTop -= 4;
        }
    }

    protected synchronized void keyReleased(int n) {
        int n2 = Screen.getKeyBit(n);
        keysReleased |= n2;
    }

    protected synchronized void keyPressed(int n) {
        if (inputMode == 1) {
            getKey = n;
            inputMode = 0;
        } else {
            if (inputBuffer != null) {
                Screen.updateInputBuffer(n);
            }
            int n2 = Screen.getKeyBit(n);
            keysPressed |= n2;
            keysReleased &= ~n2;
            keysClicked |= n2;
        }
        lastKeyPressed = n;
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    protected final void pointerDragged(int n, int n2) {
    }

    protected final void pointerPressed(int n, int n2) {
        int n3 = Touch.processPointerEvent(n, n2, 0);
        if (n3 != 0) {
            this.keyPressed(n3);
        }
        if ((n3 = Touch.processTouchSoftKey(n, n2, 0)) != 0) {
            this.keyPressed(n3);
        }
    }

    protected final void pointerReleased(int n, int n2) {
        int n3 = Touch.processPointerEvent(n, n2, 1);
        if (n3 != 0) {
            this.keyReleased(n3);
        }
        if ((n3 = Touch.processTouchSoftKey(n, n2, 1)) != 0) {
            this.keyReleased(n3);
        }
        Screen.resetKeyState();
        Touch.resetTouchKeyState(false);
    }

    static int getKeyBit(int n) {
        int n2 = 0;
        if (n == -3) {
            n2 = 4;
        } else if (n == -4) {
            n2 = 32;
        } else if (n == -1) {
            n2 = 2;
        } else if (n == -2) {
            n2 = 64;
        } else if (n == -5) {
            n2 = 256;
        } else if (n == -6) {
            n2 = 512;
        } else if (n == -7) {
            n2 = 1024;
        } else if (n == 48) {
            n2 = 0x100000;
        } else if (n == 49) {
            n2 = 0x200000;
        } else if (n == 50) {
            n2 = 0x400000;
        } else if (n == 51) {
            n2 = 0x800000;
        } else if (n == 52) {
            n2 = 0x1000000;
        } else if (n == 53) {
            n2 = 0x2000000;
        } else if (n == 54) {
            n2 = 0x4000000;
        } else if (n == 55) {
            n2 = 0x8000000;
        } else if (n == 56) {
            n2 = 0x10000000;
        } else if (n == 57) {
            n2 = 0x20000000;
        } else if (n == 42) {
            n2 = 131072;
        } else if (n == 35) {
            n2 = 65536;
        } else if (n == 111) {
            n2 = 262144;
        }
        return n2;
    }

    static void activateInputMode() {
        if (inputBuffer == null) {
            showDebugInfo = enableDebug;
            inputCursor = 0;
            input = null;
            inputBuffer = new char[12];
        }
    }

    static void activateGetKeyMode() {
        getKey = 0;
        inputMode = 1;
    }

    private static void updateInputBuffer(int n) {
        if (n > 0) {
            if (n == 35) {
                showDebugInfo = false;
                input = new String(inputBuffer, 0, inputCursor);
                inputBuffer = null;
            } else if (inputCursor < inputBuffer.length) {
                char c;
                Screen.inputBuffer[Screen.inputCursor] = c = (char)n;
                ++inputCursor;
            }
        }
    }

    static int getKeysPressed() {
        return showDebugInfo ? 0 : latchedKeysPressed;
    }

    static int getKeysClicked() {
        return showDebugInfo ? 0 : latchedKeysClicked;
    }

    static int getLastKeysPressed() {
        return showDebugInfo ? 0 : lastKeysPressed;
    }

    static void resetKeyState() {
        keysPressed = 0;
        keysReleased = 0;
        keysClicked = 0;
        latchedKeysPressed = 0;
        latchedKeysClicked = 0;
        lastKeysPressed = 0;
    }

    static void resetKeyClickedState() {
        keysClicked = 0;
        latchedKeysClicked = 0;
    }

    private static synchronized void latchKeyState() {
        lastKeysPressed = latchedKeysPressed;
        latchedKeysPressed = keysPressed;
        latchedKeysClicked = keysClicked;
        keysPressed &= ~keysReleased;
        keysReleased = 0;
        keysClicked = 0;
        if (keysPressed != 0 && time - lastKeyLatchTime > 500L) {
            Screen.resetKeyState();
        }
        lastKeyLatchTime = time;
    }

    static int toScreenPixelX(int n) {
        return (n >> 8) - viewPixelLeft + left;
    }

    static int toScreenPixelY(int n) {
        return (n >> 8) - viewPixelTop + top;
    }

    static boolean isOnScreenPixel(int n, int n2, short[] sArray) {
        return Entity.isIntersecting(n += sArray[0], n2 += sArray[1], n + sArray[2], n2 + sArray[3], clipLeft, clipTop, clipRight, clipBottom);
    }

    static boolean isOnScreenPixel(int n, int n2, int n3, int n4) {
        return Entity.isIntersecting(clipLeft, clipTop, clipRight, clipBottom, n, n2, n3, n4);
    }

    static boolean isOnScreen(int n, int n2, int n3, int n4) {
        return Entity.isIntersecting(viewLeft, viewTop, viewRight, viewBottom, n, n2, n3, n4);
    }

    static boolean isInScene(int n, int n2, int n3, int n4) {
        return Entity.isIntersecting(sceneLeft, sceneTop, sceneRight, sceneBottom, n, n2, n3, n4);
    }

    static boolean isInScene(Entity entity) {
        return Entity.isIntersecting(sceneLeft, sceneTop, sceneRight, sceneBottom, entity.getLeft(), entity.getTop(), entity.getRight(), entity.getBottom());
    }

    private static void update() {
        if (hidden) {
            return;
        }
        Screen.updateSoftkeyLabels();
        if (suspended) {
            fadeStep = -1;
            if ((latchedKeysClicked & 0x400) != 0) {
                Screen.resume();
            }
        } else {
            ++tick;
            Sound.updateSound();
            if (rootEntity != null) {
                if (Screen.isFading()) {
                    Screen.updateFade();
                    latchedKeysPressed = 0;
                    latchedKeysClicked = 0;
                } else {
                    fadeStep = -1;
                }
                rootEntity.update();
                if (rootEntity.isOnOff(16, 1) && (latchedKeysClicked & 0x2000300) != 0) {
                    rootEntity.set(1, true);
                }
            }
            if (shakingTick >= 0 && --shakingTick < 0) {
                Display.getDisplay((MIDlet)theMidlet).vibrate(0);
            }
            if (viewTrack != null) {
                int n;
                int n2 = viewMiddleX;
                int n3 = viewMiddleY;
                int n4 = viewTrack.getCenterX() - viewMiddleX;
                if (n4 > 1 || n4 < -1) {
                    n4 = n4 / 255 * viewSluggishness;
                }
                if ((n = viewTrack.getCenterY() - viewMiddleY) > 1 || n < -1) {
                    n = n / 255 * viewSluggishness;
                }
                Screen.moveView(n4, n, viewTrackRestrictToScene);
                viewInPlace = n2 == viewMiddleX && n3 == viewMiddleY;
            } else {
                viewInPlace = true;
            }
        }
        if (screen.getWidth() != actualDeviceWidth || screen.getHeight() != actualDeviceHeight) {
            Screen.setScreenMode(screenRot);
        }
        if ((latchedKeysClicked & 0x20000) != 0) {
            showDebugInfo = enableDebug ? !showDebugInfo : false;
        }
    }

    private static void requestRepaint(boolean bl, long l) {
        painting = bl;
        screen.repaint();
        long l2 = l;
        try {
            Thread.sleep(l2 > 10L ? l2 : 10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (painting) {
            Thread.yield();
        }
    }

    static boolean isPainting() {
        return painting;
    }

    public void flushGraphics() {
        this.repaint();
        this.serviceRepaints();
    }

    public void paint(Graphics graphics) {
        try {
            Graphics graphics2 = graphics;
            if (width == 0 || height == 0 || graphics2 == null) {
                painting = false;
                return;
            }
            marquee -= 2;
            anim = -(animTick++ >> 2 & 1);
            int n = (drawAreaHeight - height) / 2;
            int n2 = (drawAreaWidth - width) / 2;
            if (needsClearBorder && (n > 0 || n2 > 0)) {
                graphics2.setColor(rootEntity != null ? rootEntity.getBackColor() : 0);
                Screen.setClip(graphics2, 0, 0, drawAreaWidth, drawAreaHeight);
                graphics2.fillRect(0, 0, drawAreaWidth, drawAreaHeight);
                needsClearBorder = false;
            }
            Screen.setClip(graphics2, left, top, width, height);
            if (scheduleClearColor != -1) {
                graphics2.setColor(scheduleClearColor);
                graphics2.fillRect(left, top, width, height);
                scheduleClearColor = -1;
            }
            if (!fadingOut) {
                int n3;
                if (suspended) {
                    graphics2.setColor(0);
                    graphics2.fillRect(left, top, width, height);
                    Text.drawText(graphics2, 1, hMiddle, vMiddle, true, 0);
                    if (progress >= 0) {
                        n3 = vMiddle + bottom >> 1;
                        Screen.drawProgress(graphics2, n3, progress);
                    } else {
                        Screen.drawSoftkeyLabels(graphics2);
                    }
                } else {
                    if (Screen.isPainting() && rootEntity != null && !rootEntity.isAnyOf(3)) {
                        if (rootEntity.is(32)) {
                            graphics2.setColor(rootEntity.getBackColor());
                            graphics2.fillRect(left, top, width, height);
                        }
                        Screen.paintView(graphics2, left, top, false);
                        rootEntity.paintOverlay(graphics2);
                        Screen.drawSoftkeyLabels(graphics2);
                        graphics2.setColor(rootEntity.getColor());
                    }
                    if (progress >= 0) {
                        n3 = vMiddle;
                        Screen.drawProgress(graphics2, n3, progress);
                    }
                }
                if (showDebugInfo) {
                    n3 = lastIgnoredException != null && (keysPressed & 0x100000) != 0 ? 1 : 0;
                    int n4 = graphics2.getFont().getHeight() + 0;
                    int n5 = 5;
                    if (n3 != 0) {
                        n5 += 2;
                    }
                    int n6 = 5 * n4;
                    int n7 = vMiddle + 0 - (n6 >> 1);
                    graphics2.setColor(0);
                    graphics2.fillRect(left, n7, width, n6);
                    graphics2.setColor(0xFFFFFF);
                    graphics2.drawString(SRC, 0, n7, 20);
                    n7 += n4;
                    String string = "Key: " + lastKeyPressed;
                    try {
                        string = string + " \"" + this.getKeyName(lastKeyPressed) + "\"";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    graphics2.drawString(string, 0, n7, 20);
                    System.gc();
                    long l = Runtime.getRuntime().freeMemory();
                    long l2 = Runtime.getRuntime().totalMemory() - l;
                    graphics2.drawString("Used: " + l2, 0, n7 += n4, 20);
                    graphics2.drawString("Free: " + l, 0, n7 += n4, 20);
                    if (inputBuffer != null && inputCursor > 0) {
                        graphics2.drawChars(inputBuffer, 0, inputCursor, 0, n7 += n4, 20);
                    }
                    if (n3 != 0) {
                        graphics2.drawString(lastIgnoredException.getClass().getName(), 0, n7 += n4, 20);
                        graphics2.drawString(lastIgnoredException.getMessage(), 0, n7 += n4, 20);
                    }
                }
            }
            if (fadeStep >= 0 && progress < 0) {
                Screen.drawFade(graphics2);
            }
            Touch.drawTouchPad(graphics2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Screen.showError(exception.toString());
        }
        painting = false;
    }

    static void paintView(Graphics graphics, int n, int n2, boolean bl) {
        if (rootEntity != null && Screen.isPainting()) {
            int n3 = clipLeft;
            int n4 = clipTop;
            int n5 = clipWidth;
            int n6 = clipHeight;
            int n7 = viewPixelRight - viewPixelLeft;
            int n8 = viewPixelBottom - viewPixelTop;
            Screen.clipRect(graphics, n, n2, n7, n8);
            if (bl) {
                graphics.setColor(rootEntity.getBackColor());
                graphics.fillRect(n, n2, n7, n8);
            }
            if (shakingTick > 0) {
                int n9 = left;
                int n10 = top;
                left += Entity.random(-shakingTick, shakingTick);
                top += Entity.random(-shakingTick, shakingTick);
                rootEntity.paint(graphics);
                left = n9;
                top = n10;
            } else {
                rootEntity.paint(graphics);
            }
            Screen.setClip(graphics, n3, n4, n5, n6);
        }
    }

    static void clear(Graphics graphics, int n) {
        graphics.setColor(n);
        graphics.fillRect(clipLeft, clipTop, clipWidth, clipHeight);
    }

    static void drawFramedBox(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n5 << 1;
        if (n3 < n8 || n4 < n8) {
            if (n7 >= 0) {
                graphics.setColor(n7);
                graphics.fillRect(n, n2, n3, n4);
            }
        } else {
            if (n6 >= 0) {
                graphics.setColor(n6);
                graphics.fillRect(n + n5, n2 + n5, n3 - n8, n4 - n8);
            }
            if (n7 >= 0) {
                graphics.setColor(n7);
                graphics.fillRect(n + n5, n2, n3 - n8, n5);
                graphics.fillRect(n, n2 + n5, n5, n4 - n8);
                graphics.fillRect(n + n5, n2 + n4 - n5, n3 - n8, n5);
                graphics.fillRect(n + n3 - n5, n2 + n5, n5, n4 - n8);
                if (n3 > n8 + 2 && n4 > n8 + 2) {
                    graphics.fillRect(n + 1, n2 + 1, n5, n5);
                    graphics.fillRect(n + n3 - n5 - 1, n2 + 1, n5, n5);
                    graphics.fillRect(n + 1, n2 + n4 - n5 - 1, n5, n5);
                    graphics.fillRect(n + n3 - n5 - 1, n2 + n4 - n5 - 1, n5, n5);
                }
            }
        }
    }

    static void drawBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        if (n5 > 0) {
            Screen.drawFramedBox(graphics, n, n2, n3, n4, n5, n9, n8);
            n += n5;
            n2 += n5;
            n3 -= n5 << 1;
            n4 -= n5 << 1;
        }
        if (n6 > 0) {
            n += n6;
            n2 += n6;
            n3 -= n6 << 1;
            n4 -= n6 << 1;
        }
        if (n7 > n3) {
            n7 = n3;
        }
        if (n7 > 0) {
            Screen.drawFramedBox(graphics, n, n2, n7, n4, 1, n10, n10);
        }
    }

    static void drawProgress(Graphics graphics, int n, int n2) {
        Screen.clear(graphics, 0);
        int n3 = progressSize + 4;
        int n4 = hMiddle - (n3 >> 1);
        short[] sArray = Game.bricks.getImageBoundingRect(progressBrick);
        graphics.setColor(0xC0C0C0);
        graphics.fillRect(n4, n + 2, n3, (int)sArray[3]);
        graphics.setColor(0x515151);
        graphics.fillRect(n4 + 1, n + 3, n3 - 2, sArray[3] - 2);
        Screen.pushClip(graphics, n4 += 2, n, n2, sArray[3]);
        int n5 = n4 + n2;
        while (n4 < n5) {
            Game.bricks.paint(graphics, n4, n, progressBrick, 0);
            n4 += sArray[2];
        }
        Screen.popClip(graphics, true);
    }

    static void computeSoftPos(int n, int n2, int n3, int n4, int n5) {
        int n6;
        boolean bl;
        boolean bl2 = bl = actualDeviceWidth > actualDeviceHeight;
        if (n == 0) {
            n6 = bl ? 0 : 0;
        } else if (n == 1) {
            n6 = bl ? 1 : 1;
        } else if (n == 2) {
            n6 = bl ? 3 : 3;
        } else {
            int n7 = n6 = bl ? 2 : 2;
        }
        if (n6 < 2) {
            softX = n6 == 1 ? right - n4 - n2 : left + n4;
            softY = bottom - n5 - n3;
            softHiddenY = bottom;
        } else {
            softX = n6 == 2 ? right - n4 - n2 : left + n4;
            softY = top + n5;
            softHiddenY = top - n3;
        }
    }

    static void computeSoftSpace() {
        int n;
        int n2;
        boolean bl = false;
        if (actualDeviceWidth > actualDeviceHeight) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 0;
            n = 1;
        }
        softSpaceTop = n2 >= 2 || n >= 2 ? Screen.buttons.box[3] : 0;
        softSpaceBottom = n2 < 2 || n < 2 ? Screen.buttons.box[3] : 0;
    }

    static void resetSoftkeyLabelPositions() {
        for (int i = 0; i < 2; ++i) {
            int n = cmd[i];
            Screen.cmd[i] = -1;
            Screen.cmdPosition[i] = 0;
            Screen.cmdX[i] = 0;
            Screen.setSoftkeyLabel(i, n);
        }
    }

    static void setSoftkeyLabel(int n, int n2) {
        if (cmd[n] != n2) {
            int n3;
            Screen.cmdPrevious[n] = cmd[n];
            Screen.cmdPreviousX[n] = cmdX[n];
            Screen.cmd[n] = n2;
            int n4 = n3 = n == 0 ? 0 : 1;
            if (cmd[n] >= 0) {
                Screen.computeSoftPos(n3, Text.getTextWidth(cmd[n]), Text.getTextHeight(cmd[n]), 0, 0);
            } else {
                Screen.computeSoftPos(n3, Screen.buttons.box[2], Screen.buttons.box[3], 0, 0);
            }
            Screen.cmdX[n] = softX;
            Screen.cmdDestination[n] = softY;
            Screen.cmdHidden[n] = softHiddenY;
            if (cmdPrevious[n] == -1) {
                Screen.cmdPosition[n] = softHiddenY;
                Screen.cmdOrigin[n] = softHiddenY;
                Screen.cmdTransition[n] = 288;
            } else {
                Screen.cmdOrigin[n] = cmdPosition[n];
                Screen.cmdTransition[n] = 544;
            }
        }
    }

    static boolean isSoftkeyAnimationDone() {
        for (int i = 0; i < cmd.length; ++i) {
            if (cmdTransition[i] <= 0) continue;
            return false;
        }
        return true;
    }

    static void updateSoftkeyLabels() {
        for (int i = 0; i < cmd.length; ++i) {
            int n;
            if (cmdTransition[i] <= 0) continue;
            int n2 = i;
            cmdTransition[n2] = cmdTransition[n2] - 32;
            if (cmdTransition[i] < 0) {
                Screen.cmdTransition[i] = 0;
            }
            if (cmdTransition[i] > 256) {
                n = cmdTransition[i] - 256;
                int n3 = n = n == 256 ? 256 : Entity.getRestitutedValue2(n);
                if (n == 0) {
                    Screen.cmdPosition[i] = cmdHidden[i];
                    Screen.cmdTransition[i] = 256;
                    continue;
                }
                Screen.cmdPosition[i] = cmdOrigin[i] * n + cmdHidden[i] * (256 - n) >> 8;
                continue;
            }
            n = cmdTransition[i];
            n = n == 256 ? 256 : Entity.getRestitutedValue2(n);
            Screen.cmdPosition[i] = cmdHidden[i] * n + cmdDestination[i] * (256 - n) >> 8;
        }
    }

    static void clearSoftKeyLabels() {
        for (int i = 0; i < cmd.length; ++i) {
            Screen.cmd[i] = -1;
            Screen.cmdPrevious[i] = -1;
        }
    }

    static void drawSoftkeyLabels(Graphics graphics) {
        for (int i = 0; i < cmd.length; ++i) {
            int n;
            int n2;
            if (cmdTransition[i] > 256) {
                n2 = cmdPrevious[i];
                n = cmdPreviousX[i];
            } else {
                n2 = cmd[i];
                n = cmdX[i];
            }
            if (n2 >= 0) {
                Text.drawText(graphics, n2, n, cmdPosition[i], false, width >> 1);
                continue;
            }
            int n3 = n2 - -24;
            if (n3 < 0 || n3 >= Screen.buttons.frameCount) continue;
            buttons.paint(graphics, n, cmdPosition[i], n3 + 1, 0);
        }
    }

    static void drawArrow(Graphics graphics, int n, int n2, int n3, int n4) {
        block5: {
            int n5;
            block7: {
                block6: {
                    block4: {
                        n5 = n4 - 1;
                        if (n != 0 && n != 1) break block4;
                        n3 += n5;
                        while (n4 > 0) {
                            graphics.fillRect(n2, n3 - n4 + 1, 1, (n4 << 1) - 1);
                            --n4;
                            ++n2;
                        }
                        break block5;
                    }
                    if (n != 3 && n != 2) break block6;
                    n2 += n5;
                    n3 += n5;
                    while (n4 >= 0) {
                        graphics.fillRect(n2, n3 - n4 + 1, 1, (n4 << 1) - 1);
                        --n4;
                        --n2;
                    }
                    break block5;
                }
                if (n != 5 && n != 4) break block7;
                n2 += n5;
                n3 += n5;
                while (n4 > 0) {
                    graphics.fillRect(n2 - n4 + 1, n3, (n4 << 1) - 1, 1);
                    --n4;
                    --n3;
                }
                break block5;
            }
            if (n != 6 && n != 7) break block5;
            n2 += n5;
            while (n4 > 0) {
                graphics.fillRect(n2 - n4 + 1, n3, (n4 << 1) - 1, 1);
                --n4;
                ++n3;
            }
        }
    }

    static void drawSelectedArrows(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            if (bl2) {
                n2 -= n4 >> 1;
            }
            arrows.paint(graphics, n += n3 - Screen.arrows.box[2] >> 1, n2 - anim - Screen.arrows.box[3], bl ? 4 : 2, 0);
            arrows.paint(graphics, n, n2 + anim + n4, bl ? 2 : 4, 0);
        } else {
            if (bl2) {
                n -= n3 >> 1;
            }
            arrows.paint(graphics, n - anim - Screen.arrows.box[2], n2 += n4 - Screen.arrows.box[3] >> 1, bl ? 3 : 1, 0);
            arrows.paint(graphics, n + anim + n3, n2, bl ? 1 : 3, 0);
        }
    }

    static void showError(String string) {
        Alert alert = new Alert(null, string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display display = Display.getDisplay((MIDlet)theMidlet);
        display.setCurrent((Displayable)alert);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void shake(int n) {
        if (n > shakingTick) {
            shakingTick = n;
            Screen.vibrate(n * 200);
        }
    }

    static void vibrate(int n) {
    }

    static boolean ifVibrationEnable() {
        return false;
    }

    static void optionChanged(int n, int n2, int n3) {
        if (rootEntity != null) {
            rootEntity.optionChanged(n, n2, n3);
        }
        marquee = 0;
    }

    static void initFade() {
        fadeBarsHeight = height / 20 + 1;
    }

    static boolean isFading() {
        return fadeStep > 0;
    }

    static void fadeOut(boolean bl, int n, int n2) {
        watchdog = 0L;
        fadingOut = true;
        fadeStep = 256 + fadeBarX.length * 5;
        fadeFromColor = n;
        fadeToColor = n2;
        if (bl) {
            Sound.fade(-5);
            Sound.setMusic(-1, 2);
        }
        while (Screen.isFading() || bl && Sound.isAnySoundPlaying()) {
            if (bl) {
                Sound.updateSound();
            }
            Screen.updateFade();
            Screen.requestRepaint(true, 40L);
        }
        fadeStep = -1;
        fadingOut = false;
        Screen.clearSoftKeyLabels();
    }

    static void fadeIn(int n, int n2) {
        Storage.synchronizeData();
        fadingOut = false;
        fadeStep = 256 + fadeBarX.length * 5;
        fadeFromColor = n;
        fadeToColor = n2;
    }

    private static void updateFade() {
        if (fadeStep > 0) {
            if ((fadeStep -= 20) < 0) {
                fadeStep = 0;
            }
            for (int i = 0; i < fadeBarX.length; ++i) {
                int n = fadeStep - i * 5;
                if (n > 256) {
                    n = 256;
                }
                if (n < 0) {
                    n = 0;
                }
                if (i == 0) {
                    fadeColor = Entity.blendColors(fadeFromColor, fadeToColor, n);
                }
                if (fadingOut) {
                    n = 256 - n;
                }
                int n2 = Entity.getRestitutedValue(n) * width >> 8;
                Screen.fadeBarX[i] = (i & 1) == 0 ? -n2 : n2;
            }
        }
    }

    static void drawFade(Graphics graphics) {
        if (fadeStep >= 0 || fadingOut) {
            int n = top;
            graphics.setColor(fadeColor);
            for (int i = 0; i < fadeBarX.length; ++i) {
                if (fadeBarX[i] < 0) {
                    graphics.fillRect(left, n, -fadeBarX[i], fadeBarsHeight);
                } else {
                    graphics.fillRect(left + width - fadeBarX[i], n, fadeBarX[i], fadeBarsHeight);
                }
                n += fadeBarsHeight;
            }
        }
    }

    static void updateMoreGamesSettings() {
    }

    static int getMoreGamesString(int n, int n2) {
        return mgProducts[n] * 3 + n2;
    }

    static boolean launchUrl(String string) {
        if (string != null) {
            boolean bl = true;
            try {
                bl |= theMidlet.platformRequest(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) {
                theMidlet.notifyDestroyed();
                return true;
            }
        }
        return false;
    }

    static {
        drawAreaWidth = 0;
        drawAreaHeight = 0;
        gameKeyState = 0;
        lastIgnoredException = null;
        buttons = null;
        arrows = null;
        achievements = null;
        watchdog = 0L;
        cmd = new int[]{-1, -1};
        cmdPrevious = new int[]{-1, -1};
        cmdTransition = new int[]{0, 0};
        cmdOrigin = new int[]{0, 0};
        cmdHidden = new int[]{0, 0};
        cmdDestination = new int[]{0, 0};
        cmdPosition = new int[]{0, 0};
        cmdX = new int[]{0, 0};
        cmdPreviousX = new int[]{0, 0};
        MG_PRODUCTS_ENUM = null;
        MG_SETUP_ENUM = new String[]{"off", "wap", "static", "wapstatic"};
        mgProducts = null;
        mgBuyURI = null;
        mgCatURI = null;
        mgSetup = 0;
    }
}

