/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class Sprite2
extends Entity {
    static byte[] nullSequence = new byte[]{0};
    byte[] frameSequence = null;
    private int ticksSinceFrameChange = 0;
    byte frame = 0;
    byte transform = 0;
    Sprite2Data spriteData = null;
    int ticksPerFrame = 0;

    Sprite2() {
    }

    Sprite2(Sprite2Data sprite2Data) {
        this.transmogrify(sprite2Data);
    }

    void transmogrify(Sprite2Data sprite2Data) {
        this.spriteData = sprite2Data;
        this.ticksSinceFrameChange = 0;
        this.frameSequence = null;
        this.frame = 1;
    }

    Sprite2Data getSpriteData() {
        return this.spriteData;
    }

    void reset() {
        super.reset();
        this.ticksSinceFrameChange = 0;
        this.frame = 1;
        this.frameSequence = null;
        this.ticksPerFrame = 0;
        this.set(128, true);
    }

    void update() {
        if (this.ticksPerFrame != 0 && this.frame != 0) {
            this.ticksSinceFrameChange += 256;
            int n = this.ticksSinceFrameChange / this.ticksPerFrame;
            if (n != 0) {
                int n2 = this.frameSequence == null ? this.spriteData.frameCount : this.frameSequence.length;
                int n3 = (this.frame < 0 ? -this.frame : this.frame) - 1 + n;
                if (n > 0) {
                    if (n3 >= n2) {
                        n3 = this.is(128) ? (n3 %= n2) : (int)((byte)(n2 - 1));
                        this.set(64, true);
                    }
                } else if (n3 < 0) {
                    n3 = this.is(128) ? (int)((byte)(n2 + n3 % n2)) : 0;
                    this.set(64, true);
                }
                this.ticksSinceFrameChange = 0;
                this.frame = (byte)(this.frame < 0 ? -n3 : ++n3);
            }
        }
    }

    int getRawFrame() {
        byte by = this.frameSequence == null ? this.frame : (this.frame < 0 ? -this.frameSequence[-this.frame - 1] : this.frameSequence[this.frame - 1]);
        return by;
    }

    void paint(Graphics graphics, int n, int n2) {
        if ((this.ticksSinceFrameChange & Integer.MIN_VALUE) != 0) {
            int n3 = n;
            int n4 = this.ticksSinceFrameChange & 0xFF;
            int n5 = 0;
            for (int i = 0; i < this.frameSequence.length; ++i) {
                this.spriteData.paint(graphics, n3, n2, this.frameSequence[i], 0);
                n3 += this.spriteData.box[2];
                if (n5 != n4) continue;
                n5 = 0;
                n3 = n;
                n2 += this.spriteData.box[3];
            }
        } else if (Screen.isOnScreenPixel(n, n2, this.spriteData.box)) {
            this.spriteData.paint(graphics, n, n2, this.getRawFrame(), this.transform);
        }
    }

    int getPixelHeight() {
        if ((this.ticksSinceFrameChange & Integer.MIN_VALUE) != 0) {
            return this.spriteData.box[3] * (this.ticksSinceFrameChange >>> 8 & 0xFF);
        }
        return this.spriteData.box[3];
    }

    int getPixelWidth() {
        if ((this.ticksSinceFrameChange & Integer.MIN_VALUE) != 0) {
            return this.spriteData.box[2] * (this.ticksSinceFrameChange & 0xFF);
        }
        return this.spriteData.box[2];
    }

    int getFrameCount() {
        return this.frameSequence == null ? this.spriteData.frameCount : this.frameSequence.length;
    }

    void destroy() {
        this.spriteData = null;
        this.frameSequence = null;
    }

    void playback(byte[] byArray, int n, boolean bl) {
        this.set(256, false);
        this.frameSequence = byArray;
        this.ticksPerFrame = n;
        this.set(128, bl);
        this.set(64, false);
        this.ticksSinceFrameChange = 0;
        this.frame = n < 0 ? (byte)this.getFrameCount() : (byte)1;
    }

    void playback(int n, boolean bl, boolean bl2) {
        this.playback(this.spriteData.frameSequences[n], (bl2 ? -this.spriteData.ticksPerFrame[n] : this.spriteData.ticksPerFrame[n]) << 8, bl);
    }

    boolean isPlaying(int n) {
        return this.frameSequence == this.spriteData.frameSequences[n];
    }

    void setGrid(byte[] byArray, int n) {
        this.set(256, true);
        this.ticksSinceFrameChange = Integer.MIN_VALUE | n | (byArray.length + n - 1) / n << 8;
        this.frameSequence = byArray;
    }

    short[] getCollisionRect() {
        return this.spriteData.getCollisionRect(this.getRawFrame());
    }
}

